<?php
/*
+-----------------------------------------------------------------------------+
| $Id: *.php,v 1.* 2005/07/01 06:15:08 Bleakwind Exp $
| SnowStats
|         --- A Web Statistics Analysis for multiuser
| Copyright (c) 2003-2005 Weaverdream.com By Bleakwind
| http://www.weaverdream.com
+-----------------------------------------------------------------------------+
*/

include_once 'include/include.php';

// If select user
if(!isset($_GET['user']) || $_GET['user'] == ""){
   echo "document.write(\"".$LANGUAGE['noshowuser']."\");";
   exit;
}

$user               = $_GET['user'];
$userdir            = $SETTING['dir_data'].$user;

$file_config        = $userdir."/".$SETTING['file_config'];
$file_ipsame        = $userdir."/".$SETTING['file_ipsame'];

$file_click         = $userdir."/".$SETTING['file_click'];

$file_online        = $userdir."/".$SETTING['file_online'];
$file_visitor       = $userdir."/".$SETTING['file_visitor'];

$file_year          = $userdir."/".$SETTING['file_year'];
$file_month         = $userdir."/".$SETTING['file_month'];
$file_day           = $userdir."/".$SETTING['file_day'];
$file_hour          = $userdir."/".$SETTING['file_hour'];

$file_totalmonth    = $userdir."/".$SETTING['file_totalmonth'];
$file_totalday      = $userdir."/".$SETTING['file_totalday'];
$file_totalhour     = $userdir."/".$SETTING['file_totalhour'];

$file_os            = $userdir."/".$SETTING['file_os'];
$file_browser       = $userdir."/".$SETTING['file_browser'];
$file_language      = $userdir."/".$SETTING['file_language'];
$file_colordepth    = $userdir."/".$SETTING['file_colordepth'];
$file_screensize    = $userdir."/".$SETTING['file_screensize'];
$file_timezone      = $userdir."/".$SETTING['file_timezone'];

$file_searchfrom    = $userdir."/".$SETTING['file_searchfrom'];
$file_searchkeyword = $userdir."/".$SETTING['file_searchkeyword'];

// If isset $file_config
if(!file_exists($file_config)){
   echo "document.write(\"".$LANGUAGE['nouser']."\");";
   exit;
}

include $file_config;

// If user == user of $file_config
if($user != $CONFIGUSER['username']){
   echo "document.write(\"".$LANGUAGE['configerror']."\");";
   exit;
}

$href       = $_GET['snowstats_href'] ? $_GET['snowstats_href'] : ($_SERVER['HTTP_REFERER'] ? $_SERVER['HTTP_REFERER'] : "Unknown");
$referrer   = $_GET['snowstats_referrer'] ? $_GET['snowstats_referrer'] : "Browser Address";

$os         = return_os();
$browser    = return_browser();
$language   = ( $_GET['snowstats_language'] && ($_GET['snowstats_language'] != "undefined") ) ? $_GET['snowstats_language'] : "Unknown";
$colordepth = $_GET['snowstats_colordepth'] ? $_GET['snowstats_colordepth'] : "Unknown";
$screensize = $_GET['snowstats_screensize'] ? $_GET['snowstats_screensize'] : "Unknown";
$timezone   = $_GET['snowstats_timezone'] ? $_GET['snowstats_timezone'] : "Unknown";

$search     = return_search($referrer);

// If have a same IP in period of time
$if_ipsame               = if_ipsame($file_ipsame,$TIMENOW['time'],CONFIG_IFCOUNT_LONG);

// write data to file_click
$result_click            = write_click($file_click,$array_click,$if_ipsame,$CONFIGUSER['length']);

// Online visitor
$result_online           = write_online($file_online,CONFIG_ONLINE_LONG,$TIMENOW['time'],$href,$referrer);
// Last visitor
$result_visitor          = write_visitor($file_visitor,CONFIG_LAST_VISITOR,$TIMENOW['time'],$href,$referrer);

// About latest 10 years
$result_year             = write_lastevery($file_year,$array_year,$if_ipsame);
// About latest 12 month
$result_month            = write_lastevery($file_month,$array_month,$if_ipsame);
// About latest 31 days
$result_day              = write_lastevery($file_day,$array_day,$if_ipsame);
// About latest 24 hours
$result_hour             = write_lastevery($file_hour,$array_hour,$if_ipsame);

// Every month of total
$result_totalmonth       = write_totalevery($file_totalmonth,$array_month_virgin,$TIMENOW['month'],$if_ipsame);
// Every day of total
$result_totalday         = write_totalevery($file_totalday,$array_day_virgin,$TIMENOW['day'],$if_ipsame);
// Every hour of total
$result_totalhour        = write_totalevery($file_totalhour,$array_hour_virgin,$TIMENOW['hour'],$if_ipsame);

// Every os of total
$result_os               = write_every_add($file_os,str_encode($os),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
// Every browser of total
$result_browser          = write_every_add($file_browser,str_encode($browser),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
// Every language of total
$result_language         = write_every_add($file_language,str_encode($language),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
// Every colordepth of total
$result_colordepth       = write_every_add($file_colordepth,str_encode($colordepth),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
// Every screensize of total
$result_screensize       = write_every_add($file_screensize,str_encode($screensize),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
// Every timezone of total
$result_timezone         = write_every_add($file_timezone,str_encode($timezone),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);

// Searchfrom of total
if(!empty($search['name'])){
   $result_searchfrom    = write_every_add($file_searchfrom,str_encode($search['name']),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
}
// Searchkeyword of total
if(!empty($search['keyword'])){
   $result_searchkeyword = write_every_add($file_searchkeyword,str_encode($search['keyword']),$TIMENOW['time'],CONFIG_DEL_NUMBER,CONFIG_DEL_LONG,$if_ipsame);
}
?>
