<?
/*
 
 本软件版权归作者所有,在投入使用之前注意获取许可
 作者：程威（wiwiboy）
 项目：PHPStat流量统计 1.0
 电话：13553166317
 邮箱：wiwiboy@126.com
 QQ号：158839753
 网址：http://www.phpstat.net
 phpstat.net保留全部权力，受相关法律和国际		  		
		公约保护，请勿非法修改、转载、散播，或用于其他赢利行为，		
		并请勿删除版权声明。
*/
/*	
	verson:v1.0 20060618
	author:wiwiboy
	last update:2006/06/10	
	describe:分页程序
*/
class Pages
{
	var $CurrentPage; // 当前页
	var $RecordCount; // 记录总数
	var $PageSize; // 页容量	
	var $URL; // 链接地址
	var $PageCount; // 页数
	var $URLChar; // URL 变量分隔符

	var $LinkCount; // 邻接链接数
	var $PageVarName; // 页数变量
	var $Text_FirstPage; // 首页
	var $Text_LastPage; // 末页
	var $Text_PrevPage; // 前页
	var $Text_NextPage; // 后页
	var $Text_Overleap; // 省略字串
	var $RecordName; // 记录名称
	var $RecordUnit; // 记录单位	

	function Pages ( $RecordCount = 0, $PageSize = 0, $CurrentPage = 0, $URL = '' )
	{
		$this->RecordCount = $RecordCount;
		$this->PageSize = $PageSize;
		$this->CurrentPage = $CurrentPage;
		$this->URL = $URL;

		$this->LinkCount = 10;
		$this->PageVarName = "page";
		$this->Text_FirstPage = "首页";
		$this->Text_LastPage = "末页";
		$this->Text_PrevPage = "前页";
		$this->Text_NextPage = "后页";
		$this->Text_Overleap = "...";
		$this->RecordName = "记录";
		$this->RecordUnit = "条";	
	}

	function MakePageItems ()
	{
		// 返回值
		// $PageItems[Links] : 页数链接
		// $PageItems[Before] : 首页 前页
		// $PageItems[After] : 后页 末页

		// [Links][type] : LINK/NOLINK/CURRENTPAGE
		// [Links][text] : 文字
		// [Links][link] : 链接地址

		// 处理当前页
		if ( $this->CurrentPage == 0 )
		{
			$this->CurrentPage = intval ( $_GET[$this->PageVarName] );
		}

		// 处理 URL
		if ( $this->URL == '' )
		{
			$this->URL = $this->MakeURL ( $_GET );
		}

		$this->PageCount = @ceil ( $this->RecordCount / $this->PageSize ); // 计算总页数
		if ( $this->PageCount == 0 )
		{
			return FALSE;
		}

		$this->URLChar = strstr ( $this->URL, "?" ) ? "&" : "?";
		$this->CurrentPage = min ( $this->PageCount, $this->CurrentPage );
		$this->CurrentPage = max ( 1, $this->CurrentPage );		

		if ( $this->CurrentPage - $this->LinkCount > 1 )
		{
			// 省略 {$this->LinkCount} 页以前的页数链接
			$PageItems[Links][0][type] = "NOLINK";
			$PageItems[Links][0][text] = $this->Text_Overleap;
		}

		for ( $i = max ( 1, $this->CurrentPage - $this->LinkCount ); $i <= min ( $this->PageCount, $this->CurrentPage + $this->LinkCount ); $i++ )
		{
			$PageItems[Links][$i][text] = $i;
			if ( $this->CurrentPage == $i )
			{
				$PageItems[Links][$i][type] = "CURRENTPAGE";
			}
			else
			{
				$PageItems[Links][$i][type] = "LINK";
				$PageItems[Links][$i][link] = $this->URL . $this->URLChar . $this->PageVarName . "=" . $i;
			}
		}
		if ( $this->CurrentPage + $this->LinkCount < $this->PageCount )
		{
			// 省略 {$this->LinkCount} 页以后的页数链接
			$PageItems[Links][$i][type] = "NOLINK";
			$PageItems[Links][$i][text] = $this->Text_Overleap;
		}

		$PageItems[Before][0][text] = $this->Text_FirstPage;
		$PageItems[Before][1][text] = $this->Text_PrevPage;
		$PageItems[After][0][text] = $this->Text_NextPage;
		$PageItems[After][1][text] = $this->Text_LastPage;
		$PageItems[Before][0][link] = $this->URL . $this->URLChar . $this->PageVarName . "=1";
		$PageItems[Before][1][link] = $this->URL . $this->URLChar . $this->PageVarName . "=" . ( $this->CurrentPage - 1 );
		$PageItems[After][0][link] = $this->URL . $this->URLChar . $this->PageVarName . "=" . ( $this->CurrentPage + 1 );
		$PageItems[After][1][link] = $this->URL . $this->URLChar . $this->PageVarName . "=" . $this->PageCount;

		if ( $this->CurrentPage > 1 )
		{
			$PageItems[Before][0][type] = "LINK";
			$PageItems[Before][1][type] = "LINK";
		}
		else
		{
			$PageItems[Before][0][type] = "NOLINK";
			$PageItems[Before][1][type] = "NOLINK";
		}
		if ( $this->CurrentPage < $this->PageCount )
		{
			$PageItems[After][0][type] = "LINK";
			$PageItems[After][1][type] = "LINK";
		}
		else
		{
			$PageItems[After][0][type] = "NOLINK";
			$PageItems[After][1][type] = "NOLINK";
		}

		$PageItems[RecordCount] = $this->RecordCount;
		$PageItems[PageCount] = $this->PageCount;
		$PageItems[PageSize] = $this->PageSize;
		$PageItems[CurrentPage] = $this->CurrentPage;
		$PageItems[Offset] = ( $this->CurrentPage - 1 ) * $this->PageSize;
		$PageItems[RecordName] = $this->RecordName;
		$PageItems[RecordUnit] = $this->RecordUnit;

		return $PageItems;
	}

	function MakeURL ( $Data )
	{
		unset ( $Data[$this->PageVarName] );
		while ( list ( $Key, $Val ) = @each ( $Data ) )
		{
			$Query[] = $Key . '=' . urlencode ( $Val );
		}
		$URL = $_SERVER[SCRIPT_NAME] . '?' . @join ( '&', $Query );
		return $URL;
	}
}
?>