DROP TABLE IF EXISTS `pw_admin`;
CREATE TABLE `pw_admin` (
  `userid` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `username` varchar(32) NOT NULL COMMENT '管理员账号',
  `password` char(32) NOT NULL COMMENT '管理员密码',
  `lastlogintime` char(10) NOT NULL COMMENT '最后登录时间',
  `roleid` mediumint(8) NOT NULL DEFAULT '-1' COMMENT '所属角色ID',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态 1正常 0锁定',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`),
  KEY `password` (`password`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='管理员表';
DROP TABLE IF EXISTS `pw_admin_log`;
CREATE TABLE `pw_admin_log` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '日志ID',
  `event` varchar(128) NOT NULL COMMENT '事件',
  `logdate` char(10) NOT NULL COMMENT '操作日期',
  `logip` varchar(32) NOT NULL COMMENT '操作者IP',
  `userid` mediumint(8) NOT NULL COMMENT '操作者UserID',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='管理员操作日志';
DROP TABLE IF EXISTS `pw_admin_role`;
CREATE TABLE `pw_admin_role` (
  `roleid` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `name` varchar(64) NOT NULL COMMENT '角色名称',
  `privileges` text NOT NULL COMMENT '权限列表',
  PRIMARY KEY (`roleid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='管理员角色表';
DROP TABLE IF EXISTS `pw_area`;
CREATE TABLE `pw_area` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `cityid` mediumint(8) NOT NULL,
  `proid` mediumint(8) NOT NULL,
  `name` varchar(128) NOT NULL,
  `geocode` mediumint(8) NOT NULL,
  `parentid` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cityid` (`cityid`),
  KEY `proid` (`proid`),
  KEY `parentid` (`parentid`),
  KEY `geocode` (`geocode`)
) ENGINE=MyISAM AUTO_INCREMENT=659005 DEFAULT CHARSET=utf8;
REPLACE INTO `pw_area` VALUES('110101','110100','110000','东城区','110101','0');
REPLACE INTO `pw_area` VALUES('110102','110100','110000','西城区','110102','0');
REPLACE INTO `pw_area` VALUES('110105','110100','110000','朝阳区','110105','0');
REPLACE INTO `pw_area` VALUES('110106','110100','110000','丰台区','110106','0');
REPLACE INTO `pw_area` VALUES('110107','110100','110000','石景山区','110107','0');
REPLACE INTO `pw_area` VALUES('110108','110100','110000','海淀区','110108','0');
REPLACE INTO `pw_area` VALUES('110109','110100','110000','门头沟区','110109','0');
REPLACE INTO `pw_area` VALUES('110111','110100','110000','房山区','110111','0');
REPLACE INTO `pw_area` VALUES('110112','110100','110000','通州区','110112','0');
REPLACE INTO `pw_area` VALUES('110113','110100','110000','顺义区','110113','0');
REPLACE INTO `pw_area` VALUES('110114','110100','110000','昌平区','110114','0');
REPLACE INTO `pw_area` VALUES('110115','110100','110000','大兴区','110115','0');
REPLACE INTO `pw_area` VALUES('110116','110100','110000','怀柔区','110116','0');
REPLACE INTO `pw_area` VALUES('110117','110100','110000','平谷区','110117','0');
REPLACE INTO `pw_area` VALUES('110228','110200','110000','密云县','110228','0');
REPLACE INTO `pw_area` VALUES('110229','110200','110000','延庆县','110229','0');
REPLACE INTO `pw_area` VALUES('120101','120100','120000','和平区','120101','0');
REPLACE INTO `pw_area` VALUES('120102','120100','120000','河东区','120102','0');
REPLACE INTO `pw_area` VALUES('120103','120100','120000','河西区','120103','0');
REPLACE INTO `pw_area` VALUES('120104','120100','120000','南开区','120104','0');
REPLACE INTO `pw_area` VALUES('120105','120100','120000','河北区','120105','0');
REPLACE INTO `pw_area` VALUES('120106','120100','120000','红桥区','120106','0');
REPLACE INTO `pw_area` VALUES('120110','120100','120000','东丽区','120110','0');
REPLACE INTO `pw_area` VALUES('120111','120100','120000','西青区','120111','0');
REPLACE INTO `pw_area` VALUES('120112','120100','120000','津南区','120112','0');
REPLACE INTO `pw_area` VALUES('120113','120100','120000','北辰区','120113','0');
REPLACE INTO `pw_area` VALUES('120114','120100','120000','武清区','120114','0');
REPLACE INTO `pw_area` VALUES('120115','120100','120000','宝坻区','120115','0');
REPLACE INTO `pw_area` VALUES('120116','120100','120000','滨海新区','120116','0');
REPLACE INTO `pw_area` VALUES('120221','120200','120000','宁河县','120221','0');
REPLACE INTO `pw_area` VALUES('120223','120200','120000','静海县','120223','0');
REPLACE INTO `pw_area` VALUES('120225','120200','120000','蓟县','120225','0');
REPLACE INTO `pw_area` VALUES('130101','130100','130000','市辖区','130101','0');
REPLACE INTO `pw_area` VALUES('130102','130100','130000','长安区','130102','0');
REPLACE INTO `pw_area` VALUES('130103','130100','130000','桥东区','130103','0');
REPLACE INTO `pw_area` VALUES('130104','130100','130000','桥西区','130104','0');
REPLACE INTO `pw_area` VALUES('130105','130100','130000','新华区','130105','0');
REPLACE INTO `pw_area` VALUES('130107','130100','130000','井陉矿区','130107','0');
REPLACE INTO `pw_area` VALUES('130108','130100','130000','裕华区','130108','0');
REPLACE INTO `pw_area` VALUES('130121','130100','130000','井陉县','130121','0');
REPLACE INTO `pw_area` VALUES('130123','130100','130000','正定县','130123','0');
REPLACE INTO `pw_area` VALUES('130124','130100','130000','栾城县','130124','0');
REPLACE INTO `pw_area` VALUES('130125','130100','130000','行唐县','130125','0');
REPLACE INTO `pw_area` VALUES('130126','130100','130000','灵寿县','130126','0');
REPLACE INTO `pw_area` VALUES('130127','130100','130000','高邑县','130127','0');
REPLACE INTO `pw_area` VALUES('130128','130100','130000','深泽县','130128','0');
REPLACE INTO `pw_area` VALUES('130129','130100','130000','赞皇县','130129','0');
REPLACE INTO `pw_area` VALUES('130130','130100','130000','无极县','130130','0');
REPLACE INTO `pw_area` VALUES('130131','130100','130000','平山县','130131','0');
REPLACE INTO `pw_area` VALUES('130132','130100','130000','元氏县','130132','0');
REPLACE INTO `pw_area` VALUES('130133','130100','130000','赵县','130133','0');
REPLACE INTO `pw_area` VALUES('130181','130100','130000','辛集市','130181','0');
REPLACE INTO `pw_area` VALUES('130182','130100','130000','藁城市','130182','0');
REPLACE INTO `pw_area` VALUES('130183','130100','130000','晋州市','130183','0');
REPLACE INTO `pw_area` VALUES('130184','130100','130000','新乐市','130184','0');
REPLACE INTO `pw_area` VALUES('130185','130100','130000','鹿泉市','130185','0');
REPLACE INTO `pw_area` VALUES('130201','130200','130000','市辖区','130201','0');
REPLACE INTO `pw_area` VALUES('130202','130200','130000','路南区','130202','0');
REPLACE INTO `pw_area` VALUES('130203','130200','130000','路北区','130203','0');
REPLACE INTO `pw_area` VALUES('130204','130200','130000','古冶区','130204','0');
REPLACE INTO `pw_area` VALUES('130205','130200','130000','开平区','130205','0');
REPLACE INTO `pw_area` VALUES('130207','130200','130000','丰南区','130207','0');
REPLACE INTO `pw_area` VALUES('130208','130200','130000','丰润区','130208','0');
REPLACE INTO `pw_area` VALUES('130209','130200','130000','曹妃甸区','130209','0');
REPLACE INTO `pw_area` VALUES('130223','130200','130000','滦县','130223','0');
REPLACE INTO `pw_area` VALUES('130224','130200','130000','滦南县','130224','0');
REPLACE INTO `pw_area` VALUES('130225','130200','130000','乐亭县','130225','0');
REPLACE INTO `pw_area` VALUES('130227','130200','130000','迁西县','130227','0');
REPLACE INTO `pw_area` VALUES('130229','130200','130000','玉田县','130229','0');
REPLACE INTO `pw_area` VALUES('130281','130200','130000','遵化市','130281','0');
REPLACE INTO `pw_area` VALUES('130283','130200','130000','迁安市','130283','0');
REPLACE INTO `pw_area` VALUES('130301','130300','130000','市辖区','130301','0');
REPLACE INTO `pw_area` VALUES('130302','130300','130000','海港区','130302','0');
REPLACE INTO `pw_area` VALUES('130303','130300','130000','山海关区','130303','0');
REPLACE INTO `pw_area` VALUES('130304','130300','130000','北戴河区','130304','0');
REPLACE INTO `pw_area` VALUES('130321','130300','130000','青龙满族自治县','130321','0');
REPLACE INTO `pw_area` VALUES('130322','130300','130000','昌黎县','130322','0');
REPLACE INTO `pw_area` VALUES('130323','130300','130000','抚宁县','130323','0');
REPLACE INTO `pw_area` VALUES('130324','130300','130000','卢龙县','130324','0');
REPLACE INTO `pw_area` VALUES('130401','130400','130000','市辖区','130401','0');
REPLACE INTO `pw_area` VALUES('130402','130400','130000','邯山区','130402','0');
REPLACE INTO `pw_area` VALUES('130403','130400','130000','丛台区','130403','0');
REPLACE INTO `pw_area` VALUES('130404','130400','130000','复兴区','130404','0');
REPLACE INTO `pw_area` VALUES('130406','130400','130000','峰峰矿区','130406','0');
REPLACE INTO `pw_area` VALUES('130421','130400','130000','邯郸县','130421','0');
REPLACE INTO `pw_area` VALUES('130423','130400','130000','临漳县','130423','0');
REPLACE INTO `pw_area` VALUES('130424','130400','130000','成安县','130424','0');
REPLACE INTO `pw_area` VALUES('130425','130400','130000','大名县','130425','0');
REPLACE INTO `pw_area` VALUES('130426','130400','130000','涉县','130426','0');
REPLACE INTO `pw_area` VALUES('130427','130400','130000','磁县','130427','0');
REPLACE INTO `pw_area` VALUES('130428','130400','130000','肥乡县','130428','0');
REPLACE INTO `pw_area` VALUES('130429','130400','130000','永年县','130429','0');
REPLACE INTO `pw_area` VALUES('130430','130400','130000','邱县','130430','0');
REPLACE INTO `pw_area` VALUES('130431','130400','130000','鸡泽县','130431','0');
REPLACE INTO `pw_area` VALUES('130432','130400','130000','广平县','130432','0');
REPLACE INTO `pw_area` VALUES('130433','130400','130000','馆陶县','130433','0');
REPLACE INTO `pw_area` VALUES('130434','130400','130000','魏县','130434','0');
REPLACE INTO `pw_area` VALUES('130435','130400','130000','曲周县','130435','0');
REPLACE INTO `pw_area` VALUES('130481','130400','130000','武安市','130481','0');
REPLACE INTO `pw_area` VALUES('130501','130500','130000','市辖区','130501','0');
REPLACE INTO `pw_area` VALUES('130502','130500','130000','桥东区','130502','0');
REPLACE INTO `pw_area` VALUES('130503','130500','130000','桥西区','130503','0');
REPLACE INTO `pw_area` VALUES('130521','130500','130000','邢台县','130521','0');
REPLACE INTO `pw_area` VALUES('130522','130500','130000','临城县','130522','0');
REPLACE INTO `pw_area` VALUES('130523','130500','130000','内丘县','130523','0');
REPLACE INTO `pw_area` VALUES('130524','130500','130000','柏乡县','130524','0');
REPLACE INTO `pw_area` VALUES('130525','130500','130000','隆尧县','130525','0');
REPLACE INTO `pw_area` VALUES('130526','130500','130000','任县','130526','0');
REPLACE INTO `pw_area` VALUES('130527','130500','130000','南和县','130527','0');
REPLACE INTO `pw_area` VALUES('130528','130500','130000','宁晋县','130528','0');
REPLACE INTO `pw_area` VALUES('130529','130500','130000','巨鹿县','130529','0');
REPLACE INTO `pw_area` VALUES('130530','130500','130000','新河县','130530','0');
REPLACE INTO `pw_area` VALUES('130531','130500','130000','广宗县','130531','0');
REPLACE INTO `pw_area` VALUES('130532','130500','130000','平乡县','130532','0');
REPLACE INTO `pw_area` VALUES('130533','130500','130000','威县','130533','0');
REPLACE INTO `pw_area` VALUES('130534','130500','130000','清河县','130534','0');
REPLACE INTO `pw_area` VALUES('130535','130500','130000','临西县','130535','0');
REPLACE INTO `pw_area` VALUES('130581','130500','130000','南宫市','130581','0');
REPLACE INTO `pw_area` VALUES('130582','130500','130000','沙河市','130582','0');
REPLACE INTO `pw_area` VALUES('130601','130600','130000','市辖区','130601','0');
REPLACE INTO `pw_area` VALUES('130602','130600','130000','新市区','130602','0');
REPLACE INTO `pw_area` VALUES('130603','130600','130000','北市区','130603','0');
REPLACE INTO `pw_area` VALUES('130604','130600','130000','南市区','130604','0');
REPLACE INTO `pw_area` VALUES('130621','130600','130000','满城县','130621','0');
REPLACE INTO `pw_area` VALUES('130622','130600','130000','清苑县','130622','0');
REPLACE INTO `pw_area` VALUES('130623','130600','130000','涞水县','130623','0');
REPLACE INTO `pw_area` VALUES('130624','130600','130000','阜平县','130624','0');
REPLACE INTO `pw_area` VALUES('130625','130600','130000','徐水县','130625','0');
REPLACE INTO `pw_area` VALUES('130626','130600','130000','定兴县','130626','0');
REPLACE INTO `pw_area` VALUES('130627','130600','130000','唐县','130627','0');
REPLACE INTO `pw_area` VALUES('130628','130600','130000','高阳县','130628','0');
REPLACE INTO `pw_area` VALUES('130629','130600','130000','容城县','130629','0');
REPLACE INTO `pw_area` VALUES('130630','130600','130000','涞源县','130630','0');
REPLACE INTO `pw_area` VALUES('130631','130600','130000','望都县','130631','0');
REPLACE INTO `pw_area` VALUES('130632','130600','130000','安新县','130632','0');
REPLACE INTO `pw_area` VALUES('130633','130600','130000','易县','130633','0');
REPLACE INTO `pw_area` VALUES('130634','130600','130000','曲阳县','130634','0');
REPLACE INTO `pw_area` VALUES('130635','130600','130000','蠡县','130635','0');
REPLACE INTO `pw_area` VALUES('130636','130600','130000','顺平县','130636','0');
REPLACE INTO `pw_area` VALUES('130637','130600','130000','博野县','130637','0');
REPLACE INTO `pw_area` VALUES('130638','130600','130000','雄县','130638','0');
REPLACE INTO `pw_area` VALUES('130681','130600','130000','涿州市','130681','0');
REPLACE INTO `pw_area` VALUES('130682','130600','130000','定州市','130682','0');
REPLACE INTO `pw_area` VALUES('130683','130600','130000','安国市','130683','0');
REPLACE INTO `pw_area` VALUES('130684','130600','130000','高碑店市','130684','0');
REPLACE INTO `pw_area` VALUES('130701','130700','130000','市辖区','130701','0');
REPLACE INTO `pw_area` VALUES('130702','130700','130000','桥东区','130702','0');
REPLACE INTO `pw_area` VALUES('130703','130700','130000','桥西区','130703','0');
REPLACE INTO `pw_area` VALUES('130705','130700','130000','宣化区','130705','0');
REPLACE INTO `pw_area` VALUES('130706','130700','130000','下花园区','130706','0');
REPLACE INTO `pw_area` VALUES('130721','130700','130000','宣化县','130721','0');
REPLACE INTO `pw_area` VALUES('130722','130700','130000','张北县','130722','0');
REPLACE INTO `pw_area` VALUES('130723','130700','130000','康保县','130723','0');
REPLACE INTO `pw_area` VALUES('130724','130700','130000','沽源县','130724','0');
REPLACE INTO `pw_area` VALUES('130725','130700','130000','尚义县','130725','0');
REPLACE INTO `pw_area` VALUES('130726','130700','130000','蔚县','130726','0');
REPLACE INTO `pw_area` VALUES('130727','130700','130000','阳原县','130727','0');
REPLACE INTO `pw_area` VALUES('130728','130700','130000','怀安县','130728','0');
REPLACE INTO `pw_area` VALUES('130729','130700','130000','万全县','130729','0');
REPLACE INTO `pw_area` VALUES('130730','130700','130000','怀来县','130730','0');
REPLACE INTO `pw_area` VALUES('130731','130700','130000','涿鹿县','130731','0');
REPLACE INTO `pw_area` VALUES('130732','130700','130000','赤城县','130732','0');
REPLACE INTO `pw_area` VALUES('130733','130700','130000','崇礼县','130733','0');
REPLACE INTO `pw_area` VALUES('130801','130800','130000','市辖区','130801','0');
REPLACE INTO `pw_area` VALUES('130802','130800','130000','双桥区','130802','0');
REPLACE INTO `pw_area` VALUES('130803','130800','130000','双滦区','130803','0');
REPLACE INTO `pw_area` VALUES('130804','130800','130000','鹰手营子矿区','130804','0');
REPLACE INTO `pw_area` VALUES('130821','130800','130000','承德县','130821','0');
REPLACE INTO `pw_area` VALUES('130822','130800','130000','兴隆县','130822','0');
REPLACE INTO `pw_area` VALUES('130823','130800','130000','平泉县','130823','0');
REPLACE INTO `pw_area` VALUES('130824','130800','130000','滦平县','130824','0');
REPLACE INTO `pw_area` VALUES('130825','130800','130000','隆化县','130825','0');
REPLACE INTO `pw_area` VALUES('130826','130800','130000','丰宁满族自治县','130826','0');
REPLACE INTO `pw_area` VALUES('130827','130800','130000','宽城满族自治县','130827','0');
REPLACE INTO `pw_area` VALUES('130828','130800','130000','围场满族蒙古族自治县','130828','0');
REPLACE INTO `pw_area` VALUES('130901','130900','130000','市辖区','130901','0');
REPLACE INTO `pw_area` VALUES('130902','130900','130000','新华区','130902','0');
REPLACE INTO `pw_area` VALUES('130903','130900','130000','运河区','130903','0');
REPLACE INTO `pw_area` VALUES('130921','130900','130000','沧县','130921','0');
REPLACE INTO `pw_area` VALUES('130922','130900','130000','青县','130922','0');
REPLACE INTO `pw_area` VALUES('130923','130900','130000','东光县','130923','0');
REPLACE INTO `pw_area` VALUES('130924','130900','130000','海兴县','130924','0');
REPLACE INTO `pw_area` VALUES('130925','130900','130000','盐山县','130925','0');
REPLACE INTO `pw_area` VALUES('130926','130900','130000','肃宁县','130926','0');
REPLACE INTO `pw_area` VALUES('130927','130900','130000','南皮县','130927','0');
REPLACE INTO `pw_area` VALUES('130928','130900','130000','吴桥县','130928','0');
REPLACE INTO `pw_area` VALUES('130929','130900','130000','献县','130929','0');
REPLACE INTO `pw_area` VALUES('130930','130900','130000','孟村回族自治县','130930','0');
REPLACE INTO `pw_area` VALUES('130981','130900','130000','泊头市','130981','0');
REPLACE INTO `pw_area` VALUES('130982','130900','130000','任丘市','130982','0');
REPLACE INTO `pw_area` VALUES('130983','130900','130000','黄骅市','130983','0');
REPLACE INTO `pw_area` VALUES('130984','130900','130000','河间市','130984','0');
REPLACE INTO `pw_area` VALUES('131001','131000','130000','市辖区','131001','0');
REPLACE INTO `pw_area` VALUES('131002','131000','130000','安次区','131002','0');
REPLACE INTO `pw_area` VALUES('131003','131000','130000','广阳区','131003','0');
REPLACE INTO `pw_area` VALUES('131022','131000','130000','固安县','131022','0');
REPLACE INTO `pw_area` VALUES('131023','131000','130000','永清县','131023','0');
REPLACE INTO `pw_area` VALUES('131024','131000','130000','香河县','131024','0');
REPLACE INTO `pw_area` VALUES('131025','131000','130000','大城县','131025','0');
REPLACE INTO `pw_area` VALUES('131026','131000','130000','文安县','131026','0');
REPLACE INTO `pw_area` VALUES('131028','131000','130000','大厂回族自治县','131028','0');
REPLACE INTO `pw_area` VALUES('131081','131000','130000','霸州市','131081','0');
REPLACE INTO `pw_area` VALUES('131082','131000','130000','三河市','131082','0');
REPLACE INTO `pw_area` VALUES('131101','131100','130000','市辖区','131101','0');
REPLACE INTO `pw_area` VALUES('131102','131100','130000','桃城区','131102','0');
REPLACE INTO `pw_area` VALUES('131121','131100','130000','枣强县','131121','0');
REPLACE INTO `pw_area` VALUES('131122','131100','130000','武邑县','131122','0');
REPLACE INTO `pw_area` VALUES('131123','131100','130000','武强县','131123','0');
REPLACE INTO `pw_area` VALUES('131124','131100','130000','饶阳县','131124','0');
REPLACE INTO `pw_area` VALUES('131125','131100','130000','安平县','131125','0');
REPLACE INTO `pw_area` VALUES('131126','131100','130000','故城县','131126','0');
REPLACE INTO `pw_area` VALUES('131127','131100','130000','景县','131127','0');
REPLACE INTO `pw_area` VALUES('131128','131100','130000','阜城县','131128','0');
REPLACE INTO `pw_area` VALUES('131181','131100','130000','冀州市','131181','0');
REPLACE INTO `pw_area` VALUES('131182','131100','130000','深州市','131182','0');
REPLACE INTO `pw_area` VALUES('140101','140100','140000','市辖区','140101','0');
REPLACE INTO `pw_area` VALUES('140105','140100','140000','小店区','140105','0');
REPLACE INTO `pw_area` VALUES('140106','140100','140000','迎泽区','140106','0');
REPLACE INTO `pw_area` VALUES('140107','140100','140000','杏花岭区','140107','0');
REPLACE INTO `pw_area` VALUES('140108','140100','140000','尖草坪区','140108','0');
REPLACE INTO `pw_area` VALUES('140109','140100','140000','万柏林区','140109','0');
REPLACE INTO `pw_area` VALUES('140110','140100','140000','晋源区','140110','0');
REPLACE INTO `pw_area` VALUES('140121','140100','140000','清徐县','140121','0');
REPLACE INTO `pw_area` VALUES('140122','140100','140000','阳曲县','140122','0');
REPLACE INTO `pw_area` VALUES('140123','140100','140000','娄烦县','140123','0');
REPLACE INTO `pw_area` VALUES('140181','140100','140000','古交市','140181','0');
REPLACE INTO `pw_area` VALUES('140201','140200','140000','市辖区','140201','0');
REPLACE INTO `pw_area` VALUES('140202','140200','140000','城区','140202','0');
REPLACE INTO `pw_area` VALUES('140203','140200','140000','矿区','140203','0');
REPLACE INTO `pw_area` VALUES('140211','140200','140000','南郊区','140211','0');
REPLACE INTO `pw_area` VALUES('140212','140200','140000','新荣区','140212','0');
REPLACE INTO `pw_area` VALUES('140221','140200','140000','阳高县','140221','0');
REPLACE INTO `pw_area` VALUES('140222','140200','140000','天镇县','140222','0');
REPLACE INTO `pw_area` VALUES('140223','140200','140000','广灵县','140223','0');
REPLACE INTO `pw_area` VALUES('140224','140200','140000','灵丘县','140224','0');
REPLACE INTO `pw_area` VALUES('140225','140200','140000','浑源县','140225','0');
REPLACE INTO `pw_area` VALUES('140226','140200','140000','左云县','140226','0');
REPLACE INTO `pw_area` VALUES('140227','140200','140000','大同县','140227','0');
REPLACE INTO `pw_area` VALUES('140301','140300','140000','市辖区','140301','0');
REPLACE INTO `pw_area` VALUES('140302','140300','140000','城区','140302','0');
REPLACE INTO `pw_area` VALUES('140303','140300','140000','矿区','140303','0');
REPLACE INTO `pw_area` VALUES('140311','140300','140000','郊区','140311','0');
REPLACE INTO `pw_area` VALUES('140321','140300','140000','平定县','140321','0');
REPLACE INTO `pw_area` VALUES('140322','140300','140000','盂县','140322','0');
REPLACE INTO `pw_area` VALUES('140401','140400','140000','市辖区','140401','0');
REPLACE INTO `pw_area` VALUES('140402','140400','140000','城区','140402','0');
REPLACE INTO `pw_area` VALUES('140411','140400','140000','郊区','140411','0');
REPLACE INTO `pw_area` VALUES('140421','140400','140000','长治县','140421','0');
REPLACE INTO `pw_area` VALUES('140423','140400','140000','襄垣县','140423','0');
REPLACE INTO `pw_area` VALUES('140424','140400','140000','屯留县','140424','0');
REPLACE INTO `pw_area` VALUES('140425','140400','140000','平顺县','140425','0');
REPLACE INTO `pw_area` VALUES('140426','140400','140000','黎城县','140426','0');
REPLACE INTO `pw_area` VALUES('140427','140400','140000','壶关县','140427','0');
REPLACE INTO `pw_area` VALUES('140428','140400','140000','长子县','140428','0');
REPLACE INTO `pw_area` VALUES('140429','140400','140000','武乡县','140429','0');
REPLACE INTO `pw_area` VALUES('140430','140400','140000','沁县','140430','0');
REPLACE INTO `pw_area` VALUES('140431','140400','140000','沁源县','140431','0');
REPLACE INTO `pw_area` VALUES('140481','140400','140000','潞城市','140481','0');
REPLACE INTO `pw_area` VALUES('140501','140500','140000','市辖区','140501','0');
REPLACE INTO `pw_area` VALUES('140502','140500','140000','城区','140502','0');
REPLACE INTO `pw_area` VALUES('140521','140500','140000','沁水县','140521','0');
REPLACE INTO `pw_area` VALUES('140522','140500','140000','阳城县','140522','0');
REPLACE INTO `pw_area` VALUES('140524','140500','140000','陵川县','140524','0');
REPLACE INTO `pw_area` VALUES('140525','140500','140000','泽州县','140525','0');
REPLACE INTO `pw_area` VALUES('140581','140500','140000','高平市','140581','0');
REPLACE INTO `pw_area` VALUES('140601','140600','140000','市辖区','140601','0');
REPLACE INTO `pw_area` VALUES('140602','140600','140000','朔城区','140602','0');
REPLACE INTO `pw_area` VALUES('140603','140600','140000','平鲁区','140603','0');
REPLACE INTO `pw_area` VALUES('140621','140600','140000','山阴县','140621','0');
REPLACE INTO `pw_area` VALUES('140622','140600','140000','应县','140622','0');
REPLACE INTO `pw_area` VALUES('140623','140600','140000','右玉县','140623','0');
REPLACE INTO `pw_area` VALUES('140624','140600','140000','怀仁县','140624','0');
REPLACE INTO `pw_area` VALUES('140701','140700','140000','市辖区','140701','0');
REPLACE INTO `pw_area` VALUES('140702','140700','140000','榆次区','140702','0');
REPLACE INTO `pw_area` VALUES('140721','140700','140000','榆社县','140721','0');
REPLACE INTO `pw_area` VALUES('140722','140700','140000','左权县','140722','0');
REPLACE INTO `pw_area` VALUES('140723','140700','140000','和顺县','140723','0');
REPLACE INTO `pw_area` VALUES('140724','140700','140000','昔阳县','140724','0');
REPLACE INTO `pw_area` VALUES('140725','140700','140000','寿阳县','140725','0');
REPLACE INTO `pw_area` VALUES('140726','140700','140000','太谷县','140726','0');
REPLACE INTO `pw_area` VALUES('140727','140700','140000','祁县','140727','0');
REPLACE INTO `pw_area` VALUES('140728','140700','140000','平遥县','140728','0');
REPLACE INTO `pw_area` VALUES('140729','140700','140000','灵石县','140729','0');
REPLACE INTO `pw_area` VALUES('140781','140700','140000','介休市','140781','0');
REPLACE INTO `pw_area` VALUES('140801','140800','140000','市辖区','140801','0');
REPLACE INTO `pw_area` VALUES('140802','140800','140000','盐湖区','140802','0');
REPLACE INTO `pw_area` VALUES('140821','140800','140000','临猗县','140821','0');
REPLACE INTO `pw_area` VALUES('140822','140800','140000','万荣县','140822','0');
REPLACE INTO `pw_area` VALUES('140823','140800','140000','闻喜县','140823','0');
REPLACE INTO `pw_area` VALUES('140824','140800','140000','稷山县','140824','0');
REPLACE INTO `pw_area` VALUES('140825','140800','140000','新绛县','140825','0');
REPLACE INTO `pw_area` VALUES('140826','140800','140000','绛县','140826','0');
REPLACE INTO `pw_area` VALUES('140827','140800','140000','垣曲县','140827','0');
REPLACE INTO `pw_area` VALUES('140828','140800','140000','夏县','140828','0');
REPLACE INTO `pw_area` VALUES('140829','140800','140000','平陆县','140829','0');
REPLACE INTO `pw_area` VALUES('140830','140800','140000','芮城县','140830','0');
REPLACE INTO `pw_area` VALUES('140881','140800','140000','永济市','140881','0');
REPLACE INTO `pw_area` VALUES('140882','140800','140000','河津市','140882','0');
REPLACE INTO `pw_area` VALUES('140901','140900','140000','市辖区','140901','0');
REPLACE INTO `pw_area` VALUES('140902','140900','140000','忻府区','140902','0');
REPLACE INTO `pw_area` VALUES('140921','140900','140000','定襄县','140921','0');
REPLACE INTO `pw_area` VALUES('140922','140900','140000','五台县','140922','0');
REPLACE INTO `pw_area` VALUES('140923','140900','140000','代县','140923','0');
REPLACE INTO `pw_area` VALUES('140924','140900','140000','繁峙县','140924','0');
REPLACE INTO `pw_area` VALUES('140925','140900','140000','宁武县','140925','0');
REPLACE INTO `pw_area` VALUES('140926','140900','140000','静乐县','140926','0');
REPLACE INTO `pw_area` VALUES('140927','140900','140000','神池县','140927','0');
REPLACE INTO `pw_area` VALUES('140928','140900','140000','五寨县','140928','0');
REPLACE INTO `pw_area` VALUES('140929','140900','140000','岢岚县','140929','0');
REPLACE INTO `pw_area` VALUES('140930','140900','140000','河曲县','140930','0');
REPLACE INTO `pw_area` VALUES('140931','140900','140000','保德县','140931','0');
REPLACE INTO `pw_area` VALUES('140932','140900','140000','偏关县','140932','0');
REPLACE INTO `pw_area` VALUES('140981','140900','140000','原平市','140981','0');
REPLACE INTO `pw_area` VALUES('141001','141000','140000','市辖区','141001','0');
REPLACE INTO `pw_area` VALUES('141002','141000','140000','尧都区','141002','0');
REPLACE INTO `pw_area` VALUES('141021','141000','140000','曲沃县','141021','0');
REPLACE INTO `pw_area` VALUES('141022','141000','140000','翼城县','141022','0');
REPLACE INTO `pw_area` VALUES('141023','141000','140000','襄汾县','141023','0');
REPLACE INTO `pw_area` VALUES('141024','141000','140000','洪洞县','141024','0');
REPLACE INTO `pw_area` VALUES('141025','141000','140000','古县','141025','0');
REPLACE INTO `pw_area` VALUES('141026','141000','140000','安泽县','141026','0');
REPLACE INTO `pw_area` VALUES('141027','141000','140000','浮山县','141027','0');
REPLACE INTO `pw_area` VALUES('141028','141000','140000','吉县','141028','0');
REPLACE INTO `pw_area` VALUES('141029','141000','140000','乡宁县','141029','0');
REPLACE INTO `pw_area` VALUES('141030','141000','140000','大宁县','141030','0');
REPLACE INTO `pw_area` VALUES('141031','141000','140000','隰县','141031','0');
REPLACE INTO `pw_area` VALUES('141032','141000','140000','永和县','141032','0');
REPLACE INTO `pw_area` VALUES('141033','141000','140000','蒲县','141033','0');
REPLACE INTO `pw_area` VALUES('141034','141000','140000','汾西县','141034','0');
REPLACE INTO `pw_area` VALUES('141081','141000','140000','侯马市','141081','0');
REPLACE INTO `pw_area` VALUES('141082','141000','140000','霍州市','141082','0');
REPLACE INTO `pw_area` VALUES('141101','141100','140000','市辖区','141101','0');
REPLACE INTO `pw_area` VALUES('141102','141100','140000','离石区','141102','0');
REPLACE INTO `pw_area` VALUES('141121','141100','140000','文水县','141121','0');
REPLACE INTO `pw_area` VALUES('141122','141100','140000','交城县','141122','0');
REPLACE INTO `pw_area` VALUES('141123','141100','140000','兴县','141123','0');
REPLACE INTO `pw_area` VALUES('141124','141100','140000','临县','141124','0');
REPLACE INTO `pw_area` VALUES('141125','141100','140000','柳林县','141125','0');
REPLACE INTO `pw_area` VALUES('141126','141100','140000','石楼县','141126','0');
REPLACE INTO `pw_area` VALUES('141127','141100','140000','岚县','141127','0');
REPLACE INTO `pw_area` VALUES('141128','141100','140000','方山县','141128','0');
REPLACE INTO `pw_area` VALUES('141129','141100','140000','中阳县','141129','0');
REPLACE INTO `pw_area` VALUES('141130','141100','140000','交口县','141130','0');
REPLACE INTO `pw_area` VALUES('141181','141100','140000','孝义市','141181','0');
REPLACE INTO `pw_area` VALUES('141182','141100','140000','汾阳市','141182','0');
REPLACE INTO `pw_area` VALUES('150101','150100','150000','市辖区','150101','0');
REPLACE INTO `pw_area` VALUES('150102','150100','150000','新城区','150102','0');
REPLACE INTO `pw_area` VALUES('150103','150100','150000','回民区','150103','0');
REPLACE INTO `pw_area` VALUES('150104','150100','150000','玉泉区','150104','0');
REPLACE INTO `pw_area` VALUES('150105','150100','150000','赛罕区','150105','0');
REPLACE INTO `pw_area` VALUES('150121','150100','150000','土默特左旗','150121','0');
REPLACE INTO `pw_area` VALUES('150122','150100','150000','托克托县','150122','0');
REPLACE INTO `pw_area` VALUES('150123','150100','150000','和林格尔县','150123','0');
REPLACE INTO `pw_area` VALUES('150124','150100','150000','清水河县','150124','0');
REPLACE INTO `pw_area` VALUES('150125','150100','150000','武川县','150125','0');
REPLACE INTO `pw_area` VALUES('150201','150200','150000','市辖区','150201','0');
REPLACE INTO `pw_area` VALUES('150202','150200','150000','东河区','150202','0');
REPLACE INTO `pw_area` VALUES('150203','150200','150000','昆都仑区','150203','0');
REPLACE INTO `pw_area` VALUES('150204','150200','150000','青山区','150204','0');
REPLACE INTO `pw_area` VALUES('150205','150200','150000','石拐区','150205','0');
REPLACE INTO `pw_area` VALUES('150206','150200','150000','白云鄂博矿区','150206','0');
REPLACE INTO `pw_area` VALUES('150207','150200','150000','九原区','150207','0');
REPLACE INTO `pw_area` VALUES('150221','150200','150000','土默特右旗','150221','0');
REPLACE INTO `pw_area` VALUES('150222','150200','150000','固阳县','150222','0');
REPLACE INTO `pw_area` VALUES('150223','150200','150000','达尔罕茂明安联合旗','150223','0');
REPLACE INTO `pw_area` VALUES('150301','150300','150000','市辖区','150301','0');
REPLACE INTO `pw_area` VALUES('150302','150300','150000','海勃湾区','150302','0');
REPLACE INTO `pw_area` VALUES('150303','150300','150000','海南区','150303','0');
REPLACE INTO `pw_area` VALUES('150304','150300','150000','乌达区','150304','0');
REPLACE INTO `pw_area` VALUES('150401','150400','150000','市辖区','150401','0');
REPLACE INTO `pw_area` VALUES('150402','150400','150000','红山区','150402','0');
REPLACE INTO `pw_area` VALUES('150403','150400','150000','元宝山区','150403','0');
REPLACE INTO `pw_area` VALUES('150404','150400','150000','松山区','150404','0');
REPLACE INTO `pw_area` VALUES('150421','150400','150000','阿鲁科尔沁旗','150421','0');
REPLACE INTO `pw_area` VALUES('150422','150400','150000','巴林左旗','150422','0');
REPLACE INTO `pw_area` VALUES('150423','150400','150000','巴林右旗','150423','0');
REPLACE INTO `pw_area` VALUES('150424','150400','150000','林西县','150424','0');
REPLACE INTO `pw_area` VALUES('150425','150400','150000','克什克腾旗','150425','0');
REPLACE INTO `pw_area` VALUES('150426','150400','150000','翁牛特旗','150426','0');
REPLACE INTO `pw_area` VALUES('150428','150400','150000','喀喇沁旗','150428','0');
REPLACE INTO `pw_area` VALUES('150429','150400','150000','宁城县','150429','0');
REPLACE INTO `pw_area` VALUES('150430','150400','150000','敖汉旗','150430','0');
REPLACE INTO `pw_area` VALUES('150501','150500','150000','市辖区','150501','0');
REPLACE INTO `pw_area` VALUES('150502','150500','150000','科尔沁区','150502','0');
REPLACE INTO `pw_area` VALUES('150521','150500','150000','科尔沁左翼中旗','150521','0');
REPLACE INTO `pw_area` VALUES('150522','150500','150000','科尔沁左翼后旗','150522','0');
REPLACE INTO `pw_area` VALUES('150523','150500','150000','开鲁县','150523','0');
REPLACE INTO `pw_area` VALUES('150524','150500','150000','库伦旗','150524','0');
REPLACE INTO `pw_area` VALUES('150525','150500','150000','奈曼旗','150525','0');
REPLACE INTO `pw_area` VALUES('150526','150500','150000','扎鲁特旗','150526','0');
REPLACE INTO `pw_area` VALUES('150581','150500','150000','霍林郭勒市','150581','0');
REPLACE INTO `pw_area` VALUES('150601','150600','150000','市辖区','150601','0');
REPLACE INTO `pw_area` VALUES('150602','150600','150000','东胜区','150602','0');
REPLACE INTO `pw_area` VALUES('150621','150600','150000','达拉特旗','150621','0');
REPLACE INTO `pw_area` VALUES('150622','150600','150000','准格尔旗','150622','0');
REPLACE INTO `pw_area` VALUES('150623','150600','150000','鄂托克前旗','150623','0');
REPLACE INTO `pw_area` VALUES('150624','150600','150000','鄂托克旗','150624','0');
REPLACE INTO `pw_area` VALUES('150625','150600','150000','杭锦旗','150625','0');
REPLACE INTO `pw_area` VALUES('150626','150600','150000','乌审旗','150626','0');
REPLACE INTO `pw_area` VALUES('150627','150600','150000','伊金霍洛旗','150627','0');
REPLACE INTO `pw_area` VALUES('150701','150700','150000','市辖区','150701','0');
REPLACE INTO `pw_area` VALUES('150702','150700','150000','海拉尔区','150702','0');
REPLACE INTO `pw_area` VALUES('150703','150700','150000','扎赉诺尔区','150703','0');
REPLACE INTO `pw_area` VALUES('150721','150700','150000','阿荣旗','150721','0');
REPLACE INTO `pw_area` VALUES('150722','150700','150000','莫力达瓦达斡尔族自治旗','150722','0');
REPLACE INTO `pw_area` VALUES('150723','150700','150000','鄂伦春自治旗','150723','0');
REPLACE INTO `pw_area` VALUES('150724','150700','150000','鄂温克族自治旗','150724','0');
REPLACE INTO `pw_area` VALUES('150725','150700','150000','陈巴尔虎旗','150725','0');
REPLACE INTO `pw_area` VALUES('150726','150700','150000','新巴尔虎左旗','150726','0');
REPLACE INTO `pw_area` VALUES('150727','150700','150000','新巴尔虎右旗','150727','0');
REPLACE INTO `pw_area` VALUES('150781','150700','150000','满洲里市','150781','0');
REPLACE INTO `pw_area` VALUES('150782','150700','150000','牙克石市','150782','0');
REPLACE INTO `pw_area` VALUES('150783','150700','150000','扎兰屯市','150783','0');
REPLACE INTO `pw_area` VALUES('150784','150700','150000','额尔古纳市','150784','0');
REPLACE INTO `pw_area` VALUES('150785','150700','150000','根河市','150785','0');
REPLACE INTO `pw_area` VALUES('150801','150800','150000','市辖区','150801','0');
REPLACE INTO `pw_area` VALUES('150802','150800','150000','临河区','150802','0');
REPLACE INTO `pw_area` VALUES('150821','150800','150000','五原县','150821','0');
REPLACE INTO `pw_area` VALUES('150822','150800','150000','磴口县','150822','0');
REPLACE INTO `pw_area` VALUES('150823','150800','150000','乌拉特前旗','150823','0');
REPLACE INTO `pw_area` VALUES('150824','150800','150000','乌拉特中旗','150824','0');
REPLACE INTO `pw_area` VALUES('150825','150800','150000','乌拉特后旗','150825','0');
REPLACE INTO `pw_area` VALUES('150826','150800','150000','杭锦后旗','150826','0');
REPLACE INTO `pw_area` VALUES('150901','150900','150000','市辖区','150901','0');
REPLACE INTO `pw_area` VALUES('150902','150900','150000','集宁区','150902','0');
REPLACE INTO `pw_area` VALUES('150921','150900','150000','卓资县','150921','0');
REPLACE INTO `pw_area` VALUES('150922','150900','150000','化德县','150922','0');
REPLACE INTO `pw_area` VALUES('150923','150900','150000','商都县','150923','0');
REPLACE INTO `pw_area` VALUES('150924','150900','150000','兴和县','150924','0');
REPLACE INTO `pw_area` VALUES('150925','150900','150000','凉城县','150925','0');
REPLACE INTO `pw_area` VALUES('150926','150900','150000','察哈尔右翼前旗','150926','0');
REPLACE INTO `pw_area` VALUES('150927','150900','150000','察哈尔右翼中旗','150927','0');
REPLACE INTO `pw_area` VALUES('150928','150900','150000','察哈尔右翼后旗','150928','0');
REPLACE INTO `pw_area` VALUES('150929','150900','150000','四子王旗','150929','0');
REPLACE INTO `pw_area` VALUES('150981','150900','150000','丰镇市','150981','0');
REPLACE INTO `pw_area` VALUES('152201','152200','150000','乌兰浩特市','152201','0');
REPLACE INTO `pw_area` VALUES('152202','152200','150000','阿尔山市','152202','0');
REPLACE INTO `pw_area` VALUES('152221','152200','150000','科尔沁右翼前旗','152221','0');
REPLACE INTO `pw_area` VALUES('152222','152200','150000','科尔沁右翼中旗','152222','0');
REPLACE INTO `pw_area` VALUES('152223','152200','150000','扎赉特旗','152223','0');
REPLACE INTO `pw_area` VALUES('152224','152200','150000','突泉县','152224','0');
REPLACE INTO `pw_area` VALUES('152501','152500','150000','二连浩特市','152501','0');
REPLACE INTO `pw_area` VALUES('152502','152500','150000','锡林浩特市','152502','0');
REPLACE INTO `pw_area` VALUES('152522','152500','150000','阿巴嘎旗','152522','0');
REPLACE INTO `pw_area` VALUES('152523','152500','150000','苏尼特左旗','152523','0');
REPLACE INTO `pw_area` VALUES('152524','152500','150000','苏尼特右旗','152524','0');
REPLACE INTO `pw_area` VALUES('152525','152500','150000','东乌珠穆沁旗','152525','0');
REPLACE INTO `pw_area` VALUES('152526','152500','150000','西乌珠穆沁旗','152526','0');
REPLACE INTO `pw_area` VALUES('152527','152500','150000','太仆寺旗','152527','0');
REPLACE INTO `pw_area` VALUES('152528','152500','150000','镶黄旗','152528','0');
REPLACE INTO `pw_area` VALUES('152529','152500','150000','正镶白旗','152529','0');
REPLACE INTO `pw_area` VALUES('152530','152500','150000','正蓝旗','152530','0');
REPLACE INTO `pw_area` VALUES('152531','152500','150000','多伦县','152531','0');
REPLACE INTO `pw_area` VALUES('152921','152900','150000','阿拉善左旗','152921','0');
REPLACE INTO `pw_area` VALUES('152922','152900','150000','阿拉善右旗','152922','0');
REPLACE INTO `pw_area` VALUES('152923','152900','150000','额济纳旗','152923','0');
REPLACE INTO `pw_area` VALUES('210101','210100','210000','市辖区','210101','0');
REPLACE INTO `pw_area` VALUES('210102','210100','210000','和平区','210102','0');
REPLACE INTO `pw_area` VALUES('210103','210100','210000','沈河区','210103','0');
REPLACE INTO `pw_area` VALUES('210104','210100','210000','大东区','210104','0');
REPLACE INTO `pw_area` VALUES('210105','210100','210000','皇姑区','210105','0');
REPLACE INTO `pw_area` VALUES('210106','210100','210000','铁西区','210106','0');
REPLACE INTO `pw_area` VALUES('210111','210100','210000','苏家屯区','210111','0');
REPLACE INTO `pw_area` VALUES('210112','210100','210000','东陵区','210112','0');
REPLACE INTO `pw_area` VALUES('210113','210100','210000','沈北新区','210113','0');
REPLACE INTO `pw_area` VALUES('210114','210100','210000','于洪区','210114','0');
REPLACE INTO `pw_area` VALUES('210122','210100','210000','辽中县','210122','0');
REPLACE INTO `pw_area` VALUES('210123','210100','210000','康平县','210123','0');
REPLACE INTO `pw_area` VALUES('210124','210100','210000','法库县','210124','0');
REPLACE INTO `pw_area` VALUES('210181','210100','210000','新民市','210181','0');
REPLACE INTO `pw_area` VALUES('210201','210200','210000','市辖区','210201','0');
REPLACE INTO `pw_area` VALUES('210202','210200','210000','中山区','210202','0');
REPLACE INTO `pw_area` VALUES('210203','210200','210000','西岗区','210203','0');
REPLACE INTO `pw_area` VALUES('210204','210200','210000','沙河口区','210204','0');
REPLACE INTO `pw_area` VALUES('210211','210200','210000','甘井子区','210211','0');
REPLACE INTO `pw_area` VALUES('210212','210200','210000','旅顺口区','210212','0');
REPLACE INTO `pw_area` VALUES('210213','210200','210000','金州区','210213','0');
REPLACE INTO `pw_area` VALUES('210224','210200','210000','长海县','210224','0');
REPLACE INTO `pw_area` VALUES('210281','210200','210000','瓦房店市','210281','0');
REPLACE INTO `pw_area` VALUES('210282','210200','210000','普兰店市','210282','0');
REPLACE INTO `pw_area` VALUES('210283','210200','210000','庄河市','210283','0');
REPLACE INTO `pw_area` VALUES('210301','210300','210000','市辖区','210301','0');
REPLACE INTO `pw_area` VALUES('210302','210300','210000','铁东区','210302','0');
REPLACE INTO `pw_area` VALUES('210303','210300','210000','铁西区','210303','0');
REPLACE INTO `pw_area` VALUES('210304','210300','210000','立山区','210304','0');
REPLACE INTO `pw_area` VALUES('210311','210300','210000','千山区','210311','0');
REPLACE INTO `pw_area` VALUES('210321','210300','210000','台安县','210321','0');
REPLACE INTO `pw_area` VALUES('210323','210300','210000','岫岩满族自治县','210323','0');
REPLACE INTO `pw_area` VALUES('210381','210300','210000','海城市','210381','0');
REPLACE INTO `pw_area` VALUES('210401','210400','210000','市辖区','210401','0');
REPLACE INTO `pw_area` VALUES('210402','210400','210000','新抚区','210402','0');
REPLACE INTO `pw_area` VALUES('210403','210400','210000','东洲区','210403','0');
REPLACE INTO `pw_area` VALUES('210404','210400','210000','望花区','210404','0');
REPLACE INTO `pw_area` VALUES('210411','210400','210000','顺城区','210411','0');
REPLACE INTO `pw_area` VALUES('210421','210400','210000','抚顺县','210421','0');
REPLACE INTO `pw_area` VALUES('210422','210400','210000','新宾满族自治县','210422','0');
REPLACE INTO `pw_area` VALUES('210423','210400','210000','清原满族自治县','210423','0');
REPLACE INTO `pw_area` VALUES('210501','210500','210000','市辖区','210501','0');
REPLACE INTO `pw_area` VALUES('210502','210500','210000','平山区','210502','0');
REPLACE INTO `pw_area` VALUES('210503','210500','210000','溪湖区','210503','0');
REPLACE INTO `pw_area` VALUES('210504','210500','210000','明山区','210504','0');
REPLACE INTO `pw_area` VALUES('210505','210500','210000','南芬区','210505','0');
REPLACE INTO `pw_area` VALUES('210521','210500','210000','本溪满族自治县','210521','0');
REPLACE INTO `pw_area` VALUES('210522','210500','210000','桓仁满族自治县','210522','0');
REPLACE INTO `pw_area` VALUES('210601','210600','210000','市辖区','210601','0');
REPLACE INTO `pw_area` VALUES('210602','210600','210000','元宝区','210602','0');
REPLACE INTO `pw_area` VALUES('210603','210600','210000','振兴区','210603','0');
REPLACE INTO `pw_area` VALUES('210604','210600','210000','振安区','210604','0');
REPLACE INTO `pw_area` VALUES('210624','210600','210000','宽甸满族自治县','210624','0');
REPLACE INTO `pw_area` VALUES('210681','210600','210000','东港市','210681','0');
REPLACE INTO `pw_area` VALUES('210682','210600','210000','凤城市','210682','0');
REPLACE INTO `pw_area` VALUES('210701','210700','210000','市辖区','210701','0');
REPLACE INTO `pw_area` VALUES('210702','210700','210000','古塔区','210702','0');
REPLACE INTO `pw_area` VALUES('210703','210700','210000','凌河区','210703','0');
REPLACE INTO `pw_area` VALUES('210711','210700','210000','太和区','210711','0');
REPLACE INTO `pw_area` VALUES('210726','210700','210000','黑山县','210726','0');
REPLACE INTO `pw_area` VALUES('210727','210700','210000','义县','210727','0');
REPLACE INTO `pw_area` VALUES('210781','210700','210000','凌海市','210781','0');
REPLACE INTO `pw_area` VALUES('210782','210700','210000','北镇市','210782','0');
REPLACE INTO `pw_area` VALUES('210801','210800','210000','市辖区','210801','0');
REPLACE INTO `pw_area` VALUES('210802','210800','210000','站前区','210802','0');
REPLACE INTO `pw_area` VALUES('210803','210800','210000','西市区','210803','0');
REPLACE INTO `pw_area` VALUES('210804','210800','210000','鲅鱼圈区','210804','0');
REPLACE INTO `pw_area` VALUES('210811','210800','210000','老边区','210811','0');
REPLACE INTO `pw_area` VALUES('210881','210800','210000','盖州市','210881','0');
REPLACE INTO `pw_area` VALUES('210882','210800','210000','大石桥市','210882','0');
REPLACE INTO `pw_area` VALUES('210901','210900','210000','市辖区','210901','0');
REPLACE INTO `pw_area` VALUES('210902','210900','210000','海州区','210902','0');
REPLACE INTO `pw_area` VALUES('210903','210900','210000','新邱区','210903','0');
REPLACE INTO `pw_area` VALUES('210904','210900','210000','太平区','210904','0');
REPLACE INTO `pw_area` VALUES('210905','210900','210000','清河门区','210905','0');
REPLACE INTO `pw_area` VALUES('210911','210900','210000','细河区','210911','0');
REPLACE INTO `pw_area` VALUES('210921','210900','210000','阜新蒙古族自治县','210921','0');
REPLACE INTO `pw_area` VALUES('210922','210900','210000','彰武县','210922','0');
REPLACE INTO `pw_area` VALUES('211001','211000','210000','市辖区','211001','0');
REPLACE INTO `pw_area` VALUES('211002','211000','210000','白塔区','211002','0');
REPLACE INTO `pw_area` VALUES('211003','211000','210000','文圣区','211003','0');
REPLACE INTO `pw_area` VALUES('211004','211000','210000','宏伟区','211004','0');
REPLACE INTO `pw_area` VALUES('211005','211000','210000','弓长岭区','211005','0');
REPLACE INTO `pw_area` VALUES('211011','211000','210000','太子河区','211011','0');
REPLACE INTO `pw_area` VALUES('211021','211000','210000','辽阳县','211021','0');
REPLACE INTO `pw_area` VALUES('211081','211000','210000','灯塔市','211081','0');
REPLACE INTO `pw_area` VALUES('211101','211100','210000','市辖区','211101','0');
REPLACE INTO `pw_area` VALUES('211102','211100','210000','双台子区','211102','0');
REPLACE INTO `pw_area` VALUES('211103','211100','210000','兴隆台区','211103','0');
REPLACE INTO `pw_area` VALUES('211121','211100','210000','大洼县','211121','0');
REPLACE INTO `pw_area` VALUES('211122','211100','210000','盘山县','211122','0');
REPLACE INTO `pw_area` VALUES('211201','211200','210000','市辖区','211201','0');
REPLACE INTO `pw_area` VALUES('211202','211200','210000','银州区','211202','0');
REPLACE INTO `pw_area` VALUES('211204','211200','210000','清河区','211204','0');
REPLACE INTO `pw_area` VALUES('211221','211200','210000','铁岭县','211221','0');
REPLACE INTO `pw_area` VALUES('211223','211200','210000','西丰县','211223','0');
REPLACE INTO `pw_area` VALUES('211224','211200','210000','昌图县','211224','0');
REPLACE INTO `pw_area` VALUES('211281','211200','210000','调兵山市','211281','0');
REPLACE INTO `pw_area` VALUES('211282','211200','210000','开原市','211282','0');
REPLACE INTO `pw_area` VALUES('211301','211300','210000','市辖区','211301','0');
REPLACE INTO `pw_area` VALUES('211302','211300','210000','双塔区','211302','0');
REPLACE INTO `pw_area` VALUES('211303','211300','210000','龙城区','211303','0');
REPLACE INTO `pw_area` VALUES('211321','211300','210000','朝阳县','211321','0');
REPLACE INTO `pw_area` VALUES('211322','211300','210000','建平县','211322','0');
REPLACE INTO `pw_area` VALUES('211324','211300','210000','喀喇沁左翼蒙古族自治县','211324','0');
REPLACE INTO `pw_area` VALUES('211381','211300','210000','北票市','211381','0');
REPLACE INTO `pw_area` VALUES('211382','211300','210000','凌源市','211382','0');
REPLACE INTO `pw_area` VALUES('211401','211400','210000','市辖区','211401','0');
REPLACE INTO `pw_area` VALUES('211402','211400','210000','连山区','211402','0');
REPLACE INTO `pw_area` VALUES('211403','211400','210000','龙港区','211403','0');
REPLACE INTO `pw_area` VALUES('211404','211400','210000','南票区','211404','0');
REPLACE INTO `pw_area` VALUES('211421','211400','210000','绥中县','211421','0');
REPLACE INTO `pw_area` VALUES('211422','211400','210000','建昌县','211422','0');
REPLACE INTO `pw_area` VALUES('211481','211400','210000','兴城市','211481','0');
REPLACE INTO `pw_area` VALUES('220101','220100','220000','市辖区','220101','0');
REPLACE INTO `pw_area` VALUES('220102','220100','220000','南关区','220102','0');
REPLACE INTO `pw_area` VALUES('220103','220100','220000','宽城区','220103','0');
REPLACE INTO `pw_area` VALUES('220104','220100','220000','朝阳区','220104','0');
REPLACE INTO `pw_area` VALUES('220105','220100','220000','二道区','220105','0');
REPLACE INTO `pw_area` VALUES('220106','220100','220000','绿园区','220106','0');
REPLACE INTO `pw_area` VALUES('220112','220100','220000','双阳区','220112','0');
REPLACE INTO `pw_area` VALUES('220122','220100','220000','农安县','220122','0');
REPLACE INTO `pw_area` VALUES('220181','220100','220000','九台市','220181','0');
REPLACE INTO `pw_area` VALUES('220182','220100','220000','榆树市','220182','0');
REPLACE INTO `pw_area` VALUES('220183','220100','220000','德惠市','220183','0');
REPLACE INTO `pw_area` VALUES('220201','220200','220000','市辖区','220201','0');
REPLACE INTO `pw_area` VALUES('220202','220200','220000','昌邑区','220202','0');
REPLACE INTO `pw_area` VALUES('220203','220200','220000','龙潭区','220203','0');
REPLACE INTO `pw_area` VALUES('220204','220200','220000','船营区','220204','0');
REPLACE INTO `pw_area` VALUES('220211','220200','220000','丰满区','220211','0');
REPLACE INTO `pw_area` VALUES('220221','220200','220000','永吉县','220221','0');
REPLACE INTO `pw_area` VALUES('220281','220200','220000','蛟河市','220281','0');
REPLACE INTO `pw_area` VALUES('220282','220200','220000','桦甸市','220282','0');
REPLACE INTO `pw_area` VALUES('220283','220200','220000','舒兰市','220283','0');
REPLACE INTO `pw_area` VALUES('220284','220200','220000','磐石市','220284','0');
REPLACE INTO `pw_area` VALUES('220301','220300','220000','市辖区','220301','0');
REPLACE INTO `pw_area` VALUES('220302','220300','220000','铁西区','220302','0');
REPLACE INTO `pw_area` VALUES('220303','220300','220000','铁东区','220303','0');
REPLACE INTO `pw_area` VALUES('220322','220300','220000','梨树县','220322','0');
REPLACE INTO `pw_area` VALUES('220323','220300','220000','伊通满族自治县','220323','0');
REPLACE INTO `pw_area` VALUES('220381','220300','220000','公主岭市','220381','0');
REPLACE INTO `pw_area` VALUES('220382','220300','220000','双辽市','220382','0');
REPLACE INTO `pw_area` VALUES('220401','220400','220000','市辖区','220401','0');
REPLACE INTO `pw_area` VALUES('220402','220400','220000','龙山区','220402','0');
REPLACE INTO `pw_area` VALUES('220403','220400','220000','西安区','220403','0');
REPLACE INTO `pw_area` VALUES('220421','220400','220000','东丰县','220421','0');
REPLACE INTO `pw_area` VALUES('220422','220400','220000','东辽县','220422','0');
REPLACE INTO `pw_area` VALUES('220501','220500','220000','市辖区','220501','0');
REPLACE INTO `pw_area` VALUES('220502','220500','220000','东昌区','220502','0');
REPLACE INTO `pw_area` VALUES('220503','220500','220000','二道江区','220503','0');
REPLACE INTO `pw_area` VALUES('220521','220500','220000','通化县','220521','0');
REPLACE INTO `pw_area` VALUES('220523','220500','220000','辉南县','220523','0');
REPLACE INTO `pw_area` VALUES('220524','220500','220000','柳河县','220524','0');
REPLACE INTO `pw_area` VALUES('220581','220500','220000','梅河口市','220581','0');
REPLACE INTO `pw_area` VALUES('220582','220500','220000','集安市','220582','0');
REPLACE INTO `pw_area` VALUES('220601','220600','220000','市辖区','220601','0');
REPLACE INTO `pw_area` VALUES('220602','220600','220000','浑江区','220602','0');
REPLACE INTO `pw_area` VALUES('220605','220600','220000','江源区','220605','0');
REPLACE INTO `pw_area` VALUES('220621','220600','220000','抚松县','220621','0');
REPLACE INTO `pw_area` VALUES('220622','220600','220000','靖宇县','220622','0');
REPLACE INTO `pw_area` VALUES('220623','220600','220000','长白朝鲜族自治县','220623','0');
REPLACE INTO `pw_area` VALUES('220681','220600','220000','临江市','220681','0');
REPLACE INTO `pw_area` VALUES('220701','220700','220000','市辖区','220701','0');
REPLACE INTO `pw_area` VALUES('220702','220700','220000','宁江区','220702','0');
REPLACE INTO `pw_area` VALUES('220721','220700','220000','前郭尔罗斯蒙古族自治县','220721','0');
REPLACE INTO `pw_area` VALUES('220722','220700','220000','长岭县','220722','0');
REPLACE INTO `pw_area` VALUES('220723','220700','220000','乾安县','220723','0');
REPLACE INTO `pw_area` VALUES('220781','220700','220000','扶余市','220781','0');
REPLACE INTO `pw_area` VALUES('220801','220800','220000','市辖区','220801','0');
REPLACE INTO `pw_area` VALUES('220802','220800','220000','洮北区','220802','0');
REPLACE INTO `pw_area` VALUES('220821','220800','220000','镇赉县','220821','0');
REPLACE INTO `pw_area` VALUES('220822','220800','220000','通榆县','220822','0');
REPLACE INTO `pw_area` VALUES('220881','220800','220000','洮南市','220881','0');
REPLACE INTO `pw_area` VALUES('220882','220800','220000','大安市','220882','0');
REPLACE INTO `pw_area` VALUES('222401','222400','220000','延吉市','222401','0');
REPLACE INTO `pw_area` VALUES('222402','222400','220000','图们市','222402','0');
REPLACE INTO `pw_area` VALUES('222403','222400','220000','敦化市','222403','0');
REPLACE INTO `pw_area` VALUES('222404','222400','220000','珲春市','222404','0');
REPLACE INTO `pw_area` VALUES('222405','222400','220000','龙井市','222405','0');
REPLACE INTO `pw_area` VALUES('222406','222400','220000','和龙市','222406','0');
REPLACE INTO `pw_area` VALUES('222424','222400','220000','汪清县','222424','0');
REPLACE INTO `pw_area` VALUES('222426','222400','220000','安图县','222426','0');
REPLACE INTO `pw_area` VALUES('230101','230100','230000','市辖区','230101','0');
REPLACE INTO `pw_area` VALUES('230102','230100','230000','道里区','230102','0');
REPLACE INTO `pw_area` VALUES('230103','230100','230000','南岗区','230103','0');
REPLACE INTO `pw_area` VALUES('230104','230100','230000','道外区','230104','0');
REPLACE INTO `pw_area` VALUES('230108','230100','230000','平房区','230108','0');
REPLACE INTO `pw_area` VALUES('230109','230100','230000','松北区','230109','0');
REPLACE INTO `pw_area` VALUES('230110','230100','230000','香坊区','230110','0');
REPLACE INTO `pw_area` VALUES('230111','230100','230000','呼兰区','230111','0');
REPLACE INTO `pw_area` VALUES('230112','230100','230000','阿城区','230112','0');
REPLACE INTO `pw_area` VALUES('230123','230100','230000','依兰县','230123','0');
REPLACE INTO `pw_area` VALUES('230124','230100','230000','方正县','230124','0');
REPLACE INTO `pw_area` VALUES('230125','230100','230000','宾县','230125','0');
REPLACE INTO `pw_area` VALUES('230126','230100','230000','巴彦县','230126','0');
REPLACE INTO `pw_area` VALUES('230127','230100','230000','木兰县','230127','0');
REPLACE INTO `pw_area` VALUES('230128','230100','230000','通河县','230128','0');
REPLACE INTO `pw_area` VALUES('230129','230100','230000','延寿县','230129','0');
REPLACE INTO `pw_area` VALUES('230182','230100','230000','双城市','230182','0');
REPLACE INTO `pw_area` VALUES('230183','230100','230000','尚志市','230183','0');
REPLACE INTO `pw_area` VALUES('230184','230100','230000','五常市','230184','0');
REPLACE INTO `pw_area` VALUES('230201','230200','230000','市辖区','230201','0');
REPLACE INTO `pw_area` VALUES('230202','230200','230000','龙沙区','230202','0');
REPLACE INTO `pw_area` VALUES('230203','230200','230000','建华区','230203','0');
REPLACE INTO `pw_area` VALUES('230204','230200','230000','铁锋区','230204','0');
REPLACE INTO `pw_area` VALUES('230205','230200','230000','昂昂溪区','230205','0');
REPLACE INTO `pw_area` VALUES('230206','230200','230000','富拉尔基区','230206','0');
REPLACE INTO `pw_area` VALUES('230207','230200','230000','碾子山区','230207','0');
REPLACE INTO `pw_area` VALUES('230208','230200','230000','梅里斯达斡尔族区','230208','0');
REPLACE INTO `pw_area` VALUES('230221','230200','230000','龙江县','230221','0');
REPLACE INTO `pw_area` VALUES('230223','230200','230000','依安县','230223','0');
REPLACE INTO `pw_area` VALUES('230224','230200','230000','泰来县','230224','0');
REPLACE INTO `pw_area` VALUES('230225','230200','230000','甘南县','230225','0');
REPLACE INTO `pw_area` VALUES('230227','230200','230000','富裕县','230227','0');
REPLACE INTO `pw_area` VALUES('230229','230200','230000','克山县','230229','0');
REPLACE INTO `pw_area` VALUES('230230','230200','230000','克东县','230230','0');
REPLACE INTO `pw_area` VALUES('230231','230200','230000','拜泉县','230231','0');
REPLACE INTO `pw_area` VALUES('230281','230200','230000','讷河市','230281','0');
REPLACE INTO `pw_area` VALUES('230301','230300','230000','市辖区','230301','0');
REPLACE INTO `pw_area` VALUES('230302','230300','230000','鸡冠区','230302','0');
REPLACE INTO `pw_area` VALUES('230303','230300','230000','恒山区','230303','0');
REPLACE INTO `pw_area` VALUES('230304','230300','230000','滴道区','230304','0');
REPLACE INTO `pw_area` VALUES('230305','230300','230000','梨树区','230305','0');
REPLACE INTO `pw_area` VALUES('230306','230300','230000','城子河区','230306','0');
REPLACE INTO `pw_area` VALUES('230307','230300','230000','麻山区','230307','0');
REPLACE INTO `pw_area` VALUES('230321','230300','230000','鸡东县','230321','0');
REPLACE INTO `pw_area` VALUES('230381','230300','230000','虎林市','230381','0');
REPLACE INTO `pw_area` VALUES('230382','230300','230000','密山市','230382','0');
REPLACE INTO `pw_area` VALUES('230401','230400','230000','市辖区','230401','0');
REPLACE INTO `pw_area` VALUES('230402','230400','230000','向阳区','230402','0');
REPLACE INTO `pw_area` VALUES('230403','230400','230000','工农区','230403','0');
REPLACE INTO `pw_area` VALUES('230404','230400','230000','南山区','230404','0');
REPLACE INTO `pw_area` VALUES('230405','230400','230000','兴安区','230405','0');
REPLACE INTO `pw_area` VALUES('230406','230400','230000','东山区','230406','0');
REPLACE INTO `pw_area` VALUES('230407','230400','230000','兴山区','230407','0');
REPLACE INTO `pw_area` VALUES('230421','230400','230000','萝北县','230421','0');
REPLACE INTO `pw_area` VALUES('230422','230400','230000','绥滨县','230422','0');
REPLACE INTO `pw_area` VALUES('230501','230500','230000','市辖区','230501','0');
REPLACE INTO `pw_area` VALUES('230502','230500','230000','尖山区','230502','0');
REPLACE INTO `pw_area` VALUES('230503','230500','230000','岭东区','230503','0');
REPLACE INTO `pw_area` VALUES('230505','230500','230000','四方台区','230505','0');
REPLACE INTO `pw_area` VALUES('230506','230500','230000','宝山区','230506','0');
REPLACE INTO `pw_area` VALUES('230521','230500','230000','集贤县','230521','0');
REPLACE INTO `pw_area` VALUES('230522','230500','230000','友谊县','230522','0');
REPLACE INTO `pw_area` VALUES('230523','230500','230000','宝清县','230523','0');
REPLACE INTO `pw_area` VALUES('230524','230500','230000','饶河县','230524','0');
REPLACE INTO `pw_area` VALUES('230601','230600','230000','市辖区','230601','0');
REPLACE INTO `pw_area` VALUES('230602','230600','230000','萨尔图区','230602','0');
REPLACE INTO `pw_area` VALUES('230603','230600','230000','龙凤区','230603','0');
REPLACE INTO `pw_area` VALUES('230604','230600','230000','让胡路区','230604','0');
REPLACE INTO `pw_area` VALUES('230605','230600','230000','红岗区','230605','0');
REPLACE INTO `pw_area` VALUES('230606','230600','230000','大同区','230606','0');
REPLACE INTO `pw_area` VALUES('230621','230600','230000','肇州县','230621','0');
REPLACE INTO `pw_area` VALUES('230622','230600','230000','肇源县','230622','0');
REPLACE INTO `pw_area` VALUES('230623','230600','230000','林甸县','230623','0');
REPLACE INTO `pw_area` VALUES('230624','230600','230000','杜尔伯特蒙古族自治县','230624','0');
REPLACE INTO `pw_area` VALUES('230701','230700','230000','市辖区','230701','0');
REPLACE INTO `pw_area` VALUES('230702','230700','230000','伊春区','230702','0');
REPLACE INTO `pw_area` VALUES('230703','230700','230000','南岔区','230703','0');
REPLACE INTO `pw_area` VALUES('230704','230700','230000','友好区','230704','0');
REPLACE INTO `pw_area` VALUES('230705','230700','230000','西林区','230705','0');
REPLACE INTO `pw_area` VALUES('230706','230700','230000','翠峦区','230706','0');
REPLACE INTO `pw_area` VALUES('230707','230700','230000','新青区','230707','0');
REPLACE INTO `pw_area` VALUES('230708','230700','230000','美溪区','230708','0');
REPLACE INTO `pw_area` VALUES('230709','230700','230000','金山屯区','230709','0');
REPLACE INTO `pw_area` VALUES('230710','230700','230000','五营区','230710','0');
REPLACE INTO `pw_area` VALUES('230711','230700','230000','乌马河区','230711','0');
REPLACE INTO `pw_area` VALUES('230712','230700','230000','汤旺河区','230712','0');
REPLACE INTO `pw_area` VALUES('230713','230700','230000','带岭区','230713','0');
REPLACE INTO `pw_area` VALUES('230714','230700','230000','乌伊岭区','230714','0');
REPLACE INTO `pw_area` VALUES('230715','230700','230000','红星区','230715','0');
REPLACE INTO `pw_area` VALUES('230716','230700','230000','上甘岭区','230716','0');
REPLACE INTO `pw_area` VALUES('230722','230700','230000','嘉荫县','230722','0');
REPLACE INTO `pw_area` VALUES('230781','230700','230000','铁力市','230781','0');
REPLACE INTO `pw_area` VALUES('230801','230800','230000','市辖区','230801','0');
REPLACE INTO `pw_area` VALUES('230803','230800','230000','向阳区','230803','0');
REPLACE INTO `pw_area` VALUES('230804','230800','230000','前进区','230804','0');
REPLACE INTO `pw_area` VALUES('230805','230800','230000','东风区','230805','0');
REPLACE INTO `pw_area` VALUES('230811','230800','230000','郊区','230811','0');
REPLACE INTO `pw_area` VALUES('230822','230800','230000','桦南县','230822','0');
REPLACE INTO `pw_area` VALUES('230826','230800','230000','桦川县','230826','0');
REPLACE INTO `pw_area` VALUES('230828','230800','230000','汤原县','230828','0');
REPLACE INTO `pw_area` VALUES('230833','230800','230000','抚远县','230833','0');
REPLACE INTO `pw_area` VALUES('230881','230800','230000','同江市','230881','0');
REPLACE INTO `pw_area` VALUES('230882','230800','230000','富锦市','230882','0');
REPLACE INTO `pw_area` VALUES('230901','230900','230000','市辖区','230901','0');
REPLACE INTO `pw_area` VALUES('230902','230900','230000','新兴区','230902','0');
REPLACE INTO `pw_area` VALUES('230903','230900','230000','桃山区','230903','0');
REPLACE INTO `pw_area` VALUES('230904','230900','230000','茄子河区','230904','0');
REPLACE INTO `pw_area` VALUES('230921','230900','230000','勃利县','230921','0');
REPLACE INTO `pw_area` VALUES('231001','231000','230000','市辖区','231001','0');
REPLACE INTO `pw_area` VALUES('231002','231000','230000','东安区','231002','0');
REPLACE INTO `pw_area` VALUES('231003','231000','230000','阳明区','231003','0');
REPLACE INTO `pw_area` VALUES('231004','231000','230000','爱民区','231004','0');
REPLACE INTO `pw_area` VALUES('231005','231000','230000','西安区','231005','0');
REPLACE INTO `pw_area` VALUES('231024','231000','230000','东宁县','231024','0');
REPLACE INTO `pw_area` VALUES('231025','231000','230000','林口县','231025','0');
REPLACE INTO `pw_area` VALUES('231081','231000','230000','绥芬河市','231081','0');
REPLACE INTO `pw_area` VALUES('231083','231000','230000','海林市','231083','0');
REPLACE INTO `pw_area` VALUES('231084','231000','230000','宁安市','231084','0');
REPLACE INTO `pw_area` VALUES('231085','231000','230000','穆棱市','231085','0');
REPLACE INTO `pw_area` VALUES('231101','231100','230000','市辖区','231101','0');
REPLACE INTO `pw_area` VALUES('231102','231100','230000','爱辉区','231102','0');
REPLACE INTO `pw_area` VALUES('231121','231100','230000','嫩江县','231121','0');
REPLACE INTO `pw_area` VALUES('231123','231100','230000','逊克县','231123','0');
REPLACE INTO `pw_area` VALUES('231124','231100','230000','孙吴县','231124','0');
REPLACE INTO `pw_area` VALUES('231181','231100','230000','北安市','231181','0');
REPLACE INTO `pw_area` VALUES('231182','231100','230000','五大连池市','231182','0');
REPLACE INTO `pw_area` VALUES('231201','231200','230000','市辖区','231201','0');
REPLACE INTO `pw_area` VALUES('231202','231200','230000','北林区','231202','0');
REPLACE INTO `pw_area` VALUES('231221','231200','230000','望奎县','231221','0');
REPLACE INTO `pw_area` VALUES('231222','231200','230000','兰西县','231222','0');
REPLACE INTO `pw_area` VALUES('231223','231200','230000','青冈县','231223','0');
REPLACE INTO `pw_area` VALUES('231224','231200','230000','庆安县','231224','0');
REPLACE INTO `pw_area` VALUES('231225','231200','230000','明水县','231225','0');
REPLACE INTO `pw_area` VALUES('231226','231200','230000','绥棱县','231226','0');
REPLACE INTO `pw_area` VALUES('231281','231200','230000','安达市','231281','0');
REPLACE INTO `pw_area` VALUES('231282','231200','230000','肇东市','231282','0');
REPLACE INTO `pw_area` VALUES('231283','231200','230000','海伦市','231283','0');
REPLACE INTO `pw_area` VALUES('232721','232700','230000','呼玛县','232721','0');
REPLACE INTO `pw_area` VALUES('232722','232700','230000','塔河县','232722','0');
REPLACE INTO `pw_area` VALUES('232723','232700','230000','漠河县','232723','0');
REPLACE INTO `pw_area` VALUES('310101','310100','310000','黄浦区','310101','0');
REPLACE INTO `pw_area` VALUES('310104','310100','310000','徐汇区','310104','0');
REPLACE INTO `pw_area` VALUES('310105','310100','310000','长宁区','310105','0');
REPLACE INTO `pw_area` VALUES('310106','310100','310000','静安区','310106','0');
REPLACE INTO `pw_area` VALUES('310107','310100','310000','普陀区','310107','0');
REPLACE INTO `pw_area` VALUES('310108','310100','310000','闸北区','310108','0');
REPLACE INTO `pw_area` VALUES('310109','310100','310000','虹口区','310109','0');
REPLACE INTO `pw_area` VALUES('310110','310100','310000','杨浦区','310110','0');
REPLACE INTO `pw_area` VALUES('310112','310100','310000','闵行区','310112','0');
REPLACE INTO `pw_area` VALUES('310113','310100','310000','宝山区','310113','0');
REPLACE INTO `pw_area` VALUES('310114','310100','310000','嘉定区','310114','0');
REPLACE INTO `pw_area` VALUES('310115','310100','310000','浦东新区','310115','0');
REPLACE INTO `pw_area` VALUES('310116','310100','310000','金山区','310116','0');
REPLACE INTO `pw_area` VALUES('310117','310100','310000','松江区','310117','0');
REPLACE INTO `pw_area` VALUES('310118','310100','310000','青浦区','310118','0');
REPLACE INTO `pw_area` VALUES('310120','310100','310000','奉贤区','310120','0');
REPLACE INTO `pw_area` VALUES('310230','310200','310000','崇明县','310230','0');
REPLACE INTO `pw_area` VALUES('320101','320100','320000','市辖区','320101','0');
REPLACE INTO `pw_area` VALUES('320102','320100','320000','玄武区','320102','0');
REPLACE INTO `pw_area` VALUES('320104','320100','320000','秦淮区','320104','0');
REPLACE INTO `pw_area` VALUES('320105','320100','320000','建邺区','320105','0');
REPLACE INTO `pw_area` VALUES('320106','320100','320000','鼓楼区','320106','0');
REPLACE INTO `pw_area` VALUES('320111','320100','320000','浦口区','320111','0');
REPLACE INTO `pw_area` VALUES('320113','320100','320000','栖霞区','320113','0');
REPLACE INTO `pw_area` VALUES('320114','320100','320000','雨花台区','320114','0');
REPLACE INTO `pw_area` VALUES('320115','320100','320000','江宁区','320115','0');
REPLACE INTO `pw_area` VALUES('320116','320100','320000','六合区','320116','0');
REPLACE INTO `pw_area` VALUES('320117','320100','320000','溧水区','320117','0');
REPLACE INTO `pw_area` VALUES('320118','320100','320000','高淳区','320118','0');
REPLACE INTO `pw_area` VALUES('320201','320200','320000','市辖区','320201','0');
REPLACE INTO `pw_area` VALUES('320202','320200','320000','崇安区','320202','0');
REPLACE INTO `pw_area` VALUES('320203','320200','320000','南长区','320203','0');
REPLACE INTO `pw_area` VALUES('320204','320200','320000','北塘区','320204','0');
REPLACE INTO `pw_area` VALUES('320205','320200','320000','锡山区','320205','0');
REPLACE INTO `pw_area` VALUES('320206','320200','320000','惠山区','320206','0');
REPLACE INTO `pw_area` VALUES('320211','320200','320000','滨湖区','320211','0');
REPLACE INTO `pw_area` VALUES('320281','320200','320000','江阴市','320281','0');
REPLACE INTO `pw_area` VALUES('320282','320200','320000','宜兴市','320282','0');
REPLACE INTO `pw_area` VALUES('320301','320300','320000','市辖区','320301','0');
REPLACE INTO `pw_area` VALUES('320302','320300','320000','鼓楼区','320302','0');
REPLACE INTO `pw_area` VALUES('320303','320300','320000','云龙区','320303','0');
REPLACE INTO `pw_area` VALUES('320305','320300','320000','贾汪区','320305','0');
REPLACE INTO `pw_area` VALUES('320311','320300','320000','泉山区','320311','0');
REPLACE INTO `pw_area` VALUES('320312','320300','320000','铜山区','320312','0');
REPLACE INTO `pw_area` VALUES('320321','320300','320000','丰县','320321','0');
REPLACE INTO `pw_area` VALUES('320322','320300','320000','沛县','320322','0');
REPLACE INTO `pw_area` VALUES('320324','320300','320000','睢宁县','320324','0');
REPLACE INTO `pw_area` VALUES('320381','320300','320000','新沂市','320381','0');
REPLACE INTO `pw_area` VALUES('320382','320300','320000','邳州市','320382','0');
REPLACE INTO `pw_area` VALUES('320401','320400','320000','市辖区','320401','0');
REPLACE INTO `pw_area` VALUES('320402','320400','320000','天宁区','320402','0');
REPLACE INTO `pw_area` VALUES('320404','320400','320000','钟楼区','320404','0');
REPLACE INTO `pw_area` VALUES('320405','320400','320000','戚墅堰区','320405','0');
REPLACE INTO `pw_area` VALUES('320411','320400','320000','新北区','320411','0');
REPLACE INTO `pw_area` VALUES('320412','320400','320000','武进区','320412','0');
REPLACE INTO `pw_area` VALUES('320481','320400','320000','溧阳市','320481','0');
REPLACE INTO `pw_area` VALUES('320482','320400','320000','金坛市','320482','0');
REPLACE INTO `pw_area` VALUES('320501','320500','320000','市辖区','320501','0');
REPLACE INTO `pw_area` VALUES('320505','320500','320000','虎丘区','320505','0');
REPLACE INTO `pw_area` VALUES('320506','320500','320000','吴中区','320506','0');
REPLACE INTO `pw_area` VALUES('320507','320500','320000','相城区','320507','0');
REPLACE INTO `pw_area` VALUES('320508','320500','320000','姑苏区','320508','0');
REPLACE INTO `pw_area` VALUES('320509','320500','320000','吴江区','320509','0');
REPLACE INTO `pw_area` VALUES('320581','320500','320000','常熟市','320581','0');
REPLACE INTO `pw_area` VALUES('320582','320500','320000','张家港市','320582','0');
REPLACE INTO `pw_area` VALUES('320583','320500','320000','昆山市','320583','0');
REPLACE INTO `pw_area` VALUES('320585','320500','320000','太仓市','320585','0');
REPLACE INTO `pw_area` VALUES('320601','320600','320000','市辖区','320601','0');
REPLACE INTO `pw_area` VALUES('320602','320600','320000','崇川区','320602','0');
REPLACE INTO `pw_area` VALUES('320611','320600','320000','港闸区','320611','0');
REPLACE INTO `pw_area` VALUES('320612','320600','320000','通州区','320612','0');
REPLACE INTO `pw_area` VALUES('320621','320600','320000','海安县','320621','0');
REPLACE INTO `pw_area` VALUES('320623','320600','320000','如东县','320623','0');
REPLACE INTO `pw_area` VALUES('320681','320600','320000','启东市','320681','0');
REPLACE INTO `pw_area` VALUES('320682','320600','320000','如皋市','320682','0');
REPLACE INTO `pw_area` VALUES('320684','320600','320000','海门市','320684','0');
REPLACE INTO `pw_area` VALUES('320701','320700','320000','市辖区','320701','0');
REPLACE INTO `pw_area` VALUES('320703','320700','320000','连云区','320703','0');
REPLACE INTO `pw_area` VALUES('320705','320700','320000','新浦区','320705','0');
REPLACE INTO `pw_area` VALUES('320706','320700','320000','海州区','320706','0');
REPLACE INTO `pw_area` VALUES('320721','320700','320000','赣榆县','320721','0');
REPLACE INTO `pw_area` VALUES('320722','320700','320000','东海县','320722','0');
REPLACE INTO `pw_area` VALUES('320723','320700','320000','灌云县','320723','0');
REPLACE INTO `pw_area` VALUES('320724','320700','320000','灌南县','320724','0');
REPLACE INTO `pw_area` VALUES('320801','320800','320000','市辖区','320801','0');
REPLACE INTO `pw_area` VALUES('320802','320800','320000','清河区','320802','0');
REPLACE INTO `pw_area` VALUES('320803','320800','320000','淮安区','320803','0');
REPLACE INTO `pw_area` VALUES('320804','320800','320000','淮阴区','320804','0');
REPLACE INTO `pw_area` VALUES('320811','320800','320000','清浦区','320811','0');
REPLACE INTO `pw_area` VALUES('320826','320800','320000','涟水县','320826','0');
REPLACE INTO `pw_area` VALUES('320829','320800','320000','洪泽县','320829','0');
REPLACE INTO `pw_area` VALUES('320830','320800','320000','盱眙县','320830','0');
REPLACE INTO `pw_area` VALUES('320831','320800','320000','金湖县','320831','0');
REPLACE INTO `pw_area` VALUES('320901','320900','320000','市辖区','320901','0');
REPLACE INTO `pw_area` VALUES('320902','320900','320000','亭湖区','320902','0');
REPLACE INTO `pw_area` VALUES('320903','320900','320000','盐都区','320903','0');
REPLACE INTO `pw_area` VALUES('320921','320900','320000','响水县','320921','0');
REPLACE INTO `pw_area` VALUES('320922','320900','320000','滨海县','320922','0');
REPLACE INTO `pw_area` VALUES('320923','320900','320000','阜宁县','320923','0');
REPLACE INTO `pw_area` VALUES('320924','320900','320000','射阳县','320924','0');
REPLACE INTO `pw_area` VALUES('320925','320900','320000','建湖县','320925','0');
REPLACE INTO `pw_area` VALUES('320981','320900','320000','东台市','320981','0');
REPLACE INTO `pw_area` VALUES('320982','320900','320000','大丰市','320982','0');
REPLACE INTO `pw_area` VALUES('321001','321000','320000','市辖区','321001','0');
REPLACE INTO `pw_area` VALUES('321002','321000','320000','广陵区','321002','0');
REPLACE INTO `pw_area` VALUES('321003','321000','320000','邗江区','321003','0');
REPLACE INTO `pw_area` VALUES('321012','321000','320000','江都区','321012','0');
REPLACE INTO `pw_area` VALUES('321023','321000','320000','宝应县','321023','0');
REPLACE INTO `pw_area` VALUES('321081','321000','320000','仪征市','321081','0');
REPLACE INTO `pw_area` VALUES('321084','321000','320000','高邮市','321084','0');
REPLACE INTO `pw_area` VALUES('321101','321100','320000','市辖区','321101','0');
REPLACE INTO `pw_area` VALUES('321102','321100','320000','京口区','321102','0');
REPLACE INTO `pw_area` VALUES('321111','321100','320000','润州区','321111','0');
REPLACE INTO `pw_area` VALUES('321112','321100','320000','丹徒区','321112','0');
REPLACE INTO `pw_area` VALUES('321181','321100','320000','丹阳市','321181','0');
REPLACE INTO `pw_area` VALUES('321182','321100','320000','扬中市','321182','0');
REPLACE INTO `pw_area` VALUES('321183','321100','320000','句容市','321183','0');
REPLACE INTO `pw_area` VALUES('321201','321200','320000','市辖区','321201','0');
REPLACE INTO `pw_area` VALUES('321202','321200','320000','海陵区','321202','0');
REPLACE INTO `pw_area` VALUES('321203','321200','320000','高港区','321203','0');
REPLACE INTO `pw_area` VALUES('321204','321200','320000','姜堰区','321204','0');
REPLACE INTO `pw_area` VALUES('321281','321200','320000','兴化市','321281','0');
REPLACE INTO `pw_area` VALUES('321282','321200','320000','靖江市','321282','0');
REPLACE INTO `pw_area` VALUES('321283','321200','320000','泰兴市','321283','0');
REPLACE INTO `pw_area` VALUES('321301','321300','320000','市辖区','321301','0');
REPLACE INTO `pw_area` VALUES('321302','321300','320000','宿城区','321302','0');
REPLACE INTO `pw_area` VALUES('321311','321300','320000','宿豫区','321311','0');
REPLACE INTO `pw_area` VALUES('321322','321300','320000','沭阳县','321322','0');
REPLACE INTO `pw_area` VALUES('321323','321300','320000','泗阳县','321323','0');
REPLACE INTO `pw_area` VALUES('321324','321300','320000','泗洪县','321324','0');
REPLACE INTO `pw_area` VALUES('330101','330100','330000','市辖区','330101','0');
REPLACE INTO `pw_area` VALUES('330102','330100','330000','上城区','330102','0');
REPLACE INTO `pw_area` VALUES('330103','330100','330000','下城区','330103','0');
REPLACE INTO `pw_area` VALUES('330104','330100','330000','江干区','330104','0');
REPLACE INTO `pw_area` VALUES('330105','330100','330000','拱墅区','330105','0');
REPLACE INTO `pw_area` VALUES('330106','330100','330000','西湖区','330106','0');
REPLACE INTO `pw_area` VALUES('330108','330100','330000','滨江区','330108','0');
REPLACE INTO `pw_area` VALUES('330109','330100','330000','萧山区','330109','0');
REPLACE INTO `pw_area` VALUES('330110','330100','330000','余杭区','330110','0');
REPLACE INTO `pw_area` VALUES('330122','330100','330000','桐庐县','330122','0');
REPLACE INTO `pw_area` VALUES('330127','330100','330000','淳安县','330127','0');
REPLACE INTO `pw_area` VALUES('330182','330100','330000','建德市','330182','0');
REPLACE INTO `pw_area` VALUES('330183','330100','330000','富阳市','330183','0');
REPLACE INTO `pw_area` VALUES('330185','330100','330000','临安市','330185','0');
REPLACE INTO `pw_area` VALUES('330201','330200','330000','市辖区','330201','0');
REPLACE INTO `pw_area` VALUES('330203','330200','330000','海曙区','330203','0');
REPLACE INTO `pw_area` VALUES('330204','330200','330000','江东区','330204','0');
REPLACE INTO `pw_area` VALUES('330205','330200','330000','江北区','330205','0');
REPLACE INTO `pw_area` VALUES('330206','330200','330000','北仑区','330206','0');
REPLACE INTO `pw_area` VALUES('330211','330200','330000','镇海区','330211','0');
REPLACE INTO `pw_area` VALUES('330212','330200','330000','鄞州区','330212','0');
REPLACE INTO `pw_area` VALUES('330225','330200','330000','象山县','330225','0');
REPLACE INTO `pw_area` VALUES('330226','330200','330000','宁海县','330226','0');
REPLACE INTO `pw_area` VALUES('330281','330200','330000','余姚市','330281','0');
REPLACE INTO `pw_area` VALUES('330282','330200','330000','慈溪市','330282','0');
REPLACE INTO `pw_area` VALUES('330283','330200','330000','奉化市','330283','0');
REPLACE INTO `pw_area` VALUES('330301','330300','330000','市辖区','330301','0');
REPLACE INTO `pw_area` VALUES('330302','330300','330000','鹿城区','330302','0');
REPLACE INTO `pw_area` VALUES('330303','330300','330000','龙湾区','330303','0');
REPLACE INTO `pw_area` VALUES('330304','330300','330000','瓯海区','330304','0');
REPLACE INTO `pw_area` VALUES('330322','330300','330000','洞头县','330322','0');
REPLACE INTO `pw_area` VALUES('330324','330300','330000','永嘉县','330324','0');
REPLACE INTO `pw_area` VALUES('330326','330300','330000','平阳县','330326','0');
REPLACE INTO `pw_area` VALUES('330327','330300','330000','苍南县','330327','0');
REPLACE INTO `pw_area` VALUES('330328','330300','330000','文成县','330328','0');
REPLACE INTO `pw_area` VALUES('330329','330300','330000','泰顺县','330329','0');
REPLACE INTO `pw_area` VALUES('330381','330300','330000','瑞安市','330381','0');
REPLACE INTO `pw_area` VALUES('330382','330300','330000','乐清市','330382','0');
REPLACE INTO `pw_area` VALUES('330401','330400','330000','市辖区','330401','0');
REPLACE INTO `pw_area` VALUES('330402','330400','330000','南湖区','330402','0');
REPLACE INTO `pw_area` VALUES('330411','330400','330000','秀洲区','330411','0');
REPLACE INTO `pw_area` VALUES('330421','330400','330000','嘉善县','330421','0');
REPLACE INTO `pw_area` VALUES('330424','330400','330000','海盐县','330424','0');
REPLACE INTO `pw_area` VALUES('330481','330400','330000','海宁市','330481','0');
REPLACE INTO `pw_area` VALUES('330482','330400','330000','平湖市','330482','0');
REPLACE INTO `pw_area` VALUES('330483','330400','330000','桐乡市','330483','0');
REPLACE INTO `pw_area` VALUES('330501','330500','330000','市辖区','330501','0');
REPLACE INTO `pw_area` VALUES('330502','330500','330000','吴兴区','330502','0');
REPLACE INTO `pw_area` VALUES('330503','330500','330000','南浔区','330503','0');
REPLACE INTO `pw_area` VALUES('330521','330500','330000','德清县','330521','0');
REPLACE INTO `pw_area` VALUES('330522','330500','330000','长兴县','330522','0');
REPLACE INTO `pw_area` VALUES('330523','330500','330000','安吉县','330523','0');
REPLACE INTO `pw_area` VALUES('330601','330600','330000','市辖区','330601','0');
REPLACE INTO `pw_area` VALUES('330602','330600','330000','越城区','330602','0');
REPLACE INTO `pw_area` VALUES('330621','330600','330000','绍兴县','330621','0');
REPLACE INTO `pw_area` VALUES('330624','330600','330000','新昌县','330624','0');
REPLACE INTO `pw_area` VALUES('330681','330600','330000','诸暨市','330681','0');
REPLACE INTO `pw_area` VALUES('330682','330600','330000','上虞市','330682','0');
REPLACE INTO `pw_area` VALUES('330683','330600','330000','嵊州市','330683','0');
REPLACE INTO `pw_area` VALUES('330701','330700','330000','市辖区','330701','0');
REPLACE INTO `pw_area` VALUES('330702','330700','330000','婺城区','330702','0');
REPLACE INTO `pw_area` VALUES('330703','330700','330000','金东区','330703','0');
REPLACE INTO `pw_area` VALUES('330723','330700','330000','武义县','330723','0');
REPLACE INTO `pw_area` VALUES('330726','330700','330000','浦江县','330726','0');
REPLACE INTO `pw_area` VALUES('330727','330700','330000','磐安县','330727','0');
REPLACE INTO `pw_area` VALUES('330781','330700','330000','兰溪市','330781','0');
REPLACE INTO `pw_area` VALUES('330782','330700','330000','义乌市','330782','0');
REPLACE INTO `pw_area` VALUES('330783','330700','330000','东阳市','330783','0');
REPLACE INTO `pw_area` VALUES('330784','330700','330000','永康市','330784','0');
REPLACE INTO `pw_area` VALUES('330801','330800','330000','市辖区','330801','0');
REPLACE INTO `pw_area` VALUES('330802','330800','330000','柯城区','330802','0');
REPLACE INTO `pw_area` VALUES('330803','330800','330000','衢江区','330803','0');
REPLACE INTO `pw_area` VALUES('330822','330800','330000','常山县','330822','0');
REPLACE INTO `pw_area` VALUES('330824','330800','330000','开化县','330824','0');
REPLACE INTO `pw_area` VALUES('330825','330800','330000','龙游县','330825','0');
REPLACE INTO `pw_area` VALUES('330881','330800','330000','江山市','330881','0');
REPLACE INTO `pw_area` VALUES('330901','330900','330000','市辖区','330901','0');
REPLACE INTO `pw_area` VALUES('330902','330900','330000','定海区','330902','0');
REPLACE INTO `pw_area` VALUES('330903','330900','330000','普陀区','330903','0');
REPLACE INTO `pw_area` VALUES('330921','330900','330000','岱山县','330921','0');
REPLACE INTO `pw_area` VALUES('330922','330900','330000','嵊泗县','330922','0');
REPLACE INTO `pw_area` VALUES('331001','331000','330000','市辖区','331001','0');
REPLACE INTO `pw_area` VALUES('331002','331000','330000','椒江区','331002','0');
REPLACE INTO `pw_area` VALUES('331003','331000','330000','黄岩区','331003','0');
REPLACE INTO `pw_area` VALUES('331004','331000','330000','路桥区','331004','0');
REPLACE INTO `pw_area` VALUES('331021','331000','330000','玉环县','331021','0');
REPLACE INTO `pw_area` VALUES('331022','331000','330000','三门县','331022','0');
REPLACE INTO `pw_area` VALUES('331023','331000','330000','天台县','331023','0');
REPLACE INTO `pw_area` VALUES('331024','331000','330000','仙居县','331024','0');
REPLACE INTO `pw_area` VALUES('331081','331000','330000','温岭市','331081','0');
REPLACE INTO `pw_area` VALUES('331082','331000','330000','临海市','331082','0');
REPLACE INTO `pw_area` VALUES('331101','331100','330000','市辖区','331101','0');
REPLACE INTO `pw_area` VALUES('331102','331100','330000','莲都区','331102','0');
REPLACE INTO `pw_area` VALUES('331121','331100','330000','青田县','331121','0');
REPLACE INTO `pw_area` VALUES('331122','331100','330000','缙云县','331122','0');
REPLACE INTO `pw_area` VALUES('331123','331100','330000','遂昌县','331123','0');
REPLACE INTO `pw_area` VALUES('331124','331100','330000','松阳县','331124','0');
REPLACE INTO `pw_area` VALUES('331125','331100','330000','云和县','331125','0');
REPLACE INTO `pw_area` VALUES('331126','331100','330000','庆元县','331126','0');
REPLACE INTO `pw_area` VALUES('331127','331100','330000','景宁畲族自治县','331127','0');
REPLACE INTO `pw_area` VALUES('331181','331100','330000','龙泉市','331181','0');
REPLACE INTO `pw_area` VALUES('340101','340100','340000','市辖区','340101','0');
REPLACE INTO `pw_area` VALUES('340102','340100','340000','瑶海区','340102','0');
REPLACE INTO `pw_area` VALUES('340103','340100','340000','庐阳区','340103','0');
REPLACE INTO `pw_area` VALUES('340104','340100','340000','蜀山区','340104','0');
REPLACE INTO `pw_area` VALUES('340111','340100','340000','包河区','340111','0');
REPLACE INTO `pw_area` VALUES('340121','340100','340000','长丰县','340121','0');
REPLACE INTO `pw_area` VALUES('340122','340100','340000','肥东县','340122','0');
REPLACE INTO `pw_area` VALUES('340123','340100','340000','肥西县','340123','0');
REPLACE INTO `pw_area` VALUES('340124','340100','340000','庐江县','340124','0');
REPLACE INTO `pw_area` VALUES('340181','340100','340000','巢湖市','340181','0');
REPLACE INTO `pw_area` VALUES('340201','340200','340000','市辖区','340201','0');
REPLACE INTO `pw_area` VALUES('340202','340200','340000','镜湖区','340202','0');
REPLACE INTO `pw_area` VALUES('340203','340200','340000','弋江区','340203','0');
REPLACE INTO `pw_area` VALUES('340207','340200','340000','鸠江区','340207','0');
REPLACE INTO `pw_area` VALUES('340208','340200','340000','三山区','340208','0');
REPLACE INTO `pw_area` VALUES('340221','340200','340000','芜湖县','340221','0');
REPLACE INTO `pw_area` VALUES('340222','340200','340000','繁昌县','340222','0');
REPLACE INTO `pw_area` VALUES('340223','340200','340000','南陵县','340223','0');
REPLACE INTO `pw_area` VALUES('340225','340200','340000','无为县','340225','0');
REPLACE INTO `pw_area` VALUES('340301','340300','340000','市辖区','340301','0');
REPLACE INTO `pw_area` VALUES('340302','340300','340000','龙子湖区','340302','0');
REPLACE INTO `pw_area` VALUES('340303','340300','340000','蚌山区','340303','0');
REPLACE INTO `pw_area` VALUES('340304','340300','340000','禹会区','340304','0');
REPLACE INTO `pw_area` VALUES('340311','340300','340000','淮上区','340311','0');
REPLACE INTO `pw_area` VALUES('340321','340300','340000','怀远县','340321','0');
REPLACE INTO `pw_area` VALUES('340322','340300','340000','五河县','340322','0');
REPLACE INTO `pw_area` VALUES('340323','340300','340000','固镇县','340323','0');
REPLACE INTO `pw_area` VALUES('340401','340400','340000','市辖区','340401','0');
REPLACE INTO `pw_area` VALUES('340402','340400','340000','大通区','340402','0');
REPLACE INTO `pw_area` VALUES('340403','340400','340000','田家庵区','340403','0');
REPLACE INTO `pw_area` VALUES('340404','340400','340000','谢家集区','340404','0');
REPLACE INTO `pw_area` VALUES('340405','340400','340000','八公山区','340405','0');
REPLACE INTO `pw_area` VALUES('340406','340400','340000','潘集区','340406','0');
REPLACE INTO `pw_area` VALUES('340421','340400','340000','凤台县','340421','0');
REPLACE INTO `pw_area` VALUES('340501','340500','340000','市辖区','340501','0');
REPLACE INTO `pw_area` VALUES('340503','340500','340000','花山区','340503','0');
REPLACE INTO `pw_area` VALUES('340504','340500','340000','雨山区','340504','0');
REPLACE INTO `pw_area` VALUES('340506','340500','340000','博望区','340506','0');
REPLACE INTO `pw_area` VALUES('340521','340500','340000','当涂县','340521','0');
REPLACE INTO `pw_area` VALUES('340522','340500','340000','含山县','340522','0');
REPLACE INTO `pw_area` VALUES('340523','340500','340000','和县','340523','0');
REPLACE INTO `pw_area` VALUES('340601','340600','340000','市辖区','340601','0');
REPLACE INTO `pw_area` VALUES('340602','340600','340000','杜集区','340602','0');
REPLACE INTO `pw_area` VALUES('340603','340600','340000','相山区','340603','0');
REPLACE INTO `pw_area` VALUES('340604','340600','340000','烈山区','340604','0');
REPLACE INTO `pw_area` VALUES('340621','340600','340000','濉溪县','340621','0');
REPLACE INTO `pw_area` VALUES('340701','340700','340000','市辖区','340701','0');
REPLACE INTO `pw_area` VALUES('340702','340700','340000','铜官山区','340702','0');
REPLACE INTO `pw_area` VALUES('340703','340700','340000','狮子山区','340703','0');
REPLACE INTO `pw_area` VALUES('340711','340700','340000','郊区','340711','0');
REPLACE INTO `pw_area` VALUES('340721','340700','340000','铜陵县','340721','0');
REPLACE INTO `pw_area` VALUES('340801','340800','340000','市辖区','340801','0');
REPLACE INTO `pw_area` VALUES('340802','340800','340000','迎江区','340802','0');
REPLACE INTO `pw_area` VALUES('340803','340800','340000','大观区','340803','0');
REPLACE INTO `pw_area` VALUES('340811','340800','340000','宜秀区','340811','0');
REPLACE INTO `pw_area` VALUES('340822','340800','340000','怀宁县','340822','0');
REPLACE INTO `pw_area` VALUES('340823','340800','340000','枞阳县','340823','0');
REPLACE INTO `pw_area` VALUES('340824','340800','340000','潜山县','340824','0');
REPLACE INTO `pw_area` VALUES('340825','340800','340000','太湖县','340825','0');
REPLACE INTO `pw_area` VALUES('340826','340800','340000','宿松县','340826','0');
REPLACE INTO `pw_area` VALUES('340827','340800','340000','望江县','340827','0');
REPLACE INTO `pw_area` VALUES('340828','340800','340000','岳西县','340828','0');
REPLACE INTO `pw_area` VALUES('340881','340800','340000','桐城市','340881','0');
REPLACE INTO `pw_area` VALUES('341001','341000','340000','市辖区','341001','0');
REPLACE INTO `pw_area` VALUES('341002','341000','340000','屯溪区','341002','0');
REPLACE INTO `pw_area` VALUES('341003','341000','340000','黄山区','341003','0');
REPLACE INTO `pw_area` VALUES('341004','341000','340000','徽州区','341004','0');
REPLACE INTO `pw_area` VALUES('341021','341000','340000','歙县','341021','0');
REPLACE INTO `pw_area` VALUES('341022','341000','340000','休宁县','341022','0');
REPLACE INTO `pw_area` VALUES('341023','341000','340000','黟县','341023','0');
REPLACE INTO `pw_area` VALUES('341024','341000','340000','祁门县','341024','0');
REPLACE INTO `pw_area` VALUES('341101','341100','340000','市辖区','341101','0');
REPLACE INTO `pw_area` VALUES('341102','341100','340000','琅琊区','341102','0');
REPLACE INTO `pw_area` VALUES('341103','341100','340000','南谯区','341103','0');
REPLACE INTO `pw_area` VALUES('341122','341100','340000','来安县','341122','0');
REPLACE INTO `pw_area` VALUES('341124','341100','340000','全椒县','341124','0');
REPLACE INTO `pw_area` VALUES('341125','341100','340000','定远县','341125','0');
REPLACE INTO `pw_area` VALUES('341126','341100','340000','凤阳县','341126','0');
REPLACE INTO `pw_area` VALUES('341181','341100','340000','天长市','341181','0');
REPLACE INTO `pw_area` VALUES('341182','341100','340000','明光市','341182','0');
REPLACE INTO `pw_area` VALUES('341201','341200','340000','市辖区','341201','0');
REPLACE INTO `pw_area` VALUES('341202','341200','340000','颍州区','341202','0');
REPLACE INTO `pw_area` VALUES('341203','341200','340000','颍东区','341203','0');
REPLACE INTO `pw_area` VALUES('341204','341200','340000','颍泉区','341204','0');
REPLACE INTO `pw_area` VALUES('341221','341200','340000','临泉县','341221','0');
REPLACE INTO `pw_area` VALUES('341222','341200','340000','太和县','341222','0');
REPLACE INTO `pw_area` VALUES('341225','341200','340000','阜南县','341225','0');
REPLACE INTO `pw_area` VALUES('341226','341200','340000','颍上县','341226','0');
REPLACE INTO `pw_area` VALUES('341282','341200','340000','界首市','341282','0');
REPLACE INTO `pw_area` VALUES('341301','341300','340000','市辖区','341301','0');
REPLACE INTO `pw_area` VALUES('341302','341300','340000','埇桥区','341302','0');
REPLACE INTO `pw_area` VALUES('341321','341300','340000','砀山县','341321','0');
REPLACE INTO `pw_area` VALUES('341322','341300','340000','萧县','341322','0');
REPLACE INTO `pw_area` VALUES('341323','341300','340000','灵璧县','341323','0');
REPLACE INTO `pw_area` VALUES('341324','341300','340000','泗县','341324','0');
REPLACE INTO `pw_area` VALUES('341501','341500','340000','市辖区','341501','0');
REPLACE INTO `pw_area` VALUES('341502','341500','340000','金安区','341502','0');
REPLACE INTO `pw_area` VALUES('341503','341500','340000','裕安区','341503','0');
REPLACE INTO `pw_area` VALUES('341521','341500','340000','寿县','341521','0');
REPLACE INTO `pw_area` VALUES('341522','341500','340000','霍邱县','341522','0');
REPLACE INTO `pw_area` VALUES('341523','341500','340000','舒城县','341523','0');
REPLACE INTO `pw_area` VALUES('341524','341500','340000','金寨县','341524','0');
REPLACE INTO `pw_area` VALUES('341525','341500','340000','霍山县','341525','0');
REPLACE INTO `pw_area` VALUES('341601','341600','340000','市辖区','341601','0');
REPLACE INTO `pw_area` VALUES('341602','341600','340000','谯城区','341602','0');
REPLACE INTO `pw_area` VALUES('341621','341600','340000','涡阳县','341621','0');
REPLACE INTO `pw_area` VALUES('341622','341600','340000','蒙城县','341622','0');
REPLACE INTO `pw_area` VALUES('341623','341600','340000','利辛县','341623','0');
REPLACE INTO `pw_area` VALUES('341701','341700','340000','市辖区','341701','0');
REPLACE INTO `pw_area` VALUES('341702','341700','340000','贵池区','341702','0');
REPLACE INTO `pw_area` VALUES('341721','341700','340000','东至县','341721','0');
REPLACE INTO `pw_area` VALUES('341722','341700','340000','石台县','341722','0');
REPLACE INTO `pw_area` VALUES('341723','341700','340000','青阳县','341723','0');
REPLACE INTO `pw_area` VALUES('341801','341800','340000','市辖区','341801','0');
REPLACE INTO `pw_area` VALUES('341802','341800','340000','宣州区','341802','0');
REPLACE INTO `pw_area` VALUES('341821','341800','340000','郎溪县','341821','0');
REPLACE INTO `pw_area` VALUES('341822','341800','340000','广德县','341822','0');
REPLACE INTO `pw_area` VALUES('341823','341800','340000','泾县','341823','0');
REPLACE INTO `pw_area` VALUES('341824','341800','340000','绩溪县','341824','0');
REPLACE INTO `pw_area` VALUES('341825','341800','340000','旌德县','341825','0');
REPLACE INTO `pw_area` VALUES('341881','341800','340000','宁国市','341881','0');
REPLACE INTO `pw_area` VALUES('350101','350100','350000','市辖区','350101','0');
REPLACE INTO `pw_area` VALUES('350102','350100','350000','鼓楼区','350102','0');
REPLACE INTO `pw_area` VALUES('350103','350100','350000','台江区','350103','0');
REPLACE INTO `pw_area` VALUES('350104','350100','350000','仓山区','350104','0');
REPLACE INTO `pw_area` VALUES('350105','350100','350000','马尾区','350105','0');
REPLACE INTO `pw_area` VALUES('350111','350100','350000','晋安区','350111','0');
REPLACE INTO `pw_area` VALUES('350121','350100','350000','闽侯县','350121','0');
REPLACE INTO `pw_area` VALUES('350122','350100','350000','连江县','350122','0');
REPLACE INTO `pw_area` VALUES('350123','350100','350000','罗源县','350123','0');
REPLACE INTO `pw_area` VALUES('350124','350100','350000','闽清县','350124','0');
REPLACE INTO `pw_area` VALUES('350125','350100','350000','永泰县','350125','0');
REPLACE INTO `pw_area` VALUES('350128','350100','350000','平潭县','350128','0');
REPLACE INTO `pw_area` VALUES('350181','350100','350000','福清市','350181','0');
REPLACE INTO `pw_area` VALUES('350182','350100','350000','长乐市','350182','0');
REPLACE INTO `pw_area` VALUES('350201','350200','350000','市辖区','350201','0');
REPLACE INTO `pw_area` VALUES('350203','350200','350000','思明区','350203','0');
REPLACE INTO `pw_area` VALUES('350205','350200','350000','海沧区','350205','0');
REPLACE INTO `pw_area` VALUES('350206','350200','350000','湖里区','350206','0');
REPLACE INTO `pw_area` VALUES('350211','350200','350000','集美区','350211','0');
REPLACE INTO `pw_area` VALUES('350212','350200','350000','同安区','350212','0');
REPLACE INTO `pw_area` VALUES('350213','350200','350000','翔安区','350213','0');
REPLACE INTO `pw_area` VALUES('350301','350300','350000','市辖区','350301','0');
REPLACE INTO `pw_area` VALUES('350302','350300','350000','城厢区','350302','0');
REPLACE INTO `pw_area` VALUES('350303','350300','350000','涵江区','350303','0');
REPLACE INTO `pw_area` VALUES('350304','350300','350000','荔城区','350304','0');
REPLACE INTO `pw_area` VALUES('350305','350300','350000','秀屿区','350305','0');
REPLACE INTO `pw_area` VALUES('350322','350300','350000','仙游县','350322','0');
REPLACE INTO `pw_area` VALUES('350401','350400','350000','市辖区','350401','0');
REPLACE INTO `pw_area` VALUES('350402','350400','350000','梅列区','350402','0');
REPLACE INTO `pw_area` VALUES('350403','350400','350000','三元区','350403','0');
REPLACE INTO `pw_area` VALUES('350421','350400','350000','明溪县','350421','0');
REPLACE INTO `pw_area` VALUES('350423','350400','350000','清流县','350423','0');
REPLACE INTO `pw_area` VALUES('350424','350400','350000','宁化县','350424','0');
REPLACE INTO `pw_area` VALUES('350425','350400','350000','大田县','350425','0');
REPLACE INTO `pw_area` VALUES('350426','350400','350000','尤溪县','350426','0');
REPLACE INTO `pw_area` VALUES('350427','350400','350000','沙县','350427','0');
REPLACE INTO `pw_area` VALUES('350428','350400','350000','将乐县','350428','0');
REPLACE INTO `pw_area` VALUES('350429','350400','350000','泰宁县','350429','0');
REPLACE INTO `pw_area` VALUES('350430','350400','350000','建宁县','350430','0');
REPLACE INTO `pw_area` VALUES('350481','350400','350000','永安市','350481','0');
REPLACE INTO `pw_area` VALUES('350501','350500','350000','市辖区','350501','0');
REPLACE INTO `pw_area` VALUES('350502','350500','350000','鲤城区','350502','0');
REPLACE INTO `pw_area` VALUES('350503','350500','350000','丰泽区','350503','0');
REPLACE INTO `pw_area` VALUES('350504','350500','350000','洛江区','350504','0');
REPLACE INTO `pw_area` VALUES('350505','350500','350000','泉港区','350505','0');
REPLACE INTO `pw_area` VALUES('350521','350500','350000','惠安县','350521','0');
REPLACE INTO `pw_area` VALUES('350524','350500','350000','安溪县','350524','0');
REPLACE INTO `pw_area` VALUES('350525','350500','350000','永春县','350525','0');
REPLACE INTO `pw_area` VALUES('350526','350500','350000','德化县','350526','0');
REPLACE INTO `pw_area` VALUES('350527','350500','350000','金门县','350527','0');
REPLACE INTO `pw_area` VALUES('350581','350500','350000','石狮市','350581','0');
REPLACE INTO `pw_area` VALUES('350582','350500','350000','晋江市','350582','0');
REPLACE INTO `pw_area` VALUES('350583','350500','350000','南安市','350583','0');
REPLACE INTO `pw_area` VALUES('350601','350600','350000','市辖区','350601','0');
REPLACE INTO `pw_area` VALUES('350602','350600','350000','芗城区','350602','0');
REPLACE INTO `pw_area` VALUES('350603','350600','350000','龙文区','350603','0');
REPLACE INTO `pw_area` VALUES('350622','350600','350000','云霄县','350622','0');
REPLACE INTO `pw_area` VALUES('350623','350600','350000','漳浦县','350623','0');
REPLACE INTO `pw_area` VALUES('350624','350600','350000','诏安县','350624','0');
REPLACE INTO `pw_area` VALUES('350625','350600','350000','长泰县','350625','0');
REPLACE INTO `pw_area` VALUES('350626','350600','350000','东山县','350626','0');
REPLACE INTO `pw_area` VALUES('350627','350600','350000','南靖县','350627','0');
REPLACE INTO `pw_area` VALUES('350628','350600','350000','平和县','350628','0');
REPLACE INTO `pw_area` VALUES('350629','350600','350000','华安县','350629','0');
REPLACE INTO `pw_area` VALUES('350681','350600','350000','龙海市','350681','0');
REPLACE INTO `pw_area` VALUES('350701','350700','350000','市辖区','350701','0');
REPLACE INTO `pw_area` VALUES('350702','350700','350000','延平区','350702','0');
REPLACE INTO `pw_area` VALUES('350721','350700','350000','顺昌县','350721','0');
REPLACE INTO `pw_area` VALUES('350722','350700','350000','浦城县','350722','0');
REPLACE INTO `pw_area` VALUES('350723','350700','350000','光泽县','350723','0');
REPLACE INTO `pw_area` VALUES('350724','350700','350000','松溪县','350724','0');
REPLACE INTO `pw_area` VALUES('350725','350700','350000','政和县','350725','0');
REPLACE INTO `pw_area` VALUES('350781','350700','350000','邵武市','350781','0');
REPLACE INTO `pw_area` VALUES('350782','350700','350000','武夷山市','350782','0');
REPLACE INTO `pw_area` VALUES('350783','350700','350000','建瓯市','350783','0');
REPLACE INTO `pw_area` VALUES('350784','350700','350000','建阳市','350784','0');
REPLACE INTO `pw_area` VALUES('350801','350800','350000','市辖区','350801','0');
REPLACE INTO `pw_area` VALUES('350802','350800','350000','新罗区','350802','0');
REPLACE INTO `pw_area` VALUES('350821','350800','350000','长汀县','350821','0');
REPLACE INTO `pw_area` VALUES('350822','350800','350000','永定县','350822','0');
REPLACE INTO `pw_area` VALUES('350823','350800','350000','上杭县','350823','0');
REPLACE INTO `pw_area` VALUES('350824','350800','350000','武平县','350824','0');
REPLACE INTO `pw_area` VALUES('350825','350800','350000','连城县','350825','0');
REPLACE INTO `pw_area` VALUES('350881','350800','350000','漳平市','350881','0');
REPLACE INTO `pw_area` VALUES('350901','350900','350000','市辖区','350901','0');
REPLACE INTO `pw_area` VALUES('350902','350900','350000','蕉城区','350902','0');
REPLACE INTO `pw_area` VALUES('350921','350900','350000','霞浦县','350921','0');
REPLACE INTO `pw_area` VALUES('350922','350900','350000','古田县','350922','0');
REPLACE INTO `pw_area` VALUES('350923','350900','350000','屏南县','350923','0');
REPLACE INTO `pw_area` VALUES('350924','350900','350000','寿宁县','350924','0');
REPLACE INTO `pw_area` VALUES('350925','350900','350000','周宁县','350925','0');
REPLACE INTO `pw_area` VALUES('350926','350900','350000','柘荣县','350926','0');
REPLACE INTO `pw_area` VALUES('350981','350900','350000','福安市','350981','0');
REPLACE INTO `pw_area` VALUES('350982','350900','350000','福鼎市','350982','0');
REPLACE INTO `pw_area` VALUES('360101','360100','360000','市辖区','360101','0');
REPLACE INTO `pw_area` VALUES('360102','360100','360000','东湖区','360102','0');
REPLACE INTO `pw_area` VALUES('360103','360100','360000','西湖区','360103','0');
REPLACE INTO `pw_area` VALUES('360104','360100','360000','青云谱区','360104','0');
REPLACE INTO `pw_area` VALUES('360105','360100','360000','湾里区','360105','0');
REPLACE INTO `pw_area` VALUES('360111','360100','360000','青山湖区','360111','0');
REPLACE INTO `pw_area` VALUES('360121','360100','360000','南昌县','360121','0');
REPLACE INTO `pw_area` VALUES('360122','360100','360000','新建县','360122','0');
REPLACE INTO `pw_area` VALUES('360123','360100','360000','安义县','360123','0');
REPLACE INTO `pw_area` VALUES('360124','360100','360000','进贤县','360124','0');
REPLACE INTO `pw_area` VALUES('360201','360200','360000','市辖区','360201','0');
REPLACE INTO `pw_area` VALUES('360202','360200','360000','昌江区','360202','0');
REPLACE INTO `pw_area` VALUES('360203','360200','360000','珠山区','360203','0');
REPLACE INTO `pw_area` VALUES('360222','360200','360000','浮梁县','360222','0');
REPLACE INTO `pw_area` VALUES('360281','360200','360000','乐平市','360281','0');
REPLACE INTO `pw_area` VALUES('360301','360300','360000','市辖区','360301','0');
REPLACE INTO `pw_area` VALUES('360302','360300','360000','安源区','360302','0');
REPLACE INTO `pw_area` VALUES('360313','360300','360000','湘东区','360313','0');
REPLACE INTO `pw_area` VALUES('360321','360300','360000','莲花县','360321','0');
REPLACE INTO `pw_area` VALUES('360322','360300','360000','上栗县','360322','0');
REPLACE INTO `pw_area` VALUES('360323','360300','360000','芦溪县','360323','0');
REPLACE INTO `pw_area` VALUES('360401','360400','360000','市辖区','360401','0');
REPLACE INTO `pw_area` VALUES('360402','360400','360000','庐山区','360402','0');
REPLACE INTO `pw_area` VALUES('360403','360400','360000','浔阳区','360403','0');
REPLACE INTO `pw_area` VALUES('360421','360400','360000','九江县','360421','0');
REPLACE INTO `pw_area` VALUES('360423','360400','360000','武宁县','360423','0');
REPLACE INTO `pw_area` VALUES('360424','360400','360000','修水县','360424','0');
REPLACE INTO `pw_area` VALUES('360425','360400','360000','永修县','360425','0');
REPLACE INTO `pw_area` VALUES('360426','360400','360000','德安县','360426','0');
REPLACE INTO `pw_area` VALUES('360427','360400','360000','星子县','360427','0');
REPLACE INTO `pw_area` VALUES('360428','360400','360000','都昌县','360428','0');
REPLACE INTO `pw_area` VALUES('360429','360400','360000','湖口县','360429','0');
REPLACE INTO `pw_area` VALUES('360430','360400','360000','彭泽县','360430','0');
REPLACE INTO `pw_area` VALUES('360481','360400','360000','瑞昌市','360481','0');
REPLACE INTO `pw_area` VALUES('360482','360400','360000','共青城市','360482','0');
REPLACE INTO `pw_area` VALUES('360501','360500','360000','市辖区','360501','0');
REPLACE INTO `pw_area` VALUES('360502','360500','360000','渝水区','360502','0');
REPLACE INTO `pw_area` VALUES('360521','360500','360000','分宜县','360521','0');
REPLACE INTO `pw_area` VALUES('360601','360600','360000','市辖区','360601','0');
REPLACE INTO `pw_area` VALUES('360602','360600','360000','月湖区','360602','0');
REPLACE INTO `pw_area` VALUES('360622','360600','360000','余江县','360622','0');
REPLACE INTO `pw_area` VALUES('360681','360600','360000','贵溪市','360681','0');
REPLACE INTO `pw_area` VALUES('360701','360700','360000','市辖区','360701','0');
REPLACE INTO `pw_area` VALUES('360702','360700','360000','章贡区','360702','0');
REPLACE INTO `pw_area` VALUES('360721','360700','360000','赣县','360721','0');
REPLACE INTO `pw_area` VALUES('360722','360700','360000','信丰县','360722','0');
REPLACE INTO `pw_area` VALUES('360723','360700','360000','大余县','360723','0');
REPLACE INTO `pw_area` VALUES('360724','360700','360000','上犹县','360724','0');
REPLACE INTO `pw_area` VALUES('360725','360700','360000','崇义县','360725','0');
REPLACE INTO `pw_area` VALUES('360726','360700','360000','安远县','360726','0');
REPLACE INTO `pw_area` VALUES('360727','360700','360000','龙南县','360727','0');
REPLACE INTO `pw_area` VALUES('360728','360700','360000','定南县','360728','0');
REPLACE INTO `pw_area` VALUES('360729','360700','360000','全南县','360729','0');
REPLACE INTO `pw_area` VALUES('360730','360700','360000','宁都县','360730','0');
REPLACE INTO `pw_area` VALUES('360731','360700','360000','于都县','360731','0');
REPLACE INTO `pw_area` VALUES('360732','360700','360000','兴国县','360732','0');
REPLACE INTO `pw_area` VALUES('360733','360700','360000','会昌县','360733','0');
REPLACE INTO `pw_area` VALUES('360734','360700','360000','寻乌县','360734','0');
REPLACE INTO `pw_area` VALUES('360735','360700','360000','石城县','360735','0');
REPLACE INTO `pw_area` VALUES('360781','360700','360000','瑞金市','360781','0');
REPLACE INTO `pw_area` VALUES('360782','360700','360000','南康市','360782','0');
REPLACE INTO `pw_area` VALUES('360801','360800','360000','市辖区','360801','0');
REPLACE INTO `pw_area` VALUES('360802','360800','360000','吉州区','360802','0');
REPLACE INTO `pw_area` VALUES('360803','360800','360000','青原区','360803','0');
REPLACE INTO `pw_area` VALUES('360821','360800','360000','吉安县','360821','0');
REPLACE INTO `pw_area` VALUES('360822','360800','360000','吉水县','360822','0');
REPLACE INTO `pw_area` VALUES('360823','360800','360000','峡江县','360823','0');
REPLACE INTO `pw_area` VALUES('360824','360800','360000','新干县','360824','0');
REPLACE INTO `pw_area` VALUES('360825','360800','360000','永丰县','360825','0');
REPLACE INTO `pw_area` VALUES('360826','360800','360000','泰和县','360826','0');
REPLACE INTO `pw_area` VALUES('360827','360800','360000','遂川县','360827','0');
REPLACE INTO `pw_area` VALUES('360828','360800','360000','万安县','360828','0');
REPLACE INTO `pw_area` VALUES('360829','360800','360000','安福县','360829','0');
REPLACE INTO `pw_area` VALUES('360830','360800','360000','永新县','360830','0');
REPLACE INTO `pw_area` VALUES('360881','360800','360000','井冈山市','360881','0');
REPLACE INTO `pw_area` VALUES('360901','360900','360000','市辖区','360901','0');
REPLACE INTO `pw_area` VALUES('360902','360900','360000','袁州区','360902','0');
REPLACE INTO `pw_area` VALUES('360921','360900','360000','奉新县','360921','0');
REPLACE INTO `pw_area` VALUES('360922','360900','360000','万载县','360922','0');
REPLACE INTO `pw_area` VALUES('360923','360900','360000','上高县','360923','0');
REPLACE INTO `pw_area` VALUES('360924','360900','360000','宜丰县','360924','0');
REPLACE INTO `pw_area` VALUES('360925','360900','360000','靖安县','360925','0');
REPLACE INTO `pw_area` VALUES('360926','360900','360000','铜鼓县','360926','0');
REPLACE INTO `pw_area` VALUES('360981','360900','360000','丰城市','360981','0');
REPLACE INTO `pw_area` VALUES('360982','360900','360000','樟树市','360982','0');
REPLACE INTO `pw_area` VALUES('360983','360900','360000','高安市','360983','0');
REPLACE INTO `pw_area` VALUES('361001','361000','360000','市辖区','361001','0');
REPLACE INTO `pw_area` VALUES('361002','361000','360000','临川区','361002','0');
REPLACE INTO `pw_area` VALUES('361021','361000','360000','南城县','361021','0');
REPLACE INTO `pw_area` VALUES('361022','361000','360000','黎川县','361022','0');
REPLACE INTO `pw_area` VALUES('361023','361000','360000','南丰县','361023','0');
REPLACE INTO `pw_area` VALUES('361024','361000','360000','崇仁县','361024','0');
REPLACE INTO `pw_area` VALUES('361025','361000','360000','乐安县','361025','0');
REPLACE INTO `pw_area` VALUES('361026','361000','360000','宜黄县','361026','0');
REPLACE INTO `pw_area` VALUES('361027','361000','360000','金溪县','361027','0');
REPLACE INTO `pw_area` VALUES('361028','361000','360000','资溪县','361028','0');
REPLACE INTO `pw_area` VALUES('361029','361000','360000','东乡县','361029','0');
REPLACE INTO `pw_area` VALUES('361030','361000','360000','广昌县','361030','0');
REPLACE INTO `pw_area` VALUES('361101','361100','360000','市辖区','361101','0');
REPLACE INTO `pw_area` VALUES('361102','361100','360000','信州区','361102','0');
REPLACE INTO `pw_area` VALUES('361121','361100','360000','上饶县','361121','0');
REPLACE INTO `pw_area` VALUES('361122','361100','360000','广丰县','361122','0');
REPLACE INTO `pw_area` VALUES('361123','361100','360000','玉山县','361123','0');
REPLACE INTO `pw_area` VALUES('361124','361100','360000','铅山县','361124','0');
REPLACE INTO `pw_area` VALUES('361125','361100','360000','横峰县','361125','0');
REPLACE INTO `pw_area` VALUES('361126','361100','360000','弋阳县','361126','0');
REPLACE INTO `pw_area` VALUES('361127','361100','360000','余干县','361127','0');
REPLACE INTO `pw_area` VALUES('361128','361100','360000','鄱阳县','361128','0');
REPLACE INTO `pw_area` VALUES('361129','361100','360000','万年县','361129','0');
REPLACE INTO `pw_area` VALUES('361130','361100','360000','婺源县','361130','0');
REPLACE INTO `pw_area` VALUES('361181','361100','360000','德兴市','361181','0');
REPLACE INTO `pw_area` VALUES('370101','370100','370000','市辖区','370101','0');
REPLACE INTO `pw_area` VALUES('370102','370100','370000','历下区','370102','0');
REPLACE INTO `pw_area` VALUES('370103','370100','370000','市中区','370103','0');
REPLACE INTO `pw_area` VALUES('370104','370100','370000','槐荫区','370104','0');
REPLACE INTO `pw_area` VALUES('370105','370100','370000','天桥区','370105','0');
REPLACE INTO `pw_area` VALUES('370112','370100','370000','历城区','370112','0');
REPLACE INTO `pw_area` VALUES('370113','370100','370000','长清区','370113','0');
REPLACE INTO `pw_area` VALUES('370124','370100','370000','平阴县','370124','0');
REPLACE INTO `pw_area` VALUES('370125','370100','370000','济阳县','370125','0');
REPLACE INTO `pw_area` VALUES('370126','370100','370000','商河县','370126','0');
REPLACE INTO `pw_area` VALUES('370181','370100','370000','章丘市','370181','0');
REPLACE INTO `pw_area` VALUES('370201','370200','370000','市辖区','370201','0');
REPLACE INTO `pw_area` VALUES('370202','370200','370000','市南区','370202','0');
REPLACE INTO `pw_area` VALUES('370203','370200','370000','市北区','370203','0');
REPLACE INTO `pw_area` VALUES('370211','370200','370000','黄岛区','370211','0');
REPLACE INTO `pw_area` VALUES('370212','370200','370000','崂山区','370212','0');
REPLACE INTO `pw_area` VALUES('370213','370200','370000','李沧区','370213','0');
REPLACE INTO `pw_area` VALUES('370214','370200','370000','城阳区','370214','0');
REPLACE INTO `pw_area` VALUES('370281','370200','370000','胶州市','370281','0');
REPLACE INTO `pw_area` VALUES('370282','370200','370000','即墨市','370282','0');
REPLACE INTO `pw_area` VALUES('370283','370200','370000','平度市','370283','0');
REPLACE INTO `pw_area` VALUES('370285','370200','370000','莱西市','370285','0');
REPLACE INTO `pw_area` VALUES('370301','370300','370000','市辖区','370301','0');
REPLACE INTO `pw_area` VALUES('370302','370300','370000','淄川区','370302','0');
REPLACE INTO `pw_area` VALUES('370303','370300','370000','张店区','370303','0');
REPLACE INTO `pw_area` VALUES('370304','370300','370000','博山区','370304','0');
REPLACE INTO `pw_area` VALUES('370305','370300','370000','临淄区','370305','0');
REPLACE INTO `pw_area` VALUES('370306','370300','370000','周村区','370306','0');
REPLACE INTO `pw_area` VALUES('370321','370300','370000','桓台县','370321','0');
REPLACE INTO `pw_area` VALUES('370322','370300','370000','高青县','370322','0');
REPLACE INTO `pw_area` VALUES('370323','370300','370000','沂源县','370323','0');
REPLACE INTO `pw_area` VALUES('370401','370400','370000','市辖区','370401','0');
REPLACE INTO `pw_area` VALUES('370402','370400','370000','市中区','370402','0');
REPLACE INTO `pw_area` VALUES('370403','370400','370000','薛城区','370403','0');
REPLACE INTO `pw_area` VALUES('370404','370400','370000','峄城区','370404','0');
REPLACE INTO `pw_area` VALUES('370405','370400','370000','台儿庄区','370405','0');
REPLACE INTO `pw_area` VALUES('370406','370400','370000','山亭区','370406','0');
REPLACE INTO `pw_area` VALUES('370481','370400','370000','滕州市','370481','0');
REPLACE INTO `pw_area` VALUES('370501','370500','370000','市辖区','370501','0');
REPLACE INTO `pw_area` VALUES('370502','370500','370000','东营区','370502','0');
REPLACE INTO `pw_area` VALUES('370503','370500','370000','河口区','370503','0');
REPLACE INTO `pw_area` VALUES('370521','370500','370000','垦利县','370521','0');
REPLACE INTO `pw_area` VALUES('370522','370500','370000','利津县','370522','0');
REPLACE INTO `pw_area` VALUES('370523','370500','370000','广饶县','370523','0');
REPLACE INTO `pw_area` VALUES('370601','370600','370000','市辖区','370601','0');
REPLACE INTO `pw_area` VALUES('370602','370600','370000','芝罘区','370602','0');
REPLACE INTO `pw_area` VALUES('370611','370600','370000','福山区','370611','0');
REPLACE INTO `pw_area` VALUES('370612','370600','370000','牟平区','370612','0');
REPLACE INTO `pw_area` VALUES('370613','370600','370000','莱山区','370613','0');
REPLACE INTO `pw_area` VALUES('370634','370600','370000','长岛县','370634','0');
REPLACE INTO `pw_area` VALUES('370681','370600','370000','龙口市','370681','0');
REPLACE INTO `pw_area` VALUES('370682','370600','370000','莱阳市','370682','0');
REPLACE INTO `pw_area` VALUES('370683','370600','370000','莱州市','370683','0');
REPLACE INTO `pw_area` VALUES('370684','370600','370000','蓬莱市','370684','0');
REPLACE INTO `pw_area` VALUES('370685','370600','370000','招远市','370685','0');
REPLACE INTO `pw_area` VALUES('370686','370600','370000','栖霞市','370686','0');
REPLACE INTO `pw_area` VALUES('370687','370600','370000','海阳市','370687','0');
REPLACE INTO `pw_area` VALUES('370701','370700','370000','市辖区','370701','0');
REPLACE INTO `pw_area` VALUES('370702','370700','370000','潍城区','370702','0');
REPLACE INTO `pw_area` VALUES('370703','370700','370000','寒亭区','370703','0');
REPLACE INTO `pw_area` VALUES('370704','370700','370000','坊子区','370704','0');
REPLACE INTO `pw_area` VALUES('370705','370700','370000','奎文区','370705','0');
REPLACE INTO `pw_area` VALUES('370724','370700','370000','临朐县','370724','0');
REPLACE INTO `pw_area` VALUES('370725','370700','370000','昌乐县','370725','0');
REPLACE INTO `pw_area` VALUES('370781','370700','370000','青州市','370781','0');
REPLACE INTO `pw_area` VALUES('370782','370700','370000','诸城市','370782','0');
REPLACE INTO `pw_area` VALUES('370783','370700','370000','寿光市','370783','0');
REPLACE INTO `pw_area` VALUES('370784','370700','370000','安丘市','370784','0');
REPLACE INTO `pw_area` VALUES('370785','370700','370000','高密市','370785','0');
REPLACE INTO `pw_area` VALUES('370786','370700','370000','昌邑市','370786','0');
REPLACE INTO `pw_area` VALUES('370801','370800','370000','市辖区','370801','0');
REPLACE INTO `pw_area` VALUES('370802','370800','370000','市中区','370802','0');
REPLACE INTO `pw_area` VALUES('370811','370800','370000','任城区','370811','0');
REPLACE INTO `pw_area` VALUES('370826','370800','370000','微山县','370826','0');
REPLACE INTO `pw_area` VALUES('370827','370800','370000','鱼台县','370827','0');
REPLACE INTO `pw_area` VALUES('370828','370800','370000','金乡县','370828','0');
REPLACE INTO `pw_area` VALUES('370829','370800','370000','嘉祥县','370829','0');
REPLACE INTO `pw_area` VALUES('370830','370800','370000','汶上县','370830','0');
REPLACE INTO `pw_area` VALUES('370831','370800','370000','泗水县','370831','0');
REPLACE INTO `pw_area` VALUES('370832','370800','370000','梁山县','370832','0');
REPLACE INTO `pw_area` VALUES('370881','370800','370000','曲阜市','370881','0');
REPLACE INTO `pw_area` VALUES('370882','370800','370000','兖州市','370882','0');
REPLACE INTO `pw_area` VALUES('370883','370800','370000','邹城市','370883','0');
REPLACE INTO `pw_area` VALUES('370901','370900','370000','市辖区','370901','0');
REPLACE INTO `pw_area` VALUES('370902','370900','370000','泰山区','370902','0');
REPLACE INTO `pw_area` VALUES('370911','370900','370000','岱岳区','370911','0');
REPLACE INTO `pw_area` VALUES('370921','370900','370000','宁阳县','370921','0');
REPLACE INTO `pw_area` VALUES('370923','370900','370000','东平县','370923','0');
REPLACE INTO `pw_area` VALUES('370982','370900','370000','新泰市','370982','0');
REPLACE INTO `pw_area` VALUES('370983','370900','370000','肥城市','370983','0');
REPLACE INTO `pw_area` VALUES('371001','371000','370000','市辖区','371001','0');
REPLACE INTO `pw_area` VALUES('371002','371000','370000','环翠区','371002','0');
REPLACE INTO `pw_area` VALUES('371081','371000','370000','文登市','371081','0');
REPLACE INTO `pw_area` VALUES('371082','371000','370000','荣成市','371082','0');
REPLACE INTO `pw_area` VALUES('371083','371000','370000','乳山市','371083','0');
REPLACE INTO `pw_area` VALUES('371101','371100','370000','市辖区','371101','0');
REPLACE INTO `pw_area` VALUES('371102','371100','370000','东港区','371102','0');
REPLACE INTO `pw_area` VALUES('371103','371100','370000','岚山区','371103','0');
REPLACE INTO `pw_area` VALUES('371121','371100','370000','五莲县','371121','0');
REPLACE INTO `pw_area` VALUES('371122','371100','370000','莒县','371122','0');
REPLACE INTO `pw_area` VALUES('371201','371200','370000','市辖区','371201','0');
REPLACE INTO `pw_area` VALUES('371202','371200','370000','莱城区','371202','0');
REPLACE INTO `pw_area` VALUES('371203','371200','370000','钢城区','371203','0');
REPLACE INTO `pw_area` VALUES('371301','371300','370000','市辖区','371301','0');
REPLACE INTO `pw_area` VALUES('371302','371300','370000','兰山区','371302','0');
REPLACE INTO `pw_area` VALUES('371311','371300','370000','罗庄区','371311','0');
REPLACE INTO `pw_area` VALUES('371312','371300','370000','河东区','371312','0');
REPLACE INTO `pw_area` VALUES('371321','371300','370000','沂南县','371321','0');
REPLACE INTO `pw_area` VALUES('371322','371300','370000','郯城县','371322','0');
REPLACE INTO `pw_area` VALUES('371323','371300','370000','沂水县','371323','0');
REPLACE INTO `pw_area` VALUES('371324','371300','370000','苍山县','371324','0');
REPLACE INTO `pw_area` VALUES('371325','371300','370000','费县','371325','0');
REPLACE INTO `pw_area` VALUES('371326','371300','370000','平邑县','371326','0');
REPLACE INTO `pw_area` VALUES('371327','371300','370000','莒南县','371327','0');
REPLACE INTO `pw_area` VALUES('371328','371300','370000','蒙阴县','371328','0');
REPLACE INTO `pw_area` VALUES('371329','371300','370000','临沭县','371329','0');
REPLACE INTO `pw_area` VALUES('371401','371400','370000','市辖区','371401','0');
REPLACE INTO `pw_area` VALUES('371402','371400','370000','德城区','371402','0');
REPLACE INTO `pw_area` VALUES('371421','371400','370000','陵县','371421','0');
REPLACE INTO `pw_area` VALUES('371422','371400','370000','宁津县','371422','0');
REPLACE INTO `pw_area` VALUES('371423','371400','370000','庆云县','371423','0');
REPLACE INTO `pw_area` VALUES('371424','371400','370000','临邑县','371424','0');
REPLACE INTO `pw_area` VALUES('371425','371400','370000','齐河县','371425','0');
REPLACE INTO `pw_area` VALUES('371426','371400','370000','平原县','371426','0');
REPLACE INTO `pw_area` VALUES('371427','371400','370000','夏津县','371427','0');
REPLACE INTO `pw_area` VALUES('371428','371400','370000','武城县','371428','0');
REPLACE INTO `pw_area` VALUES('371481','371400','370000','乐陵市','371481','0');
REPLACE INTO `pw_area` VALUES('371482','371400','370000','禹城市','371482','0');
REPLACE INTO `pw_area` VALUES('371501','371500','370000','市辖区','371501','0');
REPLACE INTO `pw_area` VALUES('371502','371500','370000','东昌府区','371502','0');
REPLACE INTO `pw_area` VALUES('371521','371500','370000','阳谷县','371521','0');
REPLACE INTO `pw_area` VALUES('371522','371500','370000','莘县','371522','0');
REPLACE INTO `pw_area` VALUES('371523','371500','370000','茌平县','371523','0');
REPLACE INTO `pw_area` VALUES('371524','371500','370000','东阿县','371524','0');
REPLACE INTO `pw_area` VALUES('371525','371500','370000','冠县','371525','0');
REPLACE INTO `pw_area` VALUES('371526','371500','370000','高唐县','371526','0');
REPLACE INTO `pw_area` VALUES('371581','371500','370000','临清市','371581','0');
REPLACE INTO `pw_area` VALUES('371601','371600','370000','市辖区','371601','0');
REPLACE INTO `pw_area` VALUES('371602','371600','370000','滨城区','371602','0');
REPLACE INTO `pw_area` VALUES('371621','371600','370000','惠民县','371621','0');
REPLACE INTO `pw_area` VALUES('371622','371600','370000','阳信县','371622','0');
REPLACE INTO `pw_area` VALUES('371623','371600','370000','无棣县','371623','0');
REPLACE INTO `pw_area` VALUES('371624','371600','370000','沾化县','371624','0');
REPLACE INTO `pw_area` VALUES('371625','371600','370000','博兴县','371625','0');
REPLACE INTO `pw_area` VALUES('371626','371600','370000','邹平县','371626','0');
REPLACE INTO `pw_area` VALUES('371701','371700','370000','市辖区','371701','0');
REPLACE INTO `pw_area` VALUES('371702','371700','370000','牡丹区','371702','0');
REPLACE INTO `pw_area` VALUES('371721','371700','370000','曹县','371721','0');
REPLACE INTO `pw_area` VALUES('371722','371700','370000','单县','371722','0');
REPLACE INTO `pw_area` VALUES('371723','371700','370000','成武县','371723','0');
REPLACE INTO `pw_area` VALUES('371724','371700','370000','巨野县','371724','0');
REPLACE INTO `pw_area` VALUES('371725','371700','370000','郓城县','371725','0');
REPLACE INTO `pw_area` VALUES('371726','371700','370000','鄄城县','371726','0');
REPLACE INTO `pw_area` VALUES('371727','371700','370000','定陶县','371727','0');
REPLACE INTO `pw_area` VALUES('371728','371700','370000','东明县','371728','0');
REPLACE INTO `pw_area` VALUES('410101','410100','410000','市辖区','410101','0');
REPLACE INTO `pw_area` VALUES('410102','410100','410000','中原区','410102','0');
REPLACE INTO `pw_area` VALUES('410103','410100','410000','二七区','410103','0');
REPLACE INTO `pw_area` VALUES('410104','410100','410000','管城回族区','410104','0');
REPLACE INTO `pw_area` VALUES('410105','410100','410000','金水区','410105','0');
REPLACE INTO `pw_area` VALUES('410106','410100','410000','上街区','410106','0');
REPLACE INTO `pw_area` VALUES('410108','410100','410000','惠济区','410108','0');
REPLACE INTO `pw_area` VALUES('410122','410100','410000','中牟县','410122','0');
REPLACE INTO `pw_area` VALUES('410181','410100','410000','巩义市','410181','0');
REPLACE INTO `pw_area` VALUES('410182','410100','410000','荥阳市','410182','0');
REPLACE INTO `pw_area` VALUES('410183','410100','410000','新密市','410183','0');
REPLACE INTO `pw_area` VALUES('410184','410100','410000','新郑市','410184','0');
REPLACE INTO `pw_area` VALUES('410185','410100','410000','登封市','410185','0');
REPLACE INTO `pw_area` VALUES('410201','410200','410000','市辖区','410201','0');
REPLACE INTO `pw_area` VALUES('410202','410200','410000','龙亭区','410202','0');
REPLACE INTO `pw_area` VALUES('410203','410200','410000','顺河回族区','410203','0');
REPLACE INTO `pw_area` VALUES('410204','410200','410000','鼓楼区','410204','0');
REPLACE INTO `pw_area` VALUES('410205','410200','410000','禹王台区','410205','0');
REPLACE INTO `pw_area` VALUES('410211','410200','410000','金明区','410211','0');
REPLACE INTO `pw_area` VALUES('410221','410200','410000','杞县','410221','0');
REPLACE INTO `pw_area` VALUES('410222','410200','410000','通许县','410222','0');
REPLACE INTO `pw_area` VALUES('410223','410200','410000','尉氏县','410223','0');
REPLACE INTO `pw_area` VALUES('410224','410200','410000','开封县','410224','0');
REPLACE INTO `pw_area` VALUES('410225','410200','410000','兰考县','410225','0');
REPLACE INTO `pw_area` VALUES('410301','410300','410000','市辖区','410301','0');
REPLACE INTO `pw_area` VALUES('410302','410300','410000','老城区','410302','0');
REPLACE INTO `pw_area` VALUES('410303','410300','410000','西工区','410303','0');
REPLACE INTO `pw_area` VALUES('410304','410300','410000','瀍河回族区','410304','0');
REPLACE INTO `pw_area` VALUES('410305','410300','410000','涧西区','410305','0');
REPLACE INTO `pw_area` VALUES('410306','410300','410000','吉利区','410306','0');
REPLACE INTO `pw_area` VALUES('410311','410300','410000','洛龙区','410311','0');
REPLACE INTO `pw_area` VALUES('410322','410300','410000','孟津县','410322','0');
REPLACE INTO `pw_area` VALUES('410323','410300','410000','新安县','410323','0');
REPLACE INTO `pw_area` VALUES('410324','410300','410000','栾川县','410324','0');
REPLACE INTO `pw_area` VALUES('410325','410300','410000','嵩县','410325','0');
REPLACE INTO `pw_area` VALUES('410326','410300','410000','汝阳县','410326','0');
REPLACE INTO `pw_area` VALUES('410327','410300','410000','宜阳县','410327','0');
REPLACE INTO `pw_area` VALUES('410328','410300','410000','洛宁县','410328','0');
REPLACE INTO `pw_area` VALUES('410329','410300','410000','伊川县','410329','0');
REPLACE INTO `pw_area` VALUES('410381','410300','410000','偃师市','410381','0');
REPLACE INTO `pw_area` VALUES('410401','410400','410000','市辖区','410401','0');
REPLACE INTO `pw_area` VALUES('410402','410400','410000','新华区','410402','0');
REPLACE INTO `pw_area` VALUES('410403','410400','410000','卫东区','410403','0');
REPLACE INTO `pw_area` VALUES('410404','410400','410000','石龙区','410404','0');
REPLACE INTO `pw_area` VALUES('410411','410400','410000','湛河区','410411','0');
REPLACE INTO `pw_area` VALUES('410421','410400','410000','宝丰县','410421','0');
REPLACE INTO `pw_area` VALUES('410422','410400','410000','叶县','410422','0');
REPLACE INTO `pw_area` VALUES('410423','410400','410000','鲁山县','410423','0');
REPLACE INTO `pw_area` VALUES('410425','410400','410000','郏县','410425','0');
REPLACE INTO `pw_area` VALUES('410481','410400','410000','舞钢市','410481','0');
REPLACE INTO `pw_area` VALUES('410482','410400','410000','汝州市','410482','0');
REPLACE INTO `pw_area` VALUES('410501','410500','410000','市辖区','410501','0');
REPLACE INTO `pw_area` VALUES('410502','410500','410000','文峰区','410502','0');
REPLACE INTO `pw_area` VALUES('410503','410500','410000','北关区','410503','0');
REPLACE INTO `pw_area` VALUES('410505','410500','410000','殷都区','410505','0');
REPLACE INTO `pw_area` VALUES('410506','410500','410000','龙安区','410506','0');
REPLACE INTO `pw_area` VALUES('410522','410500','410000','安阳县','410522','0');
REPLACE INTO `pw_area` VALUES('410523','410500','410000','汤阴县','410523','0');
REPLACE INTO `pw_area` VALUES('410526','410500','410000','滑县','410526','0');
REPLACE INTO `pw_area` VALUES('410527','410500','410000','内黄县','410527','0');
REPLACE INTO `pw_area` VALUES('410581','410500','410000','林州市','410581','0');
REPLACE INTO `pw_area` VALUES('410601','410600','410000','市辖区','410601','0');
REPLACE INTO `pw_area` VALUES('410602','410600','410000','鹤山区','410602','0');
REPLACE INTO `pw_area` VALUES('410603','410600','410000','山城区','410603','0');
REPLACE INTO `pw_area` VALUES('410611','410600','410000','淇滨区','410611','0');
REPLACE INTO `pw_area` VALUES('410621','410600','410000','浚县','410621','0');
REPLACE INTO `pw_area` VALUES('410622','410600','410000','淇县','410622','0');
REPLACE INTO `pw_area` VALUES('410701','410700','410000','市辖区','410701','0');
REPLACE INTO `pw_area` VALUES('410702','410700','410000','红旗区','410702','0');
REPLACE INTO `pw_area` VALUES('410703','410700','410000','卫滨区','410703','0');
REPLACE INTO `pw_area` VALUES('410704','410700','410000','凤泉区','410704','0');
REPLACE INTO `pw_area` VALUES('410711','410700','410000','牧野区','410711','0');
REPLACE INTO `pw_area` VALUES('410721','410700','410000','新乡县','410721','0');
REPLACE INTO `pw_area` VALUES('410724','410700','410000','获嘉县','410724','0');
REPLACE INTO `pw_area` VALUES('410725','410700','410000','原阳县','410725','0');
REPLACE INTO `pw_area` VALUES('410726','410700','410000','延津县','410726','0');
REPLACE INTO `pw_area` VALUES('410727','410700','410000','封丘县','410727','0');
REPLACE INTO `pw_area` VALUES('410728','410700','410000','长垣县','410728','0');
REPLACE INTO `pw_area` VALUES('410781','410700','410000','卫辉市','410781','0');
REPLACE INTO `pw_area` VALUES('410782','410700','410000','辉县市','410782','0');
REPLACE INTO `pw_area` VALUES('410801','410800','410000','市辖区','410801','0');
REPLACE INTO `pw_area` VALUES('410802','410800','410000','解放区','410802','0');
REPLACE INTO `pw_area` VALUES('410803','410800','410000','中站区','410803','0');
REPLACE INTO `pw_area` VALUES('410804','410800','410000','马村区','410804','0');
REPLACE INTO `pw_area` VALUES('410811','410800','410000','山阳区','410811','0');
REPLACE INTO `pw_area` VALUES('410821','410800','410000','修武县','410821','0');
REPLACE INTO `pw_area` VALUES('410822','410800','410000','博爱县','410822','0');
REPLACE INTO `pw_area` VALUES('410823','410800','410000','武陟县','410823','0');
REPLACE INTO `pw_area` VALUES('410825','410800','410000','温县','410825','0');
REPLACE INTO `pw_area` VALUES('410882','410800','410000','沁阳市','410882','0');
REPLACE INTO `pw_area` VALUES('410883','410800','410000','孟州市','410883','0');
REPLACE INTO `pw_area` VALUES('410901','410900','410000','市辖区','410901','0');
REPLACE INTO `pw_area` VALUES('410902','410900','410000','华龙区','410902','0');
REPLACE INTO `pw_area` VALUES('410922','410900','410000','清丰县','410922','0');
REPLACE INTO `pw_area` VALUES('410923','410900','410000','南乐县','410923','0');
REPLACE INTO `pw_area` VALUES('410926','410900','410000','范县','410926','0');
REPLACE INTO `pw_area` VALUES('410927','410900','410000','台前县','410927','0');
REPLACE INTO `pw_area` VALUES('410928','410900','410000','濮阳县','410928','0');
REPLACE INTO `pw_area` VALUES('411001','411000','410000','市辖区','411001','0');
REPLACE INTO `pw_area` VALUES('411002','411000','410000','魏都区','411002','0');
REPLACE INTO `pw_area` VALUES('411023','411000','410000','许昌县','411023','0');
REPLACE INTO `pw_area` VALUES('411024','411000','410000','鄢陵县','411024','0');
REPLACE INTO `pw_area` VALUES('411025','411000','410000','襄城县','411025','0');
REPLACE INTO `pw_area` VALUES('411081','411000','410000','禹州市','411081','0');
REPLACE INTO `pw_area` VALUES('411082','411000','410000','长葛市','411082','0');
REPLACE INTO `pw_area` VALUES('411101','411100','410000','市辖区','411101','0');
REPLACE INTO `pw_area` VALUES('411102','411100','410000','源汇区','411102','0');
REPLACE INTO `pw_area` VALUES('411103','411100','410000','郾城区','411103','0');
REPLACE INTO `pw_area` VALUES('411104','411100','410000','召陵区','411104','0');
REPLACE INTO `pw_area` VALUES('411121','411100','410000','舞阳县','411121','0');
REPLACE INTO `pw_area` VALUES('411122','411100','410000','临颍县','411122','0');
REPLACE INTO `pw_area` VALUES('411201','411200','410000','市辖区','411201','0');
REPLACE INTO `pw_area` VALUES('411202','411200','410000','湖滨区','411202','0');
REPLACE INTO `pw_area` VALUES('411221','411200','410000','渑池县','411221','0');
REPLACE INTO `pw_area` VALUES('411222','411200','410000','陕县','411222','0');
REPLACE INTO `pw_area` VALUES('411224','411200','410000','卢氏县','411224','0');
REPLACE INTO `pw_area` VALUES('411281','411200','410000','义马市','411281','0');
REPLACE INTO `pw_area` VALUES('411282','411200','410000','灵宝市','411282','0');
REPLACE INTO `pw_area` VALUES('411301','411300','410000','市辖区','411301','0');
REPLACE INTO `pw_area` VALUES('411302','411300','410000','宛城区','411302','0');
REPLACE INTO `pw_area` VALUES('411303','411300','410000','卧龙区','411303','0');
REPLACE INTO `pw_area` VALUES('411321','411300','410000','南召县','411321','0');
REPLACE INTO `pw_area` VALUES('411322','411300','410000','方城县','411322','0');
REPLACE INTO `pw_area` VALUES('411323','411300','410000','西峡县','411323','0');
REPLACE INTO `pw_area` VALUES('411324','411300','410000','镇平县','411324','0');
REPLACE INTO `pw_area` VALUES('411325','411300','410000','内乡县','411325','0');
REPLACE INTO `pw_area` VALUES('411326','411300','410000','淅川县','411326','0');
REPLACE INTO `pw_area` VALUES('411327','411300','410000','社旗县','411327','0');
REPLACE INTO `pw_area` VALUES('411328','411300','410000','唐河县','411328','0');
REPLACE INTO `pw_area` VALUES('411329','411300','410000','新野县','411329','0');
REPLACE INTO `pw_area` VALUES('411330','411300','410000','桐柏县','411330','0');
REPLACE INTO `pw_area` VALUES('411381','411300','410000','邓州市','411381','0');
REPLACE INTO `pw_area` VALUES('411401','411400','410000','市辖区','411401','0');
REPLACE INTO `pw_area` VALUES('411402','411400','410000','梁园区','411402','0');
REPLACE INTO `pw_area` VALUES('411403','411400','410000','睢阳区','411403','0');
REPLACE INTO `pw_area` VALUES('411421','411400','410000','民权县','411421','0');
REPLACE INTO `pw_area` VALUES('411422','411400','410000','睢县','411422','0');
REPLACE INTO `pw_area` VALUES('411423','411400','410000','宁陵县','411423','0');
REPLACE INTO `pw_area` VALUES('411424','411400','410000','柘城县','411424','0');
REPLACE INTO `pw_area` VALUES('411425','411400','410000','虞城县','411425','0');
REPLACE INTO `pw_area` VALUES('411426','411400','410000','夏邑县','411426','0');
REPLACE INTO `pw_area` VALUES('411481','411400','410000','永城市','411481','0');
REPLACE INTO `pw_area` VALUES('411501','411500','410000','市辖区','411501','0');
REPLACE INTO `pw_area` VALUES('411502','411500','410000','浉河区','411502','0');
REPLACE INTO `pw_area` VALUES('411503','411500','410000','平桥区','411503','0');
REPLACE INTO `pw_area` VALUES('411521','411500','410000','罗山县','411521','0');
REPLACE INTO `pw_area` VALUES('411522','411500','410000','光山县','411522','0');
REPLACE INTO `pw_area` VALUES('411523','411500','410000','新县','411523','0');
REPLACE INTO `pw_area` VALUES('411524','411500','410000','商城县','411524','0');
REPLACE INTO `pw_area` VALUES('411525','411500','410000','固始县','411525','0');
REPLACE INTO `pw_area` VALUES('411526','411500','410000','潢川县','411526','0');
REPLACE INTO `pw_area` VALUES('411527','411500','410000','淮滨县','411527','0');
REPLACE INTO `pw_area` VALUES('411528','411500','410000','息县','411528','0');
REPLACE INTO `pw_area` VALUES('411601','411600','410000','市辖区','411601','0');
REPLACE INTO `pw_area` VALUES('411602','411600','410000','川汇区','411602','0');
REPLACE INTO `pw_area` VALUES('411621','411600','410000','扶沟县','411621','0');
REPLACE INTO `pw_area` VALUES('411622','411600','410000','西华县','411622','0');
REPLACE INTO `pw_area` VALUES('411623','411600','410000','商水县','411623','0');
REPLACE INTO `pw_area` VALUES('411624','411600','410000','沈丘县','411624','0');
REPLACE INTO `pw_area` VALUES('411625','411600','410000','郸城县','411625','0');
REPLACE INTO `pw_area` VALUES('411626','411600','410000','淮阳县','411626','0');
REPLACE INTO `pw_area` VALUES('411627','411600','410000','太康县','411627','0');
REPLACE INTO `pw_area` VALUES('411628','411600','410000','鹿邑县','411628','0');
REPLACE INTO `pw_area` VALUES('411681','411600','410000','项城市','411681','0');
REPLACE INTO `pw_area` VALUES('411701','411700','410000','市辖区','411701','0');
REPLACE INTO `pw_area` VALUES('411702','411700','410000','驿城区','411702','0');
REPLACE INTO `pw_area` VALUES('411721','411700','410000','西平县','411721','0');
REPLACE INTO `pw_area` VALUES('411722','411700','410000','上蔡县','411722','0');
REPLACE INTO `pw_area` VALUES('411723','411700','410000','平舆县','411723','0');
REPLACE INTO `pw_area` VALUES('411724','411700','410000','正阳县','411724','0');
REPLACE INTO `pw_area` VALUES('411725','411700','410000','确山县','411725','0');
REPLACE INTO `pw_area` VALUES('411726','411700','410000','泌阳县','411726','0');
REPLACE INTO `pw_area` VALUES('411727','411700','410000','汝南县','411727','0');
REPLACE INTO `pw_area` VALUES('411728','411700','410000','遂平县','411728','0');
REPLACE INTO `pw_area` VALUES('411729','411700','410000','新蔡县','411729','0');
REPLACE INTO `pw_area` VALUES('419001','419000','410000','济源市','419001','0');
REPLACE INTO `pw_area` VALUES('420101','420100','420000','市辖区','420101','0');
REPLACE INTO `pw_area` VALUES('420102','420100','420000','江岸区','420102','0');
REPLACE INTO `pw_area` VALUES('420103','420100','420000','江汉区','420103','0');
REPLACE INTO `pw_area` VALUES('420104','420100','420000','硚口区','420104','0');
REPLACE INTO `pw_area` VALUES('420105','420100','420000','汉阳区','420105','0');
REPLACE INTO `pw_area` VALUES('420106','420100','420000','武昌区','420106','0');
REPLACE INTO `pw_area` VALUES('420107','420100','420000','青山区','420107','0');
REPLACE INTO `pw_area` VALUES('420111','420100','420000','洪山区','420111','0');
REPLACE INTO `pw_area` VALUES('420112','420100','420000','东西湖区','420112','0');
REPLACE INTO `pw_area` VALUES('420113','420100','420000','汉南区','420113','0');
REPLACE INTO `pw_area` VALUES('420114','420100','420000','蔡甸区','420114','0');
REPLACE INTO `pw_area` VALUES('420115','420100','420000','江夏区','420115','0');
REPLACE INTO `pw_area` VALUES('420116','420100','420000','黄陂区','420116','0');
REPLACE INTO `pw_area` VALUES('420117','420100','420000','新洲区','420117','0');
REPLACE INTO `pw_area` VALUES('420201','420200','420000','市辖区','420201','0');
REPLACE INTO `pw_area` VALUES('420202','420200','420000','黄石港区','420202','0');
REPLACE INTO `pw_area` VALUES('420203','420200','420000','西塞山区','420203','0');
REPLACE INTO `pw_area` VALUES('420204','420200','420000','下陆区','420204','0');
REPLACE INTO `pw_area` VALUES('420205','420200','420000','铁山区','420205','0');
REPLACE INTO `pw_area` VALUES('420222','420200','420000','阳新县','420222','0');
REPLACE INTO `pw_area` VALUES('420281','420200','420000','大冶市','420281','0');
REPLACE INTO `pw_area` VALUES('420301','420300','420000','市辖区','420301','0');
REPLACE INTO `pw_area` VALUES('420302','420300','420000','茅箭区','420302','0');
REPLACE INTO `pw_area` VALUES('420303','420300','420000','张湾区','420303','0');
REPLACE INTO `pw_area` VALUES('420321','420300','420000','郧县','420321','0');
REPLACE INTO `pw_area` VALUES('420322','420300','420000','郧西县','420322','0');
REPLACE INTO `pw_area` VALUES('420323','420300','420000','竹山县','420323','0');
REPLACE INTO `pw_area` VALUES('420324','420300','420000','竹溪县','420324','0');
REPLACE INTO `pw_area` VALUES('420325','420300','420000','房县','420325','0');
REPLACE INTO `pw_area` VALUES('420381','420300','420000','丹江口市','420381','0');
REPLACE INTO `pw_area` VALUES('420501','420500','420000','市辖区','420501','0');
REPLACE INTO `pw_area` VALUES('420502','420500','420000','西陵区','420502','0');
REPLACE INTO `pw_area` VALUES('420503','420500','420000','伍家岗区','420503','0');
REPLACE INTO `pw_area` VALUES('420504','420500','420000','点军区','420504','0');
REPLACE INTO `pw_area` VALUES('420505','420500','420000','猇亭区','420505','0');
REPLACE INTO `pw_area` VALUES('420506','420500','420000','夷陵区','420506','0');
REPLACE INTO `pw_area` VALUES('420525','420500','420000','远安县','420525','0');
REPLACE INTO `pw_area` VALUES('420526','420500','420000','兴山县','420526','0');
REPLACE INTO `pw_area` VALUES('420527','420500','420000','秭归县','420527','0');
REPLACE INTO `pw_area` VALUES('420528','420500','420000','长阳土家族自治县','420528','0');
REPLACE INTO `pw_area` VALUES('420529','420500','420000','五峰土家族自治县','420529','0');
REPLACE INTO `pw_area` VALUES('420581','420500','420000','宜都市','420581','0');
REPLACE INTO `pw_area` VALUES('420582','420500','420000','当阳市','420582','0');
REPLACE INTO `pw_area` VALUES('420583','420500','420000','枝江市','420583','0');
REPLACE INTO `pw_area` VALUES('420601','420600','420000','市辖区','420601','0');
REPLACE INTO `pw_area` VALUES('420602','420600','420000','襄城区','420602','0');
REPLACE INTO `pw_area` VALUES('420606','420600','420000','樊城区','420606','0');
REPLACE INTO `pw_area` VALUES('420607','420600','420000','襄州区','420607','0');
REPLACE INTO `pw_area` VALUES('420624','420600','420000','南漳县','420624','0');
REPLACE INTO `pw_area` VALUES('420625','420600','420000','谷城县','420625','0');
REPLACE INTO `pw_area` VALUES('420626','420600','420000','保康县','420626','0');
REPLACE INTO `pw_area` VALUES('420682','420600','420000','老河口市','420682','0');
REPLACE INTO `pw_area` VALUES('420683','420600','420000','枣阳市','420683','0');
REPLACE INTO `pw_area` VALUES('420684','420600','420000','宜城市','420684','0');
REPLACE INTO `pw_area` VALUES('420701','420700','420000','市辖区','420701','0');
REPLACE INTO `pw_area` VALUES('420702','420700','420000','梁子湖区','420702','0');
REPLACE INTO `pw_area` VALUES('420703','420700','420000','华容区','420703','0');
REPLACE INTO `pw_area` VALUES('420704','420700','420000','鄂城区','420704','0');
REPLACE INTO `pw_area` VALUES('420801','420800','420000','市辖区','420801','0');
REPLACE INTO `pw_area` VALUES('420802','420800','420000','东宝区','420802','0');
REPLACE INTO `pw_area` VALUES('420804','420800','420000','掇刀区','420804','0');
REPLACE INTO `pw_area` VALUES('420821','420800','420000','京山县','420821','0');
REPLACE INTO `pw_area` VALUES('420822','420800','420000','沙洋县','420822','0');
REPLACE INTO `pw_area` VALUES('420881','420800','420000','钟祥市','420881','0');
REPLACE INTO `pw_area` VALUES('420901','420900','420000','市辖区','420901','0');
REPLACE INTO `pw_area` VALUES('420902','420900','420000','孝南区','420902','0');
REPLACE INTO `pw_area` VALUES('420921','420900','420000','孝昌县','420921','0');
REPLACE INTO `pw_area` VALUES('420922','420900','420000','大悟县','420922','0');
REPLACE INTO `pw_area` VALUES('420923','420900','420000','云梦县','420923','0');
REPLACE INTO `pw_area` VALUES('420981','420900','420000','应城市','420981','0');
REPLACE INTO `pw_area` VALUES('420982','420900','420000','安陆市','420982','0');
REPLACE INTO `pw_area` VALUES('420984','420900','420000','汉川市','420984','0');
REPLACE INTO `pw_area` VALUES('421001','421000','420000','市辖区','421001','0');
REPLACE INTO `pw_area` VALUES('421002','421000','420000','沙市区','421002','0');
REPLACE INTO `pw_area` VALUES('421003','421000','420000','荆州区','421003','0');
REPLACE INTO `pw_area` VALUES('421022','421000','420000','公安县','421022','0');
REPLACE INTO `pw_area` VALUES('421023','421000','420000','监利县','421023','0');
REPLACE INTO `pw_area` VALUES('421024','421000','420000','江陵县','421024','0');
REPLACE INTO `pw_area` VALUES('421081','421000','420000','石首市','421081','0');
REPLACE INTO `pw_area` VALUES('421083','421000','420000','洪湖市','421083','0');
REPLACE INTO `pw_area` VALUES('421087','421000','420000','松滋市','421087','0');
REPLACE INTO `pw_area` VALUES('421101','421100','420000','市辖区','421101','0');
REPLACE INTO `pw_area` VALUES('421102','421100','420000','黄州区','421102','0');
REPLACE INTO `pw_area` VALUES('421121','421100','420000','团风县','421121','0');
REPLACE INTO `pw_area` VALUES('421122','421100','420000','红安县','421122','0');
REPLACE INTO `pw_area` VALUES('421123','421100','420000','罗田县','421123','0');
REPLACE INTO `pw_area` VALUES('421124','421100','420000','英山县','421124','0');
REPLACE INTO `pw_area` VALUES('421125','421100','420000','浠水县','421125','0');
REPLACE INTO `pw_area` VALUES('421126','421100','420000','蕲春县','421126','0');
REPLACE INTO `pw_area` VALUES('421127','421100','420000','黄梅县','421127','0');
REPLACE INTO `pw_area` VALUES('421181','421100','420000','麻城市','421181','0');
REPLACE INTO `pw_area` VALUES('421182','421100','420000','武穴市','421182','0');
REPLACE INTO `pw_area` VALUES('421201','421200','420000','市辖区','421201','0');
REPLACE INTO `pw_area` VALUES('421202','421200','420000','咸安区','421202','0');
REPLACE INTO `pw_area` VALUES('421221','421200','420000','嘉鱼县','421221','0');
REPLACE INTO `pw_area` VALUES('421222','421200','420000','通城县','421222','0');
REPLACE INTO `pw_area` VALUES('421223','421200','420000','崇阳县','421223','0');
REPLACE INTO `pw_area` VALUES('421224','421200','420000','通山县','421224','0');
REPLACE INTO `pw_area` VALUES('421281','421200','420000','赤壁市','421281','0');
REPLACE INTO `pw_area` VALUES('421301','421300','420000','市辖区','421301','0');
REPLACE INTO `pw_area` VALUES('421303','421300','420000','曾都区','421303','0');
REPLACE INTO `pw_area` VALUES('421321','421300','420000','随县','421321','0');
REPLACE INTO `pw_area` VALUES('421381','421300','420000','广水市','421381','0');
REPLACE INTO `pw_area` VALUES('422801','422800','420000','恩施市','422801','0');
REPLACE INTO `pw_area` VALUES('422802','422800','420000','利川市','422802','0');
REPLACE INTO `pw_area` VALUES('422822','422800','420000','建始县','422822','0');
REPLACE INTO `pw_area` VALUES('422823','422800','420000','巴东县','422823','0');
REPLACE INTO `pw_area` VALUES('422825','422800','420000','宣恩县','422825','0');
REPLACE INTO `pw_area` VALUES('422826','422800','420000','咸丰县','422826','0');
REPLACE INTO `pw_area` VALUES('422827','422800','420000','来凤县','422827','0');
REPLACE INTO `pw_area` VALUES('422828','422800','420000','鹤峰县','422828','0');
REPLACE INTO `pw_area` VALUES('429004','429000','420000','仙桃市','429004','0');
REPLACE INTO `pw_area` VALUES('429005','429000','420000','潜江市','429005','0');
REPLACE INTO `pw_area` VALUES('429006','429000','420000','天门市','429006','0');
REPLACE INTO `pw_area` VALUES('429021','429000','420000','神农架林区','429021','0');
REPLACE INTO `pw_area` VALUES('430101','430100','430000','市辖区','430101','0');
REPLACE INTO `pw_area` VALUES('430102','430100','430000','芙蓉区','430102','0');
REPLACE INTO `pw_area` VALUES('430103','430100','430000','天心区','430103','0');
REPLACE INTO `pw_area` VALUES('430104','430100','430000','岳麓区','430104','0');
REPLACE INTO `pw_area` VALUES('430105','430100','430000','开福区','430105','0');
REPLACE INTO `pw_area` VALUES('430111','430100','430000','雨花区','430111','0');
REPLACE INTO `pw_area` VALUES('430112','430100','430000','望城区','430112','0');
REPLACE INTO `pw_area` VALUES('430121','430100','430000','长沙县','430121','0');
REPLACE INTO `pw_area` VALUES('430124','430100','430000','宁乡县','430124','0');
REPLACE INTO `pw_area` VALUES('430181','430100','430000','浏阳市','430181','0');
REPLACE INTO `pw_area` VALUES('430201','430200','430000','市辖区','430201','0');
REPLACE INTO `pw_area` VALUES('430202','430200','430000','荷塘区','430202','0');
REPLACE INTO `pw_area` VALUES('430203','430200','430000','芦淞区','430203','0');
REPLACE INTO `pw_area` VALUES('430204','430200','430000','石峰区','430204','0');
REPLACE INTO `pw_area` VALUES('430211','430200','430000','天元区','430211','0');
REPLACE INTO `pw_area` VALUES('430221','430200','430000','株洲县','430221','0');
REPLACE INTO `pw_area` VALUES('430223','430200','430000','攸县','430223','0');
REPLACE INTO `pw_area` VALUES('430224','430200','430000','茶陵县','430224','0');
REPLACE INTO `pw_area` VALUES('430225','430200','430000','炎陵县','430225','0');
REPLACE INTO `pw_area` VALUES('430281','430200','430000','醴陵市','430281','0');
REPLACE INTO `pw_area` VALUES('430301','430300','430000','市辖区','430301','0');
REPLACE INTO `pw_area` VALUES('430302','430300','430000','雨湖区','430302','0');
REPLACE INTO `pw_area` VALUES('430304','430300','430000','岳塘区','430304','0');
REPLACE INTO `pw_area` VALUES('430321','430300','430000','湘潭县','430321','0');
REPLACE INTO `pw_area` VALUES('430381','430300','430000','湘乡市','430381','0');
REPLACE INTO `pw_area` VALUES('430382','430300','430000','韶山市','430382','0');
REPLACE INTO `pw_area` VALUES('430401','430400','430000','市辖区','430401','0');
REPLACE INTO `pw_area` VALUES('430405','430400','430000','珠晖区','430405','0');
REPLACE INTO `pw_area` VALUES('430406','430400','430000','雁峰区','430406','0');
REPLACE INTO `pw_area` VALUES('430407','430400','430000','石鼓区','430407','0');
REPLACE INTO `pw_area` VALUES('430408','430400','430000','蒸湘区','430408','0');
REPLACE INTO `pw_area` VALUES('430412','430400','430000','南岳区','430412','0');
REPLACE INTO `pw_area` VALUES('430421','430400','430000','衡阳县','430421','0');
REPLACE INTO `pw_area` VALUES('430422','430400','430000','衡南县','430422','0');
REPLACE INTO `pw_area` VALUES('430423','430400','430000','衡山县','430423','0');
REPLACE INTO `pw_area` VALUES('430424','430400','430000','衡东县','430424','0');
REPLACE INTO `pw_area` VALUES('430426','430400','430000','祁东县','430426','0');
REPLACE INTO `pw_area` VALUES('430481','430400','430000','耒阳市','430481','0');
REPLACE INTO `pw_area` VALUES('430482','430400','430000','常宁市','430482','0');
REPLACE INTO `pw_area` VALUES('430501','430500','430000','市辖区','430501','0');
REPLACE INTO `pw_area` VALUES('430502','430500','430000','双清区','430502','0');
REPLACE INTO `pw_area` VALUES('430503','430500','430000','大祥区','430503','0');
REPLACE INTO `pw_area` VALUES('430511','430500','430000','北塔区','430511','0');
REPLACE INTO `pw_area` VALUES('430521','430500','430000','邵东县','430521','0');
REPLACE INTO `pw_area` VALUES('430522','430500','430000','新邵县','430522','0');
REPLACE INTO `pw_area` VALUES('430523','430500','430000','邵阳县','430523','0');
REPLACE INTO `pw_area` VALUES('430524','430500','430000','隆回县','430524','0');
REPLACE INTO `pw_area` VALUES('430525','430500','430000','洞口县','430525','0');
REPLACE INTO `pw_area` VALUES('430527','430500','430000','绥宁县','430527','0');
REPLACE INTO `pw_area` VALUES('430528','430500','430000','新宁县','430528','0');
REPLACE INTO `pw_area` VALUES('430529','430500','430000','城步苗族自治县','430529','0');
REPLACE INTO `pw_area` VALUES('430581','430500','430000','武冈市','430581','0');
REPLACE INTO `pw_area` VALUES('430601','430600','430000','市辖区','430601','0');
REPLACE INTO `pw_area` VALUES('430602','430600','430000','岳阳楼区','430602','0');
REPLACE INTO `pw_area` VALUES('430603','430600','430000','云溪区','430603','0');
REPLACE INTO `pw_area` VALUES('430611','430600','430000','君山区','430611','0');
REPLACE INTO `pw_area` VALUES('430621','430600','430000','岳阳县','430621','0');
REPLACE INTO `pw_area` VALUES('430623','430600','430000','华容县','430623','0');
REPLACE INTO `pw_area` VALUES('430624','430600','430000','湘阴县','430624','0');
REPLACE INTO `pw_area` VALUES('430626','430600','430000','平江县','430626','0');
REPLACE INTO `pw_area` VALUES('430681','430600','430000','汨罗市','430681','0');
REPLACE INTO `pw_area` VALUES('430682','430600','430000','临湘市','430682','0');
REPLACE INTO `pw_area` VALUES('430701','430700','430000','市辖区','430701','0');
REPLACE INTO `pw_area` VALUES('430702','430700','430000','武陵区','430702','0');
REPLACE INTO `pw_area` VALUES('430703','430700','430000','鼎城区','430703','0');
REPLACE INTO `pw_area` VALUES('430721','430700','430000','安乡县','430721','0');
REPLACE INTO `pw_area` VALUES('430722','430700','430000','汉寿县','430722','0');
REPLACE INTO `pw_area` VALUES('430723','430700','430000','澧县','430723','0');
REPLACE INTO `pw_area` VALUES('430724','430700','430000','临澧县','430724','0');
REPLACE INTO `pw_area` VALUES('430725','430700','430000','桃源县','430725','0');
REPLACE INTO `pw_area` VALUES('430726','430700','430000','石门县','430726','0');
REPLACE INTO `pw_area` VALUES('430781','430700','430000','津市市','430781','0');
REPLACE INTO `pw_area` VALUES('430801','430800','430000','市辖区','430801','0');
REPLACE INTO `pw_area` VALUES('430802','430800','430000','永定区','430802','0');
REPLACE INTO `pw_area` VALUES('430811','430800','430000','武陵源区','430811','0');
REPLACE INTO `pw_area` VALUES('430821','430800','430000','慈利县','430821','0');
REPLACE INTO `pw_area` VALUES('430822','430800','430000','桑植县','430822','0');
REPLACE INTO `pw_area` VALUES('430901','430900','430000','市辖区','430901','0');
REPLACE INTO `pw_area` VALUES('430902','430900','430000','资阳区','430902','0');
REPLACE INTO `pw_area` VALUES('430903','430900','430000','赫山区','430903','0');
REPLACE INTO `pw_area` VALUES('430921','430900','430000','南县','430921','0');
REPLACE INTO `pw_area` VALUES('430922','430900','430000','桃江县','430922','0');
REPLACE INTO `pw_area` VALUES('430923','430900','430000','安化县','430923','0');
REPLACE INTO `pw_area` VALUES('430981','430900','430000','沅江市','430981','0');
REPLACE INTO `pw_area` VALUES('431001','431000','430000','市辖区','431001','0');
REPLACE INTO `pw_area` VALUES('431002','431000','430000','北湖区','431002','0');
REPLACE INTO `pw_area` VALUES('431003','431000','430000','苏仙区','431003','0');
REPLACE INTO `pw_area` VALUES('431021','431000','430000','桂阳县','431021','0');
REPLACE INTO `pw_area` VALUES('431022','431000','430000','宜章县','431022','0');
REPLACE INTO `pw_area` VALUES('431023','431000','430000','永兴县','431023','0');
REPLACE INTO `pw_area` VALUES('431024','431000','430000','嘉禾县','431024','0');
REPLACE INTO `pw_area` VALUES('431025','431000','430000','临武县','431025','0');
REPLACE INTO `pw_area` VALUES('431026','431000','430000','汝城县','431026','0');
REPLACE INTO `pw_area` VALUES('431027','431000','430000','桂东县','431027','0');
REPLACE INTO `pw_area` VALUES('431028','431000','430000','安仁县','431028','0');
REPLACE INTO `pw_area` VALUES('431081','431000','430000','资兴市','431081','0');
REPLACE INTO `pw_area` VALUES('431101','431100','430000','市辖区','431101','0');
REPLACE INTO `pw_area` VALUES('431102','431100','430000','零陵区','431102','0');
REPLACE INTO `pw_area` VALUES('431103','431100','430000','冷水滩区','431103','0');
REPLACE INTO `pw_area` VALUES('431121','431100','430000','祁阳县','431121','0');
REPLACE INTO `pw_area` VALUES('431122','431100','430000','东安县','431122','0');
REPLACE INTO `pw_area` VALUES('431123','431100','430000','双牌县','431123','0');
REPLACE INTO `pw_area` VALUES('431124','431100','430000','道县','431124','0');
REPLACE INTO `pw_area` VALUES('431125','431100','430000','江永县','431125','0');
REPLACE INTO `pw_area` VALUES('431126','431100','430000','宁远县','431126','0');
REPLACE INTO `pw_area` VALUES('431127','431100','430000','蓝山县','431127','0');
REPLACE INTO `pw_area` VALUES('431128','431100','430000','新田县','431128','0');
REPLACE INTO `pw_area` VALUES('431129','431100','430000','江华瑶族自治县','431129','0');
REPLACE INTO `pw_area` VALUES('431201','431200','430000','市辖区','431201','0');
REPLACE INTO `pw_area` VALUES('431202','431200','430000','鹤城区','431202','0');
REPLACE INTO `pw_area` VALUES('431221','431200','430000','中方县','431221','0');
REPLACE INTO `pw_area` VALUES('431222','431200','430000','沅陵县','431222','0');
REPLACE INTO `pw_area` VALUES('431223','431200','430000','辰溪县','431223','0');
REPLACE INTO `pw_area` VALUES('431224','431200','430000','溆浦县','431224','0');
REPLACE INTO `pw_area` VALUES('431225','431200','430000','会同县','431225','0');
REPLACE INTO `pw_area` VALUES('431226','431200','430000','麻阳苗族自治县','431226','0');
REPLACE INTO `pw_area` VALUES('431227','431200','430000','新晃侗族自治县','431227','0');
REPLACE INTO `pw_area` VALUES('431228','431200','430000','芷江侗族自治县','431228','0');
REPLACE INTO `pw_area` VALUES('431229','431200','430000','靖州苗族侗族自治县','431229','0');
REPLACE INTO `pw_area` VALUES('431230','431200','430000','通道侗族自治县','431230','0');
REPLACE INTO `pw_area` VALUES('431281','431200','430000','洪江市','431281','0');
REPLACE INTO `pw_area` VALUES('431301','431300','430000','市辖区','431301','0');
REPLACE INTO `pw_area` VALUES('431302','431300','430000','娄星区','431302','0');
REPLACE INTO `pw_area` VALUES('431321','431300','430000','双峰县','431321','0');
REPLACE INTO `pw_area` VALUES('431322','431300','430000','新化县','431322','0');
REPLACE INTO `pw_area` VALUES('431381','431300','430000','冷水江市','431381','0');
REPLACE INTO `pw_area` VALUES('431382','431300','430000','涟源市','431382','0');
REPLACE INTO `pw_area` VALUES('433101','433100','430000','吉首市','433101','0');
REPLACE INTO `pw_area` VALUES('433122','433100','430000','泸溪县','433122','0');
REPLACE INTO `pw_area` VALUES('433123','433100','430000','凤凰县','433123','0');
REPLACE INTO `pw_area` VALUES('433124','433100','430000','花垣县','433124','0');
REPLACE INTO `pw_area` VALUES('433125','433100','430000','保靖县','433125','0');
REPLACE INTO `pw_area` VALUES('433126','433100','430000','古丈县','433126','0');
REPLACE INTO `pw_area` VALUES('433127','433100','430000','永顺县','433127','0');
REPLACE INTO `pw_area` VALUES('433130','433100','430000','龙山县','433130','0');
REPLACE INTO `pw_area` VALUES('440101','440100','440000','市辖区','440101','0');
REPLACE INTO `pw_area` VALUES('440103','440100','440000','荔湾区','440103','0');
REPLACE INTO `pw_area` VALUES('440104','440100','440000','越秀区','440104','0');
REPLACE INTO `pw_area` VALUES('440105','440100','440000','海珠区','440105','0');
REPLACE INTO `pw_area` VALUES('440106','440100','440000','天河区','440106','0');
REPLACE INTO `pw_area` VALUES('440111','440100','440000','白云区','440111','0');
REPLACE INTO `pw_area` VALUES('440112','440100','440000','黄埔区','440112','0');
REPLACE INTO `pw_area` VALUES('440113','440100','440000','番禺区','440113','0');
REPLACE INTO `pw_area` VALUES('440114','440100','440000','花都区','440114','0');
REPLACE INTO `pw_area` VALUES('440115','440100','440000','南沙区','440115','0');
REPLACE INTO `pw_area` VALUES('440116','440100','440000','萝岗区','440116','0');
REPLACE INTO `pw_area` VALUES('440183','440100','440000','增城市','440183','0');
REPLACE INTO `pw_area` VALUES('440184','440100','440000','从化市','440184','0');
REPLACE INTO `pw_area` VALUES('440201','440200','440000','市辖区','440201','0');
REPLACE INTO `pw_area` VALUES('440203','440200','440000','武江区','440203','0');
REPLACE INTO `pw_area` VALUES('440204','440200','440000','浈江区','440204','0');
REPLACE INTO `pw_area` VALUES('440205','440200','440000','曲江区','440205','0');
REPLACE INTO `pw_area` VALUES('440222','440200','440000','始兴县','440222','0');
REPLACE INTO `pw_area` VALUES('440224','440200','440000','仁化县','440224','0');
REPLACE INTO `pw_area` VALUES('440229','440200','440000','翁源县','440229','0');
REPLACE INTO `pw_area` VALUES('440232','440200','440000','乳源瑶族自治县','440232','0');
REPLACE INTO `pw_area` VALUES('440233','440200','440000','新丰县','440233','0');
REPLACE INTO `pw_area` VALUES('440281','440200','440000','乐昌市','440281','0');
REPLACE INTO `pw_area` VALUES('440282','440200','440000','南雄市','440282','0');
REPLACE INTO `pw_area` VALUES('440301','440300','440000','市辖区','440301','0');
REPLACE INTO `pw_area` VALUES('440303','440300','440000','罗湖区','440303','0');
REPLACE INTO `pw_area` VALUES('440304','440300','440000','福田区','440304','0');
REPLACE INTO `pw_area` VALUES('440305','440300','440000','南山区','440305','0');
REPLACE INTO `pw_area` VALUES('440306','440300','440000','宝安区','440306','0');
REPLACE INTO `pw_area` VALUES('440307','440300','440000','龙岗区','440307','0');
REPLACE INTO `pw_area` VALUES('440308','440300','440000','盐田区','440308','0');
REPLACE INTO `pw_area` VALUES('440401','440400','440000','市辖区','440401','0');
REPLACE INTO `pw_area` VALUES('440402','440400','440000','香洲区','440402','0');
REPLACE INTO `pw_area` VALUES('440403','440400','440000','斗门区','440403','0');
REPLACE INTO `pw_area` VALUES('440404','440400','440000','金湾区','440404','0');
REPLACE INTO `pw_area` VALUES('440501','440500','440000','市辖区','440501','0');
REPLACE INTO `pw_area` VALUES('440507','440500','440000','龙湖区','440507','0');
REPLACE INTO `pw_area` VALUES('440511','440500','440000','金平区','440511','0');
REPLACE INTO `pw_area` VALUES('440512','440500','440000','濠江区','440512','0');
REPLACE INTO `pw_area` VALUES('440513','440500','440000','潮阳区','440513','0');
REPLACE INTO `pw_area` VALUES('440514','440500','440000','潮南区','440514','0');
REPLACE INTO `pw_area` VALUES('440515','440500','440000','澄海区','440515','0');
REPLACE INTO `pw_area` VALUES('440523','440500','440000','南澳县','440523','0');
REPLACE INTO `pw_area` VALUES('440601','440600','440000','市辖区','440601','0');
REPLACE INTO `pw_area` VALUES('440604','440600','440000','禅城区','440604','0');
REPLACE INTO `pw_area` VALUES('440605','440600','440000','南海区','440605','0');
REPLACE INTO `pw_area` VALUES('440606','440600','440000','顺德区','440606','0');
REPLACE INTO `pw_area` VALUES('440607','440600','440000','三水区','440607','0');
REPLACE INTO `pw_area` VALUES('440608','440600','440000','高明区','440608','0');
REPLACE INTO `pw_area` VALUES('440701','440700','440000','市辖区','440701','0');
REPLACE INTO `pw_area` VALUES('440703','440700','440000','蓬江区','440703','0');
REPLACE INTO `pw_area` VALUES('440704','440700','440000','江海区','440704','0');
REPLACE INTO `pw_area` VALUES('440705','440700','440000','新会区','440705','0');
REPLACE INTO `pw_area` VALUES('440781','440700','440000','台山市','440781','0');
REPLACE INTO `pw_area` VALUES('440783','440700','440000','开平市','440783','0');
REPLACE INTO `pw_area` VALUES('440784','440700','440000','鹤山市','440784','0');
REPLACE INTO `pw_area` VALUES('440785','440700','440000','恩平市','440785','0');
REPLACE INTO `pw_area` VALUES('440801','440800','440000','市辖区','440801','0');
REPLACE INTO `pw_area` VALUES('440802','440800','440000','赤坎区','440802','0');
REPLACE INTO `pw_area` VALUES('440803','440800','440000','霞山区','440803','0');
REPLACE INTO `pw_area` VALUES('440804','440800','440000','坡头区','440804','0');
REPLACE INTO `pw_area` VALUES('440811','440800','440000','麻章区','440811','0');
REPLACE INTO `pw_area` VALUES('440823','440800','440000','遂溪县','440823','0');
REPLACE INTO `pw_area` VALUES('440825','440800','440000','徐闻县','440825','0');
REPLACE INTO `pw_area` VALUES('440881','440800','440000','廉江市','440881','0');
REPLACE INTO `pw_area` VALUES('440882','440800','440000','雷州市','440882','0');
REPLACE INTO `pw_area` VALUES('440883','440800','440000','吴川市','440883','0');
REPLACE INTO `pw_area` VALUES('440901','440900','440000','市辖区','440901','0');
REPLACE INTO `pw_area` VALUES('440902','440900','440000','茂南区','440902','0');
REPLACE INTO `pw_area` VALUES('440903','440900','440000','茂港区','440903','0');
REPLACE INTO `pw_area` VALUES('440923','440900','440000','电白县','440923','0');
REPLACE INTO `pw_area` VALUES('440981','440900','440000','高州市','440981','0');
REPLACE INTO `pw_area` VALUES('440982','440900','440000','化州市','440982','0');
REPLACE INTO `pw_area` VALUES('440983','440900','440000','信宜市','440983','0');
REPLACE INTO `pw_area` VALUES('441201','441200','440000','市辖区','441201','0');
REPLACE INTO `pw_area` VALUES('441202','441200','440000','端州区','441202','0');
REPLACE INTO `pw_area` VALUES('441203','441200','440000','鼎湖区','441203','0');
REPLACE INTO `pw_area` VALUES('441223','441200','440000','广宁县','441223','0');
REPLACE INTO `pw_area` VALUES('441224','441200','440000','怀集县','441224','0');
REPLACE INTO `pw_area` VALUES('441225','441200','440000','封开县','441225','0');
REPLACE INTO `pw_area` VALUES('441226','441200','440000','德庆县','441226','0');
REPLACE INTO `pw_area` VALUES('441283','441200','440000','高要市','441283','0');
REPLACE INTO `pw_area` VALUES('441284','441200','440000','四会市','441284','0');
REPLACE INTO `pw_area` VALUES('441301','441300','440000','市辖区','441301','0');
REPLACE INTO `pw_area` VALUES('441302','441300','440000','惠城区','441302','0');
REPLACE INTO `pw_area` VALUES('441303','441300','440000','惠阳区','441303','0');
REPLACE INTO `pw_area` VALUES('441322','441300','440000','博罗县','441322','0');
REPLACE INTO `pw_area` VALUES('441323','441300','440000','惠东县','441323','0');
REPLACE INTO `pw_area` VALUES('441324','441300','440000','龙门县','441324','0');
REPLACE INTO `pw_area` VALUES('441401','441400','440000','市辖区','441401','0');
REPLACE INTO `pw_area` VALUES('441402','441400','440000','梅江区','441402','0');
REPLACE INTO `pw_area` VALUES('441421','441400','440000','梅县','441421','0');
REPLACE INTO `pw_area` VALUES('441422','441400','440000','大埔县','441422','0');
REPLACE INTO `pw_area` VALUES('441423','441400','440000','丰顺县','441423','0');
REPLACE INTO `pw_area` VALUES('441424','441400','440000','五华县','441424','0');
REPLACE INTO `pw_area` VALUES('441426','441400','440000','平远县','441426','0');
REPLACE INTO `pw_area` VALUES('441427','441400','440000','蕉岭县','441427','0');
REPLACE INTO `pw_area` VALUES('441481','441400','440000','兴宁市','441481','0');
REPLACE INTO `pw_area` VALUES('441501','441500','440000','市辖区','441501','0');
REPLACE INTO `pw_area` VALUES('441502','441500','440000','城区','441502','0');
REPLACE INTO `pw_area` VALUES('441521','441500','440000','海丰县','441521','0');
REPLACE INTO `pw_area` VALUES('441523','441500','440000','陆河县','441523','0');
REPLACE INTO `pw_area` VALUES('441581','441500','440000','陆丰市','441581','0');
REPLACE INTO `pw_area` VALUES('441601','441600','440000','市辖区','441601','0');
REPLACE INTO `pw_area` VALUES('441602','441600','440000','源城区','441602','0');
REPLACE INTO `pw_area` VALUES('441621','441600','440000','紫金县','441621','0');
REPLACE INTO `pw_area` VALUES('441622','441600','440000','龙川县','441622','0');
REPLACE INTO `pw_area` VALUES('441623','441600','440000','连平县','441623','0');
REPLACE INTO `pw_area` VALUES('441624','441600','440000','和平县','441624','0');
REPLACE INTO `pw_area` VALUES('441625','441600','440000','东源县','441625','0');
REPLACE INTO `pw_area` VALUES('441701','441700','440000','市辖区','441701','0');
REPLACE INTO `pw_area` VALUES('441702','441700','440000','江城区','441702','0');
REPLACE INTO `pw_area` VALUES('441721','441700','440000','阳西县','441721','0');
REPLACE INTO `pw_area` VALUES('441723','441700','440000','阳东县','441723','0');
REPLACE INTO `pw_area` VALUES('441781','441700','440000','阳春市','441781','0');
REPLACE INTO `pw_area` VALUES('441801','441800','440000','市辖区','441801','0');
REPLACE INTO `pw_area` VALUES('441802','441800','440000','清城区','441802','0');
REPLACE INTO `pw_area` VALUES('441803','441800','440000','清新区','441803','0');
REPLACE INTO `pw_area` VALUES('441821','441800','440000','佛冈县','441821','0');
REPLACE INTO `pw_area` VALUES('441823','441800','440000','阳山县','441823','0');
REPLACE INTO `pw_area` VALUES('441825','441800','440000','连山壮族瑶族自治县','441825','0');
REPLACE INTO `pw_area` VALUES('441826','441800','440000','连南瑶族自治县','441826','0');
REPLACE INTO `pw_area` VALUES('441881','441800','440000','英德市','441881','0');
REPLACE INTO `pw_area` VALUES('441882','441800','440000','连州市','441882','0');
REPLACE INTO `pw_area` VALUES('445101','445100','440000','市辖区','445101','0');
REPLACE INTO `pw_area` VALUES('445102','445100','440000','湘桥区','445102','0');
REPLACE INTO `pw_area` VALUES('445103','445100','440000','潮安区','445103','0');
REPLACE INTO `pw_area` VALUES('445122','445100','440000','饶平县','445122','0');
REPLACE INTO `pw_area` VALUES('445201','445200','440000','市辖区','445201','0');
REPLACE INTO `pw_area` VALUES('445202','445200','440000','榕城区','445202','0');
REPLACE INTO `pw_area` VALUES('445203','445200','440000','揭东区','445203','0');
REPLACE INTO `pw_area` VALUES('445222','445200','440000','揭西县','445222','0');
REPLACE INTO `pw_area` VALUES('445224','445200','440000','惠来县','445224','0');
REPLACE INTO `pw_area` VALUES('445281','445200','440000','普宁市','445281','0');
REPLACE INTO `pw_area` VALUES('445301','445300','440000','市辖区','445301','0');
REPLACE INTO `pw_area` VALUES('445302','445300','440000','云城区','445302','0');
REPLACE INTO `pw_area` VALUES('445321','445300','440000','新兴县','445321','0');
REPLACE INTO `pw_area` VALUES('445322','445300','440000','郁南县','445322','0');
REPLACE INTO `pw_area` VALUES('445323','445300','440000','云安县','445323','0');
REPLACE INTO `pw_area` VALUES('445381','445300','440000','罗定市','445381','0');
REPLACE INTO `pw_area` VALUES('450101','450100','450000','市辖区','450101','0');
REPLACE INTO `pw_area` VALUES('450102','450100','450000','兴宁区','450102','0');
REPLACE INTO `pw_area` VALUES('450103','450100','450000','青秀区','450103','0');
REPLACE INTO `pw_area` VALUES('450105','450100','450000','江南区','450105','0');
REPLACE INTO `pw_area` VALUES('450107','450100','450000','西乡塘区','450107','0');
REPLACE INTO `pw_area` VALUES('450108','450100','450000','良庆区','450108','0');
REPLACE INTO `pw_area` VALUES('450109','450100','450000','邕宁区','450109','0');
REPLACE INTO `pw_area` VALUES('450122','450100','450000','武鸣县','450122','0');
REPLACE INTO `pw_area` VALUES('450123','450100','450000','隆安县','450123','0');
REPLACE INTO `pw_area` VALUES('450124','450100','450000','马山县','450124','0');
REPLACE INTO `pw_area` VALUES('450125','450100','450000','上林县','450125','0');
REPLACE INTO `pw_area` VALUES('450126','450100','450000','宾阳县','450126','0');
REPLACE INTO `pw_area` VALUES('450127','450100','450000','横县','450127','0');
REPLACE INTO `pw_area` VALUES('450201','450200','450000','市辖区','450201','0');
REPLACE INTO `pw_area` VALUES('450202','450200','450000','城中区','450202','0');
REPLACE INTO `pw_area` VALUES('450203','450200','450000','鱼峰区','450203','0');
REPLACE INTO `pw_area` VALUES('450204','450200','450000','柳南区','450204','0');
REPLACE INTO `pw_area` VALUES('450205','450200','450000','柳北区','450205','0');
REPLACE INTO `pw_area` VALUES('450221','450200','450000','柳江县','450221','0');
REPLACE INTO `pw_area` VALUES('450222','450200','450000','柳城县','450222','0');
REPLACE INTO `pw_area` VALUES('450223','450200','450000','鹿寨县','450223','0');
REPLACE INTO `pw_area` VALUES('450224','450200','450000','融安县','450224','0');
REPLACE INTO `pw_area` VALUES('450225','450200','450000','融水苗族自治县','450225','0');
REPLACE INTO `pw_area` VALUES('450226','450200','450000','三江侗族自治县','450226','0');
REPLACE INTO `pw_area` VALUES('450301','450300','450000','市辖区','450301','0');
REPLACE INTO `pw_area` VALUES('450302','450300','450000','秀峰区','450302','0');
REPLACE INTO `pw_area` VALUES('450303','450300','450000','叠彩区','450303','0');
REPLACE INTO `pw_area` VALUES('450304','450300','450000','象山区','450304','0');
REPLACE INTO `pw_area` VALUES('450305','450300','450000','七星区','450305','0');
REPLACE INTO `pw_area` VALUES('450311','450300','450000','雁山区','450311','0');
REPLACE INTO `pw_area` VALUES('450312','450300','450000','临桂区','450312','0');
REPLACE INTO `pw_area` VALUES('450321','450300','450000','阳朔县','450321','0');
REPLACE INTO `pw_area` VALUES('450323','450300','450000','灵川县','450323','0');
REPLACE INTO `pw_area` VALUES('450324','450300','450000','全州县','450324','0');
REPLACE INTO `pw_area` VALUES('450325','450300','450000','兴安县','450325','0');
REPLACE INTO `pw_area` VALUES('450326','450300','450000','永福县','450326','0');
REPLACE INTO `pw_area` VALUES('450327','450300','450000','灌阳县','450327','0');
REPLACE INTO `pw_area` VALUES('450328','450300','450000','龙胜各族自治县','450328','0');
REPLACE INTO `pw_area` VALUES('450329','450300','450000','资源县','450329','0');
REPLACE INTO `pw_area` VALUES('450330','450300','450000','平乐县','450330','0');
REPLACE INTO `pw_area` VALUES('450331','450300','450000','荔浦县','450331','0');
REPLACE INTO `pw_area` VALUES('450332','450300','450000','恭城瑶族自治县','450332','0');
REPLACE INTO `pw_area` VALUES('450401','450400','450000','市辖区','450401','0');
REPLACE INTO `pw_area` VALUES('450403','450400','450000','万秀区','450403','0');
REPLACE INTO `pw_area` VALUES('450405','450400','450000','长洲区','450405','0');
REPLACE INTO `pw_area` VALUES('450406','450400','450000','龙圩区','450406','0');
REPLACE INTO `pw_area` VALUES('450421','450400','450000','苍梧县','450421','0');
REPLACE INTO `pw_area` VALUES('450422','450400','450000','藤县','450422','0');
REPLACE INTO `pw_area` VALUES('450423','450400','450000','蒙山县','450423','0');
REPLACE INTO `pw_area` VALUES('450481','450400','450000','岑溪市','450481','0');
REPLACE INTO `pw_area` VALUES('450501','450500','450000','市辖区','450501','0');
REPLACE INTO `pw_area` VALUES('450502','450500','450000','海城区','450502','0');
REPLACE INTO `pw_area` VALUES('450503','450500','450000','银海区','450503','0');
REPLACE INTO `pw_area` VALUES('450512','450500','450000','铁山港区','450512','0');
REPLACE INTO `pw_area` VALUES('450521','450500','450000','合浦县','450521','0');
REPLACE INTO `pw_area` VALUES('450601','450600','450000','市辖区','450601','0');
REPLACE INTO `pw_area` VALUES('450602','450600','450000','港口区','450602','0');
REPLACE INTO `pw_area` VALUES('450603','450600','450000','防城区','450603','0');
REPLACE INTO `pw_area` VALUES('450621','450600','450000','上思县','450621','0');
REPLACE INTO `pw_area` VALUES('450681','450600','450000','东兴市','450681','0');
REPLACE INTO `pw_area` VALUES('450701','450700','450000','市辖区','450701','0');
REPLACE INTO `pw_area` VALUES('450702','450700','450000','钦南区','450702','0');
REPLACE INTO `pw_area` VALUES('450703','450700','450000','钦北区','450703','0');
REPLACE INTO `pw_area` VALUES('450721','450700','450000','灵山县','450721','0');
REPLACE INTO `pw_area` VALUES('450722','450700','450000','浦北县','450722','0');
REPLACE INTO `pw_area` VALUES('450801','450800','450000','市辖区','450801','0');
REPLACE INTO `pw_area` VALUES('450802','450800','450000','港北区','450802','0');
REPLACE INTO `pw_area` VALUES('450803','450800','450000','港南区','450803','0');
REPLACE INTO `pw_area` VALUES('450804','450800','450000','覃塘区','450804','0');
REPLACE INTO `pw_area` VALUES('450821','450800','450000','平南县','450821','0');
REPLACE INTO `pw_area` VALUES('450881','450800','450000','桂平市','450881','0');
REPLACE INTO `pw_area` VALUES('450901','450900','450000','市辖区','450901','0');
REPLACE INTO `pw_area` VALUES('450902','450900','450000','玉州区','450902','0');
REPLACE INTO `pw_area` VALUES('450903','450900','450000','福绵区','450903','0');
REPLACE INTO `pw_area` VALUES('450921','450900','450000','容县','450921','0');
REPLACE INTO `pw_area` VALUES('450922','450900','450000','陆川县','450922','0');
REPLACE INTO `pw_area` VALUES('450923','450900','450000','博白县','450923','0');
REPLACE INTO `pw_area` VALUES('450924','450900','450000','兴业县','450924','0');
REPLACE INTO `pw_area` VALUES('450981','450900','450000','北流市','450981','0');
REPLACE INTO `pw_area` VALUES('451001','451000','450000','市辖区','451001','0');
REPLACE INTO `pw_area` VALUES('451002','451000','450000','右江区','451002','0');
REPLACE INTO `pw_area` VALUES('451021','451000','450000','田阳县','451021','0');
REPLACE INTO `pw_area` VALUES('451022','451000','450000','田东县','451022','0');
REPLACE INTO `pw_area` VALUES('451023','451000','450000','平果县','451023','0');
REPLACE INTO `pw_area` VALUES('451024','451000','450000','德保县','451024','0');
REPLACE INTO `pw_area` VALUES('451025','451000','450000','靖西县','451025','0');
REPLACE INTO `pw_area` VALUES('451026','451000','450000','那坡县','451026','0');
REPLACE INTO `pw_area` VALUES('451027','451000','450000','凌云县','451027','0');
REPLACE INTO `pw_area` VALUES('451028','451000','450000','乐业县','451028','0');
REPLACE INTO `pw_area` VALUES('451029','451000','450000','田林县','451029','0');
REPLACE INTO `pw_area` VALUES('451030','451000','450000','西林县','451030','0');
REPLACE INTO `pw_area` VALUES('451031','451000','450000','隆林各族自治县','451031','0');
REPLACE INTO `pw_area` VALUES('451101','451100','450000','市辖区','451101','0');
REPLACE INTO `pw_area` VALUES('451102','451100','450000','八步区','451102','0');
REPLACE INTO `pw_area` VALUES('451121','451100','450000','昭平县','451121','0');
REPLACE INTO `pw_area` VALUES('451122','451100','450000','钟山县','451122','0');
REPLACE INTO `pw_area` VALUES('451123','451100','450000','富川瑶族自治县','451123','0');
REPLACE INTO `pw_area` VALUES('451201','451200','450000','市辖区','451201','0');
REPLACE INTO `pw_area` VALUES('451202','451200','450000','金城江区','451202','0');
REPLACE INTO `pw_area` VALUES('451221','451200','450000','南丹县','451221','0');
REPLACE INTO `pw_area` VALUES('451222','451200','450000','天峨县','451222','0');
REPLACE INTO `pw_area` VALUES('451223','451200','450000','凤山县','451223','0');
REPLACE INTO `pw_area` VALUES('451224','451200','450000','东兰县','451224','0');
REPLACE INTO `pw_area` VALUES('451225','451200','450000','罗城仫佬族自治县','451225','0');
REPLACE INTO `pw_area` VALUES('451226','451200','450000','环江毛南族自治县','451226','0');
REPLACE INTO `pw_area` VALUES('451227','451200','450000','巴马瑶族自治县','451227','0');
REPLACE INTO `pw_area` VALUES('451228','451200','450000','都安瑶族自治县','451228','0');
REPLACE INTO `pw_area` VALUES('451229','451200','450000','大化瑶族自治县','451229','0');
REPLACE INTO `pw_area` VALUES('451281','451200','450000','宜州市','451281','0');
REPLACE INTO `pw_area` VALUES('451301','451300','450000','市辖区','451301','0');
REPLACE INTO `pw_area` VALUES('451302','451300','450000','兴宾区','451302','0');
REPLACE INTO `pw_area` VALUES('451321','451300','450000','忻城县','451321','0');
REPLACE INTO `pw_area` VALUES('451322','451300','450000','象州县','451322','0');
REPLACE INTO `pw_area` VALUES('451323','451300','450000','武宣县','451323','0');
REPLACE INTO `pw_area` VALUES('451324','451300','450000','金秀瑶族自治县','451324','0');
REPLACE INTO `pw_area` VALUES('451381','451300','450000','合山市','451381','0');
REPLACE INTO `pw_area` VALUES('451401','451400','450000','市辖区','451401','0');
REPLACE INTO `pw_area` VALUES('451402','451400','450000','江州区','451402','0');
REPLACE INTO `pw_area` VALUES('451421','451400','450000','扶绥县','451421','0');
REPLACE INTO `pw_area` VALUES('451422','451400','450000','宁明县','451422','0');
REPLACE INTO `pw_area` VALUES('451423','451400','450000','龙州县','451423','0');
REPLACE INTO `pw_area` VALUES('451424','451400','450000','大新县','451424','0');
REPLACE INTO `pw_area` VALUES('451425','451400','450000','天等县','451425','0');
REPLACE INTO `pw_area` VALUES('451481','451400','450000','凭祥市','451481','0');
REPLACE INTO `pw_area` VALUES('460101','460100','460000','市辖区','460101','0');
REPLACE INTO `pw_area` VALUES('460105','460100','460000','秀英区','460105','0');
REPLACE INTO `pw_area` VALUES('460106','460100','460000','龙华区','460106','0');
REPLACE INTO `pw_area` VALUES('460107','460100','460000','琼山区','460107','0');
REPLACE INTO `pw_area` VALUES('460108','460100','460000','美兰区','460108','0');
REPLACE INTO `pw_area` VALUES('460201','460200','460000','市辖区','460201','0');
REPLACE INTO `pw_area` VALUES('460321','460300','460000','西沙群岛','460321','0');
REPLACE INTO `pw_area` VALUES('460322','460300','460000','南沙群岛','460322','0');
REPLACE INTO `pw_area` VALUES('460323','460300','460000','中沙群岛的岛礁及其海域','460323','0');
REPLACE INTO `pw_area` VALUES('469001','469000','460000','五指山市','469001','0');
REPLACE INTO `pw_area` VALUES('469002','469000','460000','琼海市','469002','0');
REPLACE INTO `pw_area` VALUES('469003','469000','460000','儋州市','469003','0');
REPLACE INTO `pw_area` VALUES('469005','469000','460000','文昌市','469005','0');
REPLACE INTO `pw_area` VALUES('469006','469000','460000','万宁市','469006','0');
REPLACE INTO `pw_area` VALUES('469007','469000','460000','东方市','469007','0');
REPLACE INTO `pw_area` VALUES('469021','469000','460000','定安县','469021','0');
REPLACE INTO `pw_area` VALUES('469022','469000','460000','屯昌县','469022','0');
REPLACE INTO `pw_area` VALUES('469023','469000','460000','澄迈县','469023','0');
REPLACE INTO `pw_area` VALUES('469024','469000','460000','临高县','469024','0');
REPLACE INTO `pw_area` VALUES('469025','469000','460000','白沙黎族自治县','469025','0');
REPLACE INTO `pw_area` VALUES('469026','469000','460000','昌江黎族自治县','469026','0');
REPLACE INTO `pw_area` VALUES('469027','469000','460000','乐东黎族自治县','469027','0');
REPLACE INTO `pw_area` VALUES('469028','469000','460000','陵水黎族自治县','469028','0');
REPLACE INTO `pw_area` VALUES('469029','469000','460000','保亭黎族苗族自治县','469029','0');
REPLACE INTO `pw_area` VALUES('469030','469000','460000','琼中黎族苗族自治县','469030','0');
REPLACE INTO `pw_area` VALUES('500101','500100','500000','万州区','500101','0');
REPLACE INTO `pw_area` VALUES('500102','500100','500000','涪陵区','500102','0');
REPLACE INTO `pw_area` VALUES('500103','500100','500000','渝中区','500103','0');
REPLACE INTO `pw_area` VALUES('500104','500100','500000','大渡口区','500104','0');
REPLACE INTO `pw_area` VALUES('500105','500100','500000','江北区','500105','0');
REPLACE INTO `pw_area` VALUES('500106','500100','500000','沙坪坝区','500106','0');
REPLACE INTO `pw_area` VALUES('500107','500100','500000','九龙坡区','500107','0');
REPLACE INTO `pw_area` VALUES('500108','500100','500000','南岸区','500108','0');
REPLACE INTO `pw_area` VALUES('500109','500100','500000','北碚区','500109','0');
REPLACE INTO `pw_area` VALUES('500110','500100','500000','綦江区','500110','0');
REPLACE INTO `pw_area` VALUES('500111','500100','500000','大足区','500111','0');
REPLACE INTO `pw_area` VALUES('500112','500100','500000','渝北区','500112','0');
REPLACE INTO `pw_area` VALUES('500113','500100','500000','巴南区','500113','0');
REPLACE INTO `pw_area` VALUES('500114','500100','500000','黔江区','500114','0');
REPLACE INTO `pw_area` VALUES('500115','500100','500000','长寿区','500115','0');
REPLACE INTO `pw_area` VALUES('500116','500100','500000','江津区','500116','0');
REPLACE INTO `pw_area` VALUES('500117','500100','500000','合川区','500117','0');
REPLACE INTO `pw_area` VALUES('500118','500100','500000','永川区','500118','0');
REPLACE INTO `pw_area` VALUES('500119','500100','500000','南川区','500119','0');
REPLACE INTO `pw_area` VALUES('500223','500200','500000','潼南县','500223','0');
REPLACE INTO `pw_area` VALUES('500224','500200','500000','铜梁县','500224','0');
REPLACE INTO `pw_area` VALUES('500226','500200','500000','荣昌县','500226','0');
REPLACE INTO `pw_area` VALUES('500227','500200','500000','璧山县','500227','0');
REPLACE INTO `pw_area` VALUES('500228','500200','500000','梁平县','500228','0');
REPLACE INTO `pw_area` VALUES('500229','500200','500000','城口县','500229','0');
REPLACE INTO `pw_area` VALUES('500230','500200','500000','丰都县','500230','0');
REPLACE INTO `pw_area` VALUES('500231','500200','500000','垫江县','500231','0');
REPLACE INTO `pw_area` VALUES('500232','500200','500000','武隆县','500232','0');
REPLACE INTO `pw_area` VALUES('500233','500200','500000','忠县','500233','0');
REPLACE INTO `pw_area` VALUES('500234','500200','500000','开县','500234','0');
REPLACE INTO `pw_area` VALUES('500235','500200','500000','云阳县','500235','0');
REPLACE INTO `pw_area` VALUES('500236','500200','500000','奉节县','500236','0');
REPLACE INTO `pw_area` VALUES('500237','500200','500000','巫山县','500237','0');
REPLACE INTO `pw_area` VALUES('500238','500200','500000','巫溪县','500238','0');
REPLACE INTO `pw_area` VALUES('500240','500200','500000','石柱土家族自治县','500240','0');
REPLACE INTO `pw_area` VALUES('500241','500200','500000','秀山土家族苗族自治县','500241','0');
REPLACE INTO `pw_area` VALUES('500242','500200','500000','酉阳土家族苗族自治县','500242','0');
REPLACE INTO `pw_area` VALUES('500243','500200','500000','彭水苗族土家族自治县','500243','0');
REPLACE INTO `pw_area` VALUES('510101','510100','510000','市辖区','510101','0');
REPLACE INTO `pw_area` VALUES('510104','510100','510000','锦江区','510104','0');
REPLACE INTO `pw_area` VALUES('510105','510100','510000','青羊区','510105','0');
REPLACE INTO `pw_area` VALUES('510106','510100','510000','金牛区','510106','0');
REPLACE INTO `pw_area` VALUES('510107','510100','510000','武侯区','510107','0');
REPLACE INTO `pw_area` VALUES('510108','510100','510000','成华区','510108','0');
REPLACE INTO `pw_area` VALUES('510112','510100','510000','龙泉驿区','510112','0');
REPLACE INTO `pw_area` VALUES('510113','510100','510000','青白江区','510113','0');
REPLACE INTO `pw_area` VALUES('510114','510100','510000','新都区','510114','0');
REPLACE INTO `pw_area` VALUES('510115','510100','510000','温江区','510115','0');
REPLACE INTO `pw_area` VALUES('510121','510100','510000','金堂县','510121','0');
REPLACE INTO `pw_area` VALUES('510122','510100','510000','双流县','510122','0');
REPLACE INTO `pw_area` VALUES('510124','510100','510000','郫县','510124','0');
REPLACE INTO `pw_area` VALUES('510129','510100','510000','大邑县','510129','0');
REPLACE INTO `pw_area` VALUES('510131','510100','510000','蒲江县','510131','0');
REPLACE INTO `pw_area` VALUES('510132','510100','510000','新津县','510132','0');
REPLACE INTO `pw_area` VALUES('510181','510100','510000','都江堰市','510181','0');
REPLACE INTO `pw_area` VALUES('510182','510100','510000','彭州市','510182','0');
REPLACE INTO `pw_area` VALUES('510183','510100','510000','邛崃市','510183','0');
REPLACE INTO `pw_area` VALUES('510184','510100','510000','崇州市','510184','0');
REPLACE INTO `pw_area` VALUES('510301','510300','510000','市辖区','510301','0');
REPLACE INTO `pw_area` VALUES('510302','510300','510000','自流井区','510302','0');
REPLACE INTO `pw_area` VALUES('510303','510300','510000','贡井区','510303','0');
REPLACE INTO `pw_area` VALUES('510304','510300','510000','大安区','510304','0');
REPLACE INTO `pw_area` VALUES('510311','510300','510000','沿滩区','510311','0');
REPLACE INTO `pw_area` VALUES('510321','510300','510000','荣县','510321','0');
REPLACE INTO `pw_area` VALUES('510322','510300','510000','富顺县','510322','0');
REPLACE INTO `pw_area` VALUES('510401','510400','510000','市辖区','510401','0');
REPLACE INTO `pw_area` VALUES('510402','510400','510000','东区','510402','0');
REPLACE INTO `pw_area` VALUES('510403','510400','510000','西区','510403','0');
REPLACE INTO `pw_area` VALUES('510411','510400','510000','仁和区','510411','0');
REPLACE INTO `pw_area` VALUES('510421','510400','510000','米易县','510421','0');
REPLACE INTO `pw_area` VALUES('510422','510400','510000','盐边县','510422','0');
REPLACE INTO `pw_area` VALUES('510501','510500','510000','市辖区','510501','0');
REPLACE INTO `pw_area` VALUES('510502','510500','510000','江阳区','510502','0');
REPLACE INTO `pw_area` VALUES('510503','510500','510000','纳溪区','510503','0');
REPLACE INTO `pw_area` VALUES('510504','510500','510000','龙马潭区','510504','0');
REPLACE INTO `pw_area` VALUES('510521','510500','510000','泸县','510521','0');
REPLACE INTO `pw_area` VALUES('510522','510500','510000','合江县','510522','0');
REPLACE INTO `pw_area` VALUES('510524','510500','510000','叙永县','510524','0');
REPLACE INTO `pw_area` VALUES('510525','510500','510000','古蔺县','510525','0');
REPLACE INTO `pw_area` VALUES('510601','510600','510000','市辖区','510601','0');
REPLACE INTO `pw_area` VALUES('510603','510600','510000','旌阳区','510603','0');
REPLACE INTO `pw_area` VALUES('510623','510600','510000','中江县','510623','0');
REPLACE INTO `pw_area` VALUES('510626','510600','510000','罗江县','510626','0');
REPLACE INTO `pw_area` VALUES('510681','510600','510000','广汉市','510681','0');
REPLACE INTO `pw_area` VALUES('510682','510600','510000','什邡市','510682','0');
REPLACE INTO `pw_area` VALUES('510683','510600','510000','绵竹市','510683','0');
REPLACE INTO `pw_area` VALUES('510701','510700','510000','市辖区','510701','0');
REPLACE INTO `pw_area` VALUES('510703','510700','510000','涪城区','510703','0');
REPLACE INTO `pw_area` VALUES('510704','510700','510000','游仙区','510704','0');
REPLACE INTO `pw_area` VALUES('510722','510700','510000','三台县','510722','0');
REPLACE INTO `pw_area` VALUES('510723','510700','510000','盐亭县','510723','0');
REPLACE INTO `pw_area` VALUES('510724','510700','510000','安县','510724','0');
REPLACE INTO `pw_area` VALUES('510725','510700','510000','梓潼县','510725','0');
REPLACE INTO `pw_area` VALUES('510726','510700','510000','北川羌族自治县','510726','0');
REPLACE INTO `pw_area` VALUES('510727','510700','510000','平武县','510727','0');
REPLACE INTO `pw_area` VALUES('510781','510700','510000','江油市','510781','0');
REPLACE INTO `pw_area` VALUES('510801','510800','510000','市辖区','510801','0');
REPLACE INTO `pw_area` VALUES('510802','510800','510000','利州区','510802','0');
REPLACE INTO `pw_area` VALUES('510811','510800','510000','元坝区','510811','0');
REPLACE INTO `pw_area` VALUES('510812','510800','510000','朝天区','510812','0');
REPLACE INTO `pw_area` VALUES('510821','510800','510000','旺苍县','510821','0');
REPLACE INTO `pw_area` VALUES('510822','510800','510000','青川县','510822','0');
REPLACE INTO `pw_area` VALUES('510823','510800','510000','剑阁县','510823','0');
REPLACE INTO `pw_area` VALUES('510824','510800','510000','苍溪县','510824','0');
REPLACE INTO `pw_area` VALUES('510901','510900','510000','市辖区','510901','0');
REPLACE INTO `pw_area` VALUES('510903','510900','510000','船山区','510903','0');
REPLACE INTO `pw_area` VALUES('510904','510900','510000','安居区','510904','0');
REPLACE INTO `pw_area` VALUES('510921','510900','510000','蓬溪县','510921','0');
REPLACE INTO `pw_area` VALUES('510922','510900','510000','射洪县','510922','0');
REPLACE INTO `pw_area` VALUES('510923','510900','510000','大英县','510923','0');
REPLACE INTO `pw_area` VALUES('511001','511000','510000','市辖区','511001','0');
REPLACE INTO `pw_area` VALUES('511002','511000','510000','市中区','511002','0');
REPLACE INTO `pw_area` VALUES('511011','511000','510000','东兴区','511011','0');
REPLACE INTO `pw_area` VALUES('511024','511000','510000','威远县','511024','0');
REPLACE INTO `pw_area` VALUES('511025','511000','510000','资中县','511025','0');
REPLACE INTO `pw_area` VALUES('511028','511000','510000','隆昌县','511028','0');
REPLACE INTO `pw_area` VALUES('511101','511100','510000','市辖区','511101','0');
REPLACE INTO `pw_area` VALUES('511102','511100','510000','市中区','511102','0');
REPLACE INTO `pw_area` VALUES('511111','511100','510000','沙湾区','511111','0');
REPLACE INTO `pw_area` VALUES('511112','511100','510000','五通桥区','511112','0');
REPLACE INTO `pw_area` VALUES('511113','511100','510000','金口河区','511113','0');
REPLACE INTO `pw_area` VALUES('511123','511100','510000','犍为县','511123','0');
REPLACE INTO `pw_area` VALUES('511124','511100','510000','井研县','511124','0');
REPLACE INTO `pw_area` VALUES('511126','511100','510000','夹江县','511126','0');
REPLACE INTO `pw_area` VALUES('511129','511100','510000','沐川县','511129','0');
REPLACE INTO `pw_area` VALUES('511132','511100','510000','峨边彝族自治县','511132','0');
REPLACE INTO `pw_area` VALUES('511133','511100','510000','马边彝族自治县','511133','0');
REPLACE INTO `pw_area` VALUES('511181','511100','510000','峨眉山市','511181','0');
REPLACE INTO `pw_area` VALUES('511301','511300','510000','市辖区','511301','0');
REPLACE INTO `pw_area` VALUES('511302','511300','510000','顺庆区','511302','0');
REPLACE INTO `pw_area` VALUES('511303','511300','510000','高坪区','511303','0');
REPLACE INTO `pw_area` VALUES('511304','511300','510000','嘉陵区','511304','0');
REPLACE INTO `pw_area` VALUES('511321','511300','510000','南部县','511321','0');
REPLACE INTO `pw_area` VALUES('511322','511300','510000','营山县','511322','0');
REPLACE INTO `pw_area` VALUES('511323','511300','510000','蓬安县','511323','0');
REPLACE INTO `pw_area` VALUES('511324','511300','510000','仪陇县','511324','0');
REPLACE INTO `pw_area` VALUES('511325','511300','510000','西充县','511325','0');
REPLACE INTO `pw_area` VALUES('511381','511300','510000','阆中市','511381','0');
REPLACE INTO `pw_area` VALUES('511401','511400','510000','市辖区','511401','0');
REPLACE INTO `pw_area` VALUES('511402','511400','510000','东坡区','511402','0');
REPLACE INTO `pw_area` VALUES('511421','511400','510000','仁寿县','511421','0');
REPLACE INTO `pw_area` VALUES('511422','511400','510000','彭山县','511422','0');
REPLACE INTO `pw_area` VALUES('511423','511400','510000','洪雅县','511423','0');
REPLACE INTO `pw_area` VALUES('511424','511400','510000','丹棱县','511424','0');
REPLACE INTO `pw_area` VALUES('511425','511400','510000','青神县','511425','0');
REPLACE INTO `pw_area` VALUES('511501','511500','510000','市辖区','511501','0');
REPLACE INTO `pw_area` VALUES('511502','511500','510000','翠屏区','511502','0');
REPLACE INTO `pw_area` VALUES('511503','511500','510000','南溪区','511503','0');
REPLACE INTO `pw_area` VALUES('511521','511500','510000','宜宾县','511521','0');
REPLACE INTO `pw_area` VALUES('511523','511500','510000','江安县','511523','0');
REPLACE INTO `pw_area` VALUES('511524','511500','510000','长宁县','511524','0');
REPLACE INTO `pw_area` VALUES('511525','511500','510000','高县','511525','0');
REPLACE INTO `pw_area` VALUES('511526','511500','510000','珙县','511526','0');
REPLACE INTO `pw_area` VALUES('511527','511500','510000','筠连县','511527','0');
REPLACE INTO `pw_area` VALUES('511528','511500','510000','兴文县','511528','0');
REPLACE INTO `pw_area` VALUES('511529','511500','510000','屏山县','511529','0');
REPLACE INTO `pw_area` VALUES('511601','511600','510000','市辖区','511601','0');
REPLACE INTO `pw_area` VALUES('511602','511600','510000','广安区','511602','0');
REPLACE INTO `pw_area` VALUES('511603','511600','510000','前锋区','511603','0');
REPLACE INTO `pw_area` VALUES('511621','511600','510000','岳池县','511621','0');
REPLACE INTO `pw_area` VALUES('511622','511600','510000','武胜县','511622','0');
REPLACE INTO `pw_area` VALUES('511623','511600','510000','邻水县','511623','0');
REPLACE INTO `pw_area` VALUES('511681','511600','510000','华蓥市','511681','0');
REPLACE INTO `pw_area` VALUES('511701','511700','510000','市辖区','511701','0');
REPLACE INTO `pw_area` VALUES('511702','511700','510000','通川区','511702','0');
REPLACE INTO `pw_area` VALUES('511703','511700','510000','达川区','511703','0');
REPLACE INTO `pw_area` VALUES('511722','511700','510000','宣汉县','511722','0');
REPLACE INTO `pw_area` VALUES('511723','511700','510000','开江县','511723','0');
REPLACE INTO `pw_area` VALUES('511724','511700','510000','大竹县','511724','0');
REPLACE INTO `pw_area` VALUES('511725','511700','510000','渠县','511725','0');
REPLACE INTO `pw_area` VALUES('511781','511700','510000','万源市','511781','0');
REPLACE INTO `pw_area` VALUES('511801','511800','510000','市辖区','511801','0');
REPLACE INTO `pw_area` VALUES('511802','511800','510000','雨城区','511802','0');
REPLACE INTO `pw_area` VALUES('511803','511800','510000','名山区','511803','0');
REPLACE INTO `pw_area` VALUES('511822','511800','510000','荥经县','511822','0');
REPLACE INTO `pw_area` VALUES('511823','511800','510000','汉源县','511823','0');
REPLACE INTO `pw_area` VALUES('511824','511800','510000','石棉县','511824','0');
REPLACE INTO `pw_area` VALUES('511825','511800','510000','天全县','511825','0');
REPLACE INTO `pw_area` VALUES('511826','511800','510000','芦山县','511826','0');
REPLACE INTO `pw_area` VALUES('511827','511800','510000','宝兴县','511827','0');
REPLACE INTO `pw_area` VALUES('511901','511900','510000','市辖区','511901','0');
REPLACE INTO `pw_area` VALUES('511902','511900','510000','巴州区','511902','0');
REPLACE INTO `pw_area` VALUES('511903','511900','510000','恩阳区','511903','0');
REPLACE INTO `pw_area` VALUES('511921','511900','510000','通江县','511921','0');
REPLACE INTO `pw_area` VALUES('511922','511900','510000','南江县','511922','0');
REPLACE INTO `pw_area` VALUES('511923','511900','510000','平昌县','511923','0');
REPLACE INTO `pw_area` VALUES('512001','512000','510000','市辖区','512001','0');
REPLACE INTO `pw_area` VALUES('512002','512000','510000','雁江区','512002','0');
REPLACE INTO `pw_area` VALUES('512021','512000','510000','安岳县','512021','0');
REPLACE INTO `pw_area` VALUES('512022','512000','510000','乐至县','512022','0');
REPLACE INTO `pw_area` VALUES('512081','512000','510000','简阳市','512081','0');
REPLACE INTO `pw_area` VALUES('513221','513200','510000','汶川县','513221','0');
REPLACE INTO `pw_area` VALUES('513222','513200','510000','理县','513222','0');
REPLACE INTO `pw_area` VALUES('513223','513200','510000','茂县','513223','0');
REPLACE INTO `pw_area` VALUES('513224','513200','510000','松潘县','513224','0');
REPLACE INTO `pw_area` VALUES('513225','513200','510000','九寨沟县','513225','0');
REPLACE INTO `pw_area` VALUES('513226','513200','510000','金川县','513226','0');
REPLACE INTO `pw_area` VALUES('513227','513200','510000','小金县','513227','0');
REPLACE INTO `pw_area` VALUES('513228','513200','510000','黑水县','513228','0');
REPLACE INTO `pw_area` VALUES('513229','513200','510000','马尔康县','513229','0');
REPLACE INTO `pw_area` VALUES('513230','513200','510000','壤塘县','513230','0');
REPLACE INTO `pw_area` VALUES('513231','513200','510000','阿坝县','513231','0');
REPLACE INTO `pw_area` VALUES('513232','513200','510000','若尔盖县','513232','0');
REPLACE INTO `pw_area` VALUES('513233','513200','510000','红原县','513233','0');
REPLACE INTO `pw_area` VALUES('513321','513300','510000','康定县','513321','0');
REPLACE INTO `pw_area` VALUES('513322','513300','510000','泸定县','513322','0');
REPLACE INTO `pw_area` VALUES('513323','513300','510000','丹巴县','513323','0');
REPLACE INTO `pw_area` VALUES('513324','513300','510000','九龙县','513324','0');
REPLACE INTO `pw_area` VALUES('513325','513300','510000','雅江县','513325','0');
REPLACE INTO `pw_area` VALUES('513326','513300','510000','道孚县','513326','0');
REPLACE INTO `pw_area` VALUES('513327','513300','510000','炉霍县','513327','0');
REPLACE INTO `pw_area` VALUES('513328','513300','510000','甘孜县','513328','0');
REPLACE INTO `pw_area` VALUES('513329','513300','510000','新龙县','513329','0');
REPLACE INTO `pw_area` VALUES('513330','513300','510000','德格县','513330','0');
REPLACE INTO `pw_area` VALUES('513331','513300','510000','白玉县','513331','0');
REPLACE INTO `pw_area` VALUES('513332','513300','510000','石渠县','513332','0');
REPLACE INTO `pw_area` VALUES('513333','513300','510000','色达县','513333','0');
REPLACE INTO `pw_area` VALUES('513334','513300','510000','理塘县','513334','0');
REPLACE INTO `pw_area` VALUES('513335','513300','510000','巴塘县','513335','0');
REPLACE INTO `pw_area` VALUES('513336','513300','510000','乡城县','513336','0');
REPLACE INTO `pw_area` VALUES('513337','513300','510000','稻城县','513337','0');
REPLACE INTO `pw_area` VALUES('513338','513300','510000','得荣县','513338','0');
REPLACE INTO `pw_area` VALUES('513401','513400','510000','西昌市','513401','0');
REPLACE INTO `pw_area` VALUES('513422','513400','510000','木里藏族自治县','513422','0');
REPLACE INTO `pw_area` VALUES('513423','513400','510000','盐源县','513423','0');
REPLACE INTO `pw_area` VALUES('513424','513400','510000','德昌县','513424','0');
REPLACE INTO `pw_area` VALUES('513425','513400','510000','会理县','513425','0');
REPLACE INTO `pw_area` VALUES('513426','513400','510000','会东县','513426','0');
REPLACE INTO `pw_area` VALUES('513427','513400','510000','宁南县','513427','0');
REPLACE INTO `pw_area` VALUES('513428','513400','510000','普格县','513428','0');
REPLACE INTO `pw_area` VALUES('513429','513400','510000','布拖县','513429','0');
REPLACE INTO `pw_area` VALUES('513430','513400','510000','金阳县','513430','0');
REPLACE INTO `pw_area` VALUES('513431','513400','510000','昭觉县','513431','0');
REPLACE INTO `pw_area` VALUES('513432','513400','510000','喜德县','513432','0');
REPLACE INTO `pw_area` VALUES('513433','513400','510000','冕宁县','513433','0');
REPLACE INTO `pw_area` VALUES('513434','513400','510000','越西县','513434','0');
REPLACE INTO `pw_area` VALUES('513435','513400','510000','甘洛县','513435','0');
REPLACE INTO `pw_area` VALUES('513436','513400','510000','美姑县','513436','0');
REPLACE INTO `pw_area` VALUES('513437','513400','510000','雷波县','513437','0');
REPLACE INTO `pw_area` VALUES('520101','520100','520000','市辖区','520101','0');
REPLACE INTO `pw_area` VALUES('520102','520100','520000','南明区','520102','0');
REPLACE INTO `pw_area` VALUES('520103','520100','520000','云岩区','520103','0');
REPLACE INTO `pw_area` VALUES('520111','520100','520000','花溪区','520111','0');
REPLACE INTO `pw_area` VALUES('520112','520100','520000','乌当区','520112','0');
REPLACE INTO `pw_area` VALUES('520113','520100','520000','白云区','520113','0');
REPLACE INTO `pw_area` VALUES('520115','520100','520000','观山湖区','520115','0');
REPLACE INTO `pw_area` VALUES('520121','520100','520000','开阳县','520121','0');
REPLACE INTO `pw_area` VALUES('520122','520100','520000','息烽县','520122','0');
REPLACE INTO `pw_area` VALUES('520123','520100','520000','修文县','520123','0');
REPLACE INTO `pw_area` VALUES('520181','520100','520000','清镇市','520181','0');
REPLACE INTO `pw_area` VALUES('520201','520200','520000','钟山区','520201','0');
REPLACE INTO `pw_area` VALUES('520203','520200','520000','六枝特区','520203','0');
REPLACE INTO `pw_area` VALUES('520221','520200','520000','水城县','520221','0');
REPLACE INTO `pw_area` VALUES('520222','520200','520000','盘县','520222','0');
REPLACE INTO `pw_area` VALUES('520301','520300','520000','市辖区','520301','0');
REPLACE INTO `pw_area` VALUES('520302','520300','520000','红花岗区','520302','0');
REPLACE INTO `pw_area` VALUES('520303','520300','520000','汇川区','520303','0');
REPLACE INTO `pw_area` VALUES('520321','520300','520000','遵义县','520321','0');
REPLACE INTO `pw_area` VALUES('520322','520300','520000','桐梓县','520322','0');
REPLACE INTO `pw_area` VALUES('520323','520300','520000','绥阳县','520323','0');
REPLACE INTO `pw_area` VALUES('520324','520300','520000','正安县','520324','0');
REPLACE INTO `pw_area` VALUES('520325','520300','520000','道真仡佬族苗族自治县','520325','0');
REPLACE INTO `pw_area` VALUES('520326','520300','520000','务川仡佬族苗族自治县','520326','0');
REPLACE INTO `pw_area` VALUES('520327','520300','520000','凤冈县','520327','0');
REPLACE INTO `pw_area` VALUES('520328','520300','520000','湄潭县','520328','0');
REPLACE INTO `pw_area` VALUES('520329','520300','520000','余庆县','520329','0');
REPLACE INTO `pw_area` VALUES('520330','520300','520000','习水县','520330','0');
REPLACE INTO `pw_area` VALUES('520381','520300','520000','赤水市','520381','0');
REPLACE INTO `pw_area` VALUES('520382','520300','520000','仁怀市','520382','0');
REPLACE INTO `pw_area` VALUES('520401','520400','520000','市辖区','520401','0');
REPLACE INTO `pw_area` VALUES('520402','520400','520000','西秀区','520402','0');
REPLACE INTO `pw_area` VALUES('520421','520400','520000','平坝县','520421','0');
REPLACE INTO `pw_area` VALUES('520422','520400','520000','普定县','520422','0');
REPLACE INTO `pw_area` VALUES('520423','520400','520000','镇宁布依族苗族自治县','520423','0');
REPLACE INTO `pw_area` VALUES('520424','520400','520000','关岭布依族苗族自治县','520424','0');
REPLACE INTO `pw_area` VALUES('520425','520400','520000','紫云苗族布依族自治县','520425','0');
REPLACE INTO `pw_area` VALUES('520501','520500','520000','市辖区','520501','0');
REPLACE INTO `pw_area` VALUES('520502','520500','520000','七星关区','520502','0');
REPLACE INTO `pw_area` VALUES('520521','520500','520000','大方县','520521','0');
REPLACE INTO `pw_area` VALUES('520522','520500','520000','黔西县','520522','0');
REPLACE INTO `pw_area` VALUES('520523','520500','520000','金沙县','520523','0');
REPLACE INTO `pw_area` VALUES('520524','520500','520000','织金县','520524','0');
REPLACE INTO `pw_area` VALUES('520525','520500','520000','纳雍县','520525','0');
REPLACE INTO `pw_area` VALUES('520526','520500','520000','威宁彝族回族苗族自治县','520526','0');
REPLACE INTO `pw_area` VALUES('520527','520500','520000','赫章县','520527','0');
REPLACE INTO `pw_area` VALUES('520601','520600','520000','市辖区','520601','0');
REPLACE INTO `pw_area` VALUES('520602','520600','520000','碧江区','520602','0');
REPLACE INTO `pw_area` VALUES('520603','520600','520000','万山区','520603','0');
REPLACE INTO `pw_area` VALUES('520621','520600','520000','江口县','520621','0');
REPLACE INTO `pw_area` VALUES('520622','520600','520000','玉屏侗族自治县','520622','0');
REPLACE INTO `pw_area` VALUES('520623','520600','520000','石阡县','520623','0');
REPLACE INTO `pw_area` VALUES('520624','520600','520000','思南县','520624','0');
REPLACE INTO `pw_area` VALUES('520625','520600','520000','印江土家族苗族自治县','520625','0');
REPLACE INTO `pw_area` VALUES('520626','520600','520000','德江县','520626','0');
REPLACE INTO `pw_area` VALUES('520627','520600','520000','沿河土家族自治县','520627','0');
REPLACE INTO `pw_area` VALUES('520628','520600','520000','松桃苗族自治县','520628','0');
REPLACE INTO `pw_area` VALUES('522301','522300','520000','兴义市','522301','0');
REPLACE INTO `pw_area` VALUES('522322','522300','520000','兴仁县','522322','0');
REPLACE INTO `pw_area` VALUES('522323','522300','520000','普安县','522323','0');
REPLACE INTO `pw_area` VALUES('522324','522300','520000','晴隆县','522324','0');
REPLACE INTO `pw_area` VALUES('522325','522300','520000','贞丰县','522325','0');
REPLACE INTO `pw_area` VALUES('522326','522300','520000','望谟县','522326','0');
REPLACE INTO `pw_area` VALUES('522327','522300','520000','册亨县','522327','0');
REPLACE INTO `pw_area` VALUES('522328','522300','520000','安龙县','522328','0');
REPLACE INTO `pw_area` VALUES('522601','522600','520000','凯里市','522601','0');
REPLACE INTO `pw_area` VALUES('522622','522600','520000','黄平县','522622','0');
REPLACE INTO `pw_area` VALUES('522623','522600','520000','施秉县','522623','0');
REPLACE INTO `pw_area` VALUES('522624','522600','520000','三穗县','522624','0');
REPLACE INTO `pw_area` VALUES('522625','522600','520000','镇远县','522625','0');
REPLACE INTO `pw_area` VALUES('522626','522600','520000','岑巩县','522626','0');
REPLACE INTO `pw_area` VALUES('522627','522600','520000','天柱县','522627','0');
REPLACE INTO `pw_area` VALUES('522628','522600','520000','锦屏县','522628','0');
REPLACE INTO `pw_area` VALUES('522629','522600','520000','剑河县','522629','0');
REPLACE INTO `pw_area` VALUES('522630','522600','520000','台江县','522630','0');
REPLACE INTO `pw_area` VALUES('522631','522600','520000','黎平县','522631','0');
REPLACE INTO `pw_area` VALUES('522632','522600','520000','榕江县','522632','0');
REPLACE INTO `pw_area` VALUES('522633','522600','520000','从江县','522633','0');
REPLACE INTO `pw_area` VALUES('522634','522600','520000','雷山县','522634','0');
REPLACE INTO `pw_area` VALUES('522635','522600','520000','麻江县','522635','0');
REPLACE INTO `pw_area` VALUES('522636','522600','520000','丹寨县','522636','0');
REPLACE INTO `pw_area` VALUES('522701','522700','520000','都匀市','522701','0');
REPLACE INTO `pw_area` VALUES('522702','522700','520000','福泉市','522702','0');
REPLACE INTO `pw_area` VALUES('522722','522700','520000','荔波县','522722','0');
REPLACE INTO `pw_area` VALUES('522723','522700','520000','贵定县','522723','0');
REPLACE INTO `pw_area` VALUES('522725','522700','520000','瓮安县','522725','0');
REPLACE INTO `pw_area` VALUES('522726','522700','520000','独山县','522726','0');
REPLACE INTO `pw_area` VALUES('522727','522700','520000','平塘县','522727','0');
REPLACE INTO `pw_area` VALUES('522728','522700','520000','罗甸县','522728','0');
REPLACE INTO `pw_area` VALUES('522729','522700','520000','长顺县','522729','0');
REPLACE INTO `pw_area` VALUES('522730','522700','520000','龙里县','522730','0');
REPLACE INTO `pw_area` VALUES('522731','522700','520000','惠水县','522731','0');
REPLACE INTO `pw_area` VALUES('522732','522700','520000','三都水族自治县','522732','0');
REPLACE INTO `pw_area` VALUES('530101','530100','530000','市辖区','530101','0');
REPLACE INTO `pw_area` VALUES('530102','530100','530000','五华区','530102','0');
REPLACE INTO `pw_area` VALUES('530103','530100','530000','盘龙区','530103','0');
REPLACE INTO `pw_area` VALUES('530111','530100','530000','官渡区','530111','0');
REPLACE INTO `pw_area` VALUES('530112','530100','530000','西山区','530112','0');
REPLACE INTO `pw_area` VALUES('530113','530100','530000','东川区','530113','0');
REPLACE INTO `pw_area` VALUES('530114','530100','530000','呈贡区','530114','0');
REPLACE INTO `pw_area` VALUES('530122','530100','530000','晋宁县','530122','0');
REPLACE INTO `pw_area` VALUES('530124','530100','530000','富民县','530124','0');
REPLACE INTO `pw_area` VALUES('530125','530100','530000','宜良县','530125','0');
REPLACE INTO `pw_area` VALUES('530126','530100','530000','石林彝族自治县','530126','0');
REPLACE INTO `pw_area` VALUES('530127','530100','530000','嵩明县','530127','0');
REPLACE INTO `pw_area` VALUES('530128','530100','530000','禄劝彝族苗族自治县','530128','0');
REPLACE INTO `pw_area` VALUES('530129','530100','530000','寻甸回族彝族自治县','530129','0');
REPLACE INTO `pw_area` VALUES('530181','530100','530000','安宁市','530181','0');
REPLACE INTO `pw_area` VALUES('530301','530300','530000','市辖区','530301','0');
REPLACE INTO `pw_area` VALUES('530302','530300','530000','麒麟区','530302','0');
REPLACE INTO `pw_area` VALUES('530321','530300','530000','马龙县','530321','0');
REPLACE INTO `pw_area` VALUES('530322','530300','530000','陆良县','530322','0');
REPLACE INTO `pw_area` VALUES('530323','530300','530000','师宗县','530323','0');
REPLACE INTO `pw_area` VALUES('530324','530300','530000','罗平县','530324','0');
REPLACE INTO `pw_area` VALUES('530325','530300','530000','富源县','530325','0');
REPLACE INTO `pw_area` VALUES('530326','530300','530000','会泽县','530326','0');
REPLACE INTO `pw_area` VALUES('530328','530300','530000','沾益县','530328','0');
REPLACE INTO `pw_area` VALUES('530381','530300','530000','宣威市','530381','0');
REPLACE INTO `pw_area` VALUES('530401','530400','530000','市辖区','530401','0');
REPLACE INTO `pw_area` VALUES('530402','530400','530000','红塔区','530402','0');
REPLACE INTO `pw_area` VALUES('530421','530400','530000','江川县','530421','0');
REPLACE INTO `pw_area` VALUES('530422','530400','530000','澄江县','530422','0');
REPLACE INTO `pw_area` VALUES('530423','530400','530000','通海县','530423','0');
REPLACE INTO `pw_area` VALUES('530424','530400','530000','华宁县','530424','0');
REPLACE INTO `pw_area` VALUES('530425','530400','530000','易门县','530425','0');
REPLACE INTO `pw_area` VALUES('530426','530400','530000','峨山彝族自治县','530426','0');
REPLACE INTO `pw_area` VALUES('530427','530400','530000','新平彝族傣族自治县','530427','0');
REPLACE INTO `pw_area` VALUES('530428','530400','530000','元江哈尼族彝族傣族自治县','530428','0');
REPLACE INTO `pw_area` VALUES('530501','530500','530000','市辖区','530501','0');
REPLACE INTO `pw_area` VALUES('530502','530500','530000','隆阳区','530502','0');
REPLACE INTO `pw_area` VALUES('530521','530500','530000','施甸县','530521','0');
REPLACE INTO `pw_area` VALUES('530522','530500','530000','腾冲县','530522','0');
REPLACE INTO `pw_area` VALUES('530523','530500','530000','龙陵县','530523','0');
REPLACE INTO `pw_area` VALUES('530524','530500','530000','昌宁县','530524','0');
REPLACE INTO `pw_area` VALUES('530601','530600','530000','市辖区','530601','0');
REPLACE INTO `pw_area` VALUES('530602','530600','530000','昭阳区','530602','0');
REPLACE INTO `pw_area` VALUES('530621','530600','530000','鲁甸县','530621','0');
REPLACE INTO `pw_area` VALUES('530622','530600','530000','巧家县','530622','0');
REPLACE INTO `pw_area` VALUES('530623','530600','530000','盐津县','530623','0');
REPLACE INTO `pw_area` VALUES('530624','530600','530000','大关县','530624','0');
REPLACE INTO `pw_area` VALUES('530625','530600','530000','永善县','530625','0');
REPLACE INTO `pw_area` VALUES('530626','530600','530000','绥江县','530626','0');
REPLACE INTO `pw_area` VALUES('530627','530600','530000','镇雄县','530627','0');
REPLACE INTO `pw_area` VALUES('530628','530600','530000','彝良县','530628','0');
REPLACE INTO `pw_area` VALUES('530629','530600','530000','威信县','530629','0');
REPLACE INTO `pw_area` VALUES('530630','530600','530000','水富县','530630','0');
REPLACE INTO `pw_area` VALUES('530701','530700','530000','市辖区','530701','0');
REPLACE INTO `pw_area` VALUES('530702','530700','530000','古城区','530702','0');
REPLACE INTO `pw_area` VALUES('530721','530700','530000','玉龙纳西族自治县','530721','0');
REPLACE INTO `pw_area` VALUES('530722','530700','530000','永胜县','530722','0');
REPLACE INTO `pw_area` VALUES('530723','530700','530000','华坪县','530723','0');
REPLACE INTO `pw_area` VALUES('530724','530700','530000','宁蒗彝族自治县','530724','0');
REPLACE INTO `pw_area` VALUES('530801','530800','530000','市辖区','530801','0');
REPLACE INTO `pw_area` VALUES('530802','530800','530000','思茅区','530802','0');
REPLACE INTO `pw_area` VALUES('530821','530800','530000','宁洱哈尼族彝族自治县','530821','0');
REPLACE INTO `pw_area` VALUES('530822','530800','530000','墨江哈尼族自治县','530822','0');
REPLACE INTO `pw_area` VALUES('530823','530800','530000','景东彝族自治县','530823','0');
REPLACE INTO `pw_area` VALUES('530824','530800','530000','景谷傣族彝族自治县','530824','0');
REPLACE INTO `pw_area` VALUES('530825','530800','530000','镇沅彝族哈尼族拉祜族自治县','530825','0');
REPLACE INTO `pw_area` VALUES('530826','530800','530000','江城哈尼族彝族自治县','530826','0');
REPLACE INTO `pw_area` VALUES('530827','530800','530000','孟连傣族拉祜族佤族自治县','530827','0');
REPLACE INTO `pw_area` VALUES('530828','530800','530000','澜沧拉祜族自治县','530828','0');
REPLACE INTO `pw_area` VALUES('530829','530800','530000','西盟佤族自治县','530829','0');
REPLACE INTO `pw_area` VALUES('530901','530900','530000','市辖区','530901','0');
REPLACE INTO `pw_area` VALUES('530902','530900','530000','临翔区','530902','0');
REPLACE INTO `pw_area` VALUES('530921','530900','530000','凤庆县','530921','0');
REPLACE INTO `pw_area` VALUES('530922','530900','530000','云县','530922','0');
REPLACE INTO `pw_area` VALUES('530923','530900','530000','永德县','530923','0');
REPLACE INTO `pw_area` VALUES('530924','530900','530000','镇康县','530924','0');
REPLACE INTO `pw_area` VALUES('530925','530900','530000','双江拉祜族佤族布朗族傣族自治县','530925','0');
REPLACE INTO `pw_area` VALUES('530926','530900','530000','耿马傣族佤族自治县','530926','0');
REPLACE INTO `pw_area` VALUES('530927','530900','530000','沧源佤族自治县','530927','0');
REPLACE INTO `pw_area` VALUES('532301','532300','530000','楚雄市','532301','0');
REPLACE INTO `pw_area` VALUES('532322','532300','530000','双柏县','532322','0');
REPLACE INTO `pw_area` VALUES('532323','532300','530000','牟定县','532323','0');
REPLACE INTO `pw_area` VALUES('532324','532300','530000','南华县','532324','0');
REPLACE INTO `pw_area` VALUES('532325','532300','530000','姚安县','532325','0');
REPLACE INTO `pw_area` VALUES('532326','532300','530000','大姚县','532326','0');
REPLACE INTO `pw_area` VALUES('532327','532300','530000','永仁县','532327','0');
REPLACE INTO `pw_area` VALUES('532328','532300','530000','元谋县','532328','0');
REPLACE INTO `pw_area` VALUES('532329','532300','530000','武定县','532329','0');
REPLACE INTO `pw_area` VALUES('532331','532300','530000','禄丰县','532331','0');
REPLACE INTO `pw_area` VALUES('532501','532500','530000','个旧市','532501','0');
REPLACE INTO `pw_area` VALUES('532502','532500','530000','开远市','532502','0');
REPLACE INTO `pw_area` VALUES('532503','532500','530000','蒙自市','532503','0');
REPLACE INTO `pw_area` VALUES('532504','532500','530000','弥勒市','532504','0');
REPLACE INTO `pw_area` VALUES('532523','532500','530000','屏边苗族自治县','532523','0');
REPLACE INTO `pw_area` VALUES('532524','532500','530000','建水县','532524','0');
REPLACE INTO `pw_area` VALUES('532525','532500','530000','石屏县','532525','0');
REPLACE INTO `pw_area` VALUES('532527','532500','530000','泸西县','532527','0');
REPLACE INTO `pw_area` VALUES('532528','532500','530000','元阳县','532528','0');
REPLACE INTO `pw_area` VALUES('532529','532500','530000','红河县','532529','0');
REPLACE INTO `pw_area` VALUES('532530','532500','530000','金平苗族瑶族傣族自治县','532530','0');
REPLACE INTO `pw_area` VALUES('532531','532500','530000','绿春县','532531','0');
REPLACE INTO `pw_area` VALUES('532532','532500','530000','河口瑶族自治县','532532','0');
REPLACE INTO `pw_area` VALUES('532601','532600','530000','文山市','532601','0');
REPLACE INTO `pw_area` VALUES('532622','532600','530000','砚山县','532622','0');
REPLACE INTO `pw_area` VALUES('532623','532600','530000','西畴县','532623','0');
REPLACE INTO `pw_area` VALUES('532624','532600','530000','麻栗坡县','532624','0');
REPLACE INTO `pw_area` VALUES('532625','532600','530000','马关县','532625','0');
REPLACE INTO `pw_area` VALUES('532626','532600','530000','丘北县','532626','0');
REPLACE INTO `pw_area` VALUES('532627','532600','530000','广南县','532627','0');
REPLACE INTO `pw_area` VALUES('532628','532600','530000','富宁县','532628','0');
REPLACE INTO `pw_area` VALUES('532801','532800','530000','景洪市','532801','0');
REPLACE INTO `pw_area` VALUES('532822','532800','530000','勐海县','532822','0');
REPLACE INTO `pw_area` VALUES('532823','532800','530000','勐腊县','532823','0');
REPLACE INTO `pw_area` VALUES('532901','532900','530000','大理市','532901','0');
REPLACE INTO `pw_area` VALUES('532922','532900','530000','漾濞彝族自治县','532922','0');
REPLACE INTO `pw_area` VALUES('532923','532900','530000','祥云县','532923','0');
REPLACE INTO `pw_area` VALUES('532924','532900','530000','宾川县','532924','0');
REPLACE INTO `pw_area` VALUES('532925','532900','530000','弥渡县','532925','0');
REPLACE INTO `pw_area` VALUES('532926','532900','530000','南涧彝族自治县','532926','0');
REPLACE INTO `pw_area` VALUES('532927','532900','530000','巍山彝族回族自治县','532927','0');
REPLACE INTO `pw_area` VALUES('532928','532900','530000','永平县','532928','0');
REPLACE INTO `pw_area` VALUES('532929','532900','530000','云龙县','532929','0');
REPLACE INTO `pw_area` VALUES('532930','532900','530000','洱源县','532930','0');
REPLACE INTO `pw_area` VALUES('532931','532900','530000','剑川县','532931','0');
REPLACE INTO `pw_area` VALUES('532932','532900','530000','鹤庆县','532932','0');
REPLACE INTO `pw_area` VALUES('533102','533100','530000','瑞丽市','533102','0');
REPLACE INTO `pw_area` VALUES('533103','533100','530000','芒市','533103','0');
REPLACE INTO `pw_area` VALUES('533122','533100','530000','梁河县','533122','0');
REPLACE INTO `pw_area` VALUES('533123','533100','530000','盈江县','533123','0');
REPLACE INTO `pw_area` VALUES('533124','533100','530000','陇川县','533124','0');
REPLACE INTO `pw_area` VALUES('533321','533300','530000','泸水县','533321','0');
REPLACE INTO `pw_area` VALUES('533323','533300','530000','福贡县','533323','0');
REPLACE INTO `pw_area` VALUES('533324','533300','530000','贡山独龙族怒族自治县','533324','0');
REPLACE INTO `pw_area` VALUES('533325','533300','530000','兰坪白族普米族自治县','533325','0');
REPLACE INTO `pw_area` VALUES('533421','533400','530000','香格里拉县','533421','0');
REPLACE INTO `pw_area` VALUES('533422','533400','530000','德钦县','533422','0');
REPLACE INTO `pw_area` VALUES('533423','533400','530000','维西傈僳族自治县','533423','0');
REPLACE INTO `pw_area` VALUES('540101','540100','540000','市辖区','540101','0');
REPLACE INTO `pw_area` VALUES('540102','540100','540000','城关区','540102','0');
REPLACE INTO `pw_area` VALUES('540121','540100','540000','林周县','540121','0');
REPLACE INTO `pw_area` VALUES('540122','540100','540000','当雄县','540122','0');
REPLACE INTO `pw_area` VALUES('540123','540100','540000','尼木县','540123','0');
REPLACE INTO `pw_area` VALUES('540124','540100','540000','曲水县','540124','0');
REPLACE INTO `pw_area` VALUES('540125','540100','540000','堆龙德庆县','540125','0');
REPLACE INTO `pw_area` VALUES('540126','540100','540000','达孜县','540126','0');
REPLACE INTO `pw_area` VALUES('540127','540100','540000','墨竹工卡县','540127','0');
REPLACE INTO `pw_area` VALUES('542121','542100','540000','昌都县','542121','0');
REPLACE INTO `pw_area` VALUES('542122','542100','540000','江达县','542122','0');
REPLACE INTO `pw_area` VALUES('542123','542100','540000','贡觉县','542123','0');
REPLACE INTO `pw_area` VALUES('542124','542100','540000','类乌齐县','542124','0');
REPLACE INTO `pw_area` VALUES('542125','542100','540000','丁青县','542125','0');
REPLACE INTO `pw_area` VALUES('542126','542100','540000','察雅县','542126','0');
REPLACE INTO `pw_area` VALUES('542127','542100','540000','八宿县','542127','0');
REPLACE INTO `pw_area` VALUES('542128','542100','540000','左贡县','542128','0');
REPLACE INTO `pw_area` VALUES('542129','542100','540000','芒康县','542129','0');
REPLACE INTO `pw_area` VALUES('542132','542100','540000','洛隆县','542132','0');
REPLACE INTO `pw_area` VALUES('542133','542100','540000','边坝县','542133','0');
REPLACE INTO `pw_area` VALUES('542221','542200','540000','乃东县','542221','0');
REPLACE INTO `pw_area` VALUES('542222','542200','540000','扎囊县','542222','0');
REPLACE INTO `pw_area` VALUES('542223','542200','540000','贡嘎县','542223','0');
REPLACE INTO `pw_area` VALUES('542224','542200','540000','桑日县','542224','0');
REPLACE INTO `pw_area` VALUES('542225','542200','540000','琼结县','542225','0');
REPLACE INTO `pw_area` VALUES('542226','542200','540000','曲松县','542226','0');
REPLACE INTO `pw_area` VALUES('542227','542200','540000','措美县','542227','0');
REPLACE INTO `pw_area` VALUES('542228','542200','540000','洛扎县','542228','0');
REPLACE INTO `pw_area` VALUES('542229','542200','540000','加查县','542229','0');
REPLACE INTO `pw_area` VALUES('542231','542200','540000','隆子县','542231','0');
REPLACE INTO `pw_area` VALUES('542232','542200','540000','错那县','542232','0');
REPLACE INTO `pw_area` VALUES('542233','542200','540000','浪卡子县','542233','0');
REPLACE INTO `pw_area` VALUES('542301','542300','540000','日喀则市','542301','0');
REPLACE INTO `pw_area` VALUES('542322','542300','540000','南木林县','542322','0');
REPLACE INTO `pw_area` VALUES('542323','542300','540000','江孜县','542323','0');
REPLACE INTO `pw_area` VALUES('542324','542300','540000','定日县','542324','0');
REPLACE INTO `pw_area` VALUES('542325','542300','540000','萨迦县','542325','0');
REPLACE INTO `pw_area` VALUES('542326','542300','540000','拉孜县','542326','0');
REPLACE INTO `pw_area` VALUES('542327','542300','540000','昂仁县','542327','0');
REPLACE INTO `pw_area` VALUES('542328','542300','540000','谢通门县','542328','0');
REPLACE INTO `pw_area` VALUES('542329','542300','540000','白朗县','542329','0');
REPLACE INTO `pw_area` VALUES('542330','542300','540000','仁布县','542330','0');
REPLACE INTO `pw_area` VALUES('542331','542300','540000','康马县','542331','0');
REPLACE INTO `pw_area` VALUES('542332','542300','540000','定结县','542332','0');
REPLACE INTO `pw_area` VALUES('542333','542300','540000','仲巴县','542333','0');
REPLACE INTO `pw_area` VALUES('542334','542300','540000','亚东县','542334','0');
REPLACE INTO `pw_area` VALUES('542335','542300','540000','吉隆县','542335','0');
REPLACE INTO `pw_area` VALUES('542336','542300','540000','聂拉木县','542336','0');
REPLACE INTO `pw_area` VALUES('542337','542300','540000','萨嘎县','542337','0');
REPLACE INTO `pw_area` VALUES('542338','542300','540000','岗巴县','542338','0');
REPLACE INTO `pw_area` VALUES('542421','542400','540000','那曲县','542421','0');
REPLACE INTO `pw_area` VALUES('542422','542400','540000','嘉黎县','542422','0');
REPLACE INTO `pw_area` VALUES('542423','542400','540000','比如县','542423','0');
REPLACE INTO `pw_area` VALUES('542424','542400','540000','聂荣县','542424','0');
REPLACE INTO `pw_area` VALUES('542425','542400','540000','安多县','542425','0');
REPLACE INTO `pw_area` VALUES('542426','542400','540000','申扎县','542426','0');
REPLACE INTO `pw_area` VALUES('542427','542400','540000','索县','542427','0');
REPLACE INTO `pw_area` VALUES('542428','542400','540000','班戈县','542428','0');
REPLACE INTO `pw_area` VALUES('542429','542400','540000','巴青县','542429','0');
REPLACE INTO `pw_area` VALUES('542430','542400','540000','尼玛县','542430','0');
REPLACE INTO `pw_area` VALUES('542431','542400','540000','双湖县','542431','0');
REPLACE INTO `pw_area` VALUES('542521','542500','540000','普兰县','542521','0');
REPLACE INTO `pw_area` VALUES('542522','542500','540000','札达县','542522','0');
REPLACE INTO `pw_area` VALUES('542523','542500','540000','噶尔县','542523','0');
REPLACE INTO `pw_area` VALUES('542524','542500','540000','日土县','542524','0');
REPLACE INTO `pw_area` VALUES('542525','542500','540000','革吉县','542525','0');
REPLACE INTO `pw_area` VALUES('542526','542500','540000','改则县','542526','0');
REPLACE INTO `pw_area` VALUES('542527','542500','540000','措勤县','542527','0');
REPLACE INTO `pw_area` VALUES('542621','542600','540000','林芝县','542621','0');
REPLACE INTO `pw_area` VALUES('542622','542600','540000','工布江达县','542622','0');
REPLACE INTO `pw_area` VALUES('542623','542600','540000','米林县','542623','0');
REPLACE INTO `pw_area` VALUES('542624','542600','540000','墨脱县','542624','0');
REPLACE INTO `pw_area` VALUES('542625','542600','540000','波密县','542625','0');
REPLACE INTO `pw_area` VALUES('542626','542600','540000','察隅县','542626','0');
REPLACE INTO `pw_area` VALUES('542627','542600','540000','朗县','542627','0');
REPLACE INTO `pw_area` VALUES('610101','610100','610000','市辖区','610101','0');
REPLACE INTO `pw_area` VALUES('610102','610100','610000','新城区','610102','0');
REPLACE INTO `pw_area` VALUES('610103','610100','610000','碑林区','610103','0');
REPLACE INTO `pw_area` VALUES('610104','610100','610000','莲湖区','610104','0');
REPLACE INTO `pw_area` VALUES('610111','610100','610000','灞桥区','610111','0');
REPLACE INTO `pw_area` VALUES('610112','610100','610000','未央区','610112','0');
REPLACE INTO `pw_area` VALUES('610113','610100','610000','雁塔区','610113','0');
REPLACE INTO `pw_area` VALUES('610114','610100','610000','阎良区','610114','0');
REPLACE INTO `pw_area` VALUES('610115','610100','610000','临潼区','610115','0');
REPLACE INTO `pw_area` VALUES('610116','610100','610000','长安区','610116','0');
REPLACE INTO `pw_area` VALUES('610122','610100','610000','蓝田县','610122','0');
REPLACE INTO `pw_area` VALUES('610124','610100','610000','周至县','610124','0');
REPLACE INTO `pw_area` VALUES('610125','610100','610000','户县','610125','0');
REPLACE INTO `pw_area` VALUES('610126','610100','610000','高陵县','610126','0');
REPLACE INTO `pw_area` VALUES('610201','610200','610000','市辖区','610201','0');
REPLACE INTO `pw_area` VALUES('610202','610200','610000','王益区','610202','0');
REPLACE INTO `pw_area` VALUES('610203','610200','610000','印台区','610203','0');
REPLACE INTO `pw_area` VALUES('610204','610200','610000','耀州区','610204','0');
REPLACE INTO `pw_area` VALUES('610222','610200','610000','宜君县','610222','0');
REPLACE INTO `pw_area` VALUES('610301','610300','610000','市辖区','610301','0');
REPLACE INTO `pw_area` VALUES('610302','610300','610000','渭滨区','610302','0');
REPLACE INTO `pw_area` VALUES('610303','610300','610000','金台区','610303','0');
REPLACE INTO `pw_area` VALUES('610304','610300','610000','陈仓区','610304','0');
REPLACE INTO `pw_area` VALUES('610322','610300','610000','凤翔县','610322','0');
REPLACE INTO `pw_area` VALUES('610323','610300','610000','岐山县','610323','0');
REPLACE INTO `pw_area` VALUES('610324','610300','610000','扶风县','610324','0');
REPLACE INTO `pw_area` VALUES('610326','610300','610000','眉县','610326','0');
REPLACE INTO `pw_area` VALUES('610327','610300','610000','陇县','610327','0');
REPLACE INTO `pw_area` VALUES('610328','610300','610000','千阳县','610328','0');
REPLACE INTO `pw_area` VALUES('610329','610300','610000','麟游县','610329','0');
REPLACE INTO `pw_area` VALUES('610330','610300','610000','凤县','610330','0');
REPLACE INTO `pw_area` VALUES('610331','610300','610000','太白县','610331','0');
REPLACE INTO `pw_area` VALUES('610401','610400','610000','市辖区','610401','0');
REPLACE INTO `pw_area` VALUES('610402','610400','610000','秦都区','610402','0');
REPLACE INTO `pw_area` VALUES('610403','610400','610000','杨陵区','610403','0');
REPLACE INTO `pw_area` VALUES('610404','610400','610000','渭城区','610404','0');
REPLACE INTO `pw_area` VALUES('610422','610400','610000','三原县','610422','0');
REPLACE INTO `pw_area` VALUES('610423','610400','610000','泾阳县','610423','0');
REPLACE INTO `pw_area` VALUES('610424','610400','610000','乾县','610424','0');
REPLACE INTO `pw_area` VALUES('610425','610400','610000','礼泉县','610425','0');
REPLACE INTO `pw_area` VALUES('610426','610400','610000','永寿县','610426','0');
REPLACE INTO `pw_area` VALUES('610427','610400','610000','彬县','610427','0');
REPLACE INTO `pw_area` VALUES('610428','610400','610000','长武县','610428','0');
REPLACE INTO `pw_area` VALUES('610429','610400','610000','旬邑县','610429','0');
REPLACE INTO `pw_area` VALUES('610430','610400','610000','淳化县','610430','0');
REPLACE INTO `pw_area` VALUES('610431','610400','610000','武功县','610431','0');
REPLACE INTO `pw_area` VALUES('610481','610400','610000','兴平市','610481','0');
REPLACE INTO `pw_area` VALUES('610501','610500','610000','市辖区','610501','0');
REPLACE INTO `pw_area` VALUES('610502','610500','610000','临渭区','610502','0');
REPLACE INTO `pw_area` VALUES('610521','610500','610000','华县','610521','0');
REPLACE INTO `pw_area` VALUES('610522','610500','610000','潼关县','610522','0');
REPLACE INTO `pw_area` VALUES('610523','610500','610000','大荔县','610523','0');
REPLACE INTO `pw_area` VALUES('610524','610500','610000','合阳县','610524','0');
REPLACE INTO `pw_area` VALUES('610525','610500','610000','澄城县','610525','0');
REPLACE INTO `pw_area` VALUES('610526','610500','610000','蒲城县','610526','0');
REPLACE INTO `pw_area` VALUES('610527','610500','610000','白水县','610527','0');
REPLACE INTO `pw_area` VALUES('610528','610500','610000','富平县','610528','0');
REPLACE INTO `pw_area` VALUES('610581','610500','610000','韩城市','610581','0');
REPLACE INTO `pw_area` VALUES('610582','610500','610000','华阴市','610582','0');
REPLACE INTO `pw_area` VALUES('610601','610600','610000','市辖区','610601','0');
REPLACE INTO `pw_area` VALUES('610602','610600','610000','宝塔区','610602','0');
REPLACE INTO `pw_area` VALUES('610621','610600','610000','延长县','610621','0');
REPLACE INTO `pw_area` VALUES('610622','610600','610000','延川县','610622','0');
REPLACE INTO `pw_area` VALUES('610623','610600','610000','子长县','610623','0');
REPLACE INTO `pw_area` VALUES('610624','610600','610000','安塞县','610624','0');
REPLACE INTO `pw_area` VALUES('610625','610600','610000','志丹县','610625','0');
REPLACE INTO `pw_area` VALUES('610626','610600','610000','吴起县','610626','0');
REPLACE INTO `pw_area` VALUES('610627','610600','610000','甘泉县','610627','0');
REPLACE INTO `pw_area` VALUES('610628','610600','610000','富县','610628','0');
REPLACE INTO `pw_area` VALUES('610629','610600','610000','洛川县','610629','0');
REPLACE INTO `pw_area` VALUES('610630','610600','610000','宜川县','610630','0');
REPLACE INTO `pw_area` VALUES('610631','610600','610000','黄龙县','610631','0');
REPLACE INTO `pw_area` VALUES('610632','610600','610000','黄陵县','610632','0');
REPLACE INTO `pw_area` VALUES('610701','610700','610000','市辖区','610701','0');
REPLACE INTO `pw_area` VALUES('610702','610700','610000','汉台区','610702','0');
REPLACE INTO `pw_area` VALUES('610721','610700','610000','南郑县','610721','0');
REPLACE INTO `pw_area` VALUES('610722','610700','610000','城固县','610722','0');
REPLACE INTO `pw_area` VALUES('610723','610700','610000','洋县','610723','0');
REPLACE INTO `pw_area` VALUES('610724','610700','610000','西乡县','610724','0');
REPLACE INTO `pw_area` VALUES('610725','610700','610000','勉县','610725','0');
REPLACE INTO `pw_area` VALUES('610726','610700','610000','宁强县','610726','0');
REPLACE INTO `pw_area` VALUES('610727','610700','610000','略阳县','610727','0');
REPLACE INTO `pw_area` VALUES('610728','610700','610000','镇巴县','610728','0');
REPLACE INTO `pw_area` VALUES('610729','610700','610000','留坝县','610729','0');
REPLACE INTO `pw_area` VALUES('610730','610700','610000','佛坪县','610730','0');
REPLACE INTO `pw_area` VALUES('610801','610800','610000','市辖区','610801','0');
REPLACE INTO `pw_area` VALUES('610802','610800','610000','榆阳区','610802','0');
REPLACE INTO `pw_area` VALUES('610821','610800','610000','神木县','610821','0');
REPLACE INTO `pw_area` VALUES('610822','610800','610000','府谷县','610822','0');
REPLACE INTO `pw_area` VALUES('610823','610800','610000','横山县','610823','0');
REPLACE INTO `pw_area` VALUES('610824','610800','610000','靖边县','610824','0');
REPLACE INTO `pw_area` VALUES('610825','610800','610000','定边县','610825','0');
REPLACE INTO `pw_area` VALUES('610826','610800','610000','绥德县','610826','0');
REPLACE INTO `pw_area` VALUES('610827','610800','610000','米脂县','610827','0');
REPLACE INTO `pw_area` VALUES('610828','610800','610000','佳县','610828','0');
REPLACE INTO `pw_area` VALUES('610829','610800','610000','吴堡县','610829','0');
REPLACE INTO `pw_area` VALUES('610830','610800','610000','清涧县','610830','0');
REPLACE INTO `pw_area` VALUES('610831','610800','610000','子洲县','610831','0');
REPLACE INTO `pw_area` VALUES('610901','610900','610000','市辖区','610901','0');
REPLACE INTO `pw_area` VALUES('610902','610900','610000','汉滨区','610902','0');
REPLACE INTO `pw_area` VALUES('610921','610900','610000','汉阴县','610921','0');
REPLACE INTO `pw_area` VALUES('610922','610900','610000','石泉县','610922','0');
REPLACE INTO `pw_area` VALUES('610923','610900','610000','宁陕县','610923','0');
REPLACE INTO `pw_area` VALUES('610924','610900','610000','紫阳县','610924','0');
REPLACE INTO `pw_area` VALUES('610925','610900','610000','岚皋县','610925','0');
REPLACE INTO `pw_area` VALUES('610926','610900','610000','平利县','610926','0');
REPLACE INTO `pw_area` VALUES('610927','610900','610000','镇坪县','610927','0');
REPLACE INTO `pw_area` VALUES('610928','610900','610000','旬阳县','610928','0');
REPLACE INTO `pw_area` VALUES('610929','610900','610000','白河县','610929','0');
REPLACE INTO `pw_area` VALUES('611001','611000','610000','市辖区','611001','0');
REPLACE INTO `pw_area` VALUES('611002','611000','610000','商州区','611002','0');
REPLACE INTO `pw_area` VALUES('611021','611000','610000','洛南县','611021','0');
REPLACE INTO `pw_area` VALUES('611022','611000','610000','丹凤县','611022','0');
REPLACE INTO `pw_area` VALUES('611023','611000','610000','商南县','611023','0');
REPLACE INTO `pw_area` VALUES('611024','611000','610000','山阳县','611024','0');
REPLACE INTO `pw_area` VALUES('611025','611000','610000','镇安县','611025','0');
REPLACE INTO `pw_area` VALUES('611026','611000','610000','柞水县','611026','0');
REPLACE INTO `pw_area` VALUES('620101','620100','620000','市辖区','620101','0');
REPLACE INTO `pw_area` VALUES('620102','620100','620000','城关区','620102','0');
REPLACE INTO `pw_area` VALUES('620103','620100','620000','七里河区','620103','0');
REPLACE INTO `pw_area` VALUES('620104','620100','620000','西固区','620104','0');
REPLACE INTO `pw_area` VALUES('620105','620100','620000','安宁区','620105','0');
REPLACE INTO `pw_area` VALUES('620111','620100','620000','红古区','620111','0');
REPLACE INTO `pw_area` VALUES('620121','620100','620000','永登县','620121','0');
REPLACE INTO `pw_area` VALUES('620122','620100','620000','皋兰县','620122','0');
REPLACE INTO `pw_area` VALUES('620123','620100','620000','榆中县','620123','0');
REPLACE INTO `pw_area` VALUES('620201','620200','620000','市辖区','620201','0');
REPLACE INTO `pw_area` VALUES('620301','620300','620000','市辖区','620301','0');
REPLACE INTO `pw_area` VALUES('620302','620300','620000','金川区','620302','0');
REPLACE INTO `pw_area` VALUES('620321','620300','620000','永昌县','620321','0');
REPLACE INTO `pw_area` VALUES('620401','620400','620000','市辖区','620401','0');
REPLACE INTO `pw_area` VALUES('620402','620400','620000','白银区','620402','0');
REPLACE INTO `pw_area` VALUES('620403','620400','620000','平川区','620403','0');
REPLACE INTO `pw_area` VALUES('620421','620400','620000','靖远县','620421','0');
REPLACE INTO `pw_area` VALUES('620422','620400','620000','会宁县','620422','0');
REPLACE INTO `pw_area` VALUES('620423','620400','620000','景泰县','620423','0');
REPLACE INTO `pw_area` VALUES('620501','620500','620000','市辖区','620501','0');
REPLACE INTO `pw_area` VALUES('620502','620500','620000','秦州区','620502','0');
REPLACE INTO `pw_area` VALUES('620503','620500','620000','麦积区','620503','0');
REPLACE INTO `pw_area` VALUES('620521','620500','620000','清水县','620521','0');
REPLACE INTO `pw_area` VALUES('620522','620500','620000','秦安县','620522','0');
REPLACE INTO `pw_area` VALUES('620523','620500','620000','甘谷县','620523','0');
REPLACE INTO `pw_area` VALUES('620524','620500','620000','武山县','620524','0');
REPLACE INTO `pw_area` VALUES('620525','620500','620000','张家川回族自治县','620525','0');
REPLACE INTO `pw_area` VALUES('620601','620600','620000','市辖区','620601','0');
REPLACE INTO `pw_area` VALUES('620602','620600','620000','凉州区','620602','0');
REPLACE INTO `pw_area` VALUES('620621','620600','620000','民勤县','620621','0');
REPLACE INTO `pw_area` VALUES('620622','620600','620000','古浪县','620622','0');
REPLACE INTO `pw_area` VALUES('620623','620600','620000','天祝藏族自治县','620623','0');
REPLACE INTO `pw_area` VALUES('620701','620700','620000','市辖区','620701','0');
REPLACE INTO `pw_area` VALUES('620702','620700','620000','甘州区','620702','0');
REPLACE INTO `pw_area` VALUES('620721','620700','620000','肃南裕固族自治县','620721','0');
REPLACE INTO `pw_area` VALUES('620722','620700','620000','民乐县','620722','0');
REPLACE INTO `pw_area` VALUES('620723','620700','620000','临泽县','620723','0');
REPLACE INTO `pw_area` VALUES('620724','620700','620000','高台县','620724','0');
REPLACE INTO `pw_area` VALUES('620725','620700','620000','山丹县','620725','0');
REPLACE INTO `pw_area` VALUES('620801','620800','620000','市辖区','620801','0');
REPLACE INTO `pw_area` VALUES('620802','620800','620000','崆峒区','620802','0');
REPLACE INTO `pw_area` VALUES('620821','620800','620000','泾川县','620821','0');
REPLACE INTO `pw_area` VALUES('620822','620800','620000','灵台县','620822','0');
REPLACE INTO `pw_area` VALUES('620823','620800','620000','崇信县','620823','0');
REPLACE INTO `pw_area` VALUES('620824','620800','620000','华亭县','620824','0');
REPLACE INTO `pw_area` VALUES('620825','620800','620000','庄浪县','620825','0');
REPLACE INTO `pw_area` VALUES('620826','620800','620000','静宁县','620826','0');
REPLACE INTO `pw_area` VALUES('620901','620900','620000','市辖区','620901','0');
REPLACE INTO `pw_area` VALUES('620902','620900','620000','肃州区','620902','0');
REPLACE INTO `pw_area` VALUES('620921','620900','620000','金塔县','620921','0');
REPLACE INTO `pw_area` VALUES('620922','620900','620000','瓜州县','620922','0');
REPLACE INTO `pw_area` VALUES('620923','620900','620000','肃北蒙古族自治县','620923','0');
REPLACE INTO `pw_area` VALUES('620924','620900','620000','阿克塞哈萨克族自治县','620924','0');
REPLACE INTO `pw_area` VALUES('620981','620900','620000','玉门市','620981','0');
REPLACE INTO `pw_area` VALUES('620982','620900','620000','敦煌市','620982','0');
REPLACE INTO `pw_area` VALUES('621001','621000','620000','市辖区','621001','0');
REPLACE INTO `pw_area` VALUES('621002','621000','620000','西峰区','621002','0');
REPLACE INTO `pw_area` VALUES('621021','621000','620000','庆城县','621021','0');
REPLACE INTO `pw_area` VALUES('621022','621000','620000','环县','621022','0');
REPLACE INTO `pw_area` VALUES('621023','621000','620000','华池县','621023','0');
REPLACE INTO `pw_area` VALUES('621024','621000','620000','合水县','621024','0');
REPLACE INTO `pw_area` VALUES('621025','621000','620000','正宁县','621025','0');
REPLACE INTO `pw_area` VALUES('621026','621000','620000','宁县','621026','0');
REPLACE INTO `pw_area` VALUES('621027','621000','620000','镇原县','621027','0');
REPLACE INTO `pw_area` VALUES('621101','621100','620000','市辖区','621101','0');
REPLACE INTO `pw_area` VALUES('621102','621100','620000','安定区','621102','0');
REPLACE INTO `pw_area` VALUES('621121','621100','620000','通渭县','621121','0');
REPLACE INTO `pw_area` VALUES('621122','621100','620000','陇西县','621122','0');
REPLACE INTO `pw_area` VALUES('621123','621100','620000','渭源县','621123','0');
REPLACE INTO `pw_area` VALUES('621124','621100','620000','临洮县','621124','0');
REPLACE INTO `pw_area` VALUES('621125','621100','620000','漳县','621125','0');
REPLACE INTO `pw_area` VALUES('621126','621100','620000','岷县','621126','0');
REPLACE INTO `pw_area` VALUES('621201','621200','620000','市辖区','621201','0');
REPLACE INTO `pw_area` VALUES('621202','621200','620000','武都区','621202','0');
REPLACE INTO `pw_area` VALUES('621221','621200','620000','成县','621221','0');
REPLACE INTO `pw_area` VALUES('621222','621200','620000','文县','621222','0');
REPLACE INTO `pw_area` VALUES('621223','621200','620000','宕昌县','621223','0');
REPLACE INTO `pw_area` VALUES('621224','621200','620000','康县','621224','0');
REPLACE INTO `pw_area` VALUES('621225','621200','620000','西和县','621225','0');
REPLACE INTO `pw_area` VALUES('621226','621200','620000','礼县','621226','0');
REPLACE INTO `pw_area` VALUES('621227','621200','620000','徽县','621227','0');
REPLACE INTO `pw_area` VALUES('621228','621200','620000','两当县','621228','0');
REPLACE INTO `pw_area` VALUES('622901','622900','620000','临夏市','622901','0');
REPLACE INTO `pw_area` VALUES('622921','622900','620000','临夏县','622921','0');
REPLACE INTO `pw_area` VALUES('622922','622900','620000','康乐县','622922','0');
REPLACE INTO `pw_area` VALUES('622923','622900','620000','永靖县','622923','0');
REPLACE INTO `pw_area` VALUES('622924','622900','620000','广河县','622924','0');
REPLACE INTO `pw_area` VALUES('622925','622900','620000','和政县','622925','0');
REPLACE INTO `pw_area` VALUES('622926','622900','620000','东乡族自治县','622926','0');
REPLACE INTO `pw_area` VALUES('622927','622900','620000','积石山保安族东乡族撒拉族自治县','622927','0');
REPLACE INTO `pw_area` VALUES('623001','623000','620000','合作市','623001','0');
REPLACE INTO `pw_area` VALUES('623021','623000','620000','临潭县','623021','0');
REPLACE INTO `pw_area` VALUES('623022','623000','620000','卓尼县','623022','0');
REPLACE INTO `pw_area` VALUES('623023','623000','620000','舟曲县','623023','0');
REPLACE INTO `pw_area` VALUES('623024','623000','620000','迭部县','623024','0');
REPLACE INTO `pw_area` VALUES('623025','623000','620000','玛曲县','623025','0');
REPLACE INTO `pw_area` VALUES('623026','623000','620000','碌曲县','623026','0');
REPLACE INTO `pw_area` VALUES('623027','623000','620000','夏河县','623027','0');
REPLACE INTO `pw_area` VALUES('630101','630100','630000','市辖区','630101','0');
REPLACE INTO `pw_area` VALUES('630102','630100','630000','城东区','630102','0');
REPLACE INTO `pw_area` VALUES('630103','630100','630000','城中区','630103','0');
REPLACE INTO `pw_area` VALUES('630104','630100','630000','城西区','630104','0');
REPLACE INTO `pw_area` VALUES('630105','630100','630000','城北区','630105','0');
REPLACE INTO `pw_area` VALUES('630121','630100','630000','大通回族土族自治县','630121','0');
REPLACE INTO `pw_area` VALUES('630122','630100','630000','湟中县','630122','0');
REPLACE INTO `pw_area` VALUES('630123','630100','630000','湟源县','630123','0');
REPLACE INTO `pw_area` VALUES('630202','630200','630000','乐都区','630202','0');
REPLACE INTO `pw_area` VALUES('630221','630200','630000','平安县','630221','0');
REPLACE INTO `pw_area` VALUES('630222','630200','630000','民和回族土族自治县','630222','0');
REPLACE INTO `pw_area` VALUES('630223','630200','630000','互助土族自治县','630223','0');
REPLACE INTO `pw_area` VALUES('630224','630200','630000','化隆回族自治县','630224','0');
REPLACE INTO `pw_area` VALUES('630225','630200','630000','循化撒拉族自治县','630225','0');
REPLACE INTO `pw_area` VALUES('632221','632200','630000','门源回族自治县','632221','0');
REPLACE INTO `pw_area` VALUES('632222','632200','630000','祁连县','632222','0');
REPLACE INTO `pw_area` VALUES('632223','632200','630000','海晏县','632223','0');
REPLACE INTO `pw_area` VALUES('632224','632200','630000','刚察县','632224','0');
REPLACE INTO `pw_area` VALUES('632321','632300','630000','同仁县','632321','0');
REPLACE INTO `pw_area` VALUES('632322','632300','630000','尖扎县','632322','0');
REPLACE INTO `pw_area` VALUES('632323','632300','630000','泽库县','632323','0');
REPLACE INTO `pw_area` VALUES('632324','632300','630000','河南蒙古族自治县','632324','0');
REPLACE INTO `pw_area` VALUES('632521','632500','630000','共和县','632521','0');
REPLACE INTO `pw_area` VALUES('632522','632500','630000','同德县','632522','0');
REPLACE INTO `pw_area` VALUES('632523','632500','630000','贵德县','632523','0');
REPLACE INTO `pw_area` VALUES('632524','632500','630000','兴海县','632524','0');
REPLACE INTO `pw_area` VALUES('632525','632500','630000','贵南县','632525','0');
REPLACE INTO `pw_area` VALUES('632621','632600','630000','玛沁县','632621','0');
REPLACE INTO `pw_area` VALUES('632622','632600','630000','班玛县','632622','0');
REPLACE INTO `pw_area` VALUES('632623','632600','630000','甘德县','632623','0');
REPLACE INTO `pw_area` VALUES('632624','632600','630000','达日县','632624','0');
REPLACE INTO `pw_area` VALUES('632625','632600','630000','久治县','632625','0');
REPLACE INTO `pw_area` VALUES('632626','632600','630000','玛多县','632626','0');
REPLACE INTO `pw_area` VALUES('632701','632700','630000','玉树市','632701','0');
REPLACE INTO `pw_area` VALUES('632722','632700','630000','杂多县','632722','0');
REPLACE INTO `pw_area` VALUES('632723','632700','630000','称多县','632723','0');
REPLACE INTO `pw_area` VALUES('632724','632700','630000','治多县','632724','0');
REPLACE INTO `pw_area` VALUES('632725','632700','630000','囊谦县','632725','0');
REPLACE INTO `pw_area` VALUES('632726','632700','630000','曲麻莱县','632726','0');
REPLACE INTO `pw_area` VALUES('632801','632800','630000','格尔木市','632801','0');
REPLACE INTO `pw_area` VALUES('632802','632800','630000','德令哈市','632802','0');
REPLACE INTO `pw_area` VALUES('632821','632800','630000','乌兰县','632821','0');
REPLACE INTO `pw_area` VALUES('632822','632800','630000','都兰县','632822','0');
REPLACE INTO `pw_area` VALUES('632823','632800','630000','天峻县','632823','0');
REPLACE INTO `pw_area` VALUES('640101','640100','640000','市辖区','640101','0');
REPLACE INTO `pw_area` VALUES('640104','640100','640000','兴庆区','640104','0');
REPLACE INTO `pw_area` VALUES('640105','640100','640000','西夏区','640105','0');
REPLACE INTO `pw_area` VALUES('640106','640100','640000','金凤区','640106','0');
REPLACE INTO `pw_area` VALUES('640121','640100','640000','永宁县','640121','0');
REPLACE INTO `pw_area` VALUES('640122','640100','640000','贺兰县','640122','0');
REPLACE INTO `pw_area` VALUES('640181','640100','640000','灵武市','640181','0');
REPLACE INTO `pw_area` VALUES('640201','640200','640000','市辖区','640201','0');
REPLACE INTO `pw_area` VALUES('640202','640200','640000','大武口区','640202','0');
REPLACE INTO `pw_area` VALUES('640205','640200','640000','惠农区','640205','0');
REPLACE INTO `pw_area` VALUES('640221','640200','640000','平罗县','640221','0');
REPLACE INTO `pw_area` VALUES('640301','640300','640000','市辖区','640301','0');
REPLACE INTO `pw_area` VALUES('640302','640300','640000','利通区','640302','0');
REPLACE INTO `pw_area` VALUES('640303','640300','640000','红寺堡区','640303','0');
REPLACE INTO `pw_area` VALUES('640323','640300','640000','盐池县','640323','0');
REPLACE INTO `pw_area` VALUES('640324','640300','640000','同心县','640324','0');
REPLACE INTO `pw_area` VALUES('640381','640300','640000','青铜峡市','640381','0');
REPLACE INTO `pw_area` VALUES('640401','640400','640000','市辖区','640401','0');
REPLACE INTO `pw_area` VALUES('640402','640400','640000','原州区','640402','0');
REPLACE INTO `pw_area` VALUES('640422','640400','640000','西吉县','640422','0');
REPLACE INTO `pw_area` VALUES('640423','640400','640000','隆德县','640423','0');
REPLACE INTO `pw_area` VALUES('640424','640400','640000','泾源县','640424','0');
REPLACE INTO `pw_area` VALUES('640425','640400','640000','彭阳县','640425','0');
REPLACE INTO `pw_area` VALUES('640501','640500','640000','市辖区','640501','0');
REPLACE INTO `pw_area` VALUES('640502','640500','640000','沙坡头区','640502','0');
REPLACE INTO `pw_area` VALUES('640521','640500','640000','中宁县','640521','0');
REPLACE INTO `pw_area` VALUES('640522','640500','640000','海原县','640522','0');
REPLACE INTO `pw_area` VALUES('650101','650100','650000','市辖区','650101','0');
REPLACE INTO `pw_area` VALUES('650102','650100','650000','天山区','650102','0');
REPLACE INTO `pw_area` VALUES('650103','650100','650000','沙依巴克区','650103','0');
REPLACE INTO `pw_area` VALUES('650104','650100','650000','新市区','650104','0');
REPLACE INTO `pw_area` VALUES('650105','650100','650000','水磨沟区','650105','0');
REPLACE INTO `pw_area` VALUES('650106','650100','650000','头屯河区','650106','0');
REPLACE INTO `pw_area` VALUES('650107','650100','650000','达坂城区','650107','0');
REPLACE INTO `pw_area` VALUES('650109','650100','650000','米东区','650109','0');
REPLACE INTO `pw_area` VALUES('650121','650100','650000','乌鲁木齐县','650121','0');
REPLACE INTO `pw_area` VALUES('650201','650200','650000','市辖区','650201','0');
REPLACE INTO `pw_area` VALUES('650202','650200','650000','独山子区','650202','0');
REPLACE INTO `pw_area` VALUES('650203','650200','650000','克拉玛依区','650203','0');
REPLACE INTO `pw_area` VALUES('650204','650200','650000','白碱滩区','650204','0');
REPLACE INTO `pw_area` VALUES('650205','650200','650000','乌尔禾区','650205','0');
REPLACE INTO `pw_area` VALUES('652101','652100','650000','吐鲁番市','652101','0');
REPLACE INTO `pw_area` VALUES('652122','652100','650000','鄯善县','652122','0');
REPLACE INTO `pw_area` VALUES('652123','652100','650000','托克逊县','652123','0');
REPLACE INTO `pw_area` VALUES('652201','652200','650000','哈密市','652201','0');
REPLACE INTO `pw_area` VALUES('652222','652200','650000','巴里坤哈萨克自治县','652222','0');
REPLACE INTO `pw_area` VALUES('652223','652200','650000','伊吾县','652223','0');
REPLACE INTO `pw_area` VALUES('652301','652300','650000','昌吉市','652301','0');
REPLACE INTO `pw_area` VALUES('652302','652300','650000','阜康市','652302','0');
REPLACE INTO `pw_area` VALUES('652323','652300','650000','呼图壁县','652323','0');
REPLACE INTO `pw_area` VALUES('652324','652300','650000','玛纳斯县','652324','0');
REPLACE INTO `pw_area` VALUES('652325','652300','650000','奇台县','652325','0');
REPLACE INTO `pw_area` VALUES('652327','652300','650000','吉木萨尔县','652327','0');
REPLACE INTO `pw_area` VALUES('652328','652300','650000','木垒哈萨克自治县','652328','0');
REPLACE INTO `pw_area` VALUES('652701','652700','650000','博乐市','652701','0');
REPLACE INTO `pw_area` VALUES('652702','652700','650000','阿拉山口市','652702','0');
REPLACE INTO `pw_area` VALUES('652722','652700','650000','精河县','652722','0');
REPLACE INTO `pw_area` VALUES('652723','652700','650000','温泉县','652723','0');
REPLACE INTO `pw_area` VALUES('652801','652800','650000','库尔勒市','652801','0');
REPLACE INTO `pw_area` VALUES('652822','652800','650000','轮台县','652822','0');
REPLACE INTO `pw_area` VALUES('652823','652800','650000','尉犁县','652823','0');
REPLACE INTO `pw_area` VALUES('652824','652800','650000','若羌县','652824','0');
REPLACE INTO `pw_area` VALUES('652825','652800','650000','且末县','652825','0');
REPLACE INTO `pw_area` VALUES('652826','652800','650000','焉耆回族自治县','652826','0');
REPLACE INTO `pw_area` VALUES('652827','652800','650000','和静县','652827','0');
REPLACE INTO `pw_area` VALUES('652828','652800','650000','和硕县','652828','0');
REPLACE INTO `pw_area` VALUES('652829','652800','650000','博湖县','652829','0');
REPLACE INTO `pw_area` VALUES('652901','652900','650000','阿克苏市','652901','0');
REPLACE INTO `pw_area` VALUES('652922','652900','650000','温宿县','652922','0');
REPLACE INTO `pw_area` VALUES('652923','652900','650000','库车县','652923','0');
REPLACE INTO `pw_area` VALUES('652924','652900','650000','沙雅县','652924','0');
REPLACE INTO `pw_area` VALUES('652925','652900','650000','新和县','652925','0');
REPLACE INTO `pw_area` VALUES('652926','652900','650000','拜城县','652926','0');
REPLACE INTO `pw_area` VALUES('652927','652900','650000','乌什县','652927','0');
REPLACE INTO `pw_area` VALUES('652928','652900','650000','阿瓦提县','652928','0');
REPLACE INTO `pw_area` VALUES('652929','652900','650000','柯坪县','652929','0');
REPLACE INTO `pw_area` VALUES('653001','653000','650000','阿图什市','653001','0');
REPLACE INTO `pw_area` VALUES('653022','653000','650000','阿克陶县','653022','0');
REPLACE INTO `pw_area` VALUES('653023','653000','650000','阿合奇县','653023','0');
REPLACE INTO `pw_area` VALUES('653024','653000','650000','乌恰县','653024','0');
REPLACE INTO `pw_area` VALUES('653101','653100','650000','喀什市','653101','0');
REPLACE INTO `pw_area` VALUES('653121','653100','650000','疏附县','653121','0');
REPLACE INTO `pw_area` VALUES('653122','653100','650000','疏勒县','653122','0');
REPLACE INTO `pw_area` VALUES('653123','653100','650000','英吉沙县','653123','0');
REPLACE INTO `pw_area` VALUES('653124','653100','650000','泽普县','653124','0');
REPLACE INTO `pw_area` VALUES('653125','653100','650000','莎车县','653125','0');
REPLACE INTO `pw_area` VALUES('653126','653100','650000','叶城县','653126','0');
REPLACE INTO `pw_area` VALUES('653127','653100','650000','麦盖提县','653127','0');
REPLACE INTO `pw_area` VALUES('653128','653100','650000','岳普湖县','653128','0');
REPLACE INTO `pw_area` VALUES('653129','653100','650000','伽师县','653129','0');
REPLACE INTO `pw_area` VALUES('653130','653100','650000','巴楚县','653130','0');
REPLACE INTO `pw_area` VALUES('653131','653100','650000','塔什库尔干塔吉克自治县','653131','0');
REPLACE INTO `pw_area` VALUES('653201','653200','650000','和田市','653201','0');
REPLACE INTO `pw_area` VALUES('653221','653200','650000','和田县','653221','0');
REPLACE INTO `pw_area` VALUES('653222','653200','650000','墨玉县','653222','0');
REPLACE INTO `pw_area` VALUES('653223','653200','650000','皮山县','653223','0');
REPLACE INTO `pw_area` VALUES('653224','653200','650000','洛浦县','653224','0');
REPLACE INTO `pw_area` VALUES('653225','653200','650000','策勒县','653225','0');
REPLACE INTO `pw_area` VALUES('653226','653200','650000','于田县','653226','0');
REPLACE INTO `pw_area` VALUES('653227','653200','650000','民丰县','653227','0');
REPLACE INTO `pw_area` VALUES('654002','654000','650000','伊宁市','654002','0');
REPLACE INTO `pw_area` VALUES('654003','654000','650000','奎屯市','654003','0');
REPLACE INTO `pw_area` VALUES('654021','654000','650000','伊宁县','654021','0');
REPLACE INTO `pw_area` VALUES('654022','654000','650000','察布查尔锡伯自治县','654022','0');
REPLACE INTO `pw_area` VALUES('654023','654000','650000','霍城县','654023','0');
REPLACE INTO `pw_area` VALUES('654024','654000','650000','巩留县','654024','0');
REPLACE INTO `pw_area` VALUES('654025','654000','650000','新源县','654025','0');
REPLACE INTO `pw_area` VALUES('654026','654000','650000','昭苏县','654026','0');
REPLACE INTO `pw_area` VALUES('654027','654000','650000','特克斯县','654027','0');
REPLACE INTO `pw_area` VALUES('654028','654000','650000','尼勒克县','654028','0');
REPLACE INTO `pw_area` VALUES('654201','654200','650000','塔城市','654201','0');
REPLACE INTO `pw_area` VALUES('654202','654200','650000','乌苏市','654202','0');
REPLACE INTO `pw_area` VALUES('654221','654200','650000','额敏县','654221','0');
REPLACE INTO `pw_area` VALUES('654223','654200','650000','沙湾县','654223','0');
REPLACE INTO `pw_area` VALUES('654224','654200','650000','托里县','654224','0');
REPLACE INTO `pw_area` VALUES('654225','654200','650000','裕民县','654225','0');
REPLACE INTO `pw_area` VALUES('654226','654200','650000','和布克赛尔蒙古自治县','654226','0');
REPLACE INTO `pw_area` VALUES('654301','654300','650000','阿勒泰市','654301','0');
REPLACE INTO `pw_area` VALUES('654321','654300','650000','布尔津县','654321','0');
REPLACE INTO `pw_area` VALUES('654322','654300','650000','富蕴县','654322','0');
REPLACE INTO `pw_area` VALUES('654323','654300','650000','福海县','654323','0');
REPLACE INTO `pw_area` VALUES('654324','654300','650000','哈巴河县','654324','0');
REPLACE INTO `pw_area` VALUES('654325','654300','650000','青河县','654325','0');
REPLACE INTO `pw_area` VALUES('654326','654300','650000','吉木乃县','654326','0');
REPLACE INTO `pw_area` VALUES('659001','659000','650000','石河子市','659001','0');
REPLACE INTO `pw_area` VALUES('659002','659000','650000','阿拉尔市','659002','0');
REPLACE INTO `pw_area` VALUES('659003','659000','650000','图木舒克市','659003','0');
REPLACE INTO `pw_area` VALUES('659004','659000','650000','五家渠市','659004','0');
DROP TABLE IF EXISTS `pw_cache_1`;
CREATE TABLE `pw_cache_1` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_10`;
CREATE TABLE `pw_cache_10` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_2`;
CREATE TABLE `pw_cache_2` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_3`;
CREATE TABLE `pw_cache_3` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_4`;
CREATE TABLE `pw_cache_4` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_5`;
CREATE TABLE `pw_cache_5` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_6`;
CREATE TABLE `pw_cache_6` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_7`;
CREATE TABLE `pw_cache_7` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_8`;
CREATE TABLE `pw_cache_8` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_9`;
CREATE TABLE `pw_cache_9` (
  `name` char(16) NOT NULL,
  `value` text NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_cache_order`;
CREATE TABLE `pw_cache_order` (
  `userid` varchar(32) NOT NULL,
  `goodsid` varchar(255) NOT NULL,
  `standard` varchar(255) NOT NULL,
  `num` varchar(255) NOT NULL,
  UNIQUE KEY `userid` (`userid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_city`;
CREATE TABLE `pw_city` (
  `proid` mediumint(8) NOT NULL,
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `geocode` mediumint(8) NOT NULL,
  `spell` varchar(128) NOT NULL,
  `initial` varchar(4) NOT NULL,
  `istop` tinyint(1) NOT NULL DEFAULT '0',
  `iswww` tinyint(1) NOT NULL DEFAULT '0',
  `color` varchar(7) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `spell` (`spell`),
  KEY `proid` (`proid`),
  KEY `initial` (`initial`),
  KEY `istop` (`istop`),
  KEY `iswww` (`iswww`),
  KEY `geocode` (`geocode`)
) ENGINE=MyISAM AUTO_INCREMENT=659001 DEFAULT CHARSET=utf8;
REPLACE INTO `pw_city` VALUES('110000','110100','市辖区','110100','110100','S','0','0','');
REPLACE INTO `pw_city` VALUES('110000','110200','县','110200','110200','X','0','0','');
REPLACE INTO `pw_city` VALUES('120000','120100','市辖区','120100','120100','S','0','0','');
REPLACE INTO `pw_city` VALUES('120000','120200','县','120200','120200','X','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130100','石家庄市','130100','130100','S','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130200','唐山市','130200','130200','T','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130300','秦皇岛市','130300','130300','Q','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130400','邯郸市','130400','130400','H','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130500','邢台市','130500','130500','X','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130600','保定市','130600','130600','B','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130700','张家口市','130700','130700','Z','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130800','承德市','130800','130800','C','0','0','');
REPLACE INTO `pw_city` VALUES('130000','130900','沧州市','130900','130900','C','0','0','');
REPLACE INTO `pw_city` VALUES('130000','131000','廊坊市','131000','131000','L','0','0','');
REPLACE INTO `pw_city` VALUES('130000','131100','衡水市','131100','131100','H','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140100','太原市','140100','140100','T','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140200','大同市','140200','140200','D','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140300','阳泉市','140300','140300','Y','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140400','长治市','140400','140400','C','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140500','晋城市','140500','140500','J','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140600','朔州市','140600','140600','S','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140700','晋中市','140700','140700','J','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140800','运城市','140800','140800','Y','0','0','');
REPLACE INTO `pw_city` VALUES('140000','140900','忻州市','140900','140900','X','0','0','');
REPLACE INTO `pw_city` VALUES('140000','141000','临汾市','141000','141000','L','0','0','');
REPLACE INTO `pw_city` VALUES('140000','141100','吕梁市','141100','141100','L','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150100','呼和浩特市','150100','150100','H','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150200','包头市','150200','150200','B','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150300','乌海市','150300','150300','W','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150400','赤峰市','150400','150400','C','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150500','通辽市','150500','150500','T','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150600','鄂尔多斯市','150600','150600','E','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150700','呼伦贝尔市','150700','150700','H','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150800','巴彦淖尔市','150800','150800','B','0','0','');
REPLACE INTO `pw_city` VALUES('150000','150900','乌兰察布市','150900','150900','W','0','0','');
REPLACE INTO `pw_city` VALUES('150000','152200','兴安盟','152200','152200','X','0','0','');
REPLACE INTO `pw_city` VALUES('150000','152500','锡林郭勒盟','152500','152500','X','0','0','');
REPLACE INTO `pw_city` VALUES('150000','152900','阿拉善盟','152900','152900','A','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210100','沈阳市','210100','210100','S','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210200','大连市','210200','210200','D','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210300','鞍山市','210300','210300','A','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210400','抚顺市','210400','210400','F','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210500','本溪市','210500','210500','B','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210600','丹东市','210600','210600','D','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210700','锦州市','210700','210700','J','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210800','营口市','210800','210800','Y','0','0','');
REPLACE INTO `pw_city` VALUES('210000','210900','阜新市','210900','210900','F','0','0','');
REPLACE INTO `pw_city` VALUES('210000','211000','辽阳市','211000','211000','L','0','0','');
REPLACE INTO `pw_city` VALUES('210000','211100','盘锦市','211100','211100','P','0','0','');
REPLACE INTO `pw_city` VALUES('210000','211200','铁岭市','211200','211200','T','0','0','');
REPLACE INTO `pw_city` VALUES('210000','211300','朝阳市','211300','211300','C','0','0','');
REPLACE INTO `pw_city` VALUES('210000','211400','葫芦岛市','211400','211400','H','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220100','长春市','220100','220100','C','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220200','吉林市','220200','220200','J','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220300','四平市','220300','220300','S','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220400','辽源市','220400','220400','L','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220500','通化市','220500','220500','T','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220600','白山市','220600','220600','B','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220700','松原市','220700','220700','S','0','0','');
REPLACE INTO `pw_city` VALUES('220000','220800','白城市','220800','220800','B','0','0','');
REPLACE INTO `pw_city` VALUES('220000','222400','延边朝鲜族自治州','222400','222400','Y','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230100','哈尔滨市','230100','230100','H','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230200','齐齐哈尔市','230200','230200','Q','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230300','鸡西市','230300','230300','J','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230400','鹤岗市','230400','230400','H','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230500','双鸭山市','230500','230500','S','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230600','大庆市','230600','230600','D','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230700','伊春市','230700','230700','Y','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230800','佳木斯市','230800','230800','J','0','0','');
REPLACE INTO `pw_city` VALUES('230000','230900','七台河市','230900','230900','Q','0','0','');
REPLACE INTO `pw_city` VALUES('230000','231000','牡丹江市','231000','231000','M','0','0','');
REPLACE INTO `pw_city` VALUES('230000','231100','黑河市','231100','231100','H','0','0','');
REPLACE INTO `pw_city` VALUES('230000','231200','绥化市','231200','231200','S','0','0','');
REPLACE INTO `pw_city` VALUES('230000','232700','大兴安岭地区','232700','232700','D','0','0','');
REPLACE INTO `pw_city` VALUES('310000','310100','市辖区','310100','310100','S','0','0','');
REPLACE INTO `pw_city` VALUES('310000','310200','县','310200','310200','X','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320100','南京市','320100','320100','N','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320200','无锡市','320200','320200','W','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320300','徐州市','320300','320300','X','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320400','常州市','320400','320400','C','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320500','苏州市','320500','320500','S','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320600','南通市','320600','320600','N','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320700','连云港市','320700','320700','L','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320800','淮安市','320800','320800','H','0','0','');
REPLACE INTO `pw_city` VALUES('320000','320900','盐城市','320900','320900','Y','0','0','');
REPLACE INTO `pw_city` VALUES('320000','321000','扬州市','321000','321000','Y','0','0','');
REPLACE INTO `pw_city` VALUES('320000','321100','镇江市','321100','321100','Z','0','0','');
REPLACE INTO `pw_city` VALUES('320000','321200','泰州市','321200','321200','T','0','0','');
REPLACE INTO `pw_city` VALUES('320000','321300','宿迁市','321300','321300','S','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330100','杭州市','330100','330100','H','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330200','宁波市','330200','330200','N','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330300','温州市','330300','330300','W','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330400','嘉兴市','330400','330400','J','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330500','湖州市','330500','330500','H','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330600','绍兴市','330600','330600','S','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330700','金华市','330700','330700','J','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330800','衢州市','330800','330800','','0','0','');
REPLACE INTO `pw_city` VALUES('330000','330900','舟山市','330900','330900','Z','0','0','');
REPLACE INTO `pw_city` VALUES('330000','331000','台州市','331000','331000','T','0','0','');
REPLACE INTO `pw_city` VALUES('330000','331100','丽水市','331100','331100','L','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340100','合肥市','340100','340100','H','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340200','芜湖市','340200','340200','W','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340300','蚌埠市','340300','340300','B','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340400','淮南市','340400','340400','H','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340500','马鞍山市','340500','340500','M','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340600','淮北市','340600','340600','H','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340700','铜陵市','340700','340700','T','0','0','');
REPLACE INTO `pw_city` VALUES('340000','340800','安庆市','340800','340800','A','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341000','黄山市','341000','341000','H','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341100','滁州市','341100','341100','C','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341200','阜阳市','341200','341200','F','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341300','宿州市','341300','341300','S','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341500','六安市','341500','341500','L','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341600','亳州市','341600','341600','','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341700','池州市','341700','341700','C','0','0','');
REPLACE INTO `pw_city` VALUES('340000','341800','宣城市','341800','341800','X','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350100','福州市','350100','350100','F','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350200','厦门市','350200','350200','X','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350300','莆田市','350300','350300','P','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350400','三明市','350400','350400','S','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350500','泉州市','350500','350500','Q','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350600','漳州市','350600','350600','Z','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350700','南平市','350700','350700','N','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350800','龙岩市','350800','350800','L','0','0','');
REPLACE INTO `pw_city` VALUES('350000','350900','宁德市','350900','350900','N','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360100','南昌市','360100','360100','N','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360200','景德镇市','360200','360200','J','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360300','萍乡市','360300','360300','P','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360400','九江市','360400','360400','J','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360500','新余市','360500','360500','X','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360600','鹰潭市','360600','360600','Y','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360700','赣州市','360700','360700','G','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360800','吉安市','360800','360800','J','0','0','');
REPLACE INTO `pw_city` VALUES('360000','360900','宜春市','360900','360900','Y','0','0','');
REPLACE INTO `pw_city` VALUES('360000','361000','抚州市','361000','361000','F','0','0','');
REPLACE INTO `pw_city` VALUES('360000','361100','上饶市','361100','361100','S','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370100','济南市','370100','370100','J','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370200','青岛市','370200','370200','Q','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370300','淄博市','370300','370300','Z','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370400','枣庄市','370400','370400','Z','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370500','东营市','370500','370500','D','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370600','烟台市','370600','370600','Y','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370700','潍坊市','370700','370700','W','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370800','济宁市','370800','370800','J','0','0','');
REPLACE INTO `pw_city` VALUES('370000','370900','泰安市','370900','370900','T','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371000','威海市','371000','371000','W','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371100','日照市','371100','371100','R','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371200','莱芜市','371200','371200','L','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371300','临沂市','371300','371300','L','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371400','德州市','371400','371400','D','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371500','聊城市','371500','371500','L','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371600','滨州市','371600','371600','B','0','0','');
REPLACE INTO `pw_city` VALUES('370000','371700','菏泽市','371700','371700','H','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410100','郑州市','410100','410100','Z','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410200','开封市','410200','410200','K','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410300','洛阳市','410300','410300','L','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410400','平顶山市','410400','410400','P','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410500','安阳市','410500','410500','A','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410600','鹤壁市','410600','410600','H','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410700','新乡市','410700','410700','X','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410800','焦作市','410800','410800','J','0','0','');
REPLACE INTO `pw_city` VALUES('410000','410900','濮阳市','410900','410900','','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411000','许昌市','411000','411000','X','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411100','漯河市','411100','411100','','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411200','三门峡市','411200','411200','S','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411300','南阳市','411300','411300','N','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411400','商丘市','411400','411400','S','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411500','信阳市','411500','411500','X','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411600','周口市','411600','411600','Z','0','0','');
REPLACE INTO `pw_city` VALUES('410000','411700','驻马店市','411700','411700','Z','0','0','');
REPLACE INTO `pw_city` VALUES('410000','419000','省直辖县级行政区划','419000','419000','S','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420100','武汉市','420100','420100','W','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420200','黄石市','420200','420200','H','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420300','十堰市','420300','420300','S','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420500','宜昌市','420500','420500','Y','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420600','襄阳市','420600','420600','X','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420700','鄂州市','420700','420700','E','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420800','荆门市','420800','420800','J','0','0','');
REPLACE INTO `pw_city` VALUES('420000','420900','孝感市','420900','420900','X','0','0','');
REPLACE INTO `pw_city` VALUES('420000','421000','荆州市','421000','421000','J','0','0','');
REPLACE INTO `pw_city` VALUES('420000','421100','黄冈市','421100','421100','H','0','0','');
REPLACE INTO `pw_city` VALUES('420000','421200','咸宁市','421200','421200','X','0','0','');
REPLACE INTO `pw_city` VALUES('420000','421300','随州市','421300','421300','S','0','0','');
REPLACE INTO `pw_city` VALUES('420000','422800','恩施土家族苗族自治州','422800','422800','E','0','0','');
REPLACE INTO `pw_city` VALUES('420000','429000','省直辖县级行政区划','429000','429000','S','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430100','长沙市','430100','430100','C','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430200','株洲市','430200','430200','Z','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430300','湘潭市','430300','430300','X','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430400','衡阳市','430400','430400','H','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430500','邵阳市','430500','430500','S','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430600','岳阳市','430600','430600','Y','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430700','常德市','430700','430700','C','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430800','张家界市','430800','430800','Z','0','0','');
REPLACE INTO `pw_city` VALUES('430000','430900','益阳市','430900','430900','Y','0','0','');
REPLACE INTO `pw_city` VALUES('430000','431000','郴州市','431000','431000','C','0','0','');
REPLACE INTO `pw_city` VALUES('430000','431100','永州市','431100','431100','Y','0','0','');
REPLACE INTO `pw_city` VALUES('430000','431200','怀化市','431200','431200','H','0','0','');
REPLACE INTO `pw_city` VALUES('430000','431300','娄底市','431300','431300','L','0','0','');
REPLACE INTO `pw_city` VALUES('430000','433100','湘西土家族苗族自治州','433100','433100','X','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440100','广州市','440100','440100','G','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440200','韶关市','440200','440200','S','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440300','深圳市','440300','440300','S','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440400','珠海市','440400','440400','Z','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440500','汕头市','440500','440500','S','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440600','佛山市','440600','440600','F','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440700','江门市','440700','440700','J','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440800','湛江市','440800','440800','Z','0','0','');
REPLACE INTO `pw_city` VALUES('440000','440900','茂名市','440900','440900','M','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441200','肇庆市','441200','441200','Z','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441300','惠州市','441300','441300','H','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441400','梅州市','441400','441400','M','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441500','汕尾市','441500','441500','S','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441600','河源市','441600','441600','H','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441700','阳江市','441700','441700','Y','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441800','清远市','441800','441800','Q','0','0','');
REPLACE INTO `pw_city` VALUES('440000','441900','东莞市','441900','441900','D','0','0','');
REPLACE INTO `pw_city` VALUES('440000','442000','中山市','442000','442000','Z','0','0','');
REPLACE INTO `pw_city` VALUES('440000','445100','潮州市','445100','445100','C','0','0','');
REPLACE INTO `pw_city` VALUES('440000','445200','揭阳市','445200','445200','J','0','0','');
REPLACE INTO `pw_city` VALUES('440000','445300','云浮市','445300','445300','Y','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450100','南宁市','450100','450100','N','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450200','柳州市','450200','450200','L','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450300','桂林市','450300','450300','G','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450400','梧州市','450400','450400','W','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450500','北海市','450500','450500','B','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450600','防城港市','450600','450600','F','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450700','钦州市','450700','450700','Q','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450800','贵港市','450800','450800','G','0','0','');
REPLACE INTO `pw_city` VALUES('450000','450900','玉林市','450900','450900','Y','0','0','');
REPLACE INTO `pw_city` VALUES('450000','451000','百色市','451000','451000','B','0','0','');
REPLACE INTO `pw_city` VALUES('450000','451100','贺州市','451100','451100','H','0','0','');
REPLACE INTO `pw_city` VALUES('450000','451200','河池市','451200','451200','H','0','0','');
REPLACE INTO `pw_city` VALUES('450000','451300','来宾市','451300','451300','L','0','0','');
REPLACE INTO `pw_city` VALUES('450000','451400','崇左市','451400','451400','C','0','0','');
REPLACE INTO `pw_city` VALUES('460000','460100','海口市','460100','460100','H','0','0','');
REPLACE INTO `pw_city` VALUES('460000','460200','三亚市','460200','460200','S','0','0','');
REPLACE INTO `pw_city` VALUES('460000','460300','三沙市','460300','460300','S','0','0','');
REPLACE INTO `pw_city` VALUES('460000','469000','省直辖县级行政区划','469000','469000','S','0','0','');
REPLACE INTO `pw_city` VALUES('500000','500100','市辖区','500100','500100','S','0','0','');
REPLACE INTO `pw_city` VALUES('500000','500200','县','500200','500200','X','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510100','成都市','510100','510100','C','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510300','自贡市','510300','510300','Z','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510400','攀枝花市','510400','510400','P','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510500','泸州市','510500','510500','','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510600','德阳市','510600','510600','D','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510700','绵阳市','510700','510700','M','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510800','广元市','510800','510800','G','0','0','');
REPLACE INTO `pw_city` VALUES('510000','510900','遂宁市','510900','510900','S','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511000','内江市','511000','511000','N','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511100','乐山市','511100','511100','L','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511300','南充市','511300','511300','N','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511400','眉山市','511400','511400','M','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511500','宜宾市','511500','511500','Y','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511600','广安市','511600','511600','G','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511700','达州市','511700','511700','D','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511800','雅安市','511800','511800','Y','0','0','');
REPLACE INTO `pw_city` VALUES('510000','511900','巴中市','511900','511900','B','0','0','');
REPLACE INTO `pw_city` VALUES('510000','512000','资阳市','512000','512000','Z','0','0','');
REPLACE INTO `pw_city` VALUES('510000','513200','阿坝藏族羌族自治州','513200','513200','A','0','0','');
REPLACE INTO `pw_city` VALUES('510000','513300','甘孜藏族自治州','513300','513300','G','0','0','');
REPLACE INTO `pw_city` VALUES('510000','513400','凉山彝族自治州','513400','513400','L','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520100','贵阳市','520100','520100','G','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520200','六盘水市','520200','520200','L','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520300','遵义市','520300','520300','Z','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520400','安顺市','520400','520400','A','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520500','毕节市','520500','520500','B','0','0','');
REPLACE INTO `pw_city` VALUES('520000','520600','铜仁市','520600','520600','T','0','0','');
REPLACE INTO `pw_city` VALUES('520000','522300','黔西南布依族苗族自治州','522300','522300','Q','0','0','');
REPLACE INTO `pw_city` VALUES('520000','522600','黔东南苗族侗族自治州','522600','522600','Q','0','0','');
REPLACE INTO `pw_city` VALUES('520000','522700','黔南布依族苗族自治州','522700','522700','Q','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530100','昆明市','530100','530100','K','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530300','曲靖市','530300','530300','Q','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530400','玉溪市','530400','530400','Y','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530500','保山市','530500','530500','B','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530600','昭通市','530600','530600','Z','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530700','丽江市','530700','530700','L','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530800','普洱市','530800','530800','P','0','0','');
REPLACE INTO `pw_city` VALUES('530000','530900','临沧市','530900','530900','L','0','0','');
REPLACE INTO `pw_city` VALUES('530000','532300','楚雄彝族自治州','532300','532300','C','0','0','');
REPLACE INTO `pw_city` VALUES('530000','532500','红河哈尼族彝族自治州','532500','532500','H','0','0','');
REPLACE INTO `pw_city` VALUES('530000','532600','文山壮族苗族自治州','532600','532600','W','0','0','');
REPLACE INTO `pw_city` VALUES('530000','532800','西双版纳傣族自治州','532800','532800','X','0','0','');
REPLACE INTO `pw_city` VALUES('530000','532900','大理白族自治州','532900','532900','D','0','0','');
REPLACE INTO `pw_city` VALUES('530000','533100','德宏傣族景颇族自治州','533100','533100','D','0','0','');
REPLACE INTO `pw_city` VALUES('530000','533300','怒江傈僳族自治州','533300','533300','N','0','0','');
REPLACE INTO `pw_city` VALUES('530000','533400','迪庆藏族自治州','533400','533400','D','0','0','');
REPLACE INTO `pw_city` VALUES('540000','540100','拉萨市','540100','540100','L','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542100','昌都地区','542100','542100','C','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542200','山南地区','542200','542200','S','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542300','日喀则地区','542300','542300','R','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542400','那曲地区','542400','542400','N','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542500','阿里地区','542500','542500','A','0','0','');
REPLACE INTO `pw_city` VALUES('540000','542600','林芝地区','542600','542600','L','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610100','西安市','610100','610100','X','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610200','铜川市','610200','610200','T','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610300','宝鸡市','610300','610300','B','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610400','咸阳市','610400','610400','X','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610500','渭南市','610500','610500','W','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610600','延安市','610600','610600','Y','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610700','汉中市','610700','610700','H','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610800','榆林市','610800','610800','Y','0','0','');
REPLACE INTO `pw_city` VALUES('610000','610900','安康市','610900','610900','A','0','0','');
REPLACE INTO `pw_city` VALUES('610000','611000','商洛市','611000','611000','S','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620100','兰州市','620100','620100','L','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620200','嘉峪关市','620200','620200','J','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620300','金昌市','620300','620300','J','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620400','白银市','620400','620400','B','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620500','天水市','620500','620500','T','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620600','武威市','620600','620600','W','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620700','张掖市','620700','620700','Z','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620800','平凉市','620800','620800','P','0','0','');
REPLACE INTO `pw_city` VALUES('620000','620900','酒泉市','620900','620900','J','0','0','');
REPLACE INTO `pw_city` VALUES('620000','621000','庆阳市','621000','621000','Q','0','0','');
REPLACE INTO `pw_city` VALUES('620000','621100','定西市','621100','621100','D','0','0','');
REPLACE INTO `pw_city` VALUES('620000','621200','陇南市','621200','621200','L','0','0','');
REPLACE INTO `pw_city` VALUES('620000','622900','临夏回族自治州','622900','622900','L','0','0','');
REPLACE INTO `pw_city` VALUES('620000','623000','甘南藏族自治州','623000','623000','G','0','0','');
REPLACE INTO `pw_city` VALUES('630000','630100','西宁市','630100','630100','X','0','0','');
REPLACE INTO `pw_city` VALUES('630000','630200','海东市','630200','630200','H','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632200','海北藏族自治州','632200','632200','H','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632300','黄南藏族自治州','632300','632300','H','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632500','海南藏族自治州','632500','632500','H','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632600','果洛藏族自治州','632600','632600','G','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632700','玉树藏族自治州','632700','632700','Y','0','0','');
REPLACE INTO `pw_city` VALUES('630000','632800','海西蒙古族藏族自治州','632800','632800','H','0','0','');
REPLACE INTO `pw_city` VALUES('640000','640100','银川市','640100','640100','Y','0','0','');
REPLACE INTO `pw_city` VALUES('640000','640200','石嘴山市','640200','640200','S','0','0','');
REPLACE INTO `pw_city` VALUES('640000','640300','吴忠市','640300','640300','W','0','0','');
REPLACE INTO `pw_city` VALUES('640000','640400','固原市','640400','640400','G','0','0','');
REPLACE INTO `pw_city` VALUES('640000','640500','中卫市','640500','640500','Z','0','0','');
REPLACE INTO `pw_city` VALUES('650000','650100','乌鲁木齐市','650100','650100','W','0','0','');
REPLACE INTO `pw_city` VALUES('650000','650200','克拉玛依市','650200','650200','K','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652100','吐鲁番地区','652100','652100','T','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652200','哈密地区','652200','652200','H','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652300','昌吉回族自治州','652300','652300','C','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652700','博尔塔拉蒙古自治州','652700','652700','B','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652800','巴音郭楞蒙古自治州','652800','652800','B','0','0','');
REPLACE INTO `pw_city` VALUES('650000','652900','阿克苏地区','652900','652900','A','0','0','');
REPLACE INTO `pw_city` VALUES('650000','653000','克孜勒苏柯尔克孜自治州','653000','653000','K','0','0','');
REPLACE INTO `pw_city` VALUES('650000','653100','喀什地区','653100','653100','K','0','0','');
REPLACE INTO `pw_city` VALUES('650000','653200','和田地区','653200','653200','H','0','0','');
REPLACE INTO `pw_city` VALUES('650000','654000','伊犁哈萨克自治州','654000','654000','Y','0','0','');
REPLACE INTO `pw_city` VALUES('650000','654200','塔城地区','654200','654200','T','0','0','');
REPLACE INTO `pw_city` VALUES('650000','654300','阿勒泰地区','654300','654300','A','0','0','');
REPLACE INTO `pw_city` VALUES('650000','659000','自治区直辖县级行政区划','659000','659000','Z','0','0','');
DROP TABLE IF EXISTS `pw_config`;
CREATE TABLE `pw_config` (
  `mod` char(16) NOT NULL DEFAULT '540eeeb8f8e9343e' COMMENT '模块',
  `config` text NOT NULL COMMENT '配置信息',
  UNIQUE KEY `mod` (`mod`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='模块配置信息表';
REPLACE INTO `pw_config` VALUES('540eeeb8f8e9343e','{\"site_url\":\"aHR0cDovL3d3dy5leGFtcGxlLmNvbS8=\",\"pw_path\":\"Lw==\",\"site_icpno\":\"5LqsSUNQLXh4eHh4eOWPtw==\",\"contact_email\":\"YWRtaW5Aa2VmdS5jb20=\",\"contact_user\":\"eOWFiOeUnw==\",\"contact_telephone\":\"NDAwOC03MjYtNzk5\",\"contact_fax\":\"MDEwLXh4eHh4eHh4\",\"contact_mobile\":\"MTg4eHh4eHh4eHg=\",\"contact_address\":\"5YyX5Lqs5YWr5aSn6IOh5ZCM\",\"contact_map\":\"MzkuOTMzNDIzNzMwNTQ0NzIsIDExNi4zMDA5NDA1NDAzMjYzNw==\",\"upload_size_limit\":\"Mg==\",\"upload_thumb1_width\":\"NjAw\",\"upload_thumb2_width\":\"MjAw\",\"upload_watermark_enable\":\"MA==\",\"upload_watermark_width\":\"NTUw\",\"upload_watermark_height\":\"MzAw\",\"upload_watermark_pct\":\"NjA=\",\"upload_watermark_pos\":\"OQ==\",\"upload_watermark\":\"dXBsb2FkL2ltYWdlcy91cGxvYWRfd2F0ZXJtYXJrLnBuZw==\",\"mail_type\":\"MQ==\",\"mail_server\":\"c210cC4xMjYuY29t\",\"mail_port\":\"MjU=\",\"mail_user\":\"eHh4eEAxMjYuY29t\",\"mail_pwd\":\"\",\"sms_target\":\"aHR0cDovLzEwNi5paHV5aS5jbi93ZWJzZXJ2aWNlL3Ntcy5waHA/bWV0aG9kPVN1Ym1pdA==\",\"sms_account\":\"\",\"sms_pwd\":\"\",\"sms_template\":\"5oKo55qE6aqM6K+B56CB5piv77ya44CQ5Y+Y6YeP44CR44CC6K+35LiN6KaB5oqK6aqM6K+B56CB5rOE6Zyy57uZ5YW25LuW5Lq644CC\",\"config_gzip\":\"MQ==\",\"memcache_host\":\"MTI3LjAuMC4x\",\"memcache_port\":\"MTEyMTE=\",\"memcache_timeout\":\"MTA=\",\"cache_mysql_db\":\"MTA=\",\"cache_ttl\":\"MQ==\",\"safety_360\":\"MA==\",\"admin_file\":\"cGhwd2VjaGF0LnBocA==\",\"admin_log\":\"MQ==\",\"captcha_width\":\"OTA=\",\"captcha_height\":\"MzU=\",\"captcha_len\":\"NA==\",\"cookie_domain\":\"\",\"cookie_path\":\"Lw==\",\"cookie_pre\":\"OVdTTkE0S0tMSkxLSktMSkxLSkxLSkpM\",\"cookie_ttl\":\"MA==\",\"config_rewrite\":\"MA==\",\"work_time\":\"5ZGo5LiA6Iez5ZGo5LqUOTowMH4xODowMA==\",\"d_path\":\"Lw==\"}');
REPLACE INTO `pw_config` VALUES('0f1cec0f9a6cb70e','{\"pc_site_url\":\"aHR0cDovL3d3dy5leGFtcGxlLmNvbS8=\",\"pc_site_name\":\"cGhwV2VDaGF05ryU56S6\",\"pc_site_title\":\"cGhwV2VDaGF05ryU56S6\",\"pc_site_keywords\":\"cGhwV2VDaGF0LOW+ruS/oSzlvq7kv6HlhazkvJflubPlj7A=\",\"pc_site_description\":\"cGhwV2VjaGF0IOaYr+eUseS4gOS4quWFt+acieWkmuW5tOihjOS4muW8gOWPkee7j+mqjOeahOWJjeerryBVSSDorr7orqHluIjjgIFQSFDlvIDlj5Hlt6XnqIvluIjnu4TmiJDnmoTlm6LpmJ/orr7orqHjgIHnoJTlj5HnmoTkuIDlpZfnmoTlvq7kv6HlhazkvJflubPlj7DnrqHnkIbns7vnu5/vvIzmgqjlj6/ku6Xnnqzpl7TlrozmiJDkuIDkuKrlhazlhbHlj7fmiJbogIVQQ+ermeaIluiAheS4pOiAheeahuacieeahOW5s+WPsOaQreW7uuOAgiA=\",\"pc_site_copyright\":\"QCBwaHBXZUNoYXQgMjAwOS0yMDE2IOeJiOadg+aJgOaciQ==\",\"pc_site_logo\":\"\",\"template\":\"ZGVmYXVsdA==\",\"pc_template\":\"ZGVmYXVsdA==\"}');
REPLACE INTO `pw_config` VALUES('5f04a16bb093201a','{\"wechat_subscribe_msg_type\":\"bWVkaWE=\",\"wechat_subscribe_msg_value\":\"a1RtTjVlMmhfT2F3bi1mVTJPWHhJSjUwUkN5OGY1eHlGWmhiUmdQN0lRQQ==\",\"wechat_token\":\"c2R4dlRRTGxOaGlFazlkOFBzWXpVcHpUb3FVV01Fb28=\",\"wechat_encodingaeskey\":\"TVRXSnp2dWFHa2hpNmlwTmZ5QTB5ZlZQY25lcWN0bDJlMjRudnBiR0tyYQ==\",\"wechat_name\":\"cGhwV2VDaGF0\",\"wechat_id\":\"\",\"wechat_no\":\"\",\"wechat_appid\":\"\",\"wechat_appsecret\":\"\",\"wechat_qr\":\"\",\"wechat_type\":\"NA==\",\"wechat_isxiaodoubi_on\":\"MA==\",\"wechat_xiaodoubi_key\":\"VTJ3OVVqTndhVU5FYTNCT2JHYzNVV2xQT1RFOWVFNVNhbmRWUVVGQlBUMA==\",\"wechat_paysignkey\":\"MXEydzNlNHI1dDZ5N3U4aTlvMHAxMTEyMjIzMzM0NDQ=\",\"wechat_mchid\":\"MTM5NjU5OTEwMg==\",\"wechat_apiclient_cert\":\"\",\"wechat_apiclient_key\":\"\",\"wechat_subscribe_msg_text\":\"5qyi6L+O5YWJ5Li06K+X576O6YC46L+e6ZSB77yM5oKo55qE5YWz5rOo5piv5oiR5Lus5pyA5aSn55qE5pSv5oyB77yBW3NtaWxlc18wMV8wMl0=\",\"wechat_auto_msg_type\":\"bWVkaWE=\",\"wechat_auto_msg_value\":\"a1RtTjVlMmhfT2F3bi1mVTJPWHhJUEdfRWpveUVhV1BwcmdsS0tONHdyMA==\",\"wechat_auto_msg_text\":\"5qyi6L+O5YWJ5Li06K+X576O6YC46L+e6ZSB77yM5oKo55qE5YWz5rOo5piv5oiR5Lus5pyA5aSn55qE5pSv5oyB77yBW3NtaWxlc18wMV8wMl0=\",\"wechat_help_msg_type\":\"bWVkaWE=\",\"wechat_help_msg_text\":\"\",\"to_kf_keyword\":\"5a6i5pyN\"}');
REPLACE INTO `pw_config` VALUES('dcb26674c6706093','{\"member_register_on\":\"MQ==\",\"member_login_on\":\"MQ==\",\"member_register_checktype\":\"MA==\"}');
DROP TABLE IF EXISTS `pw_counts`;
CREATE TABLE `pw_counts` (
  `key` char(16) NOT NULL,
  `cachetime` char(10) NOT NULL,
  `count` mediumint(8) NOT NULL,
  UNIQUE KEY `key` (`key`),
  KEY `cachetime` (`cachetime`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_ip`;
CREATE TABLE `pw_ip` (
  `ip` varchar(32) NOT NULL,
  `city` varchar(128) NOT NULL,
  `isp` varchar(64) NOT NULL,
  `lastmodified` char(10) NOT NULL,
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_mem_cache`;
CREATE TABLE `pw_mem_cache` (
  `key` char(16) NOT NULL,
  `value` varchar(512) NOT NULL,
  `expire` char(10) NOT NULL,
  UNIQUE KEY `key` (`key`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `pw_mem_cache` VALUES('fbf76a39ce69f408','-yck2Bn6jm5JHqTZYDeo61za-oF46q0jpe7lldB5S6CIR_K8kyXUlTW-zCV0NSosrYmn3PntIsUKPtC_I0-wPFdHswZX4-JDcnon3b8KumQVPFeAAAGAQ','1489673648');
REPLACE INTO `pw_mem_cache` VALUES('70ac519e703e566a','kgt8ON7yVITDhtdwci0qeapDRNQo1jV7Nq0evrf2tDV5LPefi9IbUThZ7smr9bO4JgDt6_nDxpoabf4EXVzcrQ','1489673648');
DROP TABLE IF EXISTS `pw_member`;
CREATE TABLE `pw_member` (
  `userid` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '会员ID',
  `levelid` mediumint(8) NOT NULL DEFAULT '-1' COMMENT '等级ID',
  `username` varchar(64) NOT NULL COMMENT '会员账号',
  `userpwd` varchar(32) NOT NULL COMMENT '登录密码',
  `regtime` char(10) NOT NULL COMMENT '注册时间',
  `regip` varchar(32) NOT NULL COMMENT '注册IP',
  `logintime` char(10) NOT NULL COMMENT '最后登录时间',
  `loginip` varchar(32) NOT NULL COMMENT '最后登录IP',
  `headimgurl` varchar(255) NOT NULL DEFAULT '/statics/images/avatar.png' COMMENT '头像',
  `telephone` varchar(32) NOT NULL COMMENT '手机',
  `email` varchar(64) NOT NULL COMMENT '邮箱',
  `credits` mediumint(8) NOT NULL DEFAULT '0' COMMENT '积分',
  `amount` double(8,2) NOT NULL DEFAULT '0.00' COMMENT '余额',
  `openid` varchar(128) NOT NULL COMMENT '公共号OpenID',
  `isagent` tinyint(1) NOT NULL DEFAULT '0',
  `parentagent` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`),
  KEY `userpwd` (`userpwd`),
  KEY `telephone` (`telephone`),
  KEY `email` (`email`),
  KEY `levelid` (`levelid`),
  KEY `openid` (`openid`),
  KEY `parentagent` (`parentagent`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员表';
DROP TABLE IF EXISTS `pw_member_address`;
CREATE TABLE `pw_member_address` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '地址ID',
  `userid` mediumint(8) NOT NULL COMMENT '所属会员ID',
  `realname` varchar(128) NOT NULL COMMENT '联系人',
  `telephone` varchar(32) NOT NULL COMMENT '手机',
  `province` mediumint(8) NOT NULL DEFAULT '0' COMMENT '省份',
  `city` mediumint(8) NOT NULL DEFAULT '0' COMMENT '城市',
  `area` mediumint(8) NOT NULL DEFAULT '0' COMMENT '区域',
  `address` varchar(160) NOT NULL COMMENT '详细地址',
  `postcode` varchar(16) NOT NULL COMMENT '邮编',
  `location_x` varchar(32) NOT NULL COMMENT '地图经度',
  `location_y` varchar(32) NOT NULL COMMENT '地图纬度',
  `default` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是默认地址 1是 0否',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `default` (`default`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='会员收货地址表';
DROP TABLE IF EXISTS `pw_member_amount_log`;
CREATE TABLE `pw_member_amount_log` (
  `userid` mediumint(8) NOT NULL,
  `amounttime` char(10) NOT NULL,
  `inc` tinyint(1) NOT NULL DEFAULT '-1',
  `amount` double(8,2) NOT NULL DEFAULT '0.00',
  `desc` varchar(64) NOT NULL,
  KEY `userid` (`userid`),
  KEY `inc` (`inc`),
  KEY `amounttime` (`amounttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_member_blocked_account`;
CREATE TABLE `pw_member_blocked_account` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `account` double(8,2) NOT NULL DEFAULT '0.00',
  `expiretime` char(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_member_cache`;
CREATE TABLE `pw_member_cache` (
  `userid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `levelid` mediumint(8) NOT NULL DEFAULT '0',
  `username` varchar(64) NOT NULL,
  `userpwd` varchar(32) NOT NULL,
  `regtime` char(10) NOT NULL,
  `regip` varchar(32) NOT NULL,
  `logintime` char(10) NOT NULL,
  `loginip` varchar(32) NOT NULL,
  `headimgurl` varchar(255) NOT NULL DEFAULT '/statics/images/avatar.png',
  `telephone` varchar(32) NOT NULL,
  `email` varchar(64) NOT NULL,
  `credits` mediumint(8) NOT NULL DEFAULT '0',
  `amount` double(8,2) NOT NULL DEFAULT '0.00',
  `openid` varchar(128) NOT NULL,
  `isagent` tinyint(1) NOT NULL DEFAULT '0',
  `parentagent` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`),
  KEY `userpwd` (`userpwd`),
  KEY `telephone` (`telephone`),
  KEY `email` (`email`),
  KEY `levelid` (`levelid`),
  KEY `openid` (`openid`),
  KEY `parentagent` (`parentagent`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_member_credits_log`;
CREATE TABLE `pw_member_credits_log` (
  `userid` mediumint(8) NOT NULL,
  `creditstime` char(10) NOT NULL,
  `inc` tinyint(1) NOT NULL DEFAULT '-1',
  `credits` mediumint(8) NOT NULL DEFAULT '0',
  `desc` varchar(64) NOT NULL,
  KEY `userid` (`userid`),
  KEY `inc` (`inc`),
  KEY `creditstime` (`creditstime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_member_level`;
CREATE TABLE `pw_member_level` (
  `levelid` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '等级ID',
  `name` varchar(64) NOT NULL COMMENT '等级名称',
  `ico` varchar(128) NOT NULL COMMENT '等级图标',
  `mincredits` mediumint(8) NOT NULL DEFAULT '0' COMMENT '升级最少积分值',
  `maxcredits` mediumint(8) NOT NULL DEFAULT '0' COMMENT '升级最大积分值',
  PRIMARY KEY (`levelid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='会员等级表';
REPLACE INTO `pw_member_level` VALUES('1','铜牌会员','','100','500');
REPLACE INTO `pw_member_level` VALUES('2','银牌会员','','500','1000');
REPLACE INTO `pw_member_level` VALUES('-1','普通会员','','0','100');
DROP TABLE IF EXISTS `pw_member_login_log`;
CREATE TABLE `pw_member_login_log` (
  `userid` mediumint(8) NOT NULL,
  `logintime` char(10) NOT NULL,
  `loginip` varchar(32) NOT NULL,
  `loginenv` varchar(64) NOT NULL DEFAULT '电脑',
  KEY `userid` (`userid`),
  KEY `logintime` (`logintime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_module`;
CREATE TABLE `pw_module` (
  `key` char(16) NOT NULL COMMENT '模块Key',
  `parentkey` char(16) NOT NULL DEFAULT '0' COMMENT '父模块Key',
  `name` varchar(32) NOT NULL COMMENT '模块名称',
  `folder` varchar(32) NOT NULL COMMENT '模块文件夹',
  `author` varchar(64) NOT NULL COMMENT '模块作者',
  `issystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否系统自带模块',
  `ispch5` tinyint(1) NOT NULL DEFAULT '0',
  `isuc` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` mediumint(8) NOT NULL DEFAULT '0' COMMENT '显示排序',
  `configmenu` text NOT NULL COMMENT '后台操作菜单',
  `disabled` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁用 ',
  UNIQUE KEY `folder` (`folder`),
  UNIQUE KEY `key` (`key`),
  KEY `issystem` (`issystem`),
  KEY `orderby` (`orderby`),
  KEY `disabled` (`disabled`),
  KEY `parentkey` (`parentkey`),
  KEY `ispch5` (`ispch5`),
  KEY `isuc` (`isuc`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='功能模块表';
REPLACE INTO `pw_module` VALUES('system','0','系统设置','','织信','0','0','0','0','{\"base\":\"基本配置,17\",\"upload\":\"上传配置,29\",\"email\":\"邮件配置,04\",\"sms\":\"短信接口,12\",\"city\":\"地区设置,0c\",\"cache\":\"性能优化,51\",\"safety\":\"安全验证,57\"}','0');
REPLACE INTO `pw_module` VALUES('7a57a5a743894a0e','0','管理后台','admin','织信','1','0','0','0','[]','0');
REPLACE INTO `pw_module` VALUES('dcb26674c6706093','0','会员系统','member','织信','0','1','0','3','[]','0');
REPLACE INTO `pw_module` VALUES('0f1cec0f9a6cb70e','0','PC网站','pc','织信','0','0','0','1','{\"base\":\"基本配置,17\",\"template\":\"模板配置,53\"}','0');
REPLACE INTO `pw_module` VALUES('5f04a16bb093201a','0','微信公众号','wechat','织信','0','0','0','2','{\"config\":\"公众号配置,17\",\"interface\":\"公众号接入,52\",\"wepay\":\"微信支付,58\",\"material\":\"素材管理,29\"}','0');
DROP TABLE IF EXISTS `pw_order`;
CREATE TABLE `pw_order` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '订单ID',
  `out_trade_no` varchar(32) NOT NULL COMMENT '订单号',
  `goodsid` text NOT NULL COMMENT '产品ID',
  `userid` mediumint(8) NOT NULL COMMENT '下单用户ID',
  `addressid` mediumint(8) NOT NULL COMMENT '收货地址ID',
  `total_fee` decimal(8,2) NOT NULL COMMENT '订单总额',
  `total_point` mediumint(8) NOT NULL DEFAULT '0',
  `num` mediumint(8) NOT NULL DEFAULT '1' COMMENT '订单数量',
  `body` varchar(128) NOT NULL COMMENT '订单描述',
  `createtime` char(10) NOT NULL COMMENT '创建时间',
  `paytime` char(10) NOT NULL COMMENT '支付时间',
  `moretime` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '-1' COMMENT '订单状态',
  `mod` varchar(64) NOT NULL COMMENT '所属模块',
  `action` varchar(64) NOT NULL COMMENT '所属操作',
  `note` varchar(255) NOT NULL,
  `extra` text NOT NULL COMMENT '可选字段',
  PRIMARY KEY (`id`),
  UNIQUE KEY `out_trade_no` (`out_trade_no`),
  KEY `status` (`status`),
  KEY `userid` (`userid`),
  KEY `mod` (`mod`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='订单表';
DROP TABLE IF EXISTS `pw_province`;
CREATE TABLE `pw_province` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `geocode` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `geocode` (`geocode`)
) ENGINE=MyISAM AUTO_INCREMENT=820001 DEFAULT CHARSET=utf8;
REPLACE INTO `pw_province` VALUES('110000','北京市','110000');
REPLACE INTO `pw_province` VALUES('120000','天津市','120000');
REPLACE INTO `pw_province` VALUES('130000','河北省','130000');
REPLACE INTO `pw_province` VALUES('140000','山西省','140000');
REPLACE INTO `pw_province` VALUES('150000','内蒙古自治区','150000');
REPLACE INTO `pw_province` VALUES('210000','辽宁省','210000');
REPLACE INTO `pw_province` VALUES('220000','吉林省','220000');
REPLACE INTO `pw_province` VALUES('230000','黑龙江省','230000');
REPLACE INTO `pw_province` VALUES('310000','上海市','310000');
REPLACE INTO `pw_province` VALUES('320000','江苏省','320000');
REPLACE INTO `pw_province` VALUES('330000','浙江省','330000');
REPLACE INTO `pw_province` VALUES('340000','安徽省','340000');
REPLACE INTO `pw_province` VALUES('350000','福建省','350000');
REPLACE INTO `pw_province` VALUES('360000','江西省','360000');
REPLACE INTO `pw_province` VALUES('370000','山东省','370000');
REPLACE INTO `pw_province` VALUES('410000','河南省','410000');
REPLACE INTO `pw_province` VALUES('420000','湖北省','420000');
REPLACE INTO `pw_province` VALUES('430000','湖南省','430000');
REPLACE INTO `pw_province` VALUES('440000','广东省','440000');
REPLACE INTO `pw_province` VALUES('450000','广西壮族自治区','450000');
REPLACE INTO `pw_province` VALUES('460000','海南省','460000');
REPLACE INTO `pw_province` VALUES('500000','重庆市','500000');
REPLACE INTO `pw_province` VALUES('510000','四川省','510000');
REPLACE INTO `pw_province` VALUES('520000','贵州省','520000');
REPLACE INTO `pw_province` VALUES('530000','云南省','530000');
REPLACE INTO `pw_province` VALUES('540000','西藏自治区','540000');
REPLACE INTO `pw_province` VALUES('610000','陕西省','610000');
REPLACE INTO `pw_province` VALUES('620000','甘肃省','620000');
REPLACE INTO `pw_province` VALUES('630000','青海省','630000');
REPLACE INTO `pw_province` VALUES('640000','宁夏回族自治区','640000');
REPLACE INTO `pw_province` VALUES('650000','新疆维吾尔自治区','650000');
REPLACE INTO `pw_province` VALUES('710000','台湾省','710000');
REPLACE INTO `pw_province` VALUES('810000','香港特别行政区','810000');
REPLACE INTO `pw_province` VALUES('820000','澳门特别行政区','820000');
DROP TABLE IF EXISTS `pw_wechat_auto_reply`;
CREATE TABLE `pw_wechat_auto_reply` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `media_id` varchar(128) NOT NULL,
  `keyword` varchar(64) NOT NULL,
  `keyword_type` tinyint(1) NOT NULL DEFAULT '1',
  `content` text NOT NULL,
  `material_type` varchar(64) NOT NULL DEFAULT 'media',
  PRIMARY KEY (`id`),
  KEY `media_id` (`media_id`),
  KEY `keyword_type` (`keyword_type`,`keyword`),
  KEY `material_type` (`material_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_emoji`;
CREATE TABLE `pw_wechat_emoji` (
  `utf16` varchar(32) DEFAULT NULL,
  `emoji` varchar(64) DEFAULT NULL,
  KEY `utf16` (`utf16`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F604','smiles_01_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F60A','smiles_01_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F603','smiles_01_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x263A','smiles_01_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F609','smiles_01_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F60D','smiles_01_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F618','smiles_01_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F61A','smiles_01_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F633','smiles_01_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F60C','smiles_01_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F601','smiles_01_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F61C','smiles_02_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F61D','smiles_02_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F612','smiles_02_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F60F','smiles_02_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F613','smiles_02_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F614','smiles_02_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F61E','smiles_02_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F616','smiles_02_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F625','smiles_02_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F630','smiles_02_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F628','smiles_02_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F623','smiles_03_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F622','smiles_03_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F62D','smiles_03_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F602','smiles_03_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F632','smiles_03_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F631','smiles_03_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F620','smiles_03_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F621','smiles_03_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F62A','smiles_03_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F637','smiles_03_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F47F','smiles_03_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F47D','smiles_04_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F49B','smiles_04_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F499','smiles_04_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F49C','smiles_04_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F497','smiles_04_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F49A','smiles_04_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x2764','smiles_04_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F494','smiles_04_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F493','smiles_04_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F498','smiles_04_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x2728','smiles_04_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F31F','smiles_05_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4A2','smiles_05_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x2755','smiles_05_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x2754','smiles_05_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4A4','smiles_05_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4A8','smiles_05_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4A6','smiles_05_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F3B6','smiles_05_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F3B5','smiles_05_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F525','smiles_05_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4A9','smiles_05_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44D','smiles_06_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44E','smiles_06_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44C','smiles_06_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44A','smiles_06_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x270A','smiles_06_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x270C','smiles_06_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44B','smiles_06_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x270B','smiles_06_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F450','smiles_06_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F446','smiles_06_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F447','smiles_06_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F449','smiles_07_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F448','smiles_07_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F64C','smiles_07_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F64F','smiles_07_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x261D','smiles_07_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F44F','smiles_07_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F4AA','smiles_07_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F6B6','smiles_07_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F3C3','smiles_07_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F46B','smiles_07_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F483','smiles_07_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F46F','smiles_08_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F646','smiles_08_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F645','smiles_08_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F481','smiles_08_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F647','smiles_08_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F48F','smiles_08_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F491','smiles_08_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F486','smiles_08_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F487','smiles_08_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F485','smiles_08_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F466','smiles_08_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F467','smiles_09_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F469','smiles_09_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F468','smiles_09_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F476','smiles_09_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F475','smiles_09_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F474','smiles_09_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F471','smiles_09_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F472','smiles_09_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F473','smiles_09_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F477','smiles_09_10');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F46E','smiles_09_11');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F47C','smiles_10_01');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F478','smiles_10_02');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F482','smiles_10_03');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F480','smiles_10_04');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F463','smiles_10_05');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F48B','smiles_10_06');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F444','smiles_10_07');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F442','smiles_10_08');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F440','smiles_10_09');
REPLACE INTO `pw_wechat_emoji` VALUES('0x1F443','smiles_10_10');
DROP TABLE IF EXISTS `pw_wechat_fans`;
CREATE TABLE `pw_wechat_fans` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `threaduserid` varchar(160) NOT NULL DEFAULT '0',
  `unionid` varchar(128) NOT NULL,
  `groupid` mediumint(8) NOT NULL DEFAULT '0',
  `openid` varchar(128) NOT NULL,
  `nickname` varchar(128) NOT NULL,
  `sex` tinyint(1) NOT NULL DEFAULT '0',
  `language` varchar(32) NOT NULL DEFAULT 'zh_CN',
  `city` varchar(128) NOT NULL,
  `province` varchar(128) NOT NULL,
  `country` varchar(128) NOT NULL,
  `headimgurl` varchar(255) NOT NULL,
  `subscribetime` char(10) NOT NULL,
  `issubscribe` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`),
  KEY `issubscribe` (`issubscribe`),
  KEY `subscribetime` (`subscribetime`),
  KEY `groupid` (`groupid`),
  KEY `unionid` (`unionid`),
  KEY `threaduserid` (`threaduserid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_fans_location`;
CREATE TABLE `pw_wechat_fans_location` (
  `openid` varchar(128) NOT NULL,
  `Location_X` varchar(32) NOT NULL,
  `Location_Y` varchar(32) NOT NULL,
  UNIQUE KEY `openid` (`openid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_groups`;
CREATE TABLE `pw_wechat_groups` (
  `id` mediumint(9) NOT NULL,
  `name` varchar(64) NOT NULL,
  `count` mediumint(8) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `pw_wechat_groups` VALUES('0','未分组','3');
REPLACE INTO `pw_wechat_groups` VALUES('1','黑名单','0');
REPLACE INTO `pw_wechat_groups` VALUES('2','星标组','3');
DROP TABLE IF EXISTS `pw_wechat_hello_article`;
CREATE TABLE `pw_wechat_hello_article` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(128) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_image_material`;
CREATE TABLE `pw_wechat_image_material` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `media_id` varchar(128) NOT NULL,
  `created_at` char(10) NOT NULL,
  `local_url` varchar(128) NOT NULL,
  `remote_url` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `media_id` (`media_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_kf`;
CREATE TABLE `pw_wechat_kf` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `kf_account` varchar(128) NOT NULL,
  `kf_headimgurl` varchar(255) NOT NULL,
  `kf_id` varchar(64) NOT NULL,
  `kf_nick` varchar(128) NOT NULL,
  `password` char(32) NOT NULL,
  `kf_wx` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `kf_id` (`kf_id`),
  KEY `password` (`password`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_masssend`;
CREATE TABLE `pw_wechat_masssend` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `msg_id` mediumint(8) NOT NULL,
  `media_id` varchar(128) NOT NULL,
  `content` text NOT NULL,
  `errcode` mediumint(8) NOT NULL DEFAULT '0',
  `sendtime` char(10) NOT NULL,
  `is_to_all` tinyint(1) NOT NULL DEFAULT '1',
  `tag_id` mediumint(8) NOT NULL DEFAULT '-1',
  `msgtype` varchar(32) NOT NULL DEFAULT 'media',
  PRIMARY KEY (`id`),
  KEY `msg_id` (`msg_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_material`;
CREATE TABLE `pw_wechat_material` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `group_id` mediumint(8) NOT NULL DEFAULT '0',
  `thumb_media_id` varchar(128) NOT NULL,
  `media_id` varchar(128) NOT NULL,
  `Title` varchar(160) NOT NULL,
  `Author` varchar(64) NOT NULL,
  `Description` varchar(255) NOT NULL,
  `Url` varchar(128) NOT NULL,
  `content_source_url` varchar(128) NOT NULL,
  `PicUrl` varchar(128) NOT NULL,
  `UpdateTime` char(10) NOT NULL,
  `Clicks` mediumint(8) NOT NULL DEFAULT '0',
  `Support` mediumint(8) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `orderby` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `orderby` (`orderby`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_menu`;
CREATE TABLE `pw_wechat_menu` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `parentid` mediumint(6) NOT NULL DEFAULT '0',
  `name` varchar(48) NOT NULL,
  `typeid` tinyint(1) NOT NULL DEFAULT '1',
  `keyword` varchar(128) NOT NULL,
  `url` varchar(255) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  `event` varchar(64) NOT NULL,
  `telephone` varchar(32) NOT NULL,
  `location` varchar(64) NOT NULL,
  `orderby` mediumint(8) NOT NULL DEFAULT '0',
  `mod` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `parentid` (`parentid`),
  KEY `orderby` (`orderby`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_qrcode`;
CREATE TABLE `pw_wechat_qrcode` (
  `scene_id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `scene_name` varchar(128) NOT NULL,
  `keyword` varchar(128) NOT NULL,
  `typeid` tinyint(1) NOT NULL DEFAULT '1',
  `ticket` varchar(512) NOT NULL,
  `createtime` char(10) NOT NULL,
  `expiretime` char(10) NOT NULL DEFAULT '0',
  `scan_times` mediumint(8) NOT NULL DEFAULT '0',
  `scan_fans` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`scene_id`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_request`;
CREATE TABLE `pw_wechat_request` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `ToUserName` varchar(64) NOT NULL,
  `FromUserName` varchar(128) NOT NULL,
  `CreateTime` char(10) NOT NULL,
  `MsgType` varchar(32) NOT NULL,
  `Event` varchar(32) NOT NULL,
  `EventKey` text NOT NULL,
  `keyword` text NOT NULL,
  `ip` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FromUserName` (`FromUserName`),
  KEY `MsgType` (`MsgType`),
  KEY `Event` (`Event`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_scan_log`;
CREATE TABLE `pw_wechat_scan_log` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `barcode` varchar(64) NOT NULL,
  `goodsid` mediumint(8) NOT NULL,
  `credits` mediumint(8) NOT NULL DEFAULT '0',
  `scantime` char(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `barcode` (`barcode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_template`;
CREATE TABLE `pw_wechat_template` (
  `template_id` varchar(128) NOT NULL,
  `title` varchar(128) NOT NULL,
  `primary_industry` varchar(128) NOT NULL,
  `deputy_industry` varchar(128) NOT NULL,
  `content` text NOT NULL,
  `example` text NOT NULL,
  UNIQUE KEY `template_id` (`template_id`),
  KEY `primary_industry` (`primary_industry`),
  KEY `deputy_industry` (`deputy_industry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_video_material`;
CREATE TABLE `pw_wechat_video_material` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `media_id` varchar(128) NOT NULL,
  `name` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `created_at` char(10) NOT NULL,
  `thumb` varchar(128) NOT NULL,
  `remote_url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `media_id` (`media_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `pw_wechat_voice_material`;
CREATE TABLE `pw_wechat_voice_material` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `media_id` varchar(128) NOT NULL,
  `created_at` char(10) NOT NULL,
  `local_url` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `media_id` (`media_id`),
  KEY `created_at` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
