<?php
/**
 * User: Warren Xia
 * Date: 15/9/8
 * Time: 下午10:14
 */
$this->pageTitle= '用户注册 - ' . Yii::app()->name;
Yii::app()->getClientScript()->registerCssFile('/static/css/account.css');
?>
<div class="panel panel-primary register-panel">
    <div class="panel-heading">
        <h3 class="panel-title">用户注册</h3>
    </div>
    <div class="panel-body">
            <?php $form=$this->beginWidget('CActiveForm', array(
                'id'=>'register-form',
                'enableClientValidation'=>false,
                'errorMessageCssClass'=>'alert alert-warning',
                'clientOptions'=>array(
                    'validateOnSubmit'=>true,
                ),
            )); ?>
            <div class="form-group">
                <?php echo $form->labelEx($model,'用户名'); ?>
                <?php echo $form->textField($model,'username',array('class'=>'form-control','required'=>'required')); ?>
                <?php echo $form->error($model,'username'); ?>
            </div>
            <div class="form-group">
                <?php echo $form->labelEx($model,'电子邮箱'); ?>
                <?php echo $form->emailField($model,'email',array('class'=>'form-control','required'=>'required')); ?>
                <?php echo $form->error($model,'email'); ?>
            </div>
            <div class="form-group">
                <?php echo $form->labelEx($model,'所属部门'); ?>
                <?php echo $form->dropDownList($model,'group_id',$group,array('class'=>'form-control')); ?>
                <?php echo $form->error($model,'group_id'); ?>
            </div>
            <div class="form-group">
                <?php echo $form->labelEx($model,'密码'); ?>
                <?php echo $form->passwordField($model,'password',array('class'=>'form-control', 'required'=>'required')); ?>
                <?php echo $form->error($model,'password'); ?>
            </div>
            <button onclick="alert('注册功能已关闭，请联系管理员直接添加账号！');return false;" type="submit" class="btn btn-primary">注册</button>
            <a href="<?php echo $this->createUrl('/account/login'); ?>" class="btn btn-default">登录</a>

            <?php $this->endWidget(); ?>
    </div>
</div>
<?php
Yii::app()->getClientScript()->registerScriptFile("/static/js/account.js", CClientScript::POS_END);
?>