<?php
/**
 * lemocms
 * ============================================================================
 * 版权所有 2018-2027 lemocms，并保留所有权利。
 * 网站地址: https://www.lemocms.com
 * ----------------------------------------------------------------------------
 * 采用最新Thinkphp6实现
 * ============================================================================
 * Author: yuege
 * Date: 2019/8/2
 */
namespace app\admin\controller\sys;
use app\common\controller\Backend;
use app\common\traits\Curd;
use think\facade\Request;
use app\admin\model\AdminLog as LogModel;
class Adminlog extends Backend {

    use Curd;
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->modelClass = new LogModel();
    }

    /**
     * @return array|string
     * @throws \think\db\exception\DbException
     */
    public function index(){
        if($this->request->isPost()){
            $keys=$this->request->post('keys','','trim');
//            $page = $this->request->post('page')?$this->request->post('page'):1;
            $list =  $this->modelClass->where('status',1)
               ->where('username|log_title','like','%'.$keys.'%')
               ->order('id desc')
               ->paginate(array('list_rows'=> $this->pageSize,'page'=>$this->page))
               ->toArray();
            if(!empty($list['data'])){
                foreach ($list['data'] as $k => $v) {
                    $useragent = explode('(', $v['log_agent']);
                    $list['data'][$k]['log_agent'] = $useragent[0];
                }
            }
            $result = ['code'=>0,'msg'=>lang('get info success'),'data'=>$list['data'],'count'=>$list['total']];
            return $result;
        }

        return view();
    }


}
