<?php
/**
 * lemocms
 * ============================================================================
 * 版权所有 2018-2027 lemocms，并保留所有权利。
 * 网站地址: https://www.lemocms.com
 * ----------------------------------------------------------------------------
 * 采用最新Thinkphp6实现
 * ============================================================================
 * Author: yuege
 * Date: 2019/8/2
 */
namespace app\admin\controller\sys;
use app\common\controller\Backend;
use app\common\model\Config as ConfigModel;
use app\common\model\ConfigGroup as ConfigGroupModel;
use app\common\model\FieldType;
use app\common\traits\Curd;
use think\facade\Request;
use think\facade\Db;
use think\facade\View;
class System extends Backend {
    use Curd;
    public $rules = [
        ['name'=>'email','title'=>'邮件'],
        ['name'=>'url','title'=>'网址'],
        ['name'=>'number','title'=>'有效的数值'],
        ['name'=>'ip','title'=>'IP'],
        ['name'=>'date','title'=>'日期'],
        ['name'=>'phone','title'=>'手机号'],
        ['name'=>'qq','title'=>'QQ'],
        ['name'=>'identity','title'=>'身份证号'],

    ];
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
    }

    public function index(){
        $group =  ['site','email','upload','sms'];

        $list = Db::name('config')
            ->where('type','in',$group)
            ->field('code,value')
            ->column('value','code');

        View::assign('config',json_encode($list));
        return view();

    }
    //配置设置
    public function site()
    {
        if (Request::isPost()) {
            $data = $this->request->post();
            foreach ($data as $k=>$v){
               $res =  Db::name('config')->where('code',$k)->update(['value'=>$v]);
            }

            $this->success('save success');


        } else {
            $this->error('invalid options');
        }
    }
//    配置列表
    public function configlist(){

        if (Request::isPost()) {
            $keys = $this->request->post('keys', '', 'trim');
            $page = $this->request->post('page') ? $this->request->post('page') : 1;
            $list = Db::name('config')
                ->where('code', 'like', '%' . $keys . '%')
                ->paginate(['list_rows' => $this->pageSize, 'page' => $page])
                ->toArray();
            return $result = ['code' => 0, 'msg' => lang('get info success'), 'data' => $list['data'], 'count' => $list['total']];
        }

        return view();

    }
    //添加配置
    public function configAdd(){
        if(Request::isPost()){
            $data = $this->request->post();
            $info = ConfigModel::where('code',$data['code'])->find();
            if($info){
                $this->error(lang('field already exist'));

            }else{
                $model = new ConfigModel();
                if($model->add($data)){
                    $this->success(lang('edit success'));
                }else{
                    $this->error(lang('edit fail'));
                }
            }


        }
        $info = '';
        $configGroup = Db::name('config_group')->select();
        $fieldType = FieldType::select();

        $view = ['title'=>lang('add'),'info'=>$info,'configGroup'=>$configGroup,'fieldType'=>$fieldType,'rules'=>$this->rules];
        View::assign($view);

        return view('add');
    }
//    编辑配置
    public function configEdit(){
        $id = Request::param('id');
        if(Request::isPost()){
            $info = ConfigModel::find($id);
            $data = $this->request->post();
            $model = new ConfigModel();
            if($model->edit($data)){
                $this->success(lang('edit success'));
            }else{
                $this->error(lang('edit fail'));
            }
        }
        $configGroup = Db::name('config_group')->select();
        $info = ConfigModel::find($id);
        $fieldType = FieldType::select();

        $view = ['title'=>lang('edit'),'info'=>$info,'configGroup'=>$configGroup,'fieldType'=>$fieldType,'rules'=>$this->rules];
        View::assign($view);
        return view('add');
    }
//    删除配置
    public function configDel(){
        if (Request::isPost()) {
            $id = $this->request->post('id');
            if(ConfigModel::destroy($id))
            {
                $this->success('delete success');
            }   else{

                $this->error('delete fail');
            }

        } else {
            $this->error('invalid options');
        }

    }
//    配置状态
    public function configState(){
        $id = $this->request->post('id');
        $data = $this->request->post();

        if (empty($id)) {
            $this->error('data not exist');
        }
        $model = new ConfigModel();
        $model->state($data);
        $this->success(lang('edit success'));
    }

    public function configGroup(){
        $keys = $this->request->post('keys', '', 'trim');
        $page = $this->request->post('page') ? $this->request->post('page') : 1;
        $list = Db::name('config_group')
            ->where('name', 'like', '%' . $keys . '%')
            ->select();
        $info =$list;
        $view = ['title'=>lang('config group'),'info'=>$info];
        View::assign($view);
        return view();


    }
//    配置分组
    public function configGroupAdd(){
        if(Request::isPost()){
            $data = $this->request->post();
            $info = ConfigGroupModel::where('name',$data['name'])->find();
            if($info){
                $this->error(lang('field already exist'));

            }else {
                $model = new ConfigGroupModel();
                if ($model->add($data)) {
                    $this->success(lang('edit success'));
                } else {
                    $this->error(lang('edit fail'));
                }
            }

        }
        $view = ['title'=>lang('config group'),'info'=>''];
        View::assign($view);
        return view('groupadd');

    }

    public function configGroupDel(){
        $id = $this->request->post('id');
        $info = ConfigGroupModel::find($id);
        if(!$info){
            $this->error(lang('id is not exist'));
        }
        $config = ConfigModel::where('type',$info->name)->find();
        if($config){
            $this->error(lang('group has config').lang('delete fail'));

        }
        $model = new ConfigGroupModel();
        if ($model->del($id)) {
            $this->success(lang('delete success'));
        }else{
            $this->error(lang('delete fail'));

        }

    }

//
}