<?php
/**
 * lemocms
 * ============================================================================
 * 版权所有 2018-2027 lemocms，并保留所有权利。
 * 网站地址: https://www.lemocms.com
 * ----------------------------------------------------------------------------
 * 采用最新Thinkphp6实现
 * ============================================================================
 * Author: yuege
 * Date: 2019/8/2
 */
namespace app\admin\controller\ucenter;

use app\common\controller\Backend;
use app\common\traits\Curd;
use think\facade\Request;
use think\facade\View;
use app\common\model\UserLevel;
use app\common\model\User as UserModel;
use think\facade\Db;

class User extends Backend{
    use Curd;
    public function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->modelClass = new UserModel();
    }

    public function index(){
        if (Request::isPost()) {
            $keys = $this->request->post('keys', '', 'trim');
            $page = $this->request->post('page') ? $this->request->post('page') : 1;
            $list = Db::name('user')->alias('u')
                ->where('u.email|u.mobile|u.username','like',"%".$keys."%")
                ->join('userLevel ul','u.level_id = ul.id') //此处表别名不能加as
                ->field('ul.level_name,u.*')
                ->order('u.id desc,u.create_time desc')
                ->paginate(['list_rows' => $this->pageSize, 'page' => $page])
                ->toArray();

            return $result = ['code' => 0, 'msg' => lang('get info success'), 'data' => $list['data'], 'count' => $list['total']];
        }
        return view();

    }

    public function add(){
        if (Request::isPost()) {
            $data = $this->request->post();
            try{
                $this->validate($data, 'User');
            }catch (\Exception $e){
                $this->error($e->getMessage());
            }
            $model = new UserModel();
            $res =$model->add($data);
            if ($res) {
                $this->success(lang('add success'),url('index'));
            } else {
                $this->error(lang('add fail'));
            }
        }
        $userLevel = UserLevel::where('status',1)->select();

        $view = [
            'info' => '',
            'title' => lang('add'),
            'userLevel'=>$userLevel,
        ];
        View::assign($view);
        return view();
    }

    public function edit(){
        if (Request::isPost()) {
            $data = $this->request->post();
            try {
                $this->validate($data, 'User');
            } catch (\Exception $e) {
                $this->error($e->getMessage());
            }
            $model = new UserModel();
            $res =$model->edit($data);
            if ($res) {
                $this->success(lang('edit success'), url('index'));
            } else {
                $this->error(lang('edit fail'));
            }
        }
        $info = UserModel::find(Request::get('id'));
        $userLevel = UserLevel::where('status',1)->select();
        $view = [
            'info' => $info,
            'title' => '修改',
            'userLevel'=>$userLevel,
        ];
        View::assign($view);
        return view('add');

    }
    public function state(){
        $data = $this->request->post();
        $id = $this->request->post('id');
        if($id){
            $model = new UserModel();
            $res =$model->state($data);
            $this->success(lang('edit success'));

        }else{
            $this->error(lang('invalid data'));
        }
    }
    /**---------------用户等级--------------------**/

    public function levelIndex(){
        if (Request::isPost()) {
            $keys = $this->request->post('keys', '', 'trim');
            $page = $this->request->post('page') ? $this->request->post('page') : 1;
            $list = Db::name('user_level')
                ->where('level_name','like',"%".$keys."%")
                ->order('id desc')
                ->paginate(['list_rows' => $this->pageSize, 'page' => $page])
                ->toArray();

            return $result = ['code' => 0, 'msg' => lang('get info success'), 'data' => $list['data'], 'count' => $list['total']];
        }
        return view();
    }

    public function levelAdd(){
        if (Request::isPost()) {
            $data = $this->request->post();
            try{
                $this->validate($data, 'UserLevel');
            }catch (\Exception $e){
                $this->error($e->getMessage());
            }
            $model = new UserLevel();
            $res = $model->add($data);
            if ($res) {
                $this->success(lang('add success'),url('levelIndex'));
            } else {
                $this->error(lang('add fail'));
            }
        }

        $view = [
            'info' => '',
            'title' => lang('add'),
        ];
        View::assign($view);
        return view();
    }

    public function levelEdit(){
        if (Request::isPost()) {
            $data = $this->request->post();
            try {
                $this->validate($data, 'UserLevel');
            } catch (\Exception $e) {
                $this->error($e->getMessage());
            }
            $model = new UserLevel();
            $res = $model->edit($data);
            if ($res) {
                $this->success(lang('edit success'), url('levelIndex'));
            } else {
                $this->error(lang('edit fail'));
            }
        }
        $info = UserLevel::find(Request::get('id'));
        $view = [
            'info' => $info,
            'title' => lang('edit'),
        ];
        View::assign($view);
        return view('level_add');


    }
    public function levelState(){

        $id = $this->request->post('id');
        $id = $this->request->post('id');
        if($id){
            $data = $this->request->post();
            $model = new UserLevel();
            $model->state($data);
            $this->success(lang('edit success'));
        }else{
            $this->error(lang('invalid data'));
        }
    }

    public function levelDel(){

        $ids = $this->request->post('ids');
        if($ids){
            $model = new UserLevel();
            $model->del($ids);
            $this->success(lang('delete success'));
        }else{
            $this->error(lang('invalid data'));
        }
    }


}