<?php
 namespace App\Modules\PrizePool\Util; use App\Modules\PrizePool\ActivityType; use App\Modules\PrizePool\AmountType; use App\Modules\PrizePool\CreditType; use App\Modules\PrizePool\DrawnPhysicalStatus; use App\Modules\PrizePool\PrizePoolPayDrawStatus; use App\Modules\PrizePool\PrizeType; use App\Modules\PrizePool\RedbagType; use App\Util\PlatformService; use App\Util\PlatformUtil; use Illuminate\Support\Facades\View; use TechOnline\Laravel\Dao\ModelUtil; use TechOnline\Laravel\Http\Response; use TechOnline\Laravel\Type\TypeUtil; use TechOnline\Utils\LotteryUtil; use TechOnline\Utils\RandomUtil; use TechSoft\Laravel\Assets\AssetsUtil; use TechSoft\Laravel\MemberCredit\MemberCreditUtil; class PrizePoolUtil { public static function hasPrizes($activityType, $activityId) { return ModelUtil::exists('module_prize_pool_activity_prize', [ 'activityType' => $activityType, 'activityId' => $activityId, ]); } public static function savePrizes($activityType, $activityId, $prizes) { ModelUtil::delete('module_prize_pool_activity_prize', [ 'activityType' => $activityType, 'activityId' => $activityId, ]); foreach ($prizes as $prize) { $prize['activityType'] = $activityType; $prize['activityId'] = $activityId; ModelUtil::insert('module_prize_pool_activity_prize', $prize); } } public static function listPrizes($activityType, $activityId) { $prizes = ModelUtil::all('module_prize_pool_activity_prize', [ 'activityType' => $activityType, 'activityId' => $activityId, ], ['*'], ['id', 'asc']); if (empty($prizes)) { return []; } ModelUtil::join($prizes, 'prizeId', '_prize', 'module_prize_pool', 'id'); $list = []; foreach ($prizes as $prize) { if (empty($prize['_prize'])) { continue; } $list[] = [ 'prizeId' => $prize['prizeId'], 'prizeTitle' => $prize['_prize']['name'], 'rate' => $prize['rate'], 'amountType' => $prize['amountType'], 'amount' => $prize['amount'], ]; } return $list; } public static function listDetailPrizes($activityType, $activityId) { $prizes = ModelUtil::all('module_prize_pool_activity_prize', [ 'activityType' => $activityType, 'activityId' => $activityId, ], ['*'], ['id', 'asc']); if (empty($prizes)) { return []; } ModelUtil::join($prizes, 'prizeId', '_prize', 'module_prize_pool', 'id'); $list = []; foreach ($prizes as $prize) { if (empty($prize['_prize'])) { continue; } $list[] = [ 'prizeId' => $prize['prizeId'], 'prizeTitle' => $prize['_prize']['name'], 'prizeCover' => $prize['_prize']['cover'] ? AssetsUtil::fix($prize['_prize']['cover']) : null, 'prizeType' => $prize['_prize']['type'], 'rate' => $prize['rate'], 'amountType' => $prize['amountType'], 'amount' => $prize['amount'], ]; } return $list; } public static function listUserShownPrizes($activityType, $activityId, $limit = null, $memberUserId = null) { $prizes = self::listDetailPrizes($activityType, $activityId); $filteredPrizes = []; foreach ($prizes as $prize) { $filteredPrizes[] = [ 'prizeId' => $prize['prizeId'], 'prizeTitle' => $prize['prizeTitle'], 'prizeCover' => $prize['prizeCover'], ]; } if (null === $limit) { return $filteredPrizes; } if (count($filteredPrizes) == $limit) { return $filteredPrizes; } else if (count($filteredPrizes) > $limit) { return array_slice($filteredPrizes, 0, $limit); } else { if (null !== $memberUserId) { $prizePoolSetting = ModelUtil::get('module_prize_pool_setting', ['memberUserId' => $memberUserId]); } else { $prizePoolSetting = null; } while (count($filteredPrizes) < $limit) { $filteredPrizes[] = [ 'prizeId' => 0, 'prizeTitle' => $prizePoolSetting ? $prizePoolSetting['emptyName'] : '谢谢参与', 'prizeCover' => $prizePoolSetting ? $prizePoolSetting['emptyCover'] : null, ]; } return $filteredPrizes; } } public static function getUnusedPayDraw($memberUserId, $userId, $activityType, $activityId) { return ModelUtil::get('module_prize_pool_pay_draw', [ 'memberUserId' => $memberUserId, 'userId' => $userId, 'activityType' => $activityType, 'activityId' => $activityId, 'status' => PrizePoolPayDrawStatus::NOT_USED, ]); } public static function markPayDraw($unusedPayDrawId) { $payDraw = ModelUtil::getWithLock('module_prize_pool_pay_draw', ['id' => $unusedPayDrawId]); if (empty($payDraw)) { throw new \Exception('pay draw not found'); } if ($payDraw['status'] != PrizePoolPayDrawStatus::NOT_USED) { throw new \Exception('pay draw status error'); } ModelUtil::update('module_prize_pool_pay_draw', ['id' => $unusedPayDrawId], [ 'status' => PrizePoolPayDrawStatus::USED, ]); } public static function drawPrize($memberUserId, $userId, $activityType, $activityId) { $activityTypeName = TypeUtil::name(ActivityType::class, $activityType); $activityPrizes = ModelUtil::all('module_prize_pool_activity_prize', [ 'activityType' => $activityType, 'activityId' => $activityId, ]); $pool = []; foreach ($activityPrizes as $activityPrize) { if ($activityPrize['amountType'] == AmountType::FIXED && $activityPrize['amount'] <= 0) { continue; } $pool[] = [ 'id' => $activityPrize['id'], 'rate' => $activityPrize['rate'], ]; } $activityPrizeId = LotteryUtil::fetchPoll($pool); if ($activityPrizeId === null) { return null; } $activityPrize = ModelUtil::getWithLock('module_prize_pool_activity_prize', ['id' => $activityPrizeId]); $prize = ModelUtil::getWithLock('module_prize_pool', ['id' => $activityPrize['prizeId']]); if (empty($prize)) { throw new \Exception('prize empty'); } if (!$prize['enable']) { throw new \Exception('奖品已被禁用'); } if ($activityPrize['amountType'] == AmountType::FIXED) { if ($activityPrize['amount'] <= 0) { return null; } ModelUtil::update('module_prize_pool_activity_prize', ['id' => $activityPrizeId], [ 'amount' => $activityPrize['amount'] - 1, ]); } $drawn = []; $drawn['memberUserId'] = $memberUserId; $drawn['userId'] = $userId; $drawn['prizeId'] = $prize['id']; $drawn['activityType'] = $activityType; $drawn['activityId'] = $activityId; $drawn['name'] = $prize['name']; $drawn['cover'] = $prize['cover']; $drawn['type'] = $prize['type']; switch ($prize['type']) { case PrizeType::REDBAG: $drawn['redbagType'] = $prize['redbagType']; switch ($prize['redbagType']) { case RedbagType::RANDOM: $drawn['redbagValue'] = LotteryUtil::randomMoneyInRange($prize['redbagMin'], $prize['redbagMax']); break; case RedbagType::FIXED: $drawn['redbagValue'] = $prize['redbagFixed']; break; default: throw new \Exception('redbag type error'); } PlatformUtil::remitMoneyToUser($memberUserId, $userId, $drawn['redbagValue'], $activityTypeName . '红包'); break; case PrizeType::CREDIT: $drawn['creditType'] = $prize['creditType']; switch ($prize['creditType']) { case CreditType::RANDOM: $drawn['creditValue'] = rand($prize['creditMin'], $prize['creditMax']); break; case CreditType::FIXED: $drawn['creditValue'] = $prize['creditFixed']; break; default: throw new \Exception('credit type error'); } MemberCreditUtil::change($userId, $drawn['creditValue'], $activityTypeName . '积分'); break; case PrizeType::CODE: $code = ModelUtil::get('module_prize_pool_code', ['prizeId' => $prize['id']]); if (empty($code)) { throw new \Exception('兑换码为空'); } $code = ModelUtil::getWithLock('module_prize_pool_code', ['id' => $code['id']]); $drawn['codeNo'] = $code['no']; $drawn['codeSecret'] = $code['secret']; $drawn['codeExpire'] = $code['expire']; ModelUtil::delete('module_prize_pool_code', ['id' => $code['id']]); break; case PrizeType::PHYSICAL: $drawn['checkCode'] = RandomUtil::number(10); $drawn['physicalStatus'] = DrawnPhysicalStatus::DRAWN; break; } $drawn = ModelUtil::insert('module_prize_pool_drawn', $drawn); return $drawn; } public static function mockRandomPrizeResultView($activityType, $activity, $memberUser, $user) { $drawnMocks = [ [ 'memberUserId' => $memberUser['id'], 'userId' => $user['id'], 'prizeId' => 1, 'activityType' => $activityType, 'activityId' => $activity['id'], 'checkCode' => RandomUtil::number(10), 'name' => '固定红包', 'cover' => '/placeholder/100x100', 'type' => PrizeType::REDBAG, 'redbagType' => RedbagType::FIXED, 'redbagValue' => '8.88', ], [ 'memberUserId' => $memberUser['id'], 'userId' => $user['id'], 'prizeId' => 1, 'activityType' => $activityType, 'activityId' => $activity['id'], 'checkCode' => RandomUtil::number(10), 'name' => '随机红包', 'cover' => '/placeholder/100x100', 'type' => PrizeType::REDBAG, 'redbagType' => RedbagType::RANDOM, 'redbagValue' => '6.66', ], [ 'memberUserId' => $memberUser['id'], 'userId' => $user['id'], 'prizeId' => 1, 'activityType' => $activityType, 'activityId' => $activity['id'], 'checkCode' => RandomUtil::number(10), 'name' => '固定积分', 'cover' => '/placeholder/100x100', 'type' => PrizeType::CREDIT, 'creditType' => RedbagType::FIXED, 'creditValue' => '8', ], [ 'memberUserId' => $memberUser['id'], 'userId' => $user['id'], 'prizeId' => 1, 'activityType' => $activityType, 'activityId' => $activity['id'], 'checkCode' => RandomUtil::number(10), 'name' => '随机积分', 'cover' => '/placeholder/100x100', 'type' => PrizeType::CREDIT, 'creditType' => RedbagType::RANDOM, 'creditValue' => '6', ], [ 'memberUserId' => $memberUser['id'], 'userId' => $user['id'], 'prizeId' => 1, 'activityType' => $activityType, 'activityId' => $activity['id'], 'checkCode' => RandomUtil::number(10), 'name' => '兑换码', 'cover' => '/placeholder/100x100', 'type' => PrizeType::CODE, 'codeNo' => RandomUtil::number(10), 'codeSecret' => RandomUtil::upperString(4) . '-' . RandomUtil::upperString(4) . '-' . RandomUtil::upperString(4), 'codeExpire' => date('Y-m-d', time() + 3600 * 30 * 24), 'creditValue' => '6', ], null, ]; shuffle($drawnMocks); $drawn = $drawnMocks[0]; $html = View::make('res::activity.drawn', [ 'activity' => $activity, 'drawn' => $drawn, ])->render(); return Response::send(0, null, [ 'prizeId' => $drawn ? $drawn['prizeId'] : 0, 'html' => $html, 'prizeName' => $drawn ? $drawn['name'] : null, 'prizeCover' => $drawn ? $drawn['cover'] : null, ]); } }