<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateModulePrizePoolPayDraw extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('module_prize_pool_pay_draw', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('商户ID');
            $table->integer('userId')->nullable()->comment('用户ID');

            /** @see \App\Modules\PrizePool\ActivityType */
            $table->string('activityType', 50)->nullable()->comment('活动');
            $table->integer('activityId')->nullable()->comment('活动ID');

            /** @see \App\Modules\PrizePool\PrizePoolPayDrawStatus */
            $table->tinyInteger('status')->nullable()->comment('奖品类型');

            $table->decimal('money', 20, 2)->nullable()->comment('付费抽奖');

            $table->index(['memberUserId']);
            $table->index(['userId']);

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
