@extends('theme.default.pc.member.frame')

@section('pageTitleMain','领取记录')

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li><a href="/module/manage/prize_pool">奖品中心</a></li>
        <li class="uk-active"><span>领取记录</span></li>
    </ul>
@endsection

@section('bodyScript')
    <script src="@assets('assets/main/listBasic.js')"></script>
@endsection

@section('memberContent')

    <div class="pb" id="list">
        <div class="head">
            <h2>领取记录</h2>
        </div>
        <div class="body">
            <div class="lister-search-container uk-form">
                <div class="line">
                    <div class="field" style="min-width:inherit;">
                        <span class="title">活动类型:</span>
                        <select data-search-field="activityType" data-search-type="equal">
                            <option value="">[活动类型]</option>
                            @foreach(\App\Modules\PrizePool\ActivityType::getList() as $k=>$v)
                                <option value="{{$k}}">{{$v}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="field" style="min-width:inherit;">
                        <span class="title">活动ID:</span>
                        <input type="text" style="width:5em;" data-search-field="activityId" data-search-type="equal" />
                    </div>
                    <div class="field" style="min-width:inherit;">
                        <span class="title">奖品类型:</span>
                        <select data-search-field="type" data-search-type="equal">
                            <option value="">[奖品类型]</option>
                            @foreach(\App\Modules\PrizePool\PrizeType::getList() as $k=>$v)
                                <option value="{{$k}}">{{$v}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="field" style="min-width:inherit;">
                        <span class="title">奖品ID:</span>
                        <input type="text" style="width:5em;" data-search-field="prizeId" data-search-type="equal" />
                    </div>
                    <div class="field">
                        <span class="title">实物核销码:</span>
                        <input type="text" data-search-field="checkCode" data-search-type="like" />
                    </div>
                    <div class="field">
                        <button class="uk-button uk-button-primary" data-search-button>搜索</button>
                        <button class="uk-button uk-button-default" data-reset-search-button>重置</button>
                    </div>
                </div>
            </div>
            <div class="data-table">
            </div>
            <div class="page-container"></div>
        </div>
    </div>

@endsection