@extends('theme.default.pc.member.frame')

@section('pageTitleMain','礼品中心')

@section('memberBreadcrumb')
    <ul class="uk-breadcrumb">
        <li><a href="/member">管理首页</a></li>
        <li><a href="/module/manage/prize_pool">奖品中心</a></li>
        <li class="uk-active"><span>奖品管理</span></li>
    </ul>
@endsection

@section('memberContent')

    <div class="pb pb-module-panel">
        <div class="head">
            <div class="more">
                @if(!empty($prizes))
                    <a href="/module/manage/prize_pool_prize_edit"><i class="uk-icon-plus"></i> 新建奖品</a>
                @endif
            </div>
            <h2>奖品中心</h2>
        </div>
        <div class="body">
            @if(empty($prizes))
                <a class="empty-add" href="/module/manage/prize_pool_prize_edit">
                    <i class="uk-icon-plus"></i> 新建奖品
                </a>
            @else
                <div class="uk-grid">
                    @foreach($prizes as $prize)
                        <div class="uk-width-1-4">
                            <div class="item-activity-card">
                                <div class="right-top-tool">
                                    <a data-uk-tooltip title="删除" href="javascript:;" data-confirm="删除后不可恢复，确定删除？" data-ajax-request-loading data-ajax-request="/module/manage/prize_pool_prize_delete/{{$prize['id']}}"><i class="uk-icon-trash"></i></a>
                                </div>
                                <div class="right-bottom-badge">
                                    ID：{{$prize['id']}}
                                </div>
                                <h2>{{$prize['name']}}</h2>
                                <div class="attr">
                                    @if($prize['enable'])
                                        <span class="uk-badge uk-badge-success">正常</span>
                                    @else
                                        <span class="uk-badge uk-badge-danger">禁用</span>
                                    @endif
                                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::REDBAG)
                                        <span class="uk-badge uk-badge-danger uk-badge-notification">红包</span>
                                    @endif
                                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::CREDIT)
                                        <span class="uk-badge uk-badge-success uk-badge-notification">积分</span>
                                    @endif
                                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::CODE)
                                        <span class="uk-badge uk-badge-warning uk-badge-notification">兑换码</span>
                                    @endif
                                    @if($prize['type']==\App\Modules\PrizePool\PrizeType::PHYSICAL)
                                        <span class="uk-badge uk-badge-primary uk-badge-notification">实物</span>
                                    @endif
                                </div>
                                <div class="attr">
                                </div>
                                <div class="action">
                                    <div class="uk-grid">
                                        @if($prize['type']==\App\Modules\PrizePool\PrizeType::CODE)
                                            <div class="uk-width-1-4">
                                                <a class="uk-button uk-width-1-1" data-uk-tooltip title="兑换码列表" href="/module/manage/prize_pool_prize_code/{{$prize['id']}}"><i class="uk-icon-list"></i></a>
                                            </div>
                                        @endif
                                        <div class="uk-width-1-4">
                                            <a class="uk-button uk-width-1-1" data-uk-tooltip title="编辑" href="/module/manage/prize_pool_prize_edit/{{$prize['id']}}"><i class="uk-icon-pencil"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>

@endsection