##### 请求

接口请求必须采用统一的入口地址,该地址由服务端指定. 

入口地址例子:`http://127.0.0.1/admin/`

完整请求地址例子:`http://127.0.0.1/admin/?action=value&token=value`

请求参数中有两个特殊参数`aciton`和`token`,这个两个参数固定为`GET`参数,其他参数根据接口请求方式传递

* `action`: 接口标示,用于区分不同的接口请求
* `token`: 用户标示,需要前端进行存储,服务端通过它来判断用户登录状态
* 服务端根据`action`与`token`来校验用户接口请求权限

> `action`/`token`的具体`参数名称`是可以配置的,由相应服务端和客户端约定而成,后续文档中统一使用`action`与`token`代替
>
> `token` 参数为用户标示,用于权限校验, 例如: [系统登录](api/init.md?id=系统登录)接口无需传递该参数

##### 响应

###### 业务执行成功响应
```json
{
    "status":"success",
    "info":"操作成功",
    "data":{}
}
```
> `data` 为相关的业务返回数据,数据结构有具体接口指定

###### 业务执行异常响应
```json
{
    "status":"error",
    "info":"异常信息",
    "data":{}
}
```
> `data` 为相关的业务返回数据,数据结构有具体接口指定

##### 后续接口详细文档说明 一定要看

1. `token`参数无特殊说明是必传的
1. 后续接口详细文档中的响应指的就是上面 `data` 的数据结构.
1. 如无特殊指定会忽略异常响应的说明
1. 如果连响应说明都没有,不要惊慌, 这代表该接口调用方只关心业务是否成功执行.不关心返回业务数据. 只需要根据`status`判断业务执行成功即可