<?php
/*
redirect:跳转至对应的API，即别名
method：HTTP Method
needBucket:是否需要bucket
needObject：是否需要object
signer：请求构造链
handler：结果处理链
*/
class API{
	public static $API = array(
		"getService"=>array(
			"redirect"=>"listBuckets"
		),
		"listBuckets"=> array(
			"method"=>"GET",
			"needBucket"=>FALSE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->ListBucketsHandler"
		),
		"deleteBucket"=>array(
			"method"=>"DELETE",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"deleteBucketCORS"=>array(
			"method"=>"DELETE",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"cors",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"createBucket"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->ACLSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"body"=>Array("builder"=>"LocationBuilder"),
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"setBucketAcl"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->ACLSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"subResource"=>"acl",
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"setBucketCORS"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->ContentMD5Signer->HeaderAuthSigner",
			"subResource"=>"cors",
			"body"=>Array("builder"=>"CORSBuilder"),
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"setBucketLogging"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"subResource"=>"logging",
			"body"=>Array("builder"=>"BucketLoggingBuilder"),
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"listObjects" => array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"queryParams"=>array("Options->prefix","Options->delimiter","Options->marker","Options->max-keys"),
			"handler"=>"ErrorResponseHandler->ListObjectsHandler"
		),
		"getBucketAcl" => array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"acl",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->GetAclHandler"
		),
		"getBucketCORS"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"cors",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->GetBucketCORSHandler"
		),
		"getBucketLocation"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"location",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->GetBucketLocationHandler"
		),
		"getBucketLogging"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"logging",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->GetBucketLoggingHandler"
		),
		"listMutipartUploads"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"uploads",
			"queryParams"=>array("Options->max-uploads","Options->key-marker","Options->prefix","Options->upload-id-​marker","Options->delimiter"),
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->ListMutipartUploadsHandler"
		),
		"bucketExists"=>array(
			"method"=>"HEAD",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ExistsHandler"
		),
		"putObjectByContent"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			//将ContentMD5Signer放在最后的原因是，ContentMD5需要根据Content-Length计算
			"signer"=>"DefaultUserAgentSigner->ACLSigner->SuffixContentTypeSigner->ContentLengthSigner->ObjectMetaSigner->ContentMD5Signer->UserMetaSigner->AdpSigner->CallBackSigner->SSESigner->SSECSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->UploadHandler",
			"body"=>array("position"=>"Content")
		),
		"putObjectByFile"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->ACLSigner->SuffixContentTypeSigner->ObjectMetaSigner->UserMetaSigner->AdpSigner->CallBackSigner->SSESigner->SSECSigner->StreamUploadSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->UploadHandler"
		),
		"setObjectAcl"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->ACLSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"subResource"=>"acl",
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"copyObject"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->CopySourceSigner->DefaultContentTypeSigner->CallBackSigner->SSESigner->SSECSigner->SSECSourceSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->CopyHandler"
		),
		"getObjectMeta"=>array(
			"method"=>"HEAD",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->SSECSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->ObjectMetaHandler"
		),
		"objectExists"=>array(
			"method"=>"HEAD",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->SSECSigner->HeaderAuthSigner",
			"handler"=>"ExistsHandler"
		),
		"deleteObject"=>array(
			"method"=>"DELETE",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->BooleanHandler"			
		),
		"deleteObjects"=>array(
			"method"=>"POST",
			"needBucket"=>TRUE,
			"needObject"=>FALSE,
			"subResource"=>"delete",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->ContentMD5Signer->ContentLengthSigner->HeaderAuthSigner",
			"body"=>array("builder"=>"DeleteObjectsBuilder"),
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"getObject"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->RangeSigner->SSECSigner->GetObjectSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->getObjectHandler"
		),
		"getObjectAcl" => array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"subResource"=>"acl",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->GetAclHandler"
		),
		"initMultipartUpload"=>array(
			"method"=>"POST",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"subResource"=>"uploads",
			"signer"=>"DefaultUserAgentSigner->ACLSigner->SuffixContentTypeSigner->MultipartObjectMetaSigner->UserMetaSigner->SSESigner->SSECSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->InitMultipartUploadHandler"
		),
		"uploadPart"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"queryParams"=>array("!Options->uploadId","!Options->partNumber"),
			//这个请求没有body，所以使用了ContentLengthSigner->ContentMD5Signer而没用ObjectMetaSigner
			"signer"=>"DefaultUserAgentSigner->ACLSigner->StreamContentTypeSigner->ContentLengthSigner->ContentMD5Signer->SSECSigner->StreamUploadSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->UploadHandler"
		),
		"abortMultipartUpload"=>array(
			"method"=>"DELETE",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"queryParams"=>array("!Options->uploadId"),
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->BooleanHandler"
		),
		"listParts"=>array(
			"method"=>"GET",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"queryParams"=>array("!Options->uploadId","Options->max-parts","Options->part-number​-marker"),
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->ListPartsHandler"
		),
		"completeMultipartUpload"=>array(
			"method"=>"POST",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"queryParams"=>array("!Options->uploadId"),
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->ContentLengthSigner->AdpSigner->CallBackSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->UploadHandler",
			"body"=>array("builder"=>"CompleteMultipartUploadBuilder")
		),
		"generatePresignedUrl"=>array(
			"method"=>"Method",
			"needBucket"=>FALSE,
			"needObject"=>FALSE,
			"queryParams"=>array("!Options->Expires","Options->*"),
			"signer"=>"AllHeaderSigner->QueryAuthSigner",
		),
		"putAdp"=>array(
			"method"=>"PUT",
			"needBucket"=>TRUE,
			"needObject"=>TRUE,
			"subResource"=>"adp",
			"signer"=>"DefaultUserAgentSigner->DefaultContentTypeSigner->AdpSigner->HeaderAuthSigner",
			"handler"=>"ErrorResponseHandler->UploadHandler"
		),
		"getAdp"=>array(
			"method"=>"GET",
			"needBucket"=>FALSE,
			"needObject"=>TRUE,
			"objectPostion"=>"TaskID",//专门为这个接口定义的属性
			"subResource"=>"queryadp",
			"signer"=>"DefaultUserAgentSigner",
			"handler"=>"ErrorResponseHandler->AdpHandler"
		)
	);
}
?>
