# Contributing Guidelines

We love contributions from everyone. By participating in this project, you agree to abide by the [_`Contributor Covenant Code of Conduct`_](./code_of_conduct.md) and the conventions described in this documentation.

## Getting Started

### Reporting Issues

A great way to contribute to the project is to send a detailed report when you encounter an issue. We always appreciate a well-written, thorough bug report, and will thank you for it!

Check that [our issues list](https://github.com/yunify/qingstor-sdk-php/issues) doesn't already include that problem or suggestion before submitting an issue. If you find a match, you can use the "subscribe" button to get notified on updates. Do not leave random "+1" or "I have this too" comments, as they only clutter the discussion, and don't help resolving it. However, if you have ways to reproduce the issue or have additional information that may help resolving the issue, please leave a comment.

When reporting issues, please describe what happened clearly, and include the steps required to reproduce the problem if possible and applicable. This information will help us review and fix your issue faster. When sending lengthy log-files, consider posting them as a gist (https://gist.github.com). Don't forget to remove sensitive data from your log files before posting (you can replace those parts with "CONFIDENTIAL").

### Sending Pull Request

Pull requests are always welcome, we will appreciate it.

Any significant improvement should be documented as a GitHub [issue](https://github.com/yunify/qingstor-sdk-php/issues) before anybody starts working on it.

1. Fork it ( https://github.com/yunify/qingstor-sdk-php )
2. Create your feature branch (`git checkout -b new-feature`)
3. Commit your changes (`git commit -asm 'Add some feature'`)
4. Push to the branch (`git push origin new-feature`)
5. Create a new Pull Request

## Conventions

### Patch Content

* Always remove the trailing whitespace
* Keep a newline at the end of text files
* Exclude irrelevant files, such as `*.a`, `.bundle`, and `.DS_Store`
* Always pass all the tests before submitting
* Let the propose of each patch simple and clear

### Commit Message

* Capitalize the subject line
* Limit the subject line to 50 characters
* Do not end the subject line with a period
* Wrap the body at 72 characters
* Use the body to explain what happened
