<?php
// +----------------------------------------------------------------------
// | travel_api [ THE PROJECT "name" IS travel_api ]
// +----------------------------------------------------------------------
// | File"name"=>MenuController.php
// +----------------------------------------------------------------------
// | Function=> 菜单配置
// +----------------------------------------------------------------------
// | Site ( http=>//www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author=>卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Controller\Common\v1;

use App\Controller\AbstractController;
use App\Functions\HttpDataResponse;
use Hyperf\Di\Annotation\Inject;
use Hyperf\HttpServer\Annotation\Controller;
use Hyperf\HttpServer\Annotation\GetMapping;
use Psr\Http\Message\ResponseInterface;

/**
 * @Controller(prefix="v1/common/menu")
 * Class MenuController
 * @package App\Controller\Common\v1
 */
class MenuController extends AbstractController
{
    /**
     * @Inject()
     * @var HttpDataResponse
     */
    protected $response;

    /**
     * 首页菜单
     * @GetMapping(path="home")
     * @return ResponseInterface
     */
    public function home()
    {
        $menu = [
            [
                "img"  => "/static/images/classify/weather.png",
                "name" => "今日天气",
                "url"  => "/pages/weather/weather",
                'key'  => '今日天气',
            ],
//            [
//                "img"  => "/static/images/classify/map.png",
//                "name" => "地图搜索",
//                "url"  => "/pages/maps/maps",
//                'key'  => '加油站',
//            ],
//            [
//                "img"  => "/static/images/classify/read.png",
//                "name" => "文章阅读",
//                "url"  => "/pages/article/news/news",
//                'key'  => '文章阅读',
//            ],
            [
                "img"  => "/static/images/classify/flight.png",
                "name" => "机场查询",
                "url"  => "/pages/maps/maps",
                'key'  => '机场查询',
                ''
            ],
//            [
//                "img"  => "/static/images/classify/vr.png",
//                "name" => "加油站",
//                "url"  => "/pages/maps/maps",
//                'key'  => '附近加油站',
//            ],
            [
                "img"  => "/static/images/classify/road.png",
                "name" => "路线规划",
                "url"  => "",
                'key'  => '路线规划',
                'type' => 'road'
            ],
            [
                "img"  => "/static/images/classify/subway.png",
                "name" => "地铁路线",
                "url"  => "",
                'key'  => '地铁路线',
                'type' => 'subway'
            ],
            [
                "img"  => "/static/images/classify/nearby.png",
                "name" => "附近搜索",
                "url"  => "",
                'key'  => '附近搜索',
                'type' => 'search'
            ],
        ];

        return $this->response->success((array)$menu);
    }

    /**
     * 全部菜单
     * @return ResponseInterface
     */
    public function list()
    {
        $menu = [
            [
                "img"  => "/static/images/classify/map.png",
                "name" => "地图搜索",
                "url"  => "/pages/maps/maps",
            ],
            [
                "img"  => "/static/images/classify/read.png",
                "name" => "文章阅读",
                "url"  => "/pages/article/news/news",
            ],
            [
                "img"  => "/static/images/classify/flight.png",
                "name" => "机场查询",
                "url"  => "/pages/maps/maps",
            ],
            [
                "img"  => "/static/images/classify/vr.png",
                "name" => "AI识别",
                "url"  => "/pages/maps/maps",
            ],
            [
                "img"  => "/static/images/classify/weather.png",
                "name" => "今日天气",
                "url"  => "/pages/weather/weather",
            ],
        ];
        return $this->response->success((array)$menu);
    }
}