<?php
declare(strict_types=1);
// +----------------------------------------------------------------------
// | travel_api [ THE PROJECT NAME IS travel_api ]
// +----------------------------------------------------------------------
// | FileName: SpotController.php
// +----------------------------------------------------------------------
// | Function: 
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------


namespace App\Controller\Common\v1\Spot;


use App\Controller\AbstractController;
use App\Functions\HttpDataResponse;
use App\Model\Common\SceneSpot;
use Hyperf\Di\Annotation\Inject;
use Hyperf\HttpServer\Annotation\Controller;
use Hyperf\HttpServer\Annotation\GetMapping;
use Hyperf\HttpServer\Contract\RequestInterface;
use Psr\Http\Message\ResponseInterface;

/**
 * @Controller(prefix="v1/common/spot")
 * Class SpotController
 * @package App\Controller\Common\v1
 */
class SpotController extends AbstractController
{
    /**
     * @Inject()
     * @var SceneSpot
     */
    protected $spot;

    /**
     * @Inject()
     * @var HttpDataResponse
     */
    protected $response;

    /**
     * 景点列表
     * @GetMapping(path="list")
     * @param RequestInterface $request
     * @return ResponseInterface
     */
    public function list(RequestInterface $request)
    {
        $perSize = $request->input('size', 10);
        $lists   = $this->spot->list((int)$perSize);

        return $this->response->success((array)$lists);
    }

    /**
     * 景点详情
     * @GetMapping(path="detail")
     * @param RequestInterface $request
     * @return ResponseInterface
     */
    public function detail(RequestInterface $request)
    {
        $id   = $request->input('id');
        $bean = $this->spot->detail((string)$id);

        return $this->response->success((array)$bean);
    }
}