<?php
// +----------------------------------------------------------------------
// | park_server [ THE PROJECT NAME IS park_server ]
// +----------------------------------------------------------------------
// | FileName: SceneAreaController.php
// +----------------------------------------------------------------------
// | Function: 景区管理
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Admin\Controllers\SceneSpot;


use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Godruoyi\Snowflake\Snowflake;
use App\Models\Admin\SceneSpot\SceneArea;
use App\Admin\Controllers\CommonController;
use App\Admin\Controllers\UserAuthController;

class SceneAreaController extends CommonController
{
    protected $title = '景区管理';

    public function grid()
    {
        $grid = new Grid(new SceneArea());
        $grid->column('id', '数据编号')->sortable();
        $grid->column('name', '景区名称');
        $grid->column('open_start_time', '营业开始时间');
        $grid->column('open_end_time', '营业结束时间');
        $grid->column('open_time_desc', '营业时间描述');
        $grid->column('detail_address', '景区地址');
        $grid->column('is_show', '是否显示')->display(function ($isShow) {
            if ($isShow == 0) {
                return "<span class='label bg-red'>禁用</span>";
            } elseif ($isShow == 1) {
                return "<span class='label bg-green'>启用</span>";
            } else {
                return '异常';
            }
        });
        $grid->column('keywords', '景区标签')->display(function ($keywords) {
            $str = '';
            foreach ($keywords as $key => $value) {
                $str .= "<span class='label bg-primary'>$value</span>\t\t";
            }
            return $str;
        });
        $grid->actions(function ($actions) {
            $actions->disableView();
        });
        return $grid;
    }

    public function detail($id)
    {
        $show = new Show(SceneArea::findOrFail($id));

        return $show;
    }

    public function form()
    {
        $form = new Form(new SceneArea());
        $form->tab('基础信息', function ($form) {
            $form->hidden('uuid', '全局标识')->default((new Snowflake())->id())->required();
            $form->hidden('wxapp_id')->default(UserAuthController::getWxAppId())->required();
            $form->text('name', '景区名称')->required()->placeholder('最大长度不能超过32位');
            $form->text('description', '景区简介')->required()->placeholder('最大长度不能超过32位');
            $form->image('cover', '景区封面')->required()->downloadable();
            $form->divider();
            $form->time('open_start_time', '营业开始时间')->placeholder('选择营业开始时间')->required();
            $form->time('open_end_time', '营业结束时间')->placeholder('选择营业结束时间')->required();
            $form->text('open_time_desc', '营业时间描述')->help('如全年开放、夏季开放等关键词语')->required();
            $form->divider();
            $form->tags('keywords', '景区标签')->placeholder('输入标签按回车键');
            $form->starRating('star_leave', '景区星级');
            $form->divider();
            $form->distpicker([
                'province_code' => '省份',
                'city_code'     => '市',
                'district_code' => '区'
            ], '地域选择')->default([
                'province' => 130000,
                'city'     => 130200,
                'district' => 130203,
            ])->required();
            $states = [
                'on'  => ['value' => 1, 'text' => '打开', 'color' => 'success'],
                'off' => ['value' => 0, 'text' => '禁用', 'color' => 'danger'],
            ];
            $form->switch('is_show', '显示状态')->states($states)->placeholder('是否显示');
        })->tab('内容信息', function ($form) {
            $form->text('detail_address', '景区详细地址')->required();
            $form->latlong('latitude', 'longitude', '景区定位')->default(['lat' => 40, 'lng' => 120])->required();
            $form->UEditor('content', '文章内容')->options(['initialFrameHeight' => 400])->required();
        });
        return $form;
    }
}