<?php
// +----------------------------------------------------------------------
// | park_server [ THE PROJECT NAME IS park_server ]
// +----------------------------------------------------------------------
// | FileName: SceneSpotController.php
// +----------------------------------------------------------------------
// | Function: 景点管理
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Admin\Controllers\SceneSpot;

use Encore\Admin\Form;
use Encore\Admin\Grid;
use Encore\Admin\Show;
use Godruoyi\Snowflake\Snowflake;
use App\Models\Admin\SceneSpot\SceneArea;
use App\Models\Admin\SceneSpot\SceneSpot;
use App\Admin\Controllers\CommonController;
use App\Admin\Extensions\SceneSpotExporter;
use App\Admin\Controllers\UserAuthController;

class SceneSpotController extends CommonController
{
    protected $title = '景点管理';

    /**
     * 显示文章
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new SceneSpot());
        $grid->column('id', '数据编号')->sortable();
        $grid->column('name', '景点名称');
        $grid->column('area.name', '所属景区');
        $grid->column('is_show', '是否显示')->display(function ($isShow) {
            if ($isShow == 0) {
                return "<span class='label bg-red'>禁用</span>";
            } elseif ($isShow == 1) {
                return "<span class='label bg-green'>启用</span>";
            } else {
                return '异常';
            }
        });
        $grid->column('open_start_time', '营业开始时间');
        $grid->column('open_end_time', '营业结束时间');
        $grid->column('created_at', '创建时间');
        $grid->column('star_leave', '景点星级')->display(function ($starLeave) {
            $str = '';
            for ($i = 1; $i <= $starLeave; $i++) {
                $str .= '<span class="star"> <i class="glyphicon glyphicon-star-empty"></i></span>';
            }
            return '<div class="rating-stars"><span class="empty-stars">' . $str . '</span></div>';
        });
        $grid->column('keywords', '景区标签')->display(function ($keywords) {
            $str = '';
            foreach ($keywords as $key => $value) {
                $str .= "<span class='label bg-primary'>$value</span>\t\t";
            }
            return $str;
        });
        $grid->exporter(new SceneSpotExporter());
        $grid->actions(function ($actions) {
            $actions->disableView();
        });
        return $grid;
    }

    /**
     * 回显文章
     * @param $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(SceneSpot::findOrFail($id));
        return $show;
    }


    /**
     * 创建标签
     * @return Form
     */
    protected function form()
    {
        $sceneArea      = SceneArea::where('is_show', '=', 1)->select(['id', 'name'])->get();
        $sceneAreaArray = [];
        foreach ($sceneArea as $value) {
            $sceneAreaArray[$value->id] = $value->name;
        }
        $form = new Form(new SceneSpot());

        $form->tab('基础信息', function ($form) use ($sceneAreaArray) {
            $form->hidden('uuid', '全局标识')->default((new Snowflake())->id())->required();
            $form->hidden('wxapp_id')->default(UserAuthController::getWxAppId())->required();
            $form->select('scene_area_id', '所属景区')->options($sceneAreaArray)->required();
            $form->text('name', '景点名称')->required()->placeholder('最大长度不能超过32位');
            $form->text('description', '景点简介')->required()->placeholder('最大长度不能超过32位');
            $form->image('cover', '景点封面')->required()->downloadable();
            $form->distpicker([
                'province_code' => '省份',
                'city_code'     => '市',
                'district_code' => '区'
            ], '地域选择')->default([
                'province' => 130000,
                'city'     => 130200,
                'district' => 130203,
            ])->required();
            $form->divider();
            $form->time('open_start_time', '营业开始时间')->placeholder('选择营业开始时间')->required();
            $form->time('open_end_time', '营业结束时间')->placeholder('选择营业结束时间')->required();
            $form->mobile('phone_number', '联系手机')->options(['mask' => '999 9999 9999']);
            $form->mobile('mobile_number', '联系座机')->options(['mask' => '(999) 999-9999']);
            $form->number('orders', '显示顺序')->required()->default(0)->help('值越大，排序越前');
        })->tab('内容信息', function ($form) {
            $form->text('detail_address', '景区详细地址')->required();
            $form->latlong('latitude', 'longitude', '景点定位')->default(['lat' => 40, 'lng' => 120])->required();
            $form->UEditor('content', '文章内容')->options(['initialFrameHeight' => 400])->required();
        })->tab('状态设置', function ($form) {
            $states = [
                'on'  => ['value' => 1, 'text' => '打开', 'color' => 'success'],
                'off' => ['value' => 0, 'text' => '禁用', 'color' => 'danger'],
            ];
            $form->switch('is_show', '显示状态')->states($states)->placeholder('是否显示');
            $form->switch('is_top', '置顶状态')->states($states)->placeholder('是否置顶');
            $form->switch('is_hot', '热门状态')->states($states)->placeholder('是否热门');
        })->tab('积分设置', function ($form) {
            $form->number('reading_score', '阅读积分')->required()->default(1);
            $form->number('click_score', '点赞积分')->required()->default(1);
            $form->number('share_score', '分享积分')->required()->default(1);
            $form->number('collection_score', '收藏积分')->required()->default(1);
        })->tab('数量设置', function ($form) {
            $form->number('punch', '打开人数')->required()->default(1);
            $form->number('reading', '阅读数量')->default(0);
            $form->number('click', '点赞数量')->default(0);
            $form->number('share', '分享数量')->default(0);
            $form->number('collection', '收藏数量')->default(0);
            $form->number('oppose', '反对数量')->default(0);
            $form->number('sale_ticket', '售票数量')->default(0);
        })->tab('标签设置', function ($form) {
            $form->tags('keywords', '景区标签')->placeholder('输入标签按回车键');
            $form->starRating('star_leave', '景点星级');
        });
        return $form;
    }
}