<?php

use Illuminate\Routing\Router;

Admin::routes();

Route::group([
    'prefix'     => config('admin.route.prefix'),
    'namespace'  => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {
    $router->get('/', 'HomeController@index')->name('admin.home');
    $router->resource('users', UserController::class);
    $router->resource('article/tags', Article\ArticleTagController::class);
    $router->resource('article/category', Article\ArticleCategoryController::class);
    $router->resource('article/list', Article\ArticleController::class);
    $router->resource('system/data', SetDataController::class);
    $router->resource('scene_spot/list', SceneSpot\SceneSpotController::class);
    $router->resource('scene_area/list', SceneSpot\SceneAreaController::class);
    $router->resource('banner', System\BannerController::class);
    $router->resource('notice', System\NoticeController::class);
    $router->resource('about_me', System\AboutMeController::class);
});
