<?php
// +----------------------------------------------------------------------
// | park_server [ THE PROJECT NAME IS park_server ]
// +----------------------------------------------------------------------
// | FileName: ArticleTag.php
// +----------------------------------------------------------------------
// | Function: 文章标签
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Models\Admin\Article;

use App\Scopes\WxAppId;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as AuthenticTable;

class ArticleTag extends AuthenticTable
{
    use Notifiable;
    use SoftDeletes;

    protected $table = 'article_tag';

    protected $fillable = [
        'uuid',
        'wxapp_id',
        'name',
        'is_show',
        'orders'
    ];

    public static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::addGlobalScope(new WxAppId());
    }

}