<?php
// +----------------------------------------------------------------------
// | park_server [ THE PROJECT NAME IS park_server ]
// +----------------------------------------------------------------------
// | FileName: Article.php
// +----------------------------------------------------------------------
// | Function: 
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Models\Admin\SceneSpot;

use App\Scopes\WxAppId;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as AuthenticTable;

class SceneArea extends AuthenticTable
{
    use Notifiable;
    use SoftDeletes;

    /**
     * @var string
     */
    protected $table = 'scene_area';
    /**
     * @var array
     */
    protected $fillable = [
        'uuid',
        'name',
        'wxapp_id',
        'description',
        'cover',
        'content',
        'open_start_time',
        'open_end_time',
        'detail_address',
        'longitude',
        'latitude',
        'is_show',
        'star_leave',
        'open_time_desc',
    ];

    public function getKeywordsAttribute($key): array
    {
        $str = [];
        if (!empty($key)) {
            $str = explode(',', $key);
        }
        return $str;
    }

    public static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::addGlobalScope(new WxAppId());
    }

}