<?php
// +----------------------------------------------------------------------
// | park_server [ THE PROJECT NAME IS park_server ]
// +----------------------------------------------------------------------
// | FileName: Article.php
// +----------------------------------------------------------------------
// | Function: 
// +----------------------------------------------------------------------
// | Site ( http://www.qqdeveloper.com )
// +----------------------------------------------------------------------
// | Author: 卡二条 <2665274677@qq.com>
// +----------------------------------------------------------------------
declare(strict_types=1);

namespace App\Models\Admin\SceneSpot;

use App\Scopes\WxAppId;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as AuthenticTable;

class SceneSpot extends AuthenticTable
{
    use Notifiable;
    use SoftDeletes;

    /**
     * @var string
     */
    protected $table = 'scene_spot';
    /**
     * @var array
     */
    protected $fillable = [
        'uuid',
        'name',
        'description',
        'open_start_time',
        'open_end_time',
        'detail_address',
        'longitude',
        'latitude',
        'cover',
        'content',
        'reading_score',
        'click_score',
        'share_score',
        'collection_score',
        'reading',
        'punch',
        'click',
        'orders',
        'share',
        'collection',
        'oppose',
        'is_show',
        'is_top',
        'is_hot',
        'wxapp_id',
        'scene_area_id',
        'province_code',
        'city_code',
        'district_code',
        'phone_number',
        'mobile_number',
        'keywords',
        'sale_ticket',
        'star_leave'
    ];

    public function getKeywordsAttribute($key): array
    {
        $str = [];
        if (!empty($key)) {
            $str = explode(',', $key);
        }
        return $str;
    }

    public static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        static::addGlobalScope(new WxAppId());
    }

    public function area()
    {
        return $this->belongsTo(SceneArea::class, 'scene_area_id', 'id');
    }
}