<?php
/**
 * 文章信息表
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateArticleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('article', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->string('title', 32)->comment('文章标题');
            $table->string('author', 32)->comment('文章作者');
            $table->string('description', 32)->comment('文章简介');
            $table->string('cover', 255)->comment('文章封面');
            $table->text('content')->comment('文章内容');
            $table->tinyInteger('reading_score', false, true)->default(0)->comment('文章阅读积分');
            $table->tinyInteger('share_score', false, true)->default(0)->comment('文章分享积分');
            $table->tinyInteger('click_score', false, true)->default(0)->comment('文章点赞积分');
            $table->tinyInteger('collection_score', false, true)->default(0)->comment('文章收藏积分');
            $table->tinyInteger('is_show', false, true)->default(0)->comment('是否显示');
            $table->tinyInteger('is_top', false, true)->default(0)->comment('是否置顶');
            $table->tinyInteger('is_hot', false, true)->default(0)->comment('是否热门');
            $table->integer('orders', false, true)->default(0)->comment('显示顺序');
            $table->timestamp('publish_time')->nullable()->comment('发布时间');
            $table->integer('reading', false, true)->default(0)->comment('阅读数量');
            $table->integer('click', false, true)->default(0)->comment('点赞数量');
            $table->integer('share', false, true)->default(0)->comment('分享数量');
            $table->integer('collection', false, true)->default(0)->comment('收藏数量');
            $table->integer('oppose', false, true)->default(0)->comment('反对数量');
            $table->string('keywords', 255)->nullable()->comment('文章标签');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}article`  comment '文章信息'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article');
    }
}
