<?php
/**
 * 文章标签表
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateArticleTagTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('article_tag', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->string('name', '10')->unique()->comment('标签名称');
            $table->integer('orders', false, true)->default(0)->comment('显示顺序');
            $table->tinyInteger('is_show', false, true)->default(0)->comment('是否显示');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
        });
        DB::select("alter table `{$dbPrefix}article_tag`  comment '文章标签'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_tag');
    }
}
