<?php
/**
 * 文章标签关联
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateArticleTagRelationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('article_tag_relation', function (Blueprint $table) {
            $table->uuid('article_uuid')->comment('文章uuid');
            $table->uuid('article_tag_uuid')->comment('标签uui');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
        });
        DB::select("alter table `{$dbPrefix}article_tag_relation`  comment '文章标签关联'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_tag_relation');
    }
}
