<?php
/**
 * 文章分类关联
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateArticleCategoryRelationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('article_category_relation', function (Blueprint $table) {
            $table->uuid('article_uuid')->comment('文章uuid');
            $table->uuid('article_category_uuid')->comment('分类uui');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
        });
        DB::select("alter table `{$dbPrefix}article_category_relation`  comment '文章分类关联'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('article_category_relation');
    }
}
