<?php
/**
 * 景点信息
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreatePlatformSceneSpotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('scene_spot', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->integer('scene_area_id', false, true)->comment('景区id,scene_area主键id');
            $table->string('name', 255)->comment('景点名称');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->text('cover')->comment('景点封面');
            $table->string('description', 255)->comment('景点简介');
            $table->text('content')->nullable()->comment('景点介绍');
            $table->time('open_start_time')->nullable()->comment('景点营业开始时间');
            $table->time('open_end_time')->nullable()->comment('景点营业结束时间');
            $table->string('detail_address', 255)->comment('景点地址');
            $table->string('longitude', 32)->comment('地址经度');
            $table->string('latitude', 32)->comment('地址纬度');
            $table->integer('reading', false, true)->default(0)->comment('阅读数量');
            $table->integer('click', false, true)->default(0)->comment('点赞数量');
            $table->integer('share', false, true)->default(0)->comment('分享数量');
            $table->integer('collection', false, true)->default(0)->comment('收藏数量');
            $table->integer('oppose', false, true)->default(0)->comment('反对数量');
            $table->integer('punch', false, true)->default(0)->comment('打卡数量');
            $table->tinyInteger('reading_score', false, true)->default(0)->comment('景点阅读积分');
            $table->tinyInteger('share_score', false, true)->default(0)->comment('景点分享积分');
            $table->tinyInteger('click_score', false, true)->default(0)->comment('景点点赞积分');
            $table->tinyInteger('collection_score', false, true)->default(0)->comment('景点收藏积分');
            $table->integer('orders', false, true)->default(0)->comment('显示顺序');
            $table->tinyInteger('is_show', false, true)->default(0)->comment('是否显示');
            $table->tinyInteger('is_top', false, true)->default(0)->comment('是否置顶');
            $table->tinyInteger('is_hot', false, true)->default(0)->comment('是否热门');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}scene_spot`  comment '景点信息'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scene_spot');
    }
}
