<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldAddressSpotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scene_spot', function (Blueprint $table) {
            $table->string('province_code', 10)->comment('景点省份code');
            $table->string('city_code', 10)->comment('景点城市code');
            $table->string('district_code', 10)->comment('景点县区code');
            $table->string('phone_number', 20)->nullable()->comment('景点联系手机电话');
            $table->string('mobile_number', 20)->nullable()->comment('景点联系座机电话');
            $table->string('keywords', 255)->nullable()->comment('景点标签');
            $table->integer('sale_ticket', false, true)->nullable()->default(0)->comment('景点售票数量');
            $table->tinyInteger('star_leave', false, true)->default(1)->nullable()->comment('景点星级');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scene_spot', function (Blueprint $table) {
            //
        });
    }
}
