<?php
/**
 * 景区信息
 */

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePlatformSceneAreaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('scene_area', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->string('name', 255)->comment('景区名称');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->text('cover')->comment('景区封面');
            $table->string('description', 255)->comment('景区简介');
            $table->text('content')->nullable()->comment('景区介绍');
            $table->time('open_start_time')->nullable()->comment('景区营业开始时间');
            $table->time('open_end_time')->nullable()->comment('景区营业结束时间');
            $table->string('open_time_desc')->comment('营业时间描述');
            $table->string('address', 255)->comment('景区地址');
            $table->string('longitude', 32)->comment('地址经度');
            $table->string('latitude', 32)->comment('地址纬度');
            $table->tinyInteger('star_leave', false, true)->default(1)->nullable()->comment('景区星级');
            $table->tinyInteger('is_show', false, true)->default(0)->comment('是否显示');
            $table->integer('create_time', false, true)->nullable()->comment('创建时间');
            $table->integer('update_time', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}scene_area`  comment '景区信息'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('scene_area');
    }
}
