<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldAddressAreaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('scene_area', function (Blueprint $table) {
            $table->string('province_code', 10)->comment('景区省份code');
            $table->string('city_code', 10)->comment('景区城市code');
            $table->string('district_code', 10)->comment('景区县区code');
            $table->string('keywords', 255)->nullable()->comment('景区标签');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('scene_area', function (Blueprint $table) {
            //
        });
    }
}
