<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateBannerTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('banner', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->string('title', 32)->comment('图片描述');
            $table->string('cover', 255)->comment('图片地址');
            $table->string('url', 255)->nullable()->comment('跳转地址');
            $table->tinyInteger('position', false, true)->default(1)->comment('图片位置1首页');
            $table->tinyInteger('is_show', false, true)->default(1)->comment('显示状态1显示|2禁止');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->integer('orders', false, true)->default(1)->comment('显示顺序');
            $table->integer('created_at', false, true)->nullable()->comment('创建时间');
            $table->integer('updated_at', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}banner`  comment '系统轮播图'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('banner');
    }
}
