<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateAboutMeTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('about_me', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->uuid('uuid')->unique()->comment('全局唯一id');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->text('content')->comment('内容');
            $table->tinyInteger('is_show', false, true)->default(1)->comment('显示状态1显示|2禁止');
            $table->integer('created_time', false, true)->nullable()->comment('创建时间');
            $table->integer('updated_time', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}about_me`  comment '关于我们'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('about_me');
    }
}
