<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserArticleClickTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('user_article_click', function (Blueprint $table) {
            $table->uuid('article_uuid')->comment('文章uuid');
            $table->integer('user_id', false, true)->comment('用户id');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->integer('created_time', false, true)->nullable()->comment('创建时间');
            $table->integer('updated_time', false, true)->nullable()->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}user_article_click`  comment '用户文章点赞历史'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_article_click');
    }
}
