<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserFeedbackImgTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $dbPrefix = env('DB_PREFIX', '');
        Schema::create('user_feedback_img', function (Blueprint $table) {
            $table->integer('id', true, true)->unique();
            $table->string('content', 1000)->comment('返回内容');
            $table->integer('user_id', false, true)->comment('留言用户id');
            $table->integer('user_feedback_id', false, true)->comment('留言信息id');
            $table->integer('wxapp_id', false, true)->nullable()->default(0)->comment('微信appid');
            $table->timestamp('created_at')->comment('创建时间');
            $table->timestamp('updated_at')->comment('修改时间');
            $table->timestamp('deleted_at')->nullable()->comment('删除时间');
        });
        DB::select("alter table `{$dbPrefix}user_feedback_img`  comment '用户留言图片'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_feedback_img');
    }
}
