<?php

/* ========================================================================
 * $Id: QrReader.php 5612 2019-09-07 21:05:02Z onez $
 * 
 * Email: www@onez.cn
 * QQ: 6200103
 * HomePage: http://www.onezphp.com
 * ========================================================================
 * Copyright 2016-2017 佳蓝科技.
 * 
 * ======================================================================== */


include_once(dirname(__FILE__).'/Reader.php');
include_once(dirname(__FILE__).'/BinaryBitmap.php');
include_once(dirname(__FILE__).'/common/detector/MathUtils.php');
include_once(dirname(__FILE__).'/common/BitMatrix.php');
include_once(dirname(__FILE__).'/common/BitSource.php');
include_once(dirname(__FILE__).'/common/BitArray.php');
include_once(dirname(__FILE__).'/common/CharacterSetEci.php');//
include_once(dirname(__FILE__).'/common/AbstractEnum.php');//
include_once(dirname(__FILE__).'/BinaryBitmap.php');
include_once(dirname(__FILE__).'/LuminanceSource.php');
include_once(dirname(__FILE__).'/GDLuminanceSource.php');
include_once(dirname(__FILE__).'/IMagickLuminanceSource.php');
include_once(dirname(__FILE__).'/common/customFunctions.php');
include_once(dirname(__FILE__).'/common/PerspectiveTransform.php');
include_once(dirname(__FILE__).'/common/GridSampler.php');
include_once(dirname(__FILE__).'/common/DefaultGridSampler.php');
include_once(dirname(__FILE__).'/common/DetectorResult.php');
include_once(dirname(__FILE__).'/common/reedsolomon/GenericGFPoly.php');
include_once(dirname(__FILE__).'/common/reedsolomon/GenericGF.php');
include_once(dirname(__FILE__).'/common/reedsolomon/ReedSolomonDecoder.php');
include_once(dirname(__FILE__).'/common/reedsolomon/ReedSolomonException.php');

include_once(dirname(__FILE__).'/qrcode/decoder/Decoder.php');
include_once(dirname(__FILE__).'/ReaderException.php');
include_once(dirname(__FILE__).'/NotFoundException.php');
include_once(dirname(__FILE__).'/FormatException.php');
include_once(dirname(__FILE__).'/ChecksumException.php');
include_once(dirname(__FILE__).'/qrcode/detector/FinderPatternInfo.php');
include_once(dirname(__FILE__).'/qrcode/detector/FinderPatternFinder.php');
include_once(dirname(__FILE__).'/ResultPoint.php');
include_once(dirname(__FILE__).'/qrcode/detector/FinderPattern.php');
include_once(dirname(__FILE__).'/qrcode/detector/AlignmentPatternFinder.php');
include_once(dirname(__FILE__).'/qrcode/detector/AlignmentPattern.php');
include_once(dirname(__FILE__).'/qrcode/decoder/Version.php');
include_once(dirname(__FILE__).'/qrcode/decoder/BitMatrixParser.php');
include_once(dirname(__FILE__).'/qrcode/decoder/FormatInformation.php');
include_once(dirname(__FILE__).'/qrcode/decoder/ErrorCorrectionLevel.php');
include_once(dirname(__FILE__).'/qrcode/decoder/DataMask.php');
include_once(dirname(__FILE__).'/qrcode/decoder/DataBlock.php');
include_once(dirname(__FILE__).'/qrcode/decoder/DecodedBitStreamParser.php');
include_once(dirname(__FILE__).'/qrcode/decoder/Mode.php');
include_once(dirname(__FILE__).'/common/DecoderResult.php');
include_once(dirname(__FILE__).'/Result.php');
include_once(dirname(__FILE__).'/Binarizer.php');
include_once(dirname(__FILE__).'/common/GlobalHistogramBinarizer.php');
include_once(dirname(__FILE__).'/common/HybridBinarizer.php');


final class QrReader
{
    const SOURCE_TYPE_FILE = 'file';
    const SOURCE_TYPE_BLOB = 'blob';
    const SOURCE_TYPE_RESOURCE = 'resource';

    public $result;

    function __construct($imgsource, $sourcetype = QrReader::SOURCE_TYPE_FILE, $isUseImagickIfAvailable = false)
    {

        try {
            switch($sourcetype) {
                case QrReader::SOURCE_TYPE_FILE:
                    if($isUseImagickIfAvailable && extension_loaded('imagick')) {
                        $im = new Imagick();
                        $im->readImage($imgsource);
                    }else {
                        $image = file_get_contents($imgsource);
                        $im = imagecreatefromstring($image);
                    }

                    break;

                case QrReader::SOURCE_TYPE_BLOB:
                    if($isUseImagickIfAvailable && extension_loaded('imagick')) {
                        $im = new Imagick();
                        $im->readimageblob($imgsource);
                    }else {
                        $im = imagecreatefromstring($imgsource);
                    }

                    break;

                case QrReader::SOURCE_TYPE_RESOURCE:
                    $im = $imgsource;
                    if($isUseImagickIfAvailable && extension_loaded('imagick')) {
                        $isUseImagickIfAvailable = true;
                    }else {
                        $isUseImagickIfAvailable = false;
                    }

                    break;
            }

            if($isUseImagickIfAvailable && extension_loaded('imagick')) {
                $width = $im->getImageWidth();
                $height = $im->getImageHeight();
                $source = new \Zxing\IMagickLuminanceSource($im, $width, $height);
            }else {
                $width = imagesx($im);
                $height = imagesy($im);
                $source = new \Zxing\GDLuminanceSource($im, $width, $height);
            }
            $histo = new \Zxing\Common\HybridBinarizer($source);
            $bitmap = new \Zxing\BinaryBitmap($histo);
            $reader = new \Zxing\Qrcode\QRCodeReader();

            $this->result = $reader->decode($bitmap);
        }catch (\Zxing\NotFoundException $er){
            $this->result = false;
        }catch( \Zxing\FormatException $er){
            $this->result = false;
        }catch( \Zxing\ChecksumException $er){
            $this->result = false;
        }
    }

    public function text()
    {
        if(method_exists($this->result,'toString')) {
            return  ($this->result->toString());
        }else{
            return $this->result;
        }
    }

    public function decode()
    {
        return $this->text();
    }
}

