<?php

use app\common\model\Category;
use fast\Form;
use fast\Tree;
use think\Db;

/**
 * 生成下拉列表
 * @param string $name
 * @param mixed $options
 * @param mixed $selected
 * @param mixed $attr
 * @return string
 */
function build_select($name, $options, $selected = [], $attr = [])
{
    $options = is_array($options) ? $options : explode(',', $options);
    $selected = is_array($selected) ? $selected : explode(',', $selected);
    return Form::select($name, $options, $selected, $attr);
}

/**
 * 生成单选按钮组
 * @param string $name
 * @param array $list
 * @param mixed $selected
 * @return string
 */
function build_radios($name, $list = [], $selected = null)
{
    $html = [];
    $selected = is_null($selected) ? key($list) : $selected;
    $selected = is_array($selected) ? $selected : explode(',', $selected);
    foreach ($list as $k => $v)
    {
        $html[] = sprintf(Form::label("{$name}-{$k}", "%s {$v}"), Form::radio($name, $k, in_array($k, $selected), ['id' => "{$name}-{$k}"]));
    }
    return '<div class="radio">' . implode(' ', $html) . '</div>';
}

/**
 * 生成复选按钮组
 * @param string $name
 * @param array $list
 * @param mixed $selected
 * @return string
 */
function build_checkboxs($name, $list = [], $selected = null)
{
    $html = [];
    $selected = is_null($selected) ? [] : $selected;
    $selected = is_array($selected) ? $selected : explode(',', $selected);
    foreach ($list as $k => $v)
    {
        $html[] = sprintf(Form::label("{$name}-{$k}", "%s {$v}"), Form::checkbox($name, $k, in_array($k, $selected), ['id' => "{$name}-{$k}"]));
    }
    return '<div class="checkbox">' . implode(' ', $html) . '</div>';
}

/**
 * 生成复选按钮组（针对需要在同一行显示不同复选框名称的场景）
 * @param $options
 * @return string
 */
function build_multi_checkboxs($options) {
    $checkStr = '';
    foreach ($options as $option) {
        $name = $option['name'];
        $list = $option['list'];
        $selected = $option['selected'];
        $html = [];
        $selected = is_null($selected) ? [] : $selected;
        $selected = is_array($selected) ? $selected : explode(',', $selected);
        foreach ($list as $k => $v) {
            $html[] = sprintf(Form::label("{$name}-{$k}", "%s {$v}"), Form::checkbox($name, $k, in_array($k, $selected), ['id' => "{$name}-{$k}"]));
        }
        $checkStr .= implode(' ', $html);
    }
    return '<div class="checkbox">' . $checkStr . '</div>';
}

/**
 * 生成分类下拉列表框
 * @param string $name
 * @param string $type
 * @param mixed $selected
 * @param array $attr
 * @return string
 */
function build_category_select($name, $type, $selected = null, $attr = [], $header = [])
{
    $tree = Tree::instance();
    $tree->init(Category::getCategoryArray($type), 'pid');
    $categorylist = $tree->getTreeList($tree->getTreeArray(0), 'name');
    $categorydata = $header ? $header : [];
    foreach ($categorylist as $k => $v)
    {
        $categorydata[$v['id']] = $v['name'];
    }
    $attr = array_merge(['id' => "c-{$name}", 'class' => 'form-control selectpicker'], $attr);
    return build_select($name, $categorydata, $selected, $attr);
}

/**
 * 生成表格操作按钮栏
 * @param array $btns 按钮组
 * @param array $attr 按钮属性值
 * @return string
 */
function build_toolbar($btns = NULL, $attr = [])
{
    $auth = \app\admin\library\Auth::instance();
    $controller = str_replace('.', '/', strtolower(think\Request::instance()->controller()));
    $btns = $btns ? $btns : ['refresh', 'add', 'edit', 'del'];
    $btns = is_array($btns) ? $btns : explode(',', $btns);
    $index = array_search('delete', $btns);
    if ($index !== FALSE)
    {
        $btns[$index] = 'del';
    }
    $btnAttr = [
        'refresh' => ['javascript:;', 'btn btn-primary btn-refresh', 'fa fa-refresh', ''],
        'add'     => ['javascript:;', 'btn btn-success btn-add', 'fa fa-plus', __('Add')],
        'edit'    => ['javascript:;', 'btn btn-success btn-edit btn-disabled disabled', 'fa fa-pencil', __('Edit')],
        'del'     => ['javascript:;', 'btn btn-danger btn-del btn-disabled disabled', 'fa fa-trash', __('Delete')],
    ];
    $btnAttr = array_merge($btnAttr, $attr);
    $html = [];
    foreach ($btns as $k => $v)
    {
        //如果未定义或没有权限
        if (!isset($btnAttr[$v]) || ($v !== 'refresh' && !$auth->check("{$controller}/{$v}")))
        {
            continue;
        }
        list($href, $class, $icon, $text) = $btnAttr[$v];
        $html[] = '<a href="' . $href . '" class="' . $class . '" ><i class="' . $icon . '"></i> ' . $text . '</a>';
    }
    return implode(' ', $html);
}

/**
 * 生成页面Heading
 *
 * @param string $path 指定的path
 * @return string
 */
function build_heading($path = NULL, $container = TRUE)
{
    $title = $content = '';
    if (is_null($path))
    {
        $action = request()->action();
        $controller = str_replace('.', '/', request()->controller());
        $path = strtolower($controller . ($action && $action != 'index' ? '/' . $action : ''));
    }
    // 根据当前的URI自动匹配父节点的标题和备注
    $data = Db::name('auth_rule')->where('name', $path)->field('title,remark')->find();
    if ($data)
    {
        $title = __($data['title']);
        $content = __($data['remark']);
    }
    if (!$title)
        return '';
    $result = '<div class="panel-lead"><em>' . $title . '</em>' . $content . '</div>';
    if ($container)
    {
        $result = '<div class="panel-heading">' . $result . '</div>';
    }
    return $result;
}

function build_header($breadCrumb=array(), $container = TRUE) {
    if(!$breadCrumb){
        return '';
    }
    $tmp = '';
    $result = '<div class="panel-lead"><em>';
    foreach ($breadCrumb as $k => $item) {
        $tmp .= ' / '.__($item);
    }
    if ($tmp) {
        $tmp = substr($tmp,3);
    }
    $result .= $tmp.'</em></div>';
    if ($container) {
        $result = '<div class="panel-heading">' . $result . '</div>';
    }
    return $result;
}
