/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50045
Source Host           : localhost:3306
Source Database       : ftwebos

Target Server Type    : MYSQL
Target Server Version : 50045
File Encoding         : 65001

Date: 2013-05-14 11:40:08
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `ft_app`
-- ----------------------------
DROP TABLE IF EXISTS `ft_app`;
CREATE TABLE `ft_app` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci default NULL COMMENT '图标名称',
  `icon` tinytext collate utf8_unicode_ci COMMENT '图标图片',
  `url` tinytext collate utf8_unicode_ci COMMENT '图标链接',
  `type` varchar(255) collate utf8_unicode_ci default NULL COMMENT '应用类型，参数有：app，widget',
  `kindid` int(11) default '0',
  `width` int(11) default NULL COMMENT '窗口宽度',
  `height` int(11) default NULL COMMENT '窗口高度',
  `isresize` tinyint(1) default NULL COMMENT '是否能对窗口进行拉伸',
  `issetbar` tinyint(1) default NULL COMMENT '窗口是否有评分按钮,0无1有',
  `isflash` tinyint(1) default NULL COMMENT '是否为flash应用',
  `remark` tinytext collate utf8_unicode_ci,
  `usecount` bigint(20) default '0' COMMENT '使用人数',
  `starnum` decimal(10,2) default '0.00' COMMENT '评分',
  `dt` datetime default NULL,
  `indexid` bigint(20) default '1' COMMENT '排序',
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_app
-- ----------------------------
INSERT INTO `ft_app` VALUES ('1', '应用管理', 'img/shortcut/default/app_center.png', 'sysfiles/appmanage/index.php', 'app', '1', '850', '572', '0', '0', '0', '对应用进行编辑管理', '8', '0.00', '2012-02-26 22:51:53', '1');
INSERT INTO `ft_app` VALUES ('2', '系统设置', 'img/ui/setup.png', 'sysfiles/setting/index.php', 'app', '1', '820', '583', '0', '0', '0', '系统设置', '7', '3.00', '2012-02-26 22:52:40', '1');
INSERT INTO `ft_app` VALUES ('3', '用户管理', 'img/ui/user.png', 'sysfiles/member/index.php', 'app', '1', '900', '615', '0', '0', '0', '会员管理', '9', '0.00', '2012-07-19 10:57:28', '1');
INSERT INTO `ft_app` VALUES ('4', '权限管理', 'img/ui/system-qs.png', 'sysfiles/permission/index.php', 'app', '1', '900', '615', '1', '0', '0', '权限管理', '5', '5.00', '2012-07-19 10:59:41', '1');
INSERT INTO `ft_app` VALUES ('5', '图片处理', 'img/shortcut/default/syspic.png', 'http://www.webps.cn/', 'app', '2', '900', '600', '1', '1', '0', '图片处理', '4', '3.00', '2012-02-26 22:52:55', '1');
INSERT INTO `ft_app` VALUES ('6', '视频应用', 'img/shortcut/default/shiping.png', 'http://tv.sohu.com/upload/sohuapp/index.html?api_key=9ca7e3cdef8af010b947f4934a427a2c', 'app', '2', '900', '620', '1', '1', '0', '视频应用', '4', '2.00', '2012-02-26 22:52:58', '1');
INSERT INTO `ft_app` VALUES ('7', '美图秀秀', 'img/ui/papp.png', 'http://xiuxiu.web.meitu.com/qq/web/', 'app', '2', '900', '610', '0', '0', '0', '美图秀秀', '1', '0.00', '2013-02-19 14:15:37', '1');

-- ----------------------------
-- Table structure for `ft_app_star`
-- ----------------------------
DROP TABLE IF EXISTS `ft_app_star`;
CREATE TABLE `ft_app_star` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `app_id` bigint(20) default NULL,
  `member_id` bigint(20) default NULL,
  `starnum` int(1) default '0',
  `dt` datetime default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_app_star
-- ----------------------------
INSERT INTO `ft_app_star` VALUES ('1', '7', '1', '2', '2012-07-27 22:10:02');
INSERT INTO `ft_app_star` VALUES ('2', '5', '1', '3', '2012-08-08 14:27:34');
INSERT INTO `ft_app_star` VALUES ('3', '6', '1', '3', '2012-09-23 21:59:53');
INSERT INTO `ft_app_star` VALUES ('4', '4', '1', '5', '2012-11-21 18:03:37');
INSERT INTO `ft_app_star` VALUES ('5', '2', '1', '3', '2012-11-24 23:29:29');

-- ----------------------------
-- Table structure for `ft_file`
-- ----------------------------
DROP TABLE IF EXISTS `ft_file`;
CREATE TABLE `ft_file` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `icon` varchar(255) collate utf8_unicode_ci default NULL COMMENT '图标地址',
  `name` varchar(255) collate utf8_unicode_ci default NULL COMMENT '文件名',
  `ext` varchar(255) collate utf8_unicode_ci default NULL COMMENT '扩展名',
  `size` int(11) default NULL COMMENT '文件大小',
  `url` text collate utf8_unicode_ci COMMENT '文件存放地址',
  `member_id` bigint(20) default NULL,
  `dt` datetime default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_file
-- ----------------------------

-- ----------------------------
-- Table structure for `ft_folder`
-- ----------------------------
DROP TABLE IF EXISTS `ft_folder`;
CREATE TABLE `ft_folder` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `icon` varchar(255) collate utf8_unicode_ci default 'default',
  `name` varchar(255) collate utf8_unicode_ci default NULL,
  `content` tinytext collate utf8_unicode_ci,
  `member_id` bigint(20) default NULL,
  `dt` datetime default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_folder
-- ----------------------------
INSERT INTO `ft_folder` VALUES ('1', 'img/ui/folder_default.png', '新建文件夹', '', '1', '2012-08-20 21:54:07');
INSERT INTO `ft_folder` VALUES ('2', 'img/ui/folder_doc.png', '我的文档', '', '1', '2012-09-15 23:06:43');

-- ----------------------------
-- Table structure for `ft_member`
-- ----------------------------
DROP TABLE IF EXISTS `ft_member`;
CREATE TABLE `ft_member` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `username` varchar(255) collate utf8_unicode_ci default NULL,
  `password` varchar(255) collate utf8_unicode_ci default NULL,
  `type` tinyint(1) default '0' COMMENT '用户类型，0普通用户，1管理员',
  `permission_id` bigint(20) default NULL,
  `dock` longtext collate utf8_unicode_ci COMMENT '[应用码头]应用id，用","相连',
  `desk1` longtext collate utf8_unicode_ci COMMENT '[桌面1]应用id，用","相连',
  `desk2` longtext collate utf8_unicode_ci COMMENT '[桌面2]应用id，用","相连',
  `desk3` longtext collate utf8_unicode_ci COMMENT '[桌面3]应用id，用","相连',
  `desk4` longtext collate utf8_unicode_ci COMMENT '[桌面4]应用id，用","相连',
  `desk5` longtext collate utf8_unicode_ci COMMENT '[桌面5]应用id，用","相连',
  `appxy` varchar(255) collate utf8_unicode_ci default 'x' COMMENT '图标排列方式',
  `dockpos` varchar(255) collate utf8_unicode_ci default 'right' COMMENT '应用码头位置，参数：left,right',
  `wallpaper_id` int(11) default '1',
  `wallpaperwebsite` text collate utf8_unicode_ci,
  `wallpaperstate` tinyint(4) default '1' COMMENT '1系统壁纸、2自定义壁纸、3网络地址',
  `wallpapertype` varchar(255) collate utf8_unicode_ci default 'lashen' COMMENT '壁纸显示方式：tianchong,shiying,pingpu,lashen,juzhong',
  `skin` varchar(255) collate utf8_unicode_ci default 'default' COMMENT '窗口皮肤',
  `regdt` datetime default NULL COMMENT '注册时间',
  `lastlogindt` datetime default NULL COMMENT '最后登入时间',
  `lastloginip` varchar(255) collate utf8_unicode_ci default NULL COMMENT '最后登入IP',
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_member
-- ----------------------------
INSERT INTO `ft_member` VALUES ('1', 'admin', '8ac409a3cd23299eabae39655aa88d12cca8fd37', '1', '1', '', 'app_1,app_4,app_3,app_2,app_5,app_6,app_7', 'folder_2', '', '', 'folder_1', 'y', 'right', '1', 'http://www.baidu.com', '1', 'lashen', 'default', '2012-02-29 00:00:00', '2013-04-24 18:48:24', '127.0.0.1');
INSERT INTO `ft_member` VALUES ('2', 'test', '7c4a8d09ca3762af61e59520943dc26494f8941b', '0', '2', '', 'app_2,app_1,app_3,app_4,app_5,app_6,app_7', '', '', '', '', 'y', 'no_dock', '1', null, '1', 'lashen', 'default', '2013-02-18 08:17:04', '2013-05-14 11:39:35', '127.0.0.1');

-- ----------------------------
-- Table structure for `ft_papp`
-- ----------------------------
DROP TABLE IF EXISTS `ft_papp`;
CREATE TABLE `ft_papp` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci default NULL COMMENT '图标名称',
  `icon` tinytext collate utf8_unicode_ci COMMENT '图标图片',
  `url` tinytext collate utf8_unicode_ci COMMENT '图标链接',
  `type` varchar(255) collate utf8_unicode_ci default NULL COMMENT '应用类型，参数有：app，widget',
  `width` int(11) default NULL COMMENT '窗口宽度',
  `height` int(11) default NULL COMMENT '窗口高度',
  `isresize` tinyint(1) default NULL COMMENT '是否能对窗口进行拉伸',
  `dt` datetime default NULL,
  `indexid` bigint(20) default '1' COMMENT '排序',
  `member_id` bigint(20) default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_papp
-- ----------------------------
INSERT INTO `ft_papp` VALUES ('4', '个人应用', 'img/ui/papp.png', 'http://www.qq.com', 'papp', '600', '400', '1', '2012-09-16 20:36:46', '1', '1');
INSERT INTO `ft_papp` VALUES ('5', 'aaaaa', 'img/ui/papp.png', '#', 'papp', '600', '400', '1', '2013-01-06 11:14:14', '1', '1');
INSERT INTO `ft_papp` VALUES ('6', 'bbbbb', 'img/ui/papp.png', '#', 'pwidget', '600', '400', '1', '2013-01-06 11:14:45', '1', '1');

-- ----------------------------
-- Table structure for `ft_permission`
-- ----------------------------
DROP TABLE IF EXISTS `ft_permission`;
CREATE TABLE `ft_permission` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `name` varchar(255) collate utf8_unicode_ci default NULL,
  `apps_id` longtext collate utf8_unicode_ci,
  `opqs` varchar(15) collate utf8_unicode_ci default NULL,
  `remark` text collate utf8_unicode_ci,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_permission
-- ----------------------------
INSERT INTO `ft_permission` VALUES ('1', '高级管理员', '13,10,9,7,6,4,3,2,1', '1,2,3', null);
INSERT INTO `ft_permission` VALUES ('2', '普通管理员', '13,10,9,7,6,3,1,2,4', '0', '');

-- ----------------------------
-- Table structure for `ft_pwallpaper`
-- ----------------------------
DROP TABLE IF EXISTS `ft_pwallpaper`;
CREATE TABLE `ft_pwallpaper` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `url` tinytext collate utf8_unicode_ci,
  `width` int(11) default NULL,
  `height` int(11) default NULL,
  `member_id` bigint(20) default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_pwallpaper
-- ----------------------------
INSERT INTO `ft_pwallpaper` VALUES ('1', 'userfile/member/1/wallpaper/wallpaper1.jpg', '1920', '1080', '1');
INSERT INTO `ft_pwallpaper` VALUES ('2', 'userfile/member/1/wallpaper/wallpaper2.jpg', '1920', '1080', '1');
INSERT INTO `ft_pwallpaper` VALUES ('3', 'userfile/member/1/wallpaper/wallpaper2.jpg', '1920', '1080', '2');
INSERT INTO `ft_pwallpaper` VALUES ('5', 'userfile/member/1/wallpaper/wallpaper5.jpg', '1600', '900', '1');

-- ----------------------------
-- Table structure for `ft_setting`
-- ----------------------------
DROP TABLE IF EXISTS `ft_setting`;
CREATE TABLE `ft_setting` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `title` text COMMENT '网站标题',
  `description` text COMMENT '网站描述',
  `keywords` text COMMENT '网站关键字',
  `desk` tinyint(1) default '1' COMMENT '默认在哪个桌面',
  `dockPos` varchar(15) default 'right' COMMENT '应用码头默认位置',
  `appXY` varchar(2) default 'y' COMMENT '图标排列方式：y为竖排x为横排',
  `appButtonTop` int(2) default '15' COMMENT '桌面图标top初始位置',
  `appButtonLeft` int(2) default '12' COMMENT '桌面图标left初始位置',
  `windowMinWidth` int(5) default '60' COMMENT '窗口最小高度',
  `windowMinHeight` int(3) default '60' COMMENT '窗口最小高度',
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ft_setting
-- ----------------------------
INSERT INTO `ft_setting` VALUES ('1', '飞天桌面系统 - 作者：陈惠添', '飞天桌面系统是一套web桌面应用框架，你可以用它开发出类似于Q+web这类的桌面应用网站，也可以在它的基础上二次开发出适合项目的桌面式管理系统。', 'WEB桌面,免费开源,桌面管理系统', '1', 'no_dock', 'y', '12', '12', '220', '60');

-- ----------------------------
-- Table structure for `ft_wallpaper`
-- ----------------------------
DROP TABLE IF EXISTS `ft_wallpaper`;
CREATE TABLE `ft_wallpaper` (
  `tbid` bigint(20) NOT NULL auto_increment,
  `title` varchar(255) collate utf8_unicode_ci default NULL,
  `url` tinytext collate utf8_unicode_ci,
  `width` int(11) default NULL,
  `height` int(11) default NULL,
  PRIMARY KEY  (`tbid`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of ft_wallpaper
-- ----------------------------
INSERT INTO `ft_wallpaper` VALUES ('1', '壁纸1', 'img/wallpaper/wallpaper1.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('2', '壁纸2', 'img/wallpaper/wallpaper2.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('3', '壁纸3', 'img/wallpaper/wallpaper3.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('4', '壁纸4', 'img/wallpaper/wallpaper4.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('5', '壁纸5', 'img/wallpaper/wallpaper5.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('6', '壁纸6', 'img/wallpaper/wallpaper6.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('7', '壁纸7', 'img/wallpaper/wallpaper7.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('8', '壁纸8', 'img/wallpaper/wallpaper8.jpg', '1920', '1080');
INSERT INTO `ft_wallpaper` VALUES ('9', '壁纸9', 'img/wallpaper/wallpaper9.jpg', '1920', '1080');
