FT.deskTop = (function() {
    return {
        resize: function(time) {
            $.doTimeout('resize', time, 
            function() {
                if ($('#desktop').css('display') !== 'none') {
                    FT.dock.setPos();
                    FT.deskTop.appresize();
                    FT.deskTop.windowresize();
                    FT.app.getScrollbar()
                } else {
                    FT.appmanage.resize()
                }
                FT.wallpaper.set(false)
            })
        },
        appresize: function() {
            var grid = FT.grid.getAppGrid(),
            dockGrid = FT.grid.getDockAppGrid();
            $('#dock-bar .dock-applist li').each(function(i) {
                $(this).animate({
                    'left': dockGrid[i]['startX'],
                    'top': dockGrid[i]['startY']
                },
                500)
            });
            for (var j = 1; j <= 5; j++) {
                $('#desk-' + j + ' li').each(function(i) {
                    $(this).animate({
                        'left': grid[i]['startX'] + 7,
                        'top': grid[i]['startY'] + 7
                    },
                    500)
                })
            }
        },
        windowresize: function() {
            $('#desk div.window-container').each(function() {
                var windowdata = $(this).data('info');
                currentW = $(window).width() - $(this).width();
                currentH = $(window).height() - $(this).height();
                _l = windowdata['left'] / windowdata['emptyW'] * currentW >= currentW ? currentW: windowdata['left'] / windowdata['emptyW'] * currentW;
                _l = _l <= 0 ? 0: _l;
                _t = windowdata['top'] / windowdata['emptyH'] * currentH >= currentH ? currentH: windowdata['top'] / windowdata['emptyH'] * currentH;
                _t = _t <= 0 ? 0: _t;
                $(this).animate({
                    'left': _l,
                    'top': _t
                },
                500)
            })
        }
    }
})();
FT.app = (function() {
    return {
        getXY: function(func) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=getAppXY'
            }).done(function(i) {
                FT.CONFIG.appXY = i;
                if (typeof(func) == 'function') {
                    func()
                }
            })
        },
        updateXY: function(i, func) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=setAppXY&appxy=' + i
            }).done(function() {
                FT.CONFIG.appXY = i;
                if (typeof(func) == 'function') {
                    func()
                }
            })
        },
        get: function() {
            var grid = FT.grid.getAppGrid(),
            dockGrid = FT.grid.getDockAppGrid();
            $.getJSON(ajaxUrl + '?ac=getMyApp', 
            function(sc) {
                if (sc['dock'] != null) {
                    var dock_append = '',
                    temp = {};
                    for (var i = 0; i < sc['dock'].length; i++) {
                        dock_append += appbtnTemp({
                            'top': dockGrid[i]['startY'],
                            'left': dockGrid[i]['startX'],
                            'title': sc['dock'][i]['name'],
                            'type': sc['dock'][i]['type'],
                            'id': 'd_' + sc['dock'][i]['type'] + '_' + sc['dock'][i]['id'],
                            'realid': sc['dock'][i]['id'],
                            'imgsrc': sc['dock'][i]['icon']
                        })
                    }
                    $('#dock-bar .dock-applist').html('').append(dock_append)
                }
                for (var j = 1; j <= 5; j++) {
                    var desk_append = '',
                    temp = {};
                    if (sc['desk' + j] != null) {
                        for (var i = 0; i < sc['desk' + j].length; i++) {
                            desk_append += appbtnTemp({
                                'top': grid[i]['startY'] + 7,
                                'left': grid[i]['startX'] + 7,
                                'title': sc['desk' + j][i]['name'],
                                'type': sc['desk' + j][i]['type'],
                                'id': 'd_' + sc['desk' + j][i]['type'] + '_' + sc['desk' + j][i]['id'],
                                'realid': sc['desk' + j][i]['id'],
                                'imgsrc': sc['desk' + j][i]['icon']
                            })
                        }
                    }
                    desk_append += addbtnTemp({
                        'top': grid[i]['startY'] + 7,
                        'left': grid[i]['startX'] + 7
                    });
                    $('#desk-' + j + ' li').remove();
                    $('#desk-' + j).append(desk_append);
                    i = 0
                }
                $('#desk').off('click').on('click', 'li.add', 
                function() {
                    FT.window.createTemp({
                        id: 'yysc',
                        title: '添加应用',
                        url: 'sysfiles/appmarket/index.php',
                        width: 800,
                        height: 600,
                        isresize: false,
                        isflash: false
                    })
                });
                FT.app.move();
                FT.dock.move();
                FT.app.getScrollbar();
                FT.app.moveScrollbar();
                $('#desk').on('contextmenu', '.appbtn:not(.add)', 
                function(e) {
                    $('.popup-menu').hide();
                    $('.quick_view_container').remove();
                    switch ($(this).attr('type')) {
                    case 'app':
                    case 'widget':
                        var popupmenu = FT.popupMenu.app($(this));
                        break;
                    case 'papp':
                    case 'pwidget':
                        var popupmenu = FT.popupMenu.papp($(this));
                        break;
                    case 'folder':
                        var popupmenu = FT.popupMenu.folder($(this));
                        break
                    }
                    var l = ($(document).width() - e.clientX) < popupmenu.width() ? (e.clientX - popupmenu.width()) : e.clientX;
                    var t = ($(document).height() - e.clientY) < popupmenu.height() ? (e.clientY - popupmenu.height()) : e.clientY;
                    popupmenu.css({
                        left: l,
                        top: t
                    }).show();
                    return false
                })
            })
        },
        add: function(id, type, fun) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=addMyApp&id=' + id + '&type=' + type + '&desk=' + FT.CONFIG.desk,
                success: function() {
                    if (typeof(fun) !== 'undefined') {
                        fun()
                    }
                }
            })
        },
        remove: function(id, type, fun) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=delMyApp&id=' + id + '&type=' + type,
                success: function() {
                    if (type == 'widget') {
                        FT.widget.removeCookie(id, type)
                    }
                    if (typeof(fun) !== 'undefined') {
                        fun()
                    }
                }
            })
        },
        move: function() {
            $('#dock-bar .dock-applist').off('mousedown', 'li').on('mousedown', 'li', 
            function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (e.button == 0 || e.button == 1) {
                    var oldobj = $(this),
                    x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
                    dx = cx = e.clientX;
                    dy = cy = e.clientY;
                    x = dx - oldobj.offset().left;
                    y = dy - oldobj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        $('body').append(obj);
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX <= 0 ? 0: e.clientX >= $(document).width() ? $(document).width() : e.clientX;
                        cy = e.clientY <= 0 ? 0: e.clientY >= $(document).height() ? $(document).height() : e.clientY;
                        _l = cx - x;
                        _t = cy - y;
                        if (dx != cx || dy != cy) {
                            obj.css({
                                left: _l,
                                top: _t
                            }).show()
                        }
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        obj.remove();
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        if (dx == cx && dy == cy) {
                            switch (oldobj.attr('type')) {
                            case 'app':
                            case 'papp':
                                FT.window.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'widget':
                            case 'pwidget':
                                FT.widget.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'folder':
                                FT.folderView.init(oldobj);
                                break
                            }
                            return false
                        }
                        var folderId = FT.grid.searchFolderGrid(cx, cy);
                        if (folderId != null) {
                            if (oldobj.hasClass('folder') == false) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=dock-folder&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + folderId + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        oldobj.remove();
                                        FT.deskTop.appresize();
                                        if ($('#qv_' + folderId).length != 0) {
                                            FT.folderView.init($('#d_folder_' + folderId))
                                        }
                                        if ($('#w_folder_' + folderId).length != 0) {
                                            FT.window.updateFolder(folderId, 'folder')
                                        }
                                    }
                                })
                            }
                        } else {
                            var icon,
                            icon2;
                            var iconIndex = $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1: $('#desk-' + FT.CONFIG.desk + ' li').index(oldobj);
                            var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1: $('#dock-bar .dock-applist li').index(oldobj);
                            var dock_w2 = FT.CONFIG.dockPos == 'left' ? 0: FT.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2: $(window).width() - $('#dock-bar .dock-applist').width();
                            var dock_h2 = FT.CONFIG.dockPos == 'top' ? 0: ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
                            icon2 = FT.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
                            if (icon2 != null && icon2 != oldobj.index()) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=dock-dock&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + icon2 + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        if (icon2 < iconIndex2) {
                                            $('#dock-bar .dock-applist li:eq(' + icon2 + ')').before(oldobj)
                                        } else if (icon2 > iconIndex2) {
                                            $('#dock-bar .dock-applist li:eq(' + icon2 + ')').after(oldobj)
                                        }
                                        FT.deskTop.appresize()
                                    }
                                })
                            } else {
                                var dock_w = FT.CONFIG.dockPos == 'left' ? 73: 0;
                                var dock_h = FT.CONFIG.dockPos == 'top' ? 73: 0;
                                icon = FT.grid.searchAppGrid(cx - dock_w, cy - dock_h);
                                if (icon != null) {
                                    $.ajax({
                                        type: 'POST',
                                        url: ajaxUrl,
                                        data: 'ac=updateMyApp&movetype=dock-desk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + (icon + 1) + '&desk=' + FT.CONFIG.desk,
                                        success: function() {
                                            if (icon < iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').before(oldobj)
                                            } else if (icon > iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').after(oldobj)
                                            } else {
                                                if (iconIndex == -1) {
                                                    $('#desk-' + FT.CONFIG.desk + ' li.add').before(oldobj)
                                                }
                                            }
                                            FT.deskTop.appresize()
                                        }
                                    })
                                }
                            }
                        }
                    })
                }
                return false
            });
            $('#desk .desktop-container').off('mousedown', 'li:not(.add)').on('mousedown', 'li:not(.add)', 
            function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (e.button == 0 || e.button == 1) {
                    var oldobj = $(this),
                    x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
                    dx = cx = e.clientX;
                    dy = cy = e.clientY;
                    x = dx - oldobj.offset().left;
                    y = dy - oldobj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        $('body').append(obj);
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX <= 0 ? 0: e.clientX >= $(document).width() ? $(document).width() : e.clientX;
                        cy = e.clientY <= 0 ? 0: e.clientY >= $(document).height() ? $(document).height() : e.clientY;
                        _l = cx - x;
                        _t = cy - y;
                        if (dx != cx || dy != cy) {
                            obj.css({
                                left: _l,
                                top: _t
                            }).show()
                        }
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        obj.remove();
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        if (dx == cx && dy == cy) {
                            switch (oldobj.attr('type')) {
                            case 'app':
                            case 'papp':
                                FT.window.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'widget':
                            case 'pwidget':
                                FT.widget.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'folder':
                                FT.folderView.init(oldobj);
                                break
                            }
                            return false
                        }
                        var folderId = FT.grid.searchFolderGrid(cx, cy);
                        if (folderId != null) {
                            if (oldobj.attr('type') != 'folder') {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=desk-folder&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + (oldobj.index() - 2) + '&to=' + folderId + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        oldobj.remove();
                                        FT.deskTop.appresize();
                                        if ($('#qv_' + folderId).length != 0) {
                                            FT.folderView.init($('#d_folder_' + folderId))
                                        }
                                        if ($('#w_folder_' + folderId).length != 0) {
                                            FT.window.updateFolder(folderId, 'folder')
                                        }
                                    }
                                })
                            }
                        } else {
                            var icon,
                            icon2;
                            var iconIndex = $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1: $('#desk-' + FT.CONFIG.desk + ' li').index(oldobj);
                            var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1: $('#dock-bar .dock-applist li').index(oldobj);
                            var dock_w2 = FT.CONFIG.dockPos == 'left' ? 0: FT.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2: $(window).width() - $('#dock-bar .dock-applist').width();
                            var dock_h2 = FT.CONFIG.dockPos == 'top' ? 0: ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
                            icon2 = FT.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
                            if (icon2 != null) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=desk-dock&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + (oldobj.index() - 2) + '&to=' + (icon2 + 1) + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        if (icon2 < iconIndex2) {
                                            $('#dock-bar .dock-applist li:eq(' + icon2 + ')').before(oldobj)
                                        } else if (icon2 > iconIndex2) {
                                            $('#dock-bar .dock-applist li:eq(' + icon2 + ')').after(oldobj)
                                        } else {
                                            if (iconIndex2 == -1) {
                                                $('#dock-bar .dock-applist').append(oldobj)
                                            }
                                        }
                                        if ($('#dock-bar .dock-applist li').length > 7) {
                                            $('#desk-' + FT.CONFIG.desk + ' li.add').before($('#dock-bar .dock-applist li').last())
                                        }
                                        FT.deskTop.appresize()
                                    }
                                })
                            } else {
                                var dock_w = FT.CONFIG.dockPos == 'left' ? 73: 0;
                                var dock_h = FT.CONFIG.dockPos == 'top' ? 73: 0;
                                icon = FT.grid.searchAppGrid(cx - dock_w, cy - dock_h);
                                if (icon != null && icon != (oldobj.index() - 2)) {
                                    $.ajax({
                                        type: 'POST',
                                        url: ajaxUrl,
                                        data: 'ac=updateMyApp&movetype=desk-desk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + (oldobj.index() - 2) + '&to=' + icon + '&desk=' + FT.CONFIG.desk,
                                        success: function() {
                                            if (icon < iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').before(oldobj)
                                            } else if (icon > iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li:not(.add):eq(' + icon + ')').after(oldobj)
                                            } else {
                                                if (iconIndex == -1) {
                                                    $('#desk-' + FT.CONFIG.desk + ' li.add').before(oldobj)
                                                }
                                            }
                                            FT.deskTop.appresize()
                                        }
                                    })
                                }
                            }
                        }
                    })
                }
            });
            $('.folder_body, .quick_view_container').off('mousedown', 'li').on('mousedown', 'li', 
            function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (e.button == 0 || e.button == 1) {
                    var oldobj = $(this),
                    x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
                    dx = cx = e.clientX;
                    dy = cy = e.clientY;
                    x = dx - oldobj.offset().left;
                    y = dy - oldobj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        $('body').append(obj);
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX <= 0 ? 0: e.clientX >= $(document).width() ? $(document).width() : e.clientX;
                        cy = e.clientY <= 0 ? 0: e.clientY >= $(document).height() ? $(document).height() : e.clientY;
                        _l = cx - x;
                        _t = cy - y;
                        if (dx != cx || dy != cy) {
                            obj.css({
                                left: _l,
                                top: _t
                            }).show()
                        }
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        obj.remove();
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        if (dx == cx && dy == cy) {
                            switch (oldobj.attr('type')) {
                            case 'app':
                            case 'papp':
                                FT.window.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'widget':
                            case 'pwidget':
                                FT.widget.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break
                            }
                            return false
                        }
                        var folderId = FT.grid.searchFolderGrid(cx, cy);
                        if (folderId != null) {
                            if (oldobj.parents('.folder-window').attr('realid') != folderId) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=folder-folder&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.parents('.folder-window').attr('realid') + '&to=' + folderId + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        oldobj.remove();
                                        FT.deskTop.appresize();
                                        if ($('#qv_' + folderId).length != 0) {
                                            FT.folderView.init($('#d_folder_' + folderId))
                                        }
                                        if ($('#w_folder_' + folderId).length != 0) {
                                            FT.window.updateFolder(folderId, 'folder')
                                        }
                                    }
                                })
                            }
                        } else {
                            var icon,
                            icon2;
                            var iconIndex = $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add)').length == 0 ? -1: $('#desk-' + FT.CONFIG.desk + ' li').index(oldobj);
                            var iconIndex2 = $('#dock-bar .dock-applist').html() == '' ? -1: $('#dock-bar .dock-applist li').index(oldobj);
                            var dock_w2 = FT.CONFIG.dockPos == 'left' ? 0: FT.CONFIG.dockPos == 'top' ? ($(window).width() - $('#dock-bar .dock-applist').width() - 20) / 2: $(window).width() - $('#dock-bar .dock-applist').width();
                            var dock_h2 = FT.CONFIG.dockPos == 'top' ? 0: ($(window).height() - $('#dock-bar .dock-applist').height() - 20) / 2;
                            icon2 = FT.grid.searchDockAppGrid(cx - dock_w2, cy - dock_h2);
                            if (icon2 != null) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=folder-dock&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.parents('.folder-window').attr('realid') + '&to=' + (icon2 + 1) + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        var folderId = oldobj.parents('.folder-window').attr('realid');
                                        if (icon2 < iconIndex2) {
                                            $('#dock-bar .dock-applist li.appbtn:not(.add):eq(' + icon2 + ')').before(oldobj)
                                        } else if (icon2 > iconIndex2) {
                                            $('#dock-bar .dock-applist li.appbtn:not(.add):eq(' + icon2 + ')').after(oldobj)
                                        } else {
                                            if (iconIndex2 == -1) {
                                                $('#dock-bar .dock-applist').append(oldobj)
                                            }
                                        }
                                        if ($('#dock-bar .dock-applist li').length > 7) {
                                            $('#desk-' + FT.CONFIG.desk + ' li.add').before($('#dock-bar .dock-applist li').last())
                                        }
                                        FT.deskTop.appresize();
                                        if ($('#qv_' + folderId).length != 0) {
                                            FT.folderView.init($('#d_folder_' + folderId))
                                        }
                                        if ($('#w_folder_' + folderId).length != 0) {
                                            FT.window.updateFolder(folderId, 'folder')
                                        }
                                    }
                                })
                            } else {
                                var dock_w = FT.CONFIG.dockPos == 'left' ? 73: 0;
                                var dock_h = FT.CONFIG.dockPos == 'top' ? 73: 0;
                                icon = FT.grid.searchAppGrid(cx - dock_w, cy - dock_h);
                                if (icon != null) {
                                    $.ajax({
                                        type: 'POST',
                                        url: ajaxUrl,
                                        data: 'ac=updateMyApp&movetype=folder-desk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.parents('.folder-window').attr('realid') + '&to=' + (icon + 1) + '&desk=' + FT.CONFIG.desk,
                                        success: function() {
                                            var folderId = oldobj.parents('.folder-window').attr('realid');
                                            if (icon < iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add):eq(' + icon + ')').before(oldobj)
                                            } else if (icon > iconIndex) {
                                                $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add):eq(' + icon + ')').after(oldobj)
                                            } else {
                                                if (iconIndex == -1) {
                                                    $('#desk-' + FT.CONFIG.desk + ' li.add').before(oldobj)
                                                }
                                            }
                                            FT.deskTop.appresize();
                                            if ($('#qv_' + folderId).length != 0) {
                                                FT.folderView.init($('#d_folder_' + folderId))
                                            }
                                            if ($('#w_folder_' + folderId).length != 0) {
                                                FT.window.updateFolder(folderId, 'folder')
                                            }
                                        }
                                    })
                                }
                            }
                        }
                    })
                }
            })
        },
        getScrollbar: function() {
            setTimeout(function() {
                $('#desk .desktop-container').each(function() {
                    var desk = $(this),
                    scrollbar = desk.children('.scrollbar');
                    scrollbar.hide();
                    desk.scrollLeft(0).scrollTop(0);
                    if (FT.CONFIG.appXY == 'x') {
                        var deskH = parseInt(desk.children('.add').css('top')) + 108;
                        if (desk.height() / deskH < 1) {
                            desk.children('.scrollbar-y').height(desk.height() / deskH * desk.height()).css('top', 0).show()
                        }
                    } else {
                        var deskW = parseInt(desk.children('.add').css('left')) + 106;
                        if (desk.width() / deskW < 1) {
                            desk.children('.scrollbar-x').width(desk.width() / deskW * desk.width()).css('left', 0).show()
                        }
                    }
                })
            },
            500)
        },
        moveScrollbar: function() {
            $('.scrollbar').on('mousedown', 
            function(e) {
                var x,
                y,
                cx,
                cy,
                deskrealw,
                deskrealh,
                movew,
                moveh;
                var scrollbar = $(this),
                desk = scrollbar.parent('.desktop-container');
                deskrealw = parseInt(desk.children('.add').css('left')) + 106;
                deskrealh = parseInt(desk.children('.add').css('top')) + 108;
                movew = desk.width() - scrollbar.width();
                moveh = desk.height() - scrollbar.height();
                if (scrollbar.hasClass('scrollbar-x')) {
                    x = e.clientX - scrollbar.offset().left
                } else {
                    y = e.clientY - scrollbar.offset().top
                }
                $(document).on('mousemove', 
                function(e) {
                    if (scrollbar.hasClass('scrollbar-x')) {
                        if (FT.CONFIG.dockPos == 'left') {
                            cx = e.clientX - x - 73 < 0 ? 0: e.clientX - x - 73 > movew ? movew: e.clientX - x - 73
                        } else {
                            cx = e.clientX - x < 0 ? 0: e.clientX - x > movew ? movew: e.clientX - x
                        }
                        scrollbar.css('left', cx / desk.width() * deskrealw + cx);
                        desk.scrollLeft(cx / desk.width() * deskrealw)
                    } else {
                        if (FT.CONFIG.dockPos == 'top') {
                            cy = e.clientY - y - 73 < 0 ? 0: e.clientY - y - 73 > moveh ? moveh: e.clientY - y - 73
                        } else {
                            cy = e.clientY - y < 0 ? 0: e.clientY - y > moveh ? moveh: e.clientY - y
                        }
                        scrollbar.css('top', cy / desk.height() * deskrealh + cy);
                        desk.scrollTop(cy / desk.height() * deskrealh)
                    }
                }).on('mouseup', 
                function() {
                    $(this).off('mousemove').off('mouseup')
                })
            });
            $('#desk .desktop-container').each(function(i) {
                $('#desk-' + (i + 1)).on('mousewheel', 
                function(event, delta) {
                    var desk = $(this),
                    deskrealh = parseInt(desk.children('.add').css('top')) + 108,
                    scrollupdown;
                    if (delta < 0) {
                        scrollupdown = desk.scrollTop() + 200 > deskrealh - desk.height() ? deskrealh - desk.height() : desk.scrollTop() + 200
                    } else {
                        scrollupdown = desk.scrollTop() - 200 < 0 ? 0: desk.scrollTop() - 200
                    }
                    desk.stop(false, true).animate({
                        scrollTop: scrollupdown
                    },
                    300);
                    desk.children('.scrollbar-y').stop(false, true).animate({
                        top: scrollupdown / deskrealh * desk.height() + scrollupdown
                    },
                    300)
                })
            })
        }
    }
})();
FT.base = (function() {
    return {
        init: function() {
            $('#desktop').on('click', 
            function() {
                $('.popup-menu').hide();
                $('.quick_view_container').remove()
            });
            $('body').on('contextmenu', 
            function() {
                $(".popup-menu").hide();
                return false
            });
            FT.base.resize();
            FT.zoom.init();
            FT.navbar.init();
            FT.taskbar.init();
            FT.dock.getPos(function() {
                FT.app.getXY(function() {
                    FT.app.get()
                })
            });
            FT.wallpaper.get(function() {
                FT.wallpaper.set()
            });
            $('.dock-tool-setting').on('mousedown', 
            function() {
                return false
            }).on('click', 
            function() {
                FT.window.createTemp({
                    id: 'zmsz',
                    title: '桌面设置',
                    url: 'sysfiles/desksetting/index.php',
                    width: 750,
                    height: 410,
                    isresize: false,
                    isflash: false
                })
            });
            $('.dock-tool-style').on('mousedown', 
            function() {
                return false
            }).on('click', 
            function() {
                FT.window.createTemp({
                    id: 'ztsz',
                    title: '主题设置',
                    url: 'sysfiles/wallpaper/index.php',
                    width: 580,
                    height: 520,
                    isresize: false,
                    isflash: false
                })
            });
            $('#desk').on('contextmenu', 
            function(e) {
                $(".popup-menu").hide();
                $('.quick_view_container').remove();
                var popupmenu = FT.popupMenu.desk();
                l = ($(document).width() - e.clientX) < popupmenu.width() ? (e.clientX - popupmenu.width()) : e.clientX;
                t = ($(document).height() - e.clientY) < popupmenu.height() ? (e.clientY - popupmenu.height()) : e.clientY;
                popupmenu.css({
                    left: l,
                    top: t
                }).show();
                return false
            });
            FT.base.help(); (function(config) {
                config['lock'] = true;
                config['fixed'] = true;
                config['resize'] = false;
                config['background'] = '#000';
                config['opacity'] = 0.5
            })($.dialog.defaults)
        },
        logout: function() {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=logout',
                success: function() {
                    location.href = 'login.php'
                }
            })
        },
        resize: function() {
            $(window).on('resize', 
            function() {
                FT.deskTop.resize(200)
            })
        },
        getSkin: function() {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=getSkin',
                success: function(skin) {
                    $('#window-skin').remove();
                    var link = document.createElement('link');
                    link.rel = 'stylesheet';
                    link.href = 'img/skins/' + skin + '.css?' + version;
                    link.id = 'window-skin';
                    $('body').append(link)
                }
            })
        },
        help: function() {
            if ($.cookie('isLoginFirst') == null) {
                $.cookie('isLoginFirst', '1', {
                    expires: 95
                });
                if (!$.browser.msie || ($.browser.msie && $.browser.version < 9)) {
                    $('body').append(helpTemp);
                    $('#step1').show();
                    $('.close').on('click', 
                    function() {
                        $('#help').remove()
                    });
                    $('.next').on('click', 
                    function() {
                        var obj = $(this).parents('.step');
                        var step = obj.attr('step');
                        obj.hide();
                        $('#step' + (parseInt(step) + 1)).show()
                    });
                    $('.over').on('click', 
                    function() {
                        $('#help').remove()
                    })
                }
            }
        }
    }
})();
FT.appmanage = (function() {
    return {
        init: function() {
            $('#amg_dock_container').html('').append($('#dock-container .dock-applist li').clone());
            $('#desk .desktop-container').each(function(i) {
                $('#amg_folder_container .folderItem:eq(' + i + ') .folderInner').html('');
                $(this).children('.appbtn:not(.add)').each(function() {
                    $('#amg_folder_container .folderItem:eq(' + i + ') .folderInner').append($(this).clone())
                })
            });
            $('#desktop').hide();
            $('#appmanage').show();
            $('#amg_folder_container .folderItem').show().addClass('folderItem_turn');
            $('#amg_folder_container').height($(document).height() - 80);
            $('#appmanage .amg_close').off('click').on('click', 
            function() {
                FT.appmanage.close()
            });
            FT.appmanage.appresize();
            FT.appmanage.move();
            FT.appmanage.getScrollbar();
            FT.appmanage.moveScrollbar()
        },
        getScrollbar: function() {
            setTimeout(function() {
                $('#amg_folder_container .folderItem').each(function() {
                    var desk = $(this).find('.folderInner'),
                    deskrealh = parseInt(desk.children('.appbtn:last').css('top')) + 41,
                    scrollbar = desk.next('.scrollBar');
                    scrollbar.hide();
                    desk.scrollTop(0);
                    if (desk.height() / deskrealh < 1) {
                        scrollbar.height(desk.height() / deskrealh * desk.height()).css('top', 0).show()
                    }
                })
            },
            500)
        },
        moveScrollbar: function() {
            $('.scrollBar').on('mousedown', 
            function(e) {
                var y,
                cy,
                deskrealh,
                moveh;
                var scrollbar = $(this),
                desk = scrollbar.prev('.folderInner');
                deskrealh = parseInt(desk.children('.appbtn:last').css('top')) + 41;
                moveh = desk.height() - scrollbar.height();
                y = e.clientY - scrollbar.offset().top;
                $(document).on('mousemove', 
                function(e) {
                    cy = e.clientY - y - 80 < 0 ? 0: e.clientY - y - 80 > moveh ? moveh: e.clientY - y - 80;
                    scrollbar.css('top', cy);
                    desk.scrollTop(cy / desk.height() * deskrealh)
                }).on('mouseup', 
                function() {
                    $(this).off('mousemove').off('mouseup')
                })
            });
            $('#amg_folder_container .folderInner').off('mousewheel').on('mousewheel', 
            function(event, delta) {
                var desk = $(this),
                deskrealh = parseInt(desk.children('.appbtn:last').css('top')) + 41,
                scrollupdown;
                if (delta < 0) {
                    scrollupdown = desk.scrollTop() + 120 > deskrealh - desk.height() ? deskrealh - desk.height() : desk.scrollTop() + 120
                } else {
                    scrollupdown = desk.scrollTop() - 120 < 0 ? 0: desk.scrollTop() - 120
                }
                desk.stop(false, true).animate({
                    scrollTop: scrollupdown
                },
                300);
                desk.next('.scrollBar').stop(false, true).animate({
                    top: scrollupdown / deskrealh * desk.height()
                },
                300)
            })
        },
        resize: function() {
            $('#amg_folder_container').height($(document).height() - 80);
            FT.appmanage.getScrollbar()
        },
        appresize: function() {
            var manageDockGrid = FT.grid.getManageDockAppGrid();
            $('#amg_dock_container li').each(function(i) {
                $(this).css({
                    'left': manageDockGrid[i]['startX'],
                    'top': 10
                })
            });
            for (var i = 0; i < 5; i++) {
                var manageAppGrid = FT.grid.getManageAppGrid();
                $('#amg_folder_container .folderItem:eq(' + i + ') .folderInner li').each(function(j) {
                    $(this).css({
                        'left': 0,
                        'top': manageAppGrid[j]['startY']
                    }).attr('desk', i)
                })
            }
        },
        close: function() {
            $('#amg_dock_container').html('');
            $('#amg_folder_container .folderInner').html('');
            $('#desktop').show();
            $('#appmanage').hide();
            $('#amg_folder_container .folderItem').removeClass('folderItem_turn');
            FT.app.get()
        },
        move: function() {
            $('#amg_dock_container').off('mousedown').on('mousedown', 'li', 
            function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (e.button == 0 || e.button == 1) {
                    var oldobj = $(this),
                    x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('<li id="shortcut_shadow">' + oldobj.html() + '</li>');
                    dx = cx = e.clientX;
                    dy = cy = e.clientY;
                    x = dx - oldobj.offset().left;
                    y = dy - oldobj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        $('body').append(obj);
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX <= 0 ? 0: e.clientX >= $(document).width() ? $(document).width() : e.clientX;
                        cy = e.clientY <= 0 ? 0: e.clientY >= $(document).height() ? $(document).height() : e.clientY;
                        _l = cx - x;
                        _t = cy - y;
                        if (dx != cx || dy != cy) {
                            obj.css({
                                left: _l,
                                top: _t
                            }).show()
                        }
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        obj.remove();
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        if (dx == cx && dy == cy) {
                            FT.appmanage.close();
                            switch (oldobj.attr('type')) {
                            case 'widget':
                            case 'pwidget':
                                FT.widget.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'app':
                            case 'papp':
                            case 'folder':
                                FT.window.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break
                            }
                            return false
                        }
                        var icon,
                        icon2;
                        if (cy <= 80) {
                            var appLength = $('#amg_dock_container li').length - 1;
                            icon2 = FT.grid.searchManageDockAppGrid(cx);
                            if (icon2 != oldobj.index() && icon2 - 1 != oldobj.index()) {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=dock-dock&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + icon2 + '&desk=' + FT.CONFIG.desk,
                                    success: function() {
                                        if (icon2 > appLength) {
                                            $('#amg_dock_container li:eq(' + appLength + ')').after(oldobj)
                                        } else {
                                            $('#amg_dock_container li:eq(' + icon2 + ')').before(oldobj)
                                        }
                                        FT.appmanage.appresize();
                                        FT.appmanage.getScrollbar()
                                    }
                                })
                            }
                        } else {
                            var movedesk = parseInt(cx / ($(document).width() / 5));
                            var appLength = $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li').length - 1;
                            icon = FT.grid.searchManageAppGrid(cy - 80);
                            $.ajax({
                                type: 'POST',
                                url: ajaxUrl,
                                data: 'ac=updateMyApp&movetype=dock-desk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + (icon + 1) + '&desk=' + (movedesk + 1),
                                success: function() {
                                    if (appLength == -1) {
                                        $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner').append(oldobj)
                                    } else {
                                        if (icon > appLength) {
                                            $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + appLength + ')').after(oldobj)
                                        } else {
                                            $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + icon + ')').before(oldobj)
                                        }
                                    }
                                    FT.appmanage.appresize();
                                    FT.appmanage.getScrollbar()
                                }
                            })
                        }
                    })
                }
                return false
            });
            $('#amg_folder_container').off('mousedown', 'li.appbtn:not(.add)').on('mousedown', 'li.appbtn:not(.add)', 
            function(e) {
                e.preventDefault();
                e.stopPropagation();
                if (e.button == 0 || e.button == 1) {
                    var oldobj = $(this),
                    x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('<li id="shortcut_shadow2">' + oldobj.html() + '</li>');
                    dx = cx = e.clientX;
                    dy = cy = e.clientY;
                    x = dx - oldobj.offset().left;
                    y = dy - oldobj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        $('body').append(obj);
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX <= 0 ? 0: e.clientX >= $(document).width() ? $(document).width() : e.clientX;
                        cy = e.clientY <= 0 ? 0: e.clientY >= $(document).height() ? $(document).height() : e.clientY;
                        _l = cx - x;
                        _t = cy - y;
                        if (dx != cx || dy != cy) {
                            obj.css({
                                left: _l,
                                top: _t
                            }).show()
                        }
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        obj.remove();
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        if (dx == cx && dy == cy) {
                            FT.appmanage.close();
                            switch (oldobj.attr('type')) {
                            case 'widget':
                            case 'pwidget':
                                FT.widget.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break;
                            case 'app':
                            case 'papp':
                            case 'folder':
                                FT.window.create(oldobj.attr('realid'), oldobj.attr('type'));
                                break
                            }
                            return false
                        }
                        var icon,
                        icon2;
                        if (cy <= 80) {
                            var appLength = $('#amg_dock_container li').length - 1;
                            icon2 = FT.grid.searchManageDockAppGrid(cx);
                            $.ajax({
                                type: 'POST',
                                url: ajaxUrl,
                                data: 'ac=updateMyApp&movetype=desk-dock&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + (icon2 + 1) + '&desk=' + (parseInt(oldobj.attr('desk')) + 1),
                                success: function() {
                                    if (appLength == -1) {
                                        $('#amg_dock_container').append(oldobj)
                                    } else {
                                        if (icon2 > appLength) {
                                            $('#amg_dock_container li:eq(' + appLength + ')').after(oldobj)
                                        } else {
                                            $('#amg_dock_container li:eq(' + icon2 + ')').before(oldobj)
                                        }
                                    }
                                    if ($('#amg_dock_container li.appbtn').length > 7) {
                                        if ($('#amg_folder_container .folderItem:eq(' + oldobj.attr('desk') + ') .folderInner li').length == 0) {
                                            $('#amg_folder_container .folderItem:eq(' + oldobj.attr('desk') + ') .folderInner').append($('#amg_dock_container li').last())
                                        } else {
                                            $('#amg_folder_container .folderItem:eq(' + oldobj.attr('desk') + ') .folderInner li').last().after($('#amg_dock_container li').last())
                                        }
                                    }
                                    FT.appmanage.appresize();
                                    FT.appmanage.getScrollbar()
                                }
                            })
                        } else {
                            var movedesk = parseInt(cx / ($(document).width() / 5));
                            var appLength = $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li').length - 1;
                            icon = FT.grid.searchManageAppGrid(cy - 80);
                            if (movedesk == oldobj.attr('desk')) {
                                if (icon != oldobj.index() && icon - 1 != oldobj.index()) {
                                    $.ajax({
                                        type: 'POST',
                                        url: ajaxUrl,
                                        data: 'ac=updateMyApp&movetype=desk-desk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + icon + '&desk=' + (movedesk + 1),
                                        success: function() {
                                            if (icon > appLength) {
                                                $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + appLength + ')').after(oldobj)
                                            } else {
                                                $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + icon + ')').before(oldobj)
                                            }
                                            FT.appmanage.appresize();
                                            FT.appmanage.getScrollbar()
                                        }
                                    })
                                }
                            } else {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updateMyApp&movetype=desk-otherdesk&id=' + oldobj.attr('realid') + '&type=' + oldobj.attr('type') + '&from=' + oldobj.index() + '&to=' + icon + '&desk=' + (parseInt(oldobj.attr('desk')) + 1) + '&otherdesk=' + (movedesk + 1),
                                    success: function() {
                                        if (appLength == -1) {
                                            $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner').append(oldobj)
                                        } else {
                                            if (icon > appLength) {
                                                $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + appLength + ')').after(oldobj)
                                            } else {
                                                $('#amg_folder_container .folderItem:eq(' + movedesk + ') .folderInner li:eq(' + icon + ')').before(oldobj)
                                            }
                                        }
                                        FT.appmanage.appresize();
                                        FT.appmanage.getScrollbar()
                                    }
                                })
                            }
                        }
                    })
                }
                return false
            })
        }
    }
})();
FT.dock = (function() {
    return {
        getPos: function(fun) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=getDockPos',
                success: function(i) {
                    FT.CONFIG.dockPos = i;
                    FT.dock.setPos();
                    if (typeof(fun) != 'undefined') {
                        fun()
                    }
                }
            })
        },
        setPos: function() {
            var desktop = $('#desk-' + FT.CONFIG.desk),
            desktops = $('#desk .desktop-container');
            var desk_w = desktop.css('width', '100%').width(),
            desk_h = desktop.css('height', '100%').height();
            $('#dock-container').removeClass('dock-top').removeClass('dock-left').removeClass('dock-right');
            $('#dock-bar').removeClass('top-bar').removeClass('left-bar').removeClass('right-bar').hide();
            if (FT.CONFIG.dockPos == 'left') {
                $('#dock-bar').addClass('left-bar').children('#dock-container').addClass('dock-left');
                desktops.css({
                    'width': desk_w - 73,
                    'height': desk_h - 70,
                    'left': desk_w + 73,
                    'top': 0
                });
                desktop.css({
                    'left': 73
                });
                $('#dock-bar').show()
            } else if (FT.CONFIG.dockPos == 'right') {
                $('#dock-bar').addClass('right-bar').children('#dock-container').addClass('dock-right');
                desktops.css({
                    'width': desk_w - 73,
                    'height': desk_h - 70,
                    'left': desk_w,
                    'top': 0
                });
                desktop.css({
                    'left': 0
                });
                $('#dock-bar').show()
            } else if (FT.CONFIG.dockPos == 'no_dock') {
                desktops.css({
                    'width': desk_w - 73,
                    'height': desk_h - 70,
                    'left': desk_w,
                    'top': 0
                });
                desktop.css({
                    'left': 0
                })
            }
            FT.taskbar.resize()
        },
        updatePos: function(pos, fun) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=setDockPos&dock=' + pos,
                success: function() {
                    FT.CONFIG.dockPos = pos;
                    if (typeof(fun) != 'undefined') {
                        fun()
                    }
                }
            })
        },
        move: function() {
            $('#dock-container').off('mousedown').on('mousedown', 
            function(e) {
                if (e.button == 0 || e.button == 1) {
                    var lay = FT.maskBox.dock(),
                    location;
                    $(document).on('mousemove', 
                    function(e) {
                        lay.show();
                        if (e.clientY < lay.height() * 0.2) {
                            location = 'no_dock'
                        } else if (e.clientX < lay.width() * 0.5) {
                            location = 'left'
                        } else {
                            location = 'right'
                        }
                        $('.dock_drap_effect').removeClass('hover');
                        $('.dock_drap_effect_' + location).addClass('hover')
                    }).on('mouseup', 
                    function() {
                        $(document).off('mousemove').off('mouseup');
                        lay.hide();
                        if (location != FT.CONFIG.dockPos && typeof(location) != 'undefined') {
                            FT.dock.updatePos(location, 
                            function() {
                                FT.dock.setPos();
                                FT.deskTop.appresize();
                                FT.app.getScrollbar()
                            })
                        }
                    })
                }
            })
        }
    }
})();
FT.folderView = (function() {
    return {
        init: function(obj) {
            var folderViewHtml = '';
            $.getJSON(ajaxUrl + '?ac=getMyFolderApp&folderid=' + obj.attr('realid'), 
            function(sc) {
                var height = 0;
                if (sc != null) {
                    for (var i = 0; i < sc.length; i++) {
                        switch (sc[i]['type']) {
                        case 'app':
                        case 'widget':
                        case 'papp':
                        case 'pwidget':
                            folderViewHtml += appbtnTemp({
                                'top': 0,
                                'left': 0,
                                'title': sc[i]['name'],
                                'type': sc[i]['type'],
                                'id': 'd_' + sc[i]['type'] + '_' + sc[i]['id'],
                                'realid': sc[i]['id'],
                                'imgsrc': sc[i]['icon']
                            });
                            break
                        }
                    }
                    if (sc.length % 4 == 0) {
                        height += Math.floor(sc.length / 4) * 60
                    } else {
                        height += (Math.floor(sc.length / 4) + 1) * 60
                    }
                } else {
                    folderViewHtml = '文件夹为空';
                    height += 30
                }
                var left,
                top;
                if (obj.parent('div').hasClass('dock-applist')) {
                    left = obj.offset().left + 60;
                    top = obj.offset().top
                } else {
                    left = obj.offset().left + 80;
                    top = obj.offset().top - 20
                }
                var isScrollbar = false;
                if (height + top + 46 > $(document).height()) {
                    var outH = height + top + 46 - $(document).height();
                    if (outH <= top) {
                        top -= outH
                    } else {
                        height -= outH - top;
                        top = 0;
                        isScrollbar = true
                    }
                }
                $('.quick_view_container').remove();
                if (left + 340 > $(document).width()) {
                    $('body').append(folderViewTemp({
                        'id': 'qv_' + obj.attr('realid'),
                        'realid': obj.attr('realid'),
                        'apps': folderViewHtml,
                        'top': top,
                        'left': left - 340 - 80,
                        'height': height,
                        'mlt': Math.ceil((height + 26) / 2),
                        'mlm': false,
                        'mlb': Math.ceil((height + 26) / 2),
                        'mrt': obj.offset().top - top,
                        'mrm': true,
                        'mrb': height + 26 - (obj.offset().top - top) - 20
                    }))
                } else {
                    $('body').append(folderViewTemp({
                        'id': 'qv_' + obj.attr('realid'),
                        'realid': obj.attr('realid'),
                        'apps': folderViewHtml,
                        'top': top,
                        'left': left,
                        'height': height,
                        'mlt': obj.offset().top - top,
                        'mlm': true,
                        'mlb': height + 26 - (obj.offset().top - top) - 20,
                        'mrt': Math.ceil((height + 26) / 2),
                        'mrm': false,
                        'mrb': Math.ceil((height + 26) / 2)
                    }))
                }
                $('body').on('contextmenu', '.appbtn:not(.add)', 
                function(e) {
                    $('.popup-menu').hide();
                    TEMP.AppRight = FT.popupMenu.app($(this));
                    var l = ($(document).width() - e.clientX) < TEMP.AppRight.width() ? (e.clientX - TEMP.AppRight.width()) : e.clientX;
                    var t = ($(document).height() - e.clientY) < TEMP.AppRight.height() ? (e.clientY - TEMP.AppRight.height()) : e.clientY;
                    TEMP.AppRight.css({
                        left: l,
                        top: t
                    }).show();
                    return false
                });
                $('.quick_view_container_open').on('click', 
                function() {
                    FT.window.create($(this).parents('.quick_view_container').attr('realid'), 'folder');
                    $('#quick_view_container_' + $(this).parents('.quick_view_container').attr('realid')).remove()
                });
                FT.folderView.getScrollbar(obj.attr('realid'), isScrollbar);
                FT.folderView.moveScrollbar(obj.attr('realid'));
                FT.app.move()
            })
        },
        getScrollbar: function(id, isScrollbar) {
            var view = '#quick_view_container_list_in_' + id;
            var scrollbar = '#quick_view_container_list_' + id + ' .scrollBar';
            if (isScrollbar) {
                $('#quick_view_container_list_' + id + ' .scrollBar_bgc').show();
                $(scrollbar).show().height($(view).height() / (Math.ceil($(view).children().length / 4) * 60) * $(view).height())
            } else {
                $('#quick_view_container_list_' + id + ' .scrollBar_bgc').hide();
                $(scrollbar).hide().height(0)
            }
        },
        moveScrollbar: function(id) {
            var view = '#quick_view_container_list_in_' + id;
            var scrollbar = '#quick_view_container_list_' + id + ' .scrollBar';
            $(scrollbar).on('mousedown', 
            function(e) {
                var offsetTop = $('#quick_view_container_' + id).offset().top + 36;
                var y,
                cy,
                deskrealh,
                moveh;
                var scrollbar = $(this),
                desk = $(view);
                deskrealh = Math.ceil($(view).children().length / 4) * 60;
                moveh = desk.height() - scrollbar.height();
                y = e.clientY - scrollbar.offset().top;
                $(document).on('mousemove', 
                function(e) {
                    cy = e.clientY - y - offsetTop < 0 ? 0: e.clientY - y - offsetTop > moveh ? moveh: e.clientY - y - offsetTop;
                    scrollbar.css('top', cy);
                    desk.scrollTop(cy / desk.height() * deskrealh)
                }).on('mouseup', 
                function() {
                    $(this).off('mousemove').off('mouseup')
                })
            });
            $(view).off('mousewheel').on('mousewheel', 
            function(event, delta) {
                var desk = $(this),
                deskrealh = Math.ceil($(view).children().length / 4) * 60,
                scrollupdown;
                if (delta < 0) {
                    scrollupdown = desk.scrollTop() + 40 > deskrealh - desk.height() ? deskrealh - desk.height() : desk.scrollTop() + 40
                } else {
                    scrollupdown = desk.scrollTop() - 40 < 0 ? 0: desk.scrollTop() - 40
                }
                desk.stop(false, true).animate({
                    scrollTop: scrollupdown
                },
                300);
                $(scrollbar).stop(false, true).animate({
                    top: scrollupdown / deskrealh * desk.height()
                },
                300)
            })
        }
    }
})();
FT.grid = (function() {
    return {
        getAppGrid: function() {
            var width,
            height;
            width = $('#desk-' + FT.CONFIG.desk).width() - FT.CONFIG.appButtonLeft;
            height = $('#desk-' + FT.CONFIG.desk).height() - FT.CONFIG.appButtonTop;
            var appGrid = [],
            _top = FT.CONFIG.appButtonTop,
            _left = FT.CONFIG.appButtonLeft;
            for (var i = 0; i < 10000; i++) {
                appGrid.push({
                    startY: _top,
                    endY: _top + 100,
                    startX: _left,
                    endX: _left + 102
                });
                if (FT.CONFIG.appXY == 'x') {
                    _left += 102;
                    if (_left + 100 > width) {
                        _top += 100;
                        _left = FT.CONFIG.appButtonLeft
                    }
                } else {
                    _top += 100;
                    if (_top + 70 > height) {
                        _top = FT.CONFIG.appButtonTop;
                        _left += 102
                    }
                }
            }
            return appGrid
        },
        searchAppGrid: function(x, y) {
            var grid = FT.grid.getAppGrid(),
            j = grid.length;
            var flags = 0,
            appLength = $('#desk-' + FT.CONFIG.desk + ' li.appbtn:not(.add)').length - 1;
            for (var i = 0; i < j; i++) {
                if (x >= grid[i].startX && x <= grid[i].endX) {
                    flags += 1
                }
                if (y >= grid[i].startY && y <= grid[i].endY) {
                    flags += 1
                }
                if (flags === 2) {
                    return i > appLength ? appLength: i
                } else {
                    flags = 0
                }
            }
            return null
        },
        getDockAppGrid: function() {
            var height = $('#dock-bar .dock-applist').height();
            var dockAppGrid = [],
            _left = 0,
            _top = 0;
            for (var i = 0; i < 7; i++) {
                dockAppGrid.push({
                    startY: _top,
                    endY: _top + 62,
                    startX: _left,
                    endX: _left + 62
                });
                _top += 62;
                if (_top + 62 > height) {
                    _top = 0;
                    _left += 62
                }
            }
            return dockAppGrid
        },
        searchDockAppGrid: function(x, y) {
            var grid = FT.grid.getDockAppGrid(),
            j = grid.length,
            flags = 0,
            appLength = $('#dock-bar .dock-applist li').length - 1;
            for (var i = 0; i < j; i++) {
                if (x >= grid[i].startX && x <= grid[i].endX) {
                    flags += 1
                }
                if (y >= grid[i].startY && y <= grid[i].endY) {
                    flags += 1
                }
                if (flags === 2) {
                    return i > appLength ? appLength: i
                } else {
                    flags = 0
                }
            }
            return null
        },
        getFolderGrid: function() {
            var folderGrid = [];
            $('.folder-window:visible').each(function() {
                folderGrid.push({
                    zIndex: $(this).css('z-index'),
                    id: $(this).attr('realid'),
                    startY: $(this).offset().top,
                    endY: $(this).offset().top + $(this).height(),
                    startX: $(this).offset().left,
                    endX: $(this).offset().left + $(this).width()
                })
            });
            folderGrid.sort(function(x, y) {
                return y['zIndex'] - x['zIndex']
            });
            return folderGrid
        },
        searchFolderGrid: function(x, y) {
            var folderGrid = FT.grid.getFolderGrid(),
            j = folderGrid.length,
            flags = 0;
            for (var i = 0; i < j; i++) {
                if (x >= folderGrid[i].startX && x <= folderGrid[i].endX) {
                    flags += 1
                }
                if (y >= folderGrid[i].startY && y <= folderGrid[i].endY) {
                    flags += 1
                }
                if (flags === 2) {
                    return folderGrid[i]['id']
                } else {
                    flags = 0
                }
            }
            return null
        },
        getManageDockAppGrid: function() {
            var manageDockAppGrid = [],
            _left = 20;
            for (var i = 0; i < 10000; i++) {
                manageDockAppGrid.push({
                    startX: _left,
                    endX: _left + 72
                });
                _left += 72
            }
            return manageDockAppGrid
        },
        getManageDockAppGridOnMove: function() {
            var manageDockAppGrid = [],
            _left = 20;
            for (var i = 0; i < 10000; i++) {
                manageDockAppGrid.push({
                    startX: _left,
                    endX: _left + (i == 0 ? 29: 72)
                });
                _left += (i == 0 ? 29: 72)
            }
            return manageDockAppGrid
        },
        searchManageDockAppGrid: function(x) {
            var grid = FT.grid.getManageDockAppGridOnMove(),
            flags = 0;
            var returnInfo = 0;
            for (var i = 0; i < grid.length; i++) {
                if (x >= grid[i].startX && x <= grid[i].endX) {
                    flags += 1
                }
                if (flags === 1) {
                    returnInfo = i;
                    break
                } else {
                    flags = 0
                }
            }
            return returnInfo
        },
        getManageAppGrid: function() {
            var manageAppGrid = [],
            _top = 0;
            for (var i = 0; i < 10000; i++) {
                manageAppGrid.push({
                    startY: _top,
                    endY: _top + 40
                });
                _top += 40
            }
            return manageAppGrid
        },
        getManageAppGridOnMove: function() {
            var manageAppGrid = [],
            _top = 0;
            for (var i = 0; i < 10000; i++) {
                manageAppGrid.push({
                    startY: _top,
                    endY: _top + (i == 0 ? 20: 40)
                });
                _top += (i == 0 ? 20: 40)
            }
            return manageAppGrid
        },
        searchManageAppGrid: function(y) {
            var grid = FT.grid.getManageAppGridOnMove(),
            flags = 0;
            var returnInfo = 0;
            for (var i = 0; i < grid.length; i++) {
                if (y >= grid[i].startY && y <= grid[i].endY) {
                    flags += 1
                }
                if (flags === 1) {
                    returnInfo = i;
                    break
                } else {
                    flags = 0
                }
            }
            return returnInfo
        }
    }
})();
FT.maskBox = (function() {
    return {
        desk: function() {
            if (!TEMP.maskBoxDesk) {
                TEMP.maskBoxDesk = $('<div id="maskbox"></div>');
                $('body').append(TEMP.maskBoxDesk)
            }
            return TEMP.maskBoxDesk
        },
        dock: function() {
            if (!TEMP.maskBoxDock) {
                TEMP.maskBoxDock = $('<div style="z-index:1000000003;display:block;cursor:default;background:none;width:100%;height:100%;position:absolute;top:0;left:0"><div id="docktop" class="dock_drap_effect dock_drap_effect_top"></div><div id="dockleft" class="dock_drap_effect dock_drap_effect_left"></div><div id="dockright" class="dock_drap_effect dock_drap_effect_right"></div><div id="dockmask" class="dock_drap_mask"><div class="dock_drop_region_top"></div><div class="dock_drop_region_left"></div><div class="dock_drop_region_right"></div></div></div>');
                $('body').append(TEMP.maskBoxDock)
            }
            return TEMP.maskBoxDock
        }
    }
})();
FT.navbar = (function() {
    return {
        init: function() {
            $('#nav-bar').css({
                'left': $(document).width() / 2 - 105,
                'top': 10
            }).show();
            FT.navbar.move();
            FT.navbar.deskSwitch()
        },
        move: function() {
            $('#nav-bar').on('mousedown', 
            function(e) {
                if (e.button == 0 || e.button == 1) {
                    var x,
                    y,
                    cx,
                    cy,
                    lay,
                    obj = $('#nav-bar');
                    x = e.clientX - obj.offset().left;
                    y = e.clientY - obj.offset().top;
                    $(document).on('mousemove', 
                    function(e) {
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX - x <= 0 ? 0: e.clientX - x > $(document).width() - 210 ? $(document).width() - 210: e.clientX - x;
                        cy = e.clientY - y <= 10 ? 10: e.clientY - y > $(document).height() - 50 ? $(document).height() - 50: e.clientY - y;
                        obj.css({
                            left: cx,
                            top: cy
                        })
                    }).on('mouseup', 
                    function() {
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        $(this).off('mousemove').off('mouseup')
                    })
                }
            })
        },
        deskSwitch: function() {
            $('#nav-bar .nav-container').on('mousedown', 'a.indicator', 
            function(e) {
                $('.popup-menu').hide();
                $('.quick_view_container').remove();
                if (e.button == 0 || e.button == 1) {
                    var x,
                    y,
                    cx,
                    cy,
                    dx,
                    dy,
                    lay,
                    obj = $('#nav-bar'),
                    thisobj = $(this);
                    dx = cx = obj.offset().left;
                    dy = cy = obj.offset().top;
                    x = e.clientX - dx;
                    y = e.clientY - dy;
                    $(document).on('mousemove', 
                    function(e) {
                        lay = FT.maskBox.desk();
                        lay.show();
                        cx = e.clientX - x <= 0 ? 0: e.clientX - x > $(document).width() - 210 ? $(document).width() - 210: e.clientX - x;
                        cy = e.clientY - y <= 10 ? 10: e.clientY - y > $(document).height() - 50 ? $(document).height() - 50: e.clientY - y;
                        obj.css({
                            left: cx,
                            top: cy
                        })
                    }).on('mouseup', 
                    function() {
                        if (dx == cx && dy == cy) {
                            if (typeof(thisobj.attr('index')) !== 'undefined') {
                                var nav = $('#navContainer'),
                                currindex = FT.CONFIG.desk,
                                switchindex = thisobj.attr('index'),
                                currleft = $('#desk-' + currindex).offset().left,
                                switchleft = $('#desk-' + switchindex).offset().left;
                                if (currindex != switchindex) {
                                    if (!$('#desk-' + switchindex).hasClass('animated') && !$('#desk-' + currindex).hasClass('animated')) {
                                        $('#desk-' + currindex).addClass('animated').animate({
                                            left: switchleft
                                        },
                                        500, 'easeInOutCirc', 
                                        function() {
                                            $(this).removeClass('animated')
                                        });
                                        $('#desk-' + switchindex).addClass('animated').animate({
                                            left: currleft
                                        },
                                        500, 'easeInOutCirc', 
                                        function() {
                                            $(this).removeClass('animated');
                                            nav.removeClass('nav-current-' + currindex).addClass('nav-current-' + switchindex);
                                            FT.CONFIG.desk = switchindex
                                        })
                                    }
                                }
                            } else {
                                FT.appmanage.init()
                            }
                        }
                        if (typeof(lay) !== 'undefined') {
                            lay.hide()
                        }
                        $(this).off('mousemove').off('mouseup')
                    })
                }
            })
        }
    }
})();
FT.popupMenu = (function() {
    return {
        app: function(obj) {
            if (!TEMP.popupMenuApp) {
                TEMP.popupMenuApp = $('<div class="popup-menu app-menu" style="z-index:9990;display:none"><ul><li style="border-bottom:1px solid #F0F0F0"><a menu="open" href="javascript:;">打开应用</a></li><li><a menu="move" href="javascript:;">移动应用到<b class="arrow">»</b></a><div class="popup-menu" style="display:none"><ul><li><a menu="moveto" desk="1" href="javascript:;">桌面1</a></li><li><a menu="moveto" desk="2" href="javascript:;">桌面2</a></li><li><a menu="moveto" desk="3" href="javascript:;">桌面3</a></li><li><a menu="moveto" desk="4" href="javascript:;">桌面4</a></li><li><a menu="moveto" desk="5" href="javascript:;">桌面5</a></li></ul></div></li><li><b class="uninstall"></b><a menu="del" href="javascript:;">卸载应用</a></li></ul></div>');
                $('body').append(TEMP.popupMenuApp);
                $('.app-menu').on('contextmenu', 
                function() {
                    return false
                })
            }
            $('.app-menu a[menu="moveto"]').removeClass('disabled');
            if (obj.parent().hasClass('desktop-container')) {
                $('.app-menu a[menu="moveto"]').each(function() {
                    if ($(this).attr('desk') == FT.CONFIG.desk) {
                        $(this).addClass('disabled')
                    }
                })
            }
            $('.app-menu li').off('mouseover').off('mouseout').on('mouseover', 
            function() {
                if ($(this).children('a').attr('menu') == 'move') {
                    $(this).children('a').addClass('focus');
                    if ($(document).width() - $('.app-menu').offset().left > 250) {
                        $(this).children('div').css({
                            left: 122,
                            top: -2
                        })
                    } else {
                        $(this).children('div').css({
                            left: -126,
                            top: -2
                        })
                    }
                    $(this).children('div').show()
                }
            }).on('mouseout', 
            function() {
                $(this).children('a').removeClass('focus');
                $(this).children('div').hide()
            });
            $('.app-menu a[menu="moveto"]').off('click').on('click', 
            function() {
                var desk = $(this).attr('desk');
                $.ajax({
                    type: 'POST',
                    url: ajaxUrl,
                    data: 'ac=moveMyApp&id=' + obj.attr('realid') + '&type=' + obj.attr('type') + '&todesk=' + desk,
                    success: function() {
                        $('#desk-' + desk + ' li.add').before(obj);
                        FT.deskTop.appresize();
                        FT.app.getScrollbar()
                    }
                });
                $('.popup-menu').hide()
            });
            $('.app-menu a[menu="open"]').off('click').on('click', 
            function() {
                FT.window.create(obj.attr('realid'), obj.attr('type'));
                $('.task-menu').hide()
            });
            $('.app-menu a[menu="del"]').off('click').on('click', 
            function() {
                FT.app.remove(obj.attr('realid'), obj.attr('type'), 
                function() {
                    obj.find('img, span').show().animate({
                        opacity: 'toggle',
                        width: 0,
                        height: 0
                    },
                    500, 
                    function() {
                        obj.remove();
                        FT.deskTop.resize(250)
                    })
                });
                $('.popup-menu').hide()
            });
            return TEMP.popupMenuApp
        },
        papp: function(obj) {
            if (!TEMP.popupMenuPapp) {
                TEMP.popupMenuPapp = $('<div class="popup-menu papp-menu" style="z-index:9990;display:none"><ul><li style="border-bottom:1px solid #F0F0F0"><a menu="open" href="javascript:;">打开应用</a></li><li><a menu="move" href="javascript:;">移动应用到<b class="arrow">»</b></a><div class="popup-menu" style="display:none"><ul><li><a menu="moveto" desk="1" href="javascript:;">桌面1</a></li><li><a menu="moveto" desk="2" href="javascript:;">桌面2</a></li><li><a menu="moveto" desk="3" href="javascript:;">桌面3</a></li><li><a menu="moveto" desk="4" href="javascript:;">桌面4</a></li><li><a menu="moveto" desk="5" href="javascript:;">桌面5</a></li></ul></div></li><li><b class="edit"></b><a menu="edit" href="javascript:;">编辑</a></li><li><b class="del"></b><a menu="del" href="javascript:;">删除应用</a></li></ul></div>');
                $('body').append(TEMP.popupMenuPapp);
                $('.papp-menu').on('contextmenu', 
                function() {
                    return false
                })
            }
            $('.papp-menu a[menu="moveto"]').removeClass('disabled');
            if (obj.parent().hasClass('desktop-container')) {
                $('.papp-menu a[menu="moveto"]').each(function() {
                    if ($(this).attr('desk') == FT.CONFIG.desk) {
                        $(this).addClass('disabled')
                    }
                })
            }
            $('.papp-menu li').off('mouseover').off('mouseout').on('mouseover', 
            function() {
                if ($(this).children('a').attr('menu') == 'move') {
                    $(this).children('a').addClass('focus');
                    if ($(document).width() - $('.papp-menu').offset().left > 250) {
                        $(this).children('div').css({
                            left: 122,
                            top: -2
                        })
                    } else {
                        $(this).children('div').css({
                            left: -126,
                            top: -2
                        })
                    }
                    $(this).children('div').show()
                }
            }).on('mouseout', 
            function() {
                $(this).children('a').removeClass('focus');
                $(this).children('div').hide()
            });
            $('.papp-menu a[menu="moveto"]').off('click').on('click', 
            function() {
                var desk = $(this).attr('desk');
                $.ajax({
                    type: 'POST',
                    url: ajaxUrl,
                    data: 'ac=moveMyApp&id=' + obj.attr('realid') + '&type=' + obj.attr('type') + '&todesk=' + desk,
                    success: function() {
                        $('#desk-' + desk + ' li.add').before(obj);
                        FT.deskTop.appresize();
                        FT.app.getScrollbar()
                    }
                });
                $('.popup-menu').hide()
            });
            $('.papp-menu a[menu="open"]').off('click').on('click', 
            function() {
                switch (obj.attr('type')) {
                case 'papp':
                    FT.window.create(obj.attr('realid'), obj.attr('type'));
                    break;
                case 'pwidget':
                    FT.widget.create(obj.attr('realid'), obj.attr('type'));
                    break
                }
                $('.popup-menu').hide()
            });
            $('.papp-menu a[menu="edit"]').off('click').on('click', 
            function() {
                function nextDo(options) {
                    $.dialog({
                        id: 'addfolder',
                        title: '编辑私人应用“' + options.title + '”',
                        padding: 0,
                        content: editPappDialogTemp({
                            'id': options.id,
                            'name': options.title,
                            'url': options.url,
                            'width': options.width,
                            'height': options.height
                        }),
                        ok: function() {
                            var name = $('#addpappName').val(),
                            url = $('#addpappUrl').val(),
                            width = $('#addpappWidth').val(),
                            height = $('#addpappHeight').val();
                            if (name != '' && url != '' && width != '' && height != '') {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=updatePapp&name=' + name + '&url=' + url + '&width=' + width + '&height=' + height + '&id=' + options.id,
                                    success: function(pappid) {
                                        FT.app.get()
                                    }
                                })
                            } else {
                                alert('信息填写不完整')
                            }
                        },
                        cancel: true
                    })
                }
                ZENG.msgbox.show('数据读取中，请耐心等待...', 6, 100000);
                $.getJSON(ajaxUrl + '?ac=getMyAppById&id=' + obj.attr('realid') + '&type=' + obj.attr('type'), 
                function(app) {
                    if (app != null) {
                        ZENG.msgbox._hide();
                        switch (app['type']) {
                        case 'papp':
                        case 'pwidget':
                            nextDo({
                                id:
                                app['id'],
                                title: app['name'],
                                url: app['url'],
                                width: app['width'],
                                height: app['height'],

                            });
                            break
                        }
                    } else {
                        ZENG.msgbox.show('数据拉取失败', 5, 2000);
                        return false
                    }
                });
                $('.popup-menu').hide()
            });
            $('.papp-menu a[menu="del"]').off('click').on('click', 
            function() {
                FT.app.remove(obj.attr('realid'), obj.attr('type'), 
                function() {
                    obj.find('img, span').show().animate({
                        opacity: 'toggle',
                        width: 0,
                        height: 0
                    },
                    500, 
                    function() {
                        obj.remove();
                        FT.deskTop.resize(250)
                    })
                });
                $('.popup-menu').hide()
            });
            return TEMP.popupMenuPapp
        },
        folder: function(obj) {
            if (!TEMP.popupMenuFolder) {
                TEMP.popupMenuFolder = $('<div class="popup-menu folder-menu" style="z-index:9990;display:none"><ul><li><a menu="view" href="javascript:;">预览</a></li><li style="border-bottom:1px solid #F0F0F0"><a menu="open" href="javascript:;">打开</a></li><li><b class="edit"></b><a menu="rename" href="javascript:;">重命名</a></li><li><b class="del"></b><a menu="del" href="javascript:;">删除</a></li></ul></div>');
                $('body').append(TEMP.popupMenuFolder);
                $('.folder-menu').on('contextmenu', 
                function() {
                    return false
                })
            }
            $('.folder-menu a[menu="view"]').off('click').on('click', 
            function() {
                FT.folderView.init(obj);
                $('.popup-menu').hide()
            });
            $('.folder-menu a[menu="open"]').off('click').on('click', 
            function() {
                FT.window.create(obj.attr('realid'), obj.attr('type'));
                $('.popup-menu').hide()
            });
            $('.folder-menu a[menu="del"]').off('click').on('click', 
            function() {
                $.dialog({
                    id: 'delfolder',
                    title: '删除“' + obj.find('span').text() + '”文件夹',
                    content: '删除文件夹的同时会删除文件夹内所有应用',
                    icon: 'warning',
                    ok: function() {
                        FT.app.remove(obj.attr('realid'), obj.attr('type'), 
                        function() {
                            obj.find('img, span').show().animate({
                                opacity: 'toggle',
                                width: 0,
                                height: 0
                            },
                            500, 
                            function() {
                                obj.remove();
                                FT.deskTop.resize(250)
                            })
                        })
                    },
                    cancel: true
                });
                $('.popup-menu').hide()
            });
            $('.folder-menu a[menu="rename"]').off('click').on('click', 
            function() {
                $.dialog({
                    id: 'addfolder',
                    title: '重命名“' + obj.find('span').text() + '”文件夹',
                    padding: 0,
                    content: editFolderDialogTemp({
                        'name': obj.find('span').text(),
                        'src': obj.find('img').attr('src')
                    }),
                    ok: function() {
                        if ($('#folderName').val() != '') {
                            $.ajax({
                                type: 'POST',
                                url: ajaxUrl,
                                data: 'ac=updateFolder&name=' + $('#folderName').val() + '&icon=' + $('.folderSelector img').attr('src') + '&id=' + obj.attr('realid'),
                                success: function() {
                                    FT.app.get()
                                }
                            })
                        } else {
                            $('.folderNameError').show();
                            return false
                        }
                    },
                    cancel: true
                });
                $('.folderSelector').off('click').on('click', 
                function() {
                    $('.fcDropdown').show()
                });
                $('.fcDropdown_item').off('click').on('click', 
                function() {
                    $('.folderSelector img').attr('src', $(this).children('img').attr('src')).attr('idx', $(this).children('img').attr('idx'));
                    $('.fcDropdown').hide()
                });
                $('.popup-menu').hide()
            });
            return TEMP.popupMenuFolder
        },
        task: function(obj) {
            if (!TEMP.popupMenuTask) {
                TEMP.popupMenuTask = $('<div class="popup-menu task-menu" style="z-index:9990;display:none"><ul><li><a menu="max" href="javascript:;">最大化</a></li><li style="border-bottom:1px solid #F0F0F0"><a menu="hide" href="javascript:;">最小化</a></li><li><a menu="close" href="javascript:;">关闭</a></li></ul></div>');
                $('body').append(TEMP.popupMenuTask);
                $('.task-menu').on('contextmenu', 
                function() {
                    return false
                })
            }
            $('.task-menu a[menu="max"]').off('click').on('click', 
            function() {
                FT.window.max(obj.attr('realid'), obj.attr('type'));
                $('.popup-menu').hide()
            });
            $('.task-menu a[menu="hide"]').off('click').on('click', 
            function() {
                FT.window.hide(obj.attr('realid'), obj.attr('type'));
                $('.popup-menu').hide()
            });
            $('.task-menu a[menu="close"]').off('click').on('click', 
            function() {
                FT.window.close(obj.attr('realid'), obj.attr('type'));
                $('.popup-menu').hide()
            });
            return TEMP.popupMenuTask
        },
        desk: function() {
            if (!TEMP.popupMenuDesk) {
                TEMP.popupMenuDesk = $('<div class="popup-menu desk-menu" style="z-index:9990;display:none"><ul><li><a menu="hideall" href="javascript:;">显示桌面</a></li><li><b class="refresh"></b><a menu="refresh" href="javascript:;">刷新桌面</a></li><li style="border-bottom:1px solid #F0F0F0"><a menu="closeall" href="javascript:;">关闭所有应用</a></li><li><a menu="addpapp" href="javascript:;">新建私人应用</a><!--<div class="popup-menu" style="display:none"><ul><li><b class="folder"></b><a menu="addfolder" href="javascript:;">文件夹</a></li><li><b class="customapp"></b><a menu="addpapp" href="javascript:;">私人应用</a></li></ul></div>--></li><!--li style="border-bottom:1px solid #F0F0F0"><b class="upload"></b><a menu="uploadfile" href="javascript:;">上传文件</a></li--><li><b class="themes"></b><a menu="themes" href="javascript:;">主题设置</a></li><li><b class="setting"></b><a menu="setting" href="javascript:;">桌面设置</a></li><li style="border-bottom:1px solid #F0F0F0"><a href="javascript:;">图标设置<b class="arrow">»</b></a><div class="popup-menu" style="display:none"><ul><li><b class="hook"></b><a menu="orderby" orderby="x" href="javascript:;">横向排列</a></li><li><b class="hook"></b><a menu="orderby" orderby="y" href="javascript:;">纵向排列</a></li></ul></div></li><li><a menu="logout" href="javascript:;">退出系统</a></li></ul></div>');
                $('body').append(TEMP.popupMenuDesk);
                $('.desk-menu').on('contextmenu', 
                function() {
                    return false
                });
                $('.desk-menu li').off('mouseover').off('mouseout').on('mouseover', 
                function() {
                    if ($(this).children('a').next() != '') {
                        $(this).children('a').addClass('focus');
                        if ($(document).width() - $('.desk-menu').offset().left > 250) {
                            $(this).children('div').css({
                                left: 122,
                                top: -2
                            })
                        } else {
                            $(this).children('div').css({
                                left: -126,
                                top: -2
                            })
                        }
                        $(this).children('div').show()
                    }
                }).on('mouseout', 
                function() {
                    $(this).children('a').removeClass('focus');
                    $(this).children('div').hide()
                });
                $('.desk-menu a[menu="orderby"]').off('click').on('click', 
                function() {
                    var xy = $(this).attr('orderby');
                    if (FT.CONFIG.appXY != xy) {
                        FT.app.updateXY(xy, 
                        function() {
                            FT.deskTop.appresize();
                            FT.app.getScrollbar()
                        })
                    }
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="hideall"]').on('click', 
                function() {
                    FT.window.hideAll();
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="refresh"]').on('click', 
                function() {
                    FT.app.get();
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="closeall"]').on('click', 
                function() {
                    FT.window.closeAll();
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="addfolder"]').on('click', 
                function() {
                    $.dialog({
                        id: 'addfolder',
                        title: '新建文件夹',
                        padding: 0,
                        content: editFolderDialogTemp({
                            'name': '新建文件夹',
                            'src': 'img/ui/folder_default.png'
                        }),
                        ok: function() {
                            if ($('#folderName').val() != '') {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=addFolder&name=' + $('#folderName').val() + '&icon=' + $('.folderSelector img').attr('src'),
                                    success: function(folderid) {
                                        $.ajax({
                                            type: 'POST',
                                            url: ajaxUrl,
                                            data: 'ac=addMyApp&id=' + folderid + '&type=folder&desk=' + FT.CONFIG.desk,
                                            success: function() {
                                                FT.app.get()
                                            }
                                        })
                                    }
                                })
                            } else {
                                $('.folderNameError').show();
                                return false
                            }
                        },
                        cancel: true
                    });
                    $('.folderSelector').off('click').on('click', 
                    function() {
                        $('.fcDropdown').show()
                    });
                    $('.fcDropdown_item').off('click').on('click', 
                    function() {
                        $('.folderSelector img').attr('src', $(this).children('img').attr('src')).attr('idx', $(this).children('img').attr('idx'));
                        $('.fcDropdown').hide()
                    });
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="addpapp"]').on('click', 
                function() {
                    $.dialog({
                        id: 'addpapp',
                        title: '新建私人应用',
                        padding: 0,
                        content: editPappDialogTemp({
                            'width': 600,
                            'height': 400,
                            'type': 'papp',
                            'isresize': 1
                        }),
                        ok: function() {
                            var name = $('#addpappName').val(),
                            url = $('#addpappUrl').val(),
                            width = $('#addpappWidth').val(),
                            height = $('#addpappHeight').val(),
                            type = $('#addpapp input[name="addpappType"]:checked').val(),
                            isresize = $('#addpapp input[name="addpappIsresize"]:checked').val();
                            if (name != '' && url != '' && width != '' && height != '') {
                                $.ajax({
                                    type: 'POST',
                                    url: ajaxUrl,
                                    data: 'ac=addPapp&name=' + name + '&url=' + url + '&width=' + width + '&height=' + height + '&type=' + type + '&isresize=' + isresize,
                                    success: function(pappid) {
                                        $.ajax({
                                            type: 'POST',
                                            url: ajaxUrl,
                                            data: 'ac=addMyApp&id=' + pappid + '&type=' + type + '&desk=' + FT.CONFIG.desk,
                                            success: function() {
                                                FT.app.get()
                                            }
                                        })
                                    }
                                })
                            } else {
                                alert('信息填写不完整')
                            }
                        },
                        cancel: true
                    });
                    $('#addpapp input[name="addpappType"]').off('change').on('change', 
                    function() {
                        if ($(this).val() == 'papp') {
                            $('#addpapp tbody tr').eq(4).fadeIn()
                        } else {
                            $('#addpapp tbody tr').eq(4).fadeOut()
                        }
                    });
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="uploadfile"]').on('click', 
                function() {
                    FT.uploadFile.getDialog();
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="themes"]').on('click', 
                function() {
                    FT.window.createTemp({
                        id: 'ztsz',
                        title: '主题设置',
                        url: 'sysfiles/wallpaper/index.php',
                        width: 580,
                        height: 520,
                        isresize: false,
                        isflash: false
                    });
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="setting"]').on('click', 
                function() {
                    FT.window.createTemp({
                        id: 'zmsz',
                        title: '桌面设置',
                        url: 'sysfiles/desksetting/index.php',
                        width: 750,
                        height: 450,
                        isresize: false,
                        isflash: false
                    });
                    $('.popup-menu').hide()
                });
                $('.desk-menu a[menu="logout"]').on('click', 
                function() {
                    FT.base.logout();
                    $('.popup-menu').hide()
                })
            }
            $('.desk-menu a[menu="orderby"]').each(function() {
                $(this).prev().hide();
                if ($(this).attr('orderby') == FT.CONFIG.appXY) {
                    $(this).prev().show()
                }
                $('.popup-menu').hide()
            });
            return TEMP.popupMenuDesk
        }
    }
})();
FT.taskbar = (function() {
    return {
        init: function() {
            $('#task-content-inner').off('click').on('click', 'a.task-item', 
            function() {
                if ($(this).hasClass('task-item-current')) {
                    FT.window.hide($(this).attr('realid'), $(this).attr('type'))
                } else {
                    FT.window.show2top($(this).attr('realid'), $(this).attr('type'))
                }
            }).off('contextmenu').on('contextmenu', 'a.task-item', 
            function(e) {
                $('.popup-menu').hide();
                $('.quick_view_container').remove();
                FT.taskbar.rightClick($(this), e.clientX, e.clientY);
                return false
            })
        },
        rightClick: function(obj, x, y) {
            $('.popup-menu').hide();
            $('.quick_view_container').remove();
            var popupmenu = FT.popupMenu.task(obj);
            l = $(document).width() - x < popupmenu.width() ? x - popupmenu.width() : x;
            t = y - popupmenu.height();
            popupmenu.css({
                left: l,
                top: t
            }).show();
            return false
        },
        pageClick: function(showW, realW) {
            var overW = realW - showW;
            if (FT.CONFIG.dockPos == 'right') {
                $('#task-content-inner').animate({
                    marginLeft: 0
                },
                200)
            } else {
                $('#task-content-inner').animate({
                    marginRight: 0
                },
                200)
            }
            $('#task-next a').addClass('disable');
            $('#task-pre a').removeClass('disable');
            $('#task-next-btn').off('click').on('click', 
            function() {
                if ($(this).hasClass('disable') == false) {
                    if (FT.CONFIG.dockPos == 'right') {
                        var marginL = parseInt($('#task-content-inner').css('margin-left')) + 114;
                        if (marginL >= 0) {
                            marginL = 0;
                            $('#task-next a').addClass('disable')
                        }
                        $('#task-pre a').removeClass('disable');
                        $('#task-content-inner').animate({
                            marginLeft: marginL
                        },
                        200)
                    } else {
                        var marginR = parseInt($('#task-content-inner').css('margin-right')) + 114;
                        if (marginR >= 0) {
                            marginR = 0;
                            $('#task-next a').addClass('disable')
                        }
                        $('#task-pre a').removeClass('disable');
                        $('#task-content-inner').animate({
                            marginRight: marginR
                        },
                        200)
                    }
                }
            });
            $('#task-pre-btn').off('click').on('click', 
            function() {
                if ($(this).hasClass('disable') == false) {
                    if (FT.CONFIG.dockPos == 'right') {
                        var marginL = parseInt($('#task-content-inner').css('margin-left')) - 114;
                        if (marginL <= overW * -1) {
                            marginL = overW * -1;
                            $('#task-pre a').addClass('disable')
                        }
                        $('#task-next a').removeClass('disable');
                        $('#task-content-inner').animate({
                            marginLeft: marginL
                        },
                        200)
                    } else {
                        var marginR = parseInt($('#task-content-inner').css('margin-right')) - 114;
                        if (marginR <= overW * -1) {
                            marginR = overW * -1;
                            $('#task-pre a').addClass('disable')
                        }
                        $('#task-next a').removeClass('disable');
                        $('#task-content-inner').animate({
                            marginRight: marginR
                        },
                        200)
                    }
                }
            })
        },
        resize: function() {
            if (FT.CONFIG.dockPos == 'left') {
                $('#task-bar').css({
                    'left': 73,
                    'right': 0
                });
                $('#task-content-inner').removeClass('fl')
            } else if (FT.CONFIG.dockPos == 'right') {
                $('#task-bar').css({
                    'left': 0,
                    'right': 73
                });
                $('#task-content-inner').addClass('fl')
            } else if (FT.CONFIG.dockPos == 'no_dock') {
                $('#task-bar').css({
                    'left': 0,
                    'right': 73
                });
                $('#task-content-inner').addClass('fl')
            } else {
                $('#task-bar').css({
                    'left': 0,
                    'right': 0
                });
                $('#task-content-inner').removeClass('fl')
            }
            var w = $('#task-bar').width(),
            taskItemW = $('#task-content-inner .task-item').length * 114,
            showW = w - 112;
            if (taskItemW >= showW) {
                $('#task-next, #task-pre').show();
                $('#task-content').css('width', showW);
                FT.taskbar.pageClick(showW, taskItemW)
            } else {
                $('#task-next, #task-pre').hide();
                $('#task-content').css('width', '100%');
                $('#task-content-inner').css({
                    'margin-left': 0,
                    'margin-right': 0
                })
            }
        }
    }
})();
FT.wallpaper = (function() {
    return {
        get: function(fun) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=getWallpaper',
                success: function(msg) {
                    var w = msg.split('<{|}>');
                    FT.CONFIG.wallpaperState = w[0];
                    switch (w[0]) {
                    case '1':
                    case '2':
                        FT.CONFIG.wallpaper = w[1];
                        FT.CONFIG.wallpaperType = w[2];
                        FT.CONFIG.wallpaperWidth = w[3];
                        FT.CONFIG.wallpaperHeight = w[4];
                        break;
                    case '3':
                        FT.CONFIG.wallpaper = w[1];
                        break
                    }
                    if (typeof(fun) != 'undefined') {
                        fun()
                    }
                }
            })
        },
        set: function(isreload) {
            var isreload = typeof(isreload) == 'undefined' ? true: isreload;
            if (isreload) {
                $('#zoomWallpaperGrid').remove()
            }
            var w = $(window).width(),
            h = $(window).height();
            switch (FT.CONFIG.wallpaperState) {
            case '1':
            case '2':
                switch (FT.CONFIG.wallpaperType) {
                case 'pingpu':
                    if (isreload) {
                        $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;background:url(' + FT.CONFIG.wallpaper + ') repeat"></div>')
                    }
                    break;
                case 'juzhong':
                    if (isreload) {
                        $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;background:url(' + FT.CONFIG.wallpaper + ') no-repeat 50% 50%"></div>')
                    }
                    break;
                case 'tianchong':
                    var t = (h - FT.CONFIG.wallpaperHeight) / 2,
                    l = (w - FT.CONFIG.wallpaperWidth) / 2;
                    if (isreload) {
                        $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + FT.CONFIG.wallpaperHeight + 'px;width:' + FT.CONFIG.wallpaperWidth + 'px;top:' + t + 'px;left:' + l + 'px"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
                        $('#zoomWallpaper').attr('src', FT.CONFIG.wallpaper).on('load', 
                        function() {
                            $(this).show()
                        })
                    } else {
                        $('#zoomWallpaperGrid, #zoomWallpaperGrid div').css({
                            height: h + 'px',
                            width: w + 'px'
                        });
                        $('#zoomWallpaper').css({
                            top: t + 'px',
                            left: l + 'px'
                        })
                    }
                    break;
                case 'shiying':
                    var imgH,
                    imgW,
                    t,
                    l;
                    if (FT.CONFIG.wallpaperHeight / FT.CONFIG.wallpaperWidth > h / w) {
                        imgH = h;
                        imgW = FT.CONFIG.wallpaperWidth * (h / FT.CONFIG.wallpaperHeight);
                        t = 0;
                        l = (w - imgW) / 2
                    } else if (FT.CONFIG.wallpaperHeight / FT.CONFIG.wallpaperWidth < h / w) {
                        imgW = w;
                        imgH = FT.CONFIG.wallpaperHeight * (w / FT.CONFIG.wallpaperWidth);
                        l = 0;
                        t = (h - imgH) / 2
                    } else {
                        imgH = FT.CONFIG.wallpaperHeight;
                        imgW = FT.CONFIG.wallpaperWidth;
                        t = l = 0
                    }
                    if (isreload) {
                        $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + imgH + 'px;width:' + imgW + 'px;top:' + t + 'px;left:' + l + 'px"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
                        $('#zoomWallpaper').attr('src', FT.CONFIG.wallpaper).on('load', 
                        function() {
                            $(this).show()
                        })
                    } else {
                        $('#zoomWallpaperGrid, #zoomWallpaperGrid div').css({
                            height: h + 'px',
                            width: w + 'px'
                        });
                        $('#zoomWallpaper').css({
                            height: imgH + 'px',
                            width: imgW + 'px',
                            top: t + 'px',
                            left: l + 'px'
                        })
                    }
                    break;
                case 'lashen':
                    if (isreload) {
                        $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;left:0;top:0;overflow:hidden;height:' + h + 'px;width:' + w + 'px"><img id="zoomWallpaper" style="position:absolute;height:' + h + 'px;width:' + w + 'px;top:0;left:0"><div style="position:absolute;height:' + h + 'px;width:' + w + 'px;background:#fff;opacity:0;filter:alpha(opacity=0)"></div></div>');
                        $('#zoomWallpaper').attr('src', FT.CONFIG.wallpaper).on('load', 
                        function() {
                            $(this).show()
                        })
                    } else {
                        $('#zoomWallpaperGrid').css({
                            height: h + 'px',
                            width: w + 'px'
                        }).children('#zoomWallpaper, div').css({
                            height: h + 'px',
                            width: w + 'px'
                        })
                    }
                    break
                }
                break;
            case '3':
                if (isreload) {
                    $('body').append('<div id="zoomWallpaperGrid" style="position:absolute;z-index:-10;top:0;left:0;height:100%;width:100%;overflow:hidden"><div></div><iframe id="iframeWallpaper" frameborder="no" border="0" class="iframeWallpaper" style="position:absolute;left:0;top:0;overflow:hidden;width:100%;height:100%" src="' + FT.CONFIG.wallpaper + '"></iframe></div>')
                }
                break
            }
        },
        update: function(wallpaperstate, wallpapertype, wallpaper) {
            $.ajax({
                type: 'POST',
                url: ajaxUrl,
                data: 'ac=setWallpaper&wpstate=' + wallpaperstate + '&wptype=' + wallpapertype + '&wp=' + wallpaper,
                success: function() {
                    FT.wallpaper.get(function() {
                        FT.wallpaper.set()
                    })
                }
            })
        }
    }
})();
FT.window = (function() {
    return {
        createTemp: function(obj) {
            $('.popup-menu').hide();
            $('.quick_view_container').remove();
            var type = 'app',
            id = obj.id == null ? Date.parse(new Date()) : obj.id;
            var iswindowopen = false;
            $('#task-content-inner a.task-item').each(function() {
                if ($(this).attr('realid') == id && $(this).attr('type') == type) {
                    iswindowopen = true;
                    FT.window.show2top(id, type)
                }
            });
            if (iswindowopen == false) {
                function nextDo(options) {
                    var windowId = '#w_' + options.type + '_' + options.id;
                    $('#task-content-inner').prepend(taskTemp({
                        'type': options.type,
                        'id': 't_' + options.type + '_' + options.id,
                        'realid': options.id,
                        'title': options.title,
                        'imgsrc': options.imgsrc
                    }));
                    $('#task-content-inner').css('width', $('#task-content-inner .task-item').length * 114);
                    FT.taskbar.resize();
                    TEMP.windowTemp = {
                        'width': options.width,
                        'height': options.height,
                        'top': ($(window).height() - options.height) / 2 <= 0 ? 0: ($(window).height() - options.height) / 2,
                        'left': ($(window).width() - options.width) / 2 <= 0 ? 0: ($(window).width() - options.width) / 2,
                        'emptyW': $(window).width() - options.width,
                        'emptyH': $(window).height() - options.height,
                        'zIndex': FT.CONFIG.createIndexid,
                        'type': options.type,
                        'id': 'w_' + options.type + '_' + options.id,
                        'realid': options.id,
                        'title': options.title,
                        'url': options.url,
                        'imgsrc': options.imgsrc,
                        'isresize': options.isresize == 1 ? true: false,
                        'istitlebar': options.isresize == 1 ? true: false,
                        'istitlebarFullscreen': options.isresize == 1 ? window.fullScreenApi.supportsFullScreen == true ? true: false: false,
                        'issetbar': options.issetbar == 1 ? true: false,
                        'isflash': options.isflash == 1 ? true: false
                    };
                    $('#desk').append(windowTemp(TEMP.windowTemp));
                    $(windowId).data('info', TEMP.windowTemp);
                    FT.CONFIG.createIndexid += 1;
                    $(windowId).find('iframe').on('load', 
                    function() {
                        if (options.isresize) {
                            FT.window.resize($(windowId))
                        }
                        $(windowId + ' .window-frame').children('div').eq(1).fadeOut()
                    });
                    $(windowId).on('contextmenu', 
                    function() {
                        return false
                    });
                    FT.window.handle($(windowId));
                    FT.window.move($(windowId));
                    $('.window-mask').off('click').on('click', 
                    function() {
                        FT.window.show2top($(this).parents('.window-container').attr('realid'), $(this).parents('.window-container').attr('type'))
                    });
                    FT.window.show2top(options.id, options.type)
                }
                nextDo({
                    type: 'app',
                    id: obj.id == null ? Date.parse(new Date()) : obj.id,
                    imgsrc: 'img/ui/add_icon.png',
                    title: obj.title,
                    url: obj.url,
                    width: obj.width,
                    height: obj.height,
                    isresize: obj.isresize,
                    issetbar: false,
                    isflash: obj.isflash == null ? true: obj.isflash
                })
            }
        },
        create: function(id, type) {
            $('.popup-menu').hide();
            $('.quick_view_container').remove();
            var iswindowopen = false;
            $('#task-content-inner a.task-item').each(function() {
                if ($(this).attr('realid') == id && $(this).attr('type') == type) {
                    iswindowopen = true;
                    FT.window.show2top(id, type)
                }
            });
            if (iswindowopen == false) {
                function nextDo(options) {
                    var windowId = '#w_' + options.type + '_' + options.id;
                    var top = ($(window).height() - options.height) / 2 <= 0 ? 0: ($(window).height() - options.height) / 2;
                    var left = ($(window).width() - options.width) / 2 <= 0 ? 0: ($(window).width() - options.width) / 2;
                    switch (options.type) {
                    case 'app':
                    case 'papp':
                        $('#task-content-inner').prepend(taskTemp({
                            'type':
                            options.type,
                            'id': 't_' + options.type + '_' + options.id,
                            'realid': options.id,
                            'title': options.title,
                            'imgsrc': options.imgsrc
                        }));
                        $('#task-content-inner').css('width', $('#task-content-inner .task-item').length * 114);
                        FT.taskbar.resize();
                        TEMP.windowTemp = {
                            'width': options.width,
                            'height': options.height,
                            'top': top,
                            'left': left,
                            'emptyW': $(window).width() - options.width,
                            'emptyH': $(window).height() - options.height,
                            'zIndex': FT.CONFIG.createIndexid,
                            'type': options.type,
                            'id': 'w_' + options.type + '_' + options.id,
                            'realid': options.id,
                            'title': options.title,
                            'url': options.url,
                            'imgsrc': options.imgsrc,
                            'isresize': options.isresize == 1 ? true: false,
                            'istitlebar': options.isresize == 1 ? true: false,
                            'istitlebarFullscreen': options.isresize == 1 ? window.fullScreenApi.supportsFullScreen == true ? true: false: false,
                            'issetbar': options.issetbar == 1 ? true: false,
                            'isflash': options.isflash == 1 ? true: false
                        };
                        $('#desk').append(windowTemp(TEMP.windowTemp));
                        $(windowId).data('info', TEMP.windowTemp);
                        FT.CONFIG.createIndexid += 1;
                        $(windowId + ' iframe').on('load', 
                        function() {
                            if (options.isresize) {
                                FT.window.resize($(windowId))
                            }
                            $(windowId + ' .window-frame').children('div').eq(1).fadeOut()
                        });
                        $(windowId).on('contextmenu', 
                        function() {
                            return false
                        });
                        FT.window.handle($(windowId));
                        FT.window.move($(windowId));
                        $('.window-mask').off('click').on('click', 
                        function() {
                            FT.window.show2top($(this).parents('.window-container').attr('realid'), $(this).parents('.window-container').attr('type'))
                        });
                        FT.window.show2top(options.id, options.type);
                        break;
                    case 'folder':
                        $('#task-content-inner').prepend(taskTemp({
                            'type':
                            options.type,
                            'id': 't_' + options.type + '_' + options.id,
                            'realid': options.id,
                            'title': options.title,
                            'imgsrc': options.imgsrc
                        }));
                        $('#task-content-inner').css('width', $('#task-content-inner .task-item').length * 114);
                        FT.taskbar.resize();
                        TEMP.folderWindowTemp = {
                            'width': options.width,
                            'height': options.height,
                            'top': top,
                            'left': left,
                            'emptyW': $(window).width() - options.width,
                            'emptyH': $(window).height() - options.height,
                            'zIndex': FT.CONFIG.createIndexid,
                            'type': options.type,
                            'id': 'w_' + options.type + '_' + options.id,
                            'realid': options.id,
                            'title': options.title,
                            'imgsrc': options.imgsrc
                        };
                        $('#desk').append(folderWindowTemp(TEMP.folderWindowTemp));
                        $(windowId).data('info', TEMP.folderWindowTemp);
                        FT.CONFIG.createIndexid += 1;
                        $.getJSON(ajaxUrl + '?ac=getMyFolderApp&folderid=' + options.id, 
                        function(sc) {
                            if (sc != null) {
                                for (var i = 0; i < sc.length; i++) {
                                    switch (sc[i]['type']) {
                                    case 'app':
                                    case 'widget':
                                    case 'papp':
                                    case 'pwidget':
                                        $(windowId).find('.folder_body').append(appbtnTemp({
                                            'top':
                                            0,
                                            'left': 0,
                                            'title': sc[i]['name'],
                                            'type': sc[i]['type'],
                                            'id': 'd_' + sc[i]['type'] + '_' + sc[i]['id'],
                                            'realid': sc[i]['id'],
                                            'imgsrc': sc[i]['icon']
                                        }));
                                        break;
                                    case 'folder':
                                        $(windowId).find('.folder_body').append(appbtnTemp({
                                            'top':
                                            0,
                                            'left': 0,
                                            'title': sc[i]['name'],
                                            'type': sc[i]['type'],
                                            'id': 'd_' + sc[i]['type'] + '_' + sc[i]['id'],
                                            'realid': sc[i]['id'],
                                            'imgsrc': sc[i]['icon']
                                        }));
                                        break
                                    }
                                }
                                FT.app.move()
                            }
                            appEvent()
                        });
                        function appEvent() {
                            $(windowId).on('contextmenu', 
                            function() {
                                return false
                            });
                            $(windowId + ' .folder_body').on('contextmenu', '.appbtn', 
                            function(e) {
                                $('.popup-menu').hide();
                                $('.quick_view_container').remove();
                                switch ($(this).attr('type')) {
                                case 'app':
                                case 'widget':
                                    var popupmenu = FT.popupMenu.app($(this));
                                    break;
                                case 'papp':
                                case 'pwidget':
                                    var popupmenu = FT.popupMenu.papp($(this));
                                    break
                                }
                                var l = ($(document).width() - e.clientX) < popupmenu.width() ? (e.clientX - popupmenu.width()) : e.clientX;
                                var t = ($(document).height() - e.clientY) < popupmenu.height() ? (e.clientY - popupmenu.height()) : e.clientY;
                                popupmenu.css({
                                    left: l,
                                    top: t
                                }).show();
                                return false
                            });
                            FT.window.resize($(windowId));
                            $(windowId + ' .window-frame').children('div').eq(1).fadeOut();
                            FT.window.handle($(windowId));
                            FT.window.move($(windowId));
                            $('.window-mask').off('click').on('click', 
                            function() {
                                FT.window.show2top($(this).parents('.window-container').attr('realid'), $(this).parents('.window-container').attr('type'))
                            });
                            FT.window.show2top(options.id, options.type)
                        }
                        break
                    }
                }
                ZENG.msgbox.show('应用正在加载中，请耐心等待...', 6, 100000);
                $.getJSON(ajaxUrl + '?ac=getMyAppById&id=' + id + '&type=' + type, 
                function(app) {
                    if (app != null) {
                        ZENG.msgbox._hide();
                        switch (app['type']) {
                        case 'app':
                        case 'papp':
                        case 'widget':
                        case 'pwidget':
                            nextDo({
                                type:
                                app['type'],
                                id: app['id'],
                                title: app['name'],
                                imgsrc: app['icon'],
                                url: app['url'] + '?qs_appid=' + app['id'],
                                width: app['width'],
                                height: app['height'],
                                isresize: app['isresize'],
                                issetbar: app['issetbar'],
                                isflash: app['isflash']
                            });
                            break;
                        case 'folder':
                            nextDo({
                                type:
                                app['type'],
                                id: app['id'],
                                title: app['name'],
                                imgsrc: app['icon'],
                                width: app['width'],
                                height: app['height']
                            });
                            break
                        }
                    } else {
                        ZENG.msgbox.show('数据拉取失败', 5, 2000);
                        return false
                    }
                })
            }
        },
        close: function(id, type) {
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $(windowId).removeData('info').html('').remove();
            $('#task-content-inner ' + taskId).html('').remove();
            $('#task-content-inner').css('width', $('#task-content-inner .task-item').length * 114);
            $('#task-bar, #nav-bar').removeClass('min-zIndex');
            FT.taskbar.resize()
        },
        closeAll: function() {
            $('#desk .window-container').each(function() {
                FT.window.close($(this).attr('realid'), $(this).attr('type'))
            })
        },
        hide: function(id, type) {
            FT.window.show2top(id, type);
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $(windowId).css('visibility', 'hidden');
            $('#task-content-inner ' + taskId).removeClass('task-item-current');
            if ($(windowId).attr('ismax') == 1) {
                $('#task-bar, #nav-bar').removeClass('min-zIndex')
            }
        },
        hideAll: function() {
            $('#task-content-inner a.task-item').removeClass('task-item-current');
            $('#desk-' + FT.CONFIG.desk).nextAll('div.window-container').css('visibility', 'hidden')
        },
        max: function(id, type) {
            FT.window.show2top(id, type);
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $(windowId + ' .title-handle .ha-max').hide().next(".ha-revert").show();
            $(windowId).attr('ismax', 1).animate({
                width: '100%',
                height: '100%',
                top: 0,
                left: 0
            },
            200);
            $('#task-bar, #nav-bar').addClass('min-zIndex')
        },
        revert: function(id, type) {
            FT.window.show2top(id, type);
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $(windowId + ' .title-handle .ha-revert').hide().prev('.ha-max').show();
            var obj = $(windowId),
            windowdata = obj.data('info');
            obj.attr('ismax', 0).animate({
                width: windowdata['width'],
                height: windowdata['height'],
                left: windowdata['left'],
                top: windowdata['top']
            },
            500);
            $('#task-bar, #nav-bar').removeClass('min-zIndex')
        },
        refresh: function(id, type) {
            FT.window.show2top(id, type);
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            if ($(windowId + '_iframe').length != 0) {
                $(windowId + '_iframe').attr('src', $(windowId + '_iframe').attr('src'))
            } else {
                FT.window.updateFolder(id, type)
            }
        },
        show2top: function(id, type) {
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $('#task-content-inner a.task-item').removeClass('task-item-current');
            $('#task-content-inner ' + taskId).addClass('task-item-current');
            if ($(windowId).attr('ismax') == 1) {
                $('#task-bar, #nav-bar').addClass('min-zIndex')
            }
            $('#desk .window-container .window-container').removeClass('window-current');
            $(windowId).addClass('window-current').css({
                'z-index': FT.CONFIG.createIndexid,
                'visibility': 'visible'
            });
            $('#desk .window-container .window-mask').show();
            $(windowId + ' .window-mask').hide();
            $('#desk .window-container-flash iframe').hide();
            $(windowId + ' iframe').show();
            FT.CONFIG.createIndexid += 1
        },
        updateFolder: function(id, type) {
            FT.window.show2top(id, type);
            var windowId = '#w_' + type + '_' + id,
            taskId = '#t_' + type + '_' + id;
            $.getJSON(ajaxUrl + '?ac=getMyFolderApp&folderid=' + id, 
            function(sc) {
                if (sc != null) {
                    var folder_append = '';
                    for (var i = 0; i < sc.length; i++) {
                        switch (sc[i]['type']) {
                        case 'app':
                        case 'widget':
                            folder_append += appbtnTemp({
                                'top': 0,
                                'left': 0,
                                'title': sc[i]['name'],
                                'type': sc[i]['type'],
                                'id': 'd_' + sc[i]['type'] + '_' + sc[i]['id'],
                                'realid': sc[i]['id'],
                                'imgsrc': sc[i]['icon']
                            });
                            break
                        }
                    }
                    $(windowId).find('.folder_body').html('').append(folder_append).on('contextmenu', '.appbtn', 
                    function(e) {
                        $('.popup-menu').hide();
                        $('.quick_view_container').remove();
                        TEMP.AppRight = FT.popupMenu.app($(this));
                        var l = ($(document).width() - e.clientX) < TEMP.AppRight.width() ? (e.clientX - TEMP.AppRight.width()) : e.clientX;
                        var t = ($(document).height() - e.clientY) < TEMP.AppRight.height() ? (e.clientY - TEMP.AppRight.height()) : e.clientY;
                        TEMP.AppRight.css({
                            left: l,
                            top: t
                        }).show();
                        return false
                    });
                    FT.app.move()
                }
            })
        },
        handle: function(obj) {
            obj.on('dblclick', '.title-bar', 
            function(e) {
                if (obj.find('.ha-max').is(':hidden')) {
                    obj.find('.ha-revert').click()
                } else {
                    obj.find('.ha-max').click()
                }
            }).on('click', '.ha-hide', 
            function() {
                FT.window.hide(obj.attr('realid'), obj.attr('type'))
            }).on('click', '.ha-max', 
            function() {
                FT.window.max(obj.attr('realid'), obj.attr('type'))
            }).on('click', '.ha-revert', 
            function() {
                FT.window.revert(obj.attr('realid'), obj.attr('type'))
            }).on('click', '.ha-fullscreen', 
            function() {
                window.fullScreenApi.requestFullScreen(document.getElementById(obj.find('iframe').attr('id')))
            }).on('click', '.ha-close', 
            function() {
                FT.window.close(obj.attr('realid'), obj.attr('type'))
            }).on('click', '.refresh', 
            function() {
                FT.window.refresh(obj.attr('realid'), obj.attr('type'))
            }).on('click', '.help', 
            function() {
                var help = art.dialog({
                    title: '帮助',
                    follow: this,
                    width: 196
                });
                $.ajax({
                    type: 'POST',
                    url: ajaxUrl,
                    data: 'ac=getAppRemark&id=' + obj.data('info').realid,
                    success: function(msg) {
                        help.content(msg)
                    }
                })
            }).on('click', '.star', 
            function() {
                $.ajax({
                    type: 'POST',
                    url: ajaxUrl,
                    data: 'ac=getAppStar&id=' + obj.data('info').realid,
                    success: function(point) {
                        $.dialog({
                            title: '给“' + obj.data('info').title + '”打分',
                            width: 250,
                            id: 'star',
                            content: starDialogTemp({
                                'point': Math.floor(point),
                                'realpoint': point * 20
                            })
                        });
                        $('#star ul').data('id', obj.data('info').realid)
                    }
                });
                $('body').off('click').on('click', '#star ul li', 
                function() {
                    var num = $(this).attr('num');
                    var id = $(this).parent('ul').data('id');
                    if (!isNaN(num) && /^[1-5]$/.test(num)) {
                        $.ajax({
                            type: 'POST',
                            url: ajaxUrl,
                            data: 'ac=updateAppStar&id=' + id + '&starnum=' + num,
                            success: function(msg) {
                                art.dialog.list['star'].close();
                                if (msg) {
                                    ZENG.msgbox.show("打分成功！", 4, 2000)
                                } else {
                                    ZENG.msgbox.show("你已经打过分了！", 1, 2000)
                                }
                            }
                        })
                    }
                })
            }).on('contextmenu', '.window-container', 
            function() {
                $('.popup-menu').hide();
                $('.quick_view_container').remove();
                return false
            })
        },
        move: function(obj) {
            obj.on('mousedown', '.title-bar', 
            function(e) {
                if (obj.attr('ismax') == 1) {
                    return false
                }
                FT.window.show2top(obj.attr('realid'), obj.attr('type'));
                var windowdata = obj.data('info'),
                lay,
                x,
                y;
                x = e.clientX - obj.offset().left;
                y = e.clientY - obj.offset().top;
                $(document).on('mousemove', 
                function(e) {
                    lay = FT.maskBox.desk();
                    lay.show();
                    obj.find('.ha-revert').hide().prev('.ha-max').show();
                    _l = e.clientX - x;
                    _t = e.clientY - y;
                    _w = windowdata['width'];
                    _h = windowdata['height'];
                    _t = _t <= 10 ? 0: _t >= lay.height() - 30 ? lay.height() - 30: _t;
                    obj.css({
                        width: _w,
                        height: _h,
                        left: _l,
                        top: _t
                    });
                    obj.data('info').left = obj.offset().left;
                    obj.data('info').top = obj.offset().top
                }).on('mouseup', 
                function() {
                    $(this).off('mousemove').off('mouseup');
                    if (typeof(lay) !== 'undefined') {
                        lay.hide()
                    }
                })
            })
        },
        resize: function(obj) {
            obj.find('div.window-resize').on('mousedown', 
            function(e) {
                var resizeobj = $(this),
                lay,
                x = e.clientX,
                y = e.clientY,
                w = obj.width(),
                h = obj.height();
                $(document).on('mousemove', 
                function(e) {
                    lay = FT.maskBox.desk();
                    lay.show();
                    _x = e.clientX;
                    _y = e.clientY;
                    _x = _x <= 10 ? 0: _x >= (lay.width() - 12) ? (lay.width() - 2) : _x;
                    _y = _y <= 10 ? 0: _y >= (lay.height() - 12) ? lay.height() : _y;
                    switch (resizeobj.attr('resize')) {
                    case 't':
                        h + y - _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h + y - _y,
                            top: _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        break;
                    case 'r':
                        w - x + _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w - x + _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        break;
                    case 'b':
                        h - y + _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h - y + _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        break;
                    case 'l':
                        w + x - _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w + x - _x,
                            left: _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        break;
                    case 'rt':
                        h + y - _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h + y - _y,
                            top: _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        w - x + _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w - x + _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        break;
                    case 'rb':
                        w - x + _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w - x + _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        h - y + _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h - y + _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        break;
                    case 'lt':
                        w + x - _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w + x - _x,
                            left: _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        h + y - _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h + y - _y,
                            top: _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        break;
                    case 'lb':
                        w + x - _x > FT.CONFIG.windowMinWidth ? obj.css({
                            width: w + x - _x,
                            left: _x
                        }) : obj.css({
                            width: FT.CONFIG.windowMinWidth
                        });
                        h - y + _y > FT.CONFIG.windowMinHeight ? obj.css({
                            height: h - y + _y
                        }) : obj.css({
                            height: FT.CONFIG.windowMinHeight
                        });
                        break
                    }
                }).on('mouseup', 
                function() {
                    if (typeof(lay) !== 'undefined') {
                        lay.hide()
                    }
                    obj.data('info').width = obj.width();
                    obj.data('info').height = obj.height();
                    obj.data('info').left = obj.offset().left;
                    obj.data('info').top = obj.offset().top;
                    obj.data('info').emptyW = $(window).width() - obj.width();
                    obj.data('info').emptyH = $(window).height() - obj.height();
                    $(this).off('mousemove').off('mouseup')
                })
            })
        }
    }
})();
FT.zoom = (function() {
    return {
        init: function() {
            $('body').append('<div id="zoombox"></div>');
            swfobject.embedSWF('js/zoom.swf?onchange=FT.zoom.check', 'zoombox', '10', '10', '6.0.0', 'expressInstall.swf', '', {
                allowScriptAccess: 'always',
                wmode: 'transparent',
                scale: 'noScale'
            },
            {
                id: 'accessory_zoom',
                name: 'zoom_detect'
            })
        },
        check: function(o) {
            var s = o.scale,
            m = s > 1 ? '放大': '缩小';
            if (s != 1) {
                zoomlevel = s;
                $('#zoom-tip').show().find('span').text('您的浏览器目前处于' + m + '状态，会导致显示不正常，您可以按“ctrl+数字0”组合键恢复初始状态！')
            } else {
                if (s != zoomlevel) {
                    $('#zoom-tip').fadeOut()
                }
            }
        },
        close: function() {
            $('#zoom-tip').remove()
        }
    }
})();