<?php
	require('../../global.php');
	require('inc/setting.inc.php');
?>
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<title>应用市场</title>
<?php include('sysfiles/global_css.php'); ?>
<link rel="stylesheet" href="../../img/ui/sys.css">
</head>

<body>
<div class="sub-nav">
	<ul class="nav-sort">
		<li class="focus" value="0"><a href="javascript:;">全部</a></li>
		<?php
			$mytype = $db->select(0, 1, $tbpre.'member', 'type', 'and tbid='.$_SESSION['member']['id']);
			foreach($apptype as $at){
				//if(($at['id'] == 1 && $mytype['type'] == 1) || $at['id'] != 1){
				if($at['id'] == 1 || $at['id'] != 1){
					echo '<li value="'.$at['id'].'"><a href="javascript:;">'.$at['name'].'</a></li>';
				}
			}
		?>
	</ul>
	<dl class="nav-personal">
		<dt></dt>
		<dd value="-1"><a href="javascript:;" class="per-app">我的应用</a></dd>
	</dl>
	<input type="hidden" name="search_1" id="search_1" value="">
</div>
<div class="wrap">
	<div class="col-main">
		<div class="search-box" align="center">
			<div class="input-append">
				<input type="text" name="keyword" id="keyword" style="width:258px"><button id="search_3" class="btn"><i class="icon-search"></i></button>
			</div>
		</div>
		<div class="mbox app-list-box">
			<div class="title">
				<ul>
					<li class="focus" value="1"><a href="javascript:;">最新应用</a></li>
					<li value="2"><a href="javascript:;">最热门</a></li>
					<li value="3"><a href="javascript:;">最高评价</a></li>
					<input type="hidden" name="search_2" id="search_2" value="1">
				</ul>
			</div>
			<ul class="app-list"></ul>
			<div class="pagination pagination-centered" style="margin-top:6px"><ul id="pagination"></ul></div>
			<?php $appcount = $db->select(0, 2, $tbpre.'app', 'tbid'); ?>
			<input id="pagination_setting" type="hidden" maxrn="<?php echo $appcount; ?>" prn="6" pid="0" />
		</div>
	</div>
</div>
<?php include('sysfiles/global_js.php'); ?>
<script>
$(function(){
	$('.nav-sort li, .nav-personal dd').click(function(){
		$('.nav-sort li, .nav-personal dd').removeClass('focus');
		$(this).addClass('focus');
		$('#search_1').val($(this).attr('value'));
		$('.app-list-box .title li').removeClass('focus').eq(0).addClass('focus');
		$('#search_2').val(1);
		pageselectCallback(-1);
	});
	$('.app-list-box .title li').click(function(){
		$('.app-list-box .title li').removeClass('focus');
		$(this).addClass('focus');
		$('#search_2').val($(this).attr('value'));
		pageselectCallback(-1);
	});
	//搜索按钮
	$('#search_3').click(function(){
		$('.app-list-box .title li').removeClass('focus').eq(0).addClass('focus');
		$('.nav-sort li').removeClass('focus').eq(0).addClass('focus');
		$('#search_1').val(0);
		$('#search_2').val(1);
		pageselectCallback(-1);
	});
	//添加应用
	$('.btn-add-s').live('click', function(){
		var appid = $(this).attr('app_id');
		var apptype = $(this).attr('app_type');
		window.parent.FT.app.add(appid, apptype, function(){
			pageselectCallback($('#pagination_setting').attr('pid'));
			window.parent.FT.app.get();
		});
	});
	//删除应用
	$('.btn-remove-s').live('click', function(){
		var appid = $(this).attr('app_id');
		var apptype = $(this).attr('app_type');
		window.parent.FT.app.remove(appid, apptype, function(){
			pageselectCallback($('#pagination_setting').attr('pid'));
			window.parent.FT.app.get();
		});
	});
	//打开应用
	$('.btn-run-s').live('click', function(){
		if($(this).attr('app_type') == 'app'){
			window.parent.FT.window.create($(this).attr('app_id'), $(this).attr('app_type'));
		}else{
			window.parent.FT.widget.create($(this).attr('app_id'), $(this).attr('app_type'));
		}
	});
	//加载列表
	pageselectCallback();
});
function initPagination(cpn){
	$('#pagination').pagination(parseInt($('#pagination_setting').attr('maxrn')), {
		current_page : cpn,
		items_per_page : parseInt($('#pagination_setting').attr('prn')),
		num_display_entries : 4,
		callback : pageselectCallback,
		prev_text : '上一页',
		next_text : '下一页',
		corner : '0'
	});
}
function pageselectCallback(page_id, reset){
	ZENG.msgbox.show('正在加载中，请稍后...', 6, 100000);
	page_id = (page_id == undefined || isNaN(page_id)) ? 0 : page_id;
	if(page_id == -1){
		page_id = 0;
		reset = 1;
	}
	var from = page_id * parseInt($('#pagination_setting').attr('prn')), to = parseInt($('#pagination_setting').attr('prn')); 
	$.ajax({
		type : 'POST',
		url : 'index.ajax.php',
		data : 'ac=getList&reset=' + reset + '&from=' + from + '&to=' + to + '&search_1=' + $('#search_1').val() + '&search_2=' + $('#search_2').val() + '&search_3=' + $('#keyword').val(),
		success : function(msg){
			var arr = msg.split('<{|*|}>');
			if(parseInt(arr[0], 10) != -1){
				$('#pagination_setting').attr('maxrn', arr[0]);
				initPagination(page_id);
			}
			$('.app-list').html(arr[1]);
			ZENG.msgbox._hide();
		}
	}); 
}
</script>
</body>
</html>