<?php
	require('../../global.php');
	require('inc/setting.inc.php');
	
	$wallpaper = $db->select(0, 1, $tbpre.'member', 'wallpapertype,wallpaperwebsite', 'and tbid = '.$_SESSION['member']['id']);
	$wallpaperList = $db->select(0, 0, $tbpre.'pwallpaper','*',' and member_id = '.$_SESSION['member']['id']);
	foreach($wallpaperList as &$value){
		$value['surl'] = getSimgSrc($value['url']);
	}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta charset="utf-8">
<title>壁纸设置</title>
<?php include('sysfiles/global_css.php'); ?>
<link rel="stylesheet" href="../../img/ui/sys.css">
</head>

<body>
	<div class="title">
		<ul>
			<li class="focus">壁纸设置</li>
			<li><a href="../skin/index.php">皮肤设置</a></li>
		</ul>
	</div>
	<div class="wallpapertype form-inline">
		<div class="btn-group fl">
			<a class="btn" href="index.php">系统壁纸</a><a class="btn disabled">自定义</a>
		</div>
		<div class="fr">
			<label>显示方式：</label>
			<select name="wallpapertype" id="wallpapertype" style="width:100px">
				<option value="tianchong" <?php if($wallpaper['wallpapertype'] == 'tianchong'){echo 'selected';} ?>>填充</option>
				<option value="shiying" <?php if($wallpaper['wallpapertype'] == 'shiying'){echo 'selected';} ?>>适应</option>
				<option value="pingpu" <?php if($wallpaper['wallpapertype'] == 'pingpu'){echo 'selected';} ?>>平铺</option>
				<option value="lashen" <?php if($wallpaper['wallpapertype'] == 'lashen'){echo 'selected';} ?>>拉伸</option>
				<option value="juzhong" <?php if($wallpaper['wallpapertype'] == 'juzhong'){echo 'selected';} ?>>居中</option>
			</select>
		</div>
	</div>
	<div class="wapppapercustom">
		<div class="view">
			<ul id="piclist">
				<?php
					foreach($wallpaperList as $v){
						echo '<li id="'.$v['tbid'].'" style="background:url(../../'.$v['surl'].')"><a href="javascript:;">删 除</a></li>';
					}
				?>
			</ul>
		</div>
	</div>
	<div class="wapppaperupload form-inline">
	    <form id="form" name="form" method="post" action="custom.ajax.php" enctype="multipart/form-data" style="margin:0px;">
		<label>上传壁纸：</label>
		<div class="input-append">
			<input name="pic" type="file" class="grayinput" size="42" id="file" style="height:28px;">
			<button type="button" class="btn">上传</button>
			<input type="hidden" name="ac" value="imgUpload">
		</div>
		</form>
	</div>
	<div class="wapppaperwebsite form-inline">
		<label>网络壁纸：</label>
		<div class="input-append">
			<input type="text" id="wallpaperurl" style="width:300px" placeholder="请输入一个URL地址（地址以jpg,jpeg,png,gif结尾）" value="<?php echo $wallpaper['wallpaperwebsite']; ?>"><button type="button" class="btn">应用</button>
		</div>
	</div>
<?php include('sysfiles/global_js.php'); ?>
<script>
$().ready(function(){
	var options = {
		beforeSubmit : showRequest,
		success : showResponse,
		type : 'POST'
	};
	$('#form').ajaxForm(options);
	$('.wapppaperupload button').click(function(){
		$('#form').submit();
	});
});

$(function(){
	$('#wallpapertype').on('change', function(){
		window.parent.FT.wallpaper.update(2, $('#wallpapertype').val(), '');
	});
	$('.wapppapercustom li').on('click', function(){
		window.parent.FT.wallpaper.update(2, $('#wallpapertype').val(), $(this).attr('id'));
	});
	$('.wapppapercustom li a').on('click', function(){
		var id = $(this).parent().attr('id');
		$.ajax({
			type : 'POST',
			url : 'custom.ajax.php',
			data : 'ac=del&id=' + id,
			success : function(){
				$('#' + id).remove();
			}
		});
		return false;
	});

	$('.wapppaperwebsite button').on('click', function(){
		window.parent.FT.wallpaper.update(3, $('#wallpapertype').val(), $('#wallpaperurl').val());
	});
});

function showRequest(formData, jqForm, options){
	//alert('提交信息: \n\n' + $.param(formData));
	return true;
}
function showResponse(responseText, statusText, xhr, $form){
	//alert('status: ' + statusText + '\n\nresponseText: \n' + responseText);
	if (responseText == 1){
		window.top.ZENG.msgbox.show("请选择你要上传的壁纸！", 1, 3000);
	}else if (responseText == 2){
        window.top.ZENG.msgbox.show("不允许上传这种类型文件！", 1, 3000);
	}else if (responseText == 3){
        window.top.ZENG.msgbox.show("你上传的文件太大了！", 1, 3000);
	}else if (responseText == 4){
        window.top.ZENG.msgbox.show("壁纸文件名已存在,请重新命名后再提交!", 1, 3000);
	}else if (responseText == 5){
		//$('#piclist').append(responseText);
		//$('.wapppapercustom').html(responseText);   //写入新内容
		$.dialog({
			id : 'uploadfile',
			content : '自定义壁纸已上传成功！',
			ok : function(){
				$.dialog.list['uploadfile'].close();
				//$('.wapppapercustom').append(responseText); //内容叠加
				//$('.wapppapercustom').html(responseText);   //写入新内容
				window.location.href='custom.php';
			}
		});
	}else if (responseText == 6){
        window.top.ZENG.msgbox.show("你上传的壁纸有问题,请换一张再传！", 1, 3000);
	}
}
</script>
</body>
</html>