<?php
/* 
 * wps接口用到了COM组件，必须在windows平台下；linux环境建议用openoffice方案解决
 * 使用说明：
 * 以下为php的系统命令函数调用php命令行
 * system('xxxx/php.exe yyyyy/test.php zzzz/filename.wps');//注意参数中的文件名路径必须是绝对路径
 * 作者：大宇（366377779@qq.com）
 */
error_reporting(5);
header("Content-type:text/html; charset=utf-8");
set_time_limit(0);



if($argv[1]) {
  $src_filename = $argv[1];

  if(!file_exists($src_filename)) {
    echo "File : $src_filename not found!";
    exit;
  }
  
  //生成同目录下同文件名的pdf后缀文件
  $filepathinfo = pathinfo($src_filename);
  $filename = $filepathinfo['filename'];
  $extension = $filepathinfo['extension'];//原始文件的后缀名
  $dirname = realpath($filepathinfo['dirname']);
  $pdf_filename = $dirname . $filename . ".pdf";
}




$doc_arr = array('doc', 'docx', 'wps');
$xls_arr = array('xls', 'xlsx', 'et');
$ppt_arr = array('ppt', 'pptx', 'dps');

if(in_array($extension, $doc_arr)) {
  $wps = new COM("Word.Application") or die('Com Error');
  
  $doc = $wps->Documents->Open($src_filename);
  $doc->ExportAsFixedFormat($pdf_filename, 17);//17=pdf
}elseif(in_array($extension, $xls_arr)) {
  $wps = new COM("Excel.Application") or die('Com Error');
  
  $doc = $wps->Workbooks->Open($src_filename);
  $doc->ExportAsFixedFormat(0, $pdf_filename);//0=pdf
}elseif(in_array($extension, $ppt_arr)) {
  $wps = new COM("Powerpoint.Application") or die('Com Error');
  
  $doc = $wps->Presentations->Open($src_filename, true);
  //$doc->ExportAsFixedFormat($pdf_filename, 2);
  $doc->SaveAs($pdf_filename, 32, 1);//ppt另存为可以生成pdf
}else{
  echo "Src File Extension: $extension, is error";
  exit;
}

$doc->Close();

$wps->Quit(); 

unset( $doc , $wps );
echo "ok";
