<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Biz_Account extends Ctl
{
    
    public function login($params)
    {
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if(!$passwd = $params['passwd']){
            $this->msgbox->add('登录密码不正确',212);
        }else if($shop = K::M('shop/auth')->login($mobile, $passwd)){
            $shop = $this->filter_fields('shop_id,title,logo,mobile,money', $shop);
            $shop['token'] = $this->auth->token;
            $this->msgbox->set_data('data', $shop);
        }
    }

    public function signup($params)
    {
        $session = K::M('system/session')->start();
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($sms_code = $params['sms_code']){
            $this->msgbox->add('手机验证码有误',213);
        }else if(K::M('system/session')->start()->get('code_'.$mobile) != $sms_code){
            $this->msgbox->add('短信验证码有误',213);
        }else if(!$passwd = $params['passwd']){
            $this->msgbox->add('登录密码不正确',214);
        }else if($shop = K::M('shop/shop')->shop($mobile, 'mobile')){
            $this->msgbox->add('该手机号已经注册过',215);
        }else{

        }
    }

    public function forgot($params)
    {
        $session = K::M('system/session')->start();
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($session->get('code_'.$mobile) != $params['sms_code']){
            $this->msgbox->add('短信验证码有误',213);
        }else if(!$new_passwd = $params['new_passwd']){
            $this->msgbox->add('登录密码不正确',214);
        }else if(!$shop = K::M('shop/shop')->shop($mobile, 'mobile')){
            $this->msgbox->add('该手机号未注册过',215);
        }else if(K::M('shop/shop')->update($staff['shop_id'], array('passwd'=>$new_passwd))){
            $this->msgbox->set_data('data', array('shop_id'=>$shop['shop_id']));
        }
    }

}