<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Biz_Comment extends Ctl_Biz
{
    
    protected $_allow_fields = 'comment_id,shop_id,uid,order_id,score,score_fuwu,score_kouwei,pei_time,content,have_photo,reply,reply_ip,reply_time,dateline'

    public function items($params)
    {
        $limit = 10;
        $page = max((int)$params['page'], 1);
        $filter = array('shop_id'=>$this->shop_id);
        if($items = K::M('shop/comment')->items($filter, null, $page, $limit, $count)){
            foreach($items as $k=>$v){
                $items[$k] = $this->filter_fields($this->_allow_fields, $v);
            }
        }else{
            $items = array();
        }
        $this->msgbox->set_data('data', array('items'=>array_values($items), 'total_count'=>$count));
    }

    public function reply($params)
    {
        if(!$comment_id = (int)$params['comment_id']){
            $this->msgbox->add('参数错误', 211);
        }if(!$comment = K::M('shop/comment')->detail($comment_id)){
            $this->msgbox->add('回复的评论不存在', 212);
        }else if($comment['shop_id'] != $this->shop_id){
            $this->msgbox->add('您没有权限评论改评论', 213);
        }else if(!$reply = $params['reply']){
            $this->msgbox->add('评论内容不能为空', 214);
        }else if(K::M('shop/comment')->update($comment_id, array('reply'=>$reply, 'reply_time'=>__TIME, 'reply_ip'=>__IP)){
            $this->msgbox->add('success');
        }
    }

}