<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Biz_Member extends Ctl_Biz
{
    
    public function fans($params)
    {
        $limit = 10;
        $page = max((int)$page, 1);
        $member_list = array();
        if($items = K::M('shop/collect')->items(array('shop_id'=>$shop_id), null, $page, $limit, $count)){
            $uids = array();
            foreach($items as $v){
                $uids[$v['uid']] = $v['uid'];
            }
            if($uids){
                $member_list = K::M('member/member')->items_by_ids($uids);
            }
        }
        $this->msgbox->set_data('data', array('items'=>array_values($member_list), 'total_count'=>$count));
    }

    public function order($params)
    {
        $limit = 10;
        $page = max((int)$page, 1);
        $member_list = array();
        if($items = K::M('order/order')->customs_by_shop(array('shop_id'=>$this->shop_id), $page, $limit, $count)){
            $uids = array();
            foreach($items as $v){
                $uids[$v['uid']] = $v['uid'];
            }
            if($uids){
                $member_list = K::M('member/member')->items_by_ids($uids);
            }
            foreach($items as $k=>$v){
                if($m = $member_list[$v['uid']]){
                    $v['nickname'] = $m['nickname'];
                    $v['mobile'] = $m['mobile'];
                }
                $items[$k] = $v;
            }
        }
        $this->msgbox->set_data('data', array('items'=>array_values($items)));
    }

    public function detail($params)
    {
        if(!$uid = (int)$params['uid']){
            $this->msgbox->add('未指定客户ID', 211);
        }else if(!$member = K::M('member/member')->detail($uid)){
            $this->msgbox->add('要查看的客户不存在或已经删除', 212);
        }else{
            $custom = array('uid'=>$member['uid'], 'nickname'=>$member['nickname'], 'mobile'=>$member['mobile']);
            $custom['total_amount'] = $custom['total_order'] = 0;
            if($custom_list = K::M('order/order')->customs_by_shop(array('shop_id'=>$this->shop_id, 'uid'=>$uid), 1, 1)){
                if($custom = $custom_list[$uid]){
                    $member['total_order'] = $custom['total_order'];
                    $member['total_amount'] = $custom['total_amount'];
                }
                $items = K::M('order/order')->items(array('shop_id'=>$this->shop_id, 'uid'=>$uid), null, 1, 10);
            }
            $this->msgbox->set_data('data', array('items'=>array_values($items), 'custom'=>$custom));
        }
    }

}