<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Biz_Order extends Ctl_Biz
{

    public function items($params)
    {
        $limit = 10;
        $page = max((int)$params['page'], 1);
        $filter['shop_id'] = $this->shop_id;
        if(in_array($params['status'], array(1, 2, 3))){
            switch ($params['status']) {
                case 1 :
                    $filter['order_status'] = 0;
                    $filter['pei_type'] = array(0, 1);
                    $filter[':OR'] = array('pay_status'=>1, 'online_pay'=>0);
                    break;
                case 2 :
                    $filter['pei_type'] = array(0, 1);
                    $filter['order_status'] = array(1, 2, 3);
                    break;
                case 3 :
                    $filter['order_status'] = 8;
                    break;
            }
        }
        if($items = K::M('order/order')->items($filter, null, $page, $limit, $count)){
            $staff_ids = $staff_list = array();
            foreach($items as $k=>$v){
                if($v['staff_id']){
                    $staff_ids[$v['staff_id']] = $v['staff_id'];
                }
            }
            if($staff_ids){
                $staff_list = K::M('staff/staff')->items_by_ids($staff_ids);
            }
            foreach ($items as $k=>$v) {
                if($v['staff_id']){
                    $v['staff'] = (array)$staff_list[$v['staff_id']];
                }else{
                    $v['staff'] = array();
                }
            }
        }
        $this->msgbox->set_data('data', array('items'=>array_values($items), 'total_count'=>$count));
    }

    public function jiedan($params)
    {
        if($order_id = (int)$params['order_id']){
            $this->msgbox->add('参数传递有误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在或已经删除', 212);
        }else if($order['shop_id'] != $this->shop_id){
            $this->msgbox->add('您没有权限操作该订单', 213);
        }else if($order['pei_type'] == 2){
            $this->msgbox->add('代购订单不可接单', 214);
        }else if($order['order_status'] !== 0 && ($order['pay_status'] || empty($order['online_pay']))){
            $this->msgbox->add('订单状态不可接单', 215);
        }else if(K::M('order/order')->update($order_id, array('order_status'=>1))){
            //订单日志
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'shop', 'log'=>'商家已接单', 'type'=>'3'));
            $this->msgbox->add('success');
        }
    }

    public function cancel($params)
    {
        if($order_id = (int)$params['order_id']){
            $this->msgbox->add('参数传递有误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在或已经删除', 212);
        }else if($order['shop_id'] != $this->shop_id){
            $this->msgbox->add('您没有权限操作该订单', 213);
        }else if($order['pei_type'] == 2){
            $this->msgbox->add('代购订单不可取消', 214);
        }else if($order['order_status'] !== 0 ))){
            $this->msgbox->add('订单状态不可取消', 215);
        }else if(K::M('order/order')->update($order_id, array('order_status'=>-2))){
            //订单日志
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'shop', 'log'=>'商家取消订单', 'type'=>'-1'));
            $this->msgbox->add('success');
        }
    }

    public function pei($params)
    {
        if($order_id = (int)$params['order_id']){
            $this->msgbox->add('参数传递有误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在或已经删除', 212);
        }else if($order['shop_id'] != $this->shop_id){
            $this->msgbox->add('您没有权限操作该订单', 213);
        }else if($order['pei_type'] == 2){
            $this->msgbox->add('代购订单不可操作', 214);
        }else if($order['order_status'] == 1 ))){
            $this->msgbox->add('订单状态不可发货', 215);
        }else if(K::M('order/order')->update($order_id, array('order_status'=>3))){
            //订单日志 v-1取消，0其他，1下单，2支付，3接单，4配送，5送达，6确认完成
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'shop', 'log'=>'商家取消订单', 'type'=>4));
            $this->msgbox->add('success');
        }
    }

    public function delivered($params)
    {
        if($order_id = (int)$params['order_id']){
            $this->msgbox->add('参数传递有误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在或已经删除', 212);
        }else if($order['shop_id'] != $this->shop_id){
            $this->msgbox->add('您没有权限操作该订单', 213);
        }else if($order['pei_type'] == 2){
            $this->msgbox->add('代购订单不可操作', 214);
        }else if($order['order_status'] == 3 ))){
            $this->msgbox->add('订单状态不可设置为已送达', 215);
        }else if(K::M('order/order')->update($order_id, array('order_status'=>4))){
            //订单日志 v-1取消，0其他，1下单，2支付，3接单，4配送，5送达，6确认完成
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'shop', 'log'=>'商家取消订单', 'type'=>5));
            $this->msgbox->add('success');
        }
    }

    public function batch($params)
    {

    }

}
