<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Member_Collect extends Ctl
{


    public function items($params)
    {
        $this->check_login();
        $filter = $items = array();
        $filter['uid'] = $this->uid;
        $page = max((int)$params['page'], 1);
        if($collect_list = K::M('member/mystaff')->items($filter, null, $page, 10)){
            
            $staff_ids = array();
            foreach($collect_list as $k=>$val){
                $staff_ids[$val['staff_id']] = $val['staff_id'];
            }
            $catess = K::M('cate/cate')->fetch_all();
            foreach($catess as $k=>$val){
                if($val['parent_id'] != 0){
                    $cates[$k] = $val;
                }
            }
            $staff_list = K::M('staff/staff')->items_by_ids($staff_ids);
            $attrs = K::M('staff/attr')->items(array('staff_id'=>$staff_ids));
            $cate_lists = array();
            foreach ($attrs as $k=>$val){
                if(!$cates[$val['cate_id']]){
                    $cate_lists[$val['staff_id']] = array();
                }else{
                    $cate_lists[$val['staff_id']][] = $this->filter_fields('cate_id,title,photo,deposit,parent_id',$cates[$val['cate_id']]);
                }
            }
            foreach($staff_list as $k=>$val){
                if($cate_lists[$val['staff_id']]){
                    $staff_list[$val['staff_id']]['skill'] = $cate_lists[$val['staff_id']];
                }else{
                    $staff_list[$val['staff_id']]['skill'] = array();
                }
            }
            $items = array();
            foreach($staff_list as $k=>$val){
                $items[] = $this->filter_fields('staff_id,city_id,mobile,orders,name,face,intro,skill,title,lat,lng,score,comments,praise_num,year_num', $val);
            }
        }else{
            $items = array();
        }
        $this->msgbox->add('success');
        $this->msgbox->set_data('data', array('items'=>array_values($items)));
    }


    public function add($params)
    {
        $this->check_login();
        if(!$staff_id = (int)$params['staff_id']) {
            $this->msgbox->add('该师傅不存在',202);
        }else if(!$detail = K::M('staff/staff')->detail($staff_id)){
            $this->msgbox->add('该师傅不存在',203);
        }else if(empty($detail['audit'])) {
            $this->msgbox->add('师傅未通过审核',204);
        }else if($result = K::M('member/mystaff')->find(array('uid'=>$this->uid,'staff_id'=>$staff_id))){
            $this->msgbox->add('您已经关注过该师傅了',205);
        }else {
            $data = array('uid'=>$this->uid,'staff_id'=>$staff_id);
            if(K::M('member/mystaff')->create($data)){
                $this->msgbox->add('collect success');
            }
        }
    }

    public function cancel($params)
    {
        $this->check_login();
        if(!$staff_id = (int)$params['staff_id']) {
            $this->msgbox->add('该师傅不存在',202);
        }else if(!$detail = K::M('staff/staff')->detail($staff_id)){
            $this->msgbox->add('该师傅不存在',203);
        }else if($detail['audit'] !=1||$detail['closed'] !=0) {
            $this->msgbox->add('该师傅不存在或已被删除',204);
        }else if(!$result = K::M('member/mystaff')->find(array('uid'=>$this->uid,'staff_id'=>$staff_id))){
            $this->msgbox->add('您还没有关注该师傅',205);
        }else {
            if(K::M('member/mystaff')->del($this->uid,$staff_id)){  //
                $this->msgbox->add('cancel success');
            }

        }


    }



}
