<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Payment extends Ctl
{
    

    public function order($params)
    {
        $this->check_login();
        if(!($order_id = (int)$order_id) && !($order_id = (int)$params['order_id'])){
            $this->msgbox->add('参数传递错误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在', 212);
        }else if($order['uid'] != $this->uid){
            $this->msgbox->add('订单非法', 213);
        }else if($order['order_status'] < 0){
            $this->msgbox->add('订单已取消不可支付', 214);
        }else if($order['pay_status'] == 1){
            $this->msgbox->add('该订单已经支付', 216);
        }else if($order['amount'] <= 0){
            $this->msgbox->add('该订单不需要支付', 217);
        }else if(!$code = $params['code']){
            $this->msgbox->add('未选定支付方式', 221);
        }else if($code == 'money' && $this->MEMBER['money'] < ($order['amount'] - $order['hongbao'] - $order['deposit'])){
            $this->msgbox->add('余额不足，请更换支付方式', 221);
        }else if(!$data = K::M('trade/payment')->order($code, $order, 'APP')){
            $this->msgbox->add('创建支付请求失败', 223);
        }else{
            $this->msgbox->set_data('data', $data);
            $this->msgbox->add('success');
        }
    }

    public function deposit($params)
    {
        $this->check_login();
        if(!($order_id = (int)$order_id) && !($order_id = (int)$params['order_id'])){
            $this->msgbox->add('参数传递错误', 211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('订单不存在', 212);
        }else if($order['uid'] != $this->uid){
            $this->msgbox->add('订单非法', 213);
        }else if($order['order_status'] < 0){
            $this->msgbox->add('订单已取消不可支付', 214);
        }else if($order['pay_status'] == 1){
            $this->msgbox->add('该订单已经支付', 216);
        }else if($order['deposit'] == 0){
            $this->msgbox->add('该订单不需要支付', 217);
        }else if(!$code = $params['code']){
            $this->msgbox->add('未选定支付方式', 221);
        }else if($code == 'money' && $this->MEMBER['passwd'] != $params['passwd']){
            $this->msgbox->add('密码不正确', 220);
        }else if($code == 'money' && $this->MEMBER['money'] < $order['deposit']){
            $this->msgbox->add('余额不足，请更换支付方式', 222);
        }else if(!$data = K::M('trade/payment')->deposit($code, $order, 'APP')){
            $this->msgbox->add('创建支付请求失败', 223);
        }else{
            $this->msgbox->set_data('data', $data);
            $this->msgbox->add('success');
        }        
    }

    public function money($params)
    {
        $this->check_login();
        if(!$code = $params['code']){
            $this->msgbox->add('未选定支付方式', 211);
        }else if(!$amount = $params['amount']){
            $this->msgbox->add('未选择充值金额', 212);
        }else if($data = K::M('trade/payment')->money($this->uid, $code, $amount, 'APP')){
            $this->msgbox->set_data('data', $data);
            $this->msgbox->add('success');
        }else{
            $this->msgbox->add('创建支付请求失败', 213);
        }
    }

    public function payment_return($params)
    {
        $this->check_login();
        if(!$code && !($code = $params['code'])){
            $this->msgbox->add('未指定支付方式', 211);
        }else if(!$return_data =$params['return_data']){
            $this->msgbox->add('支付返回参数不正确', 212);
        }else if($obj = K::M('trade/payment')->loadPayment($code)){
            $_GET = array_merge($_GET, json_decode($return_data, true));
            if($trade = $obj->return_verify()){
                if(!$log = K::M('payment/log')->log_by_no($trade['trade_no'])){
                    $this->msgbox->add('支付的订单不存在', 211);
                }else if(K::M('payment/log')->set_payed($trade['trade_no'])){
                    if($log['from'] == 'order'){ //订单支付
                        K::M('trade/payment')->payed_order($log, $trade);
                        $this->pagedata['order'] = K::M('trade/order')->detail_by_no($trade['trade_no']);
                        $this->msgbox->add('success');//订单支付成功                      
                        $forward = $this->mklink('mobile/order:detail', array($trade['trade_no']));
                    }else if($log['from'] == 'money'){ //余额充值
                        K::M('trade/payment')->payed_money($log, $trade);
                        $this->msgbox->add('success');//充值余额成功
                    }
                }else{
                    if($log['from'] == 'order'){
                        $this->msgbox->add('该订单已经支付过了', 213);
                    }else if($log['from'] == 'money'){
                        $this->msgbox->add('已经充值成功，请不要重复提交', 214);
                    }
                }
            }else{
                $this->msgbox->add('支付验证签名失败', 215);
            }
        }        
    }

    public function package($params)
    {
        $data = array();
        if($package = K::M('member/money')->package()){
            foreach($package as $k=>$v){
                $data[] = array('chong'=>$k, 'song'=>$v);
            }
        }
        $this->msgbox->set_data('data', array('items'=>$data));
    }


    /**
     * 余额支付确认
     * trade_no 支付订单号
     * passwd 支付密码同用户登录密码
     */
    public function paymoney($params)
    {
        $this->check_login();
        $passwd = $params['passwd'];
        if(!$order_id = $params['order_id']){
            $this->msgbox->add('要支付订单号错误', 211);
        }else if($passwd != $this->MEMBER['passwd']){
            $this->msgbox->add('支付密码不正确', 212);
        }else {
            if(!$order = K::M('order/order')->detail($order_id)){
                $this->msgbox->add('订单不存在或已删除', 214);
            }else if($this->uid != $order['uid']){
                $this->msgbox->add('非法的数据操作', 215);
            }else if($order['order_status'] < 0){
                $this->msgbox->add('订单已经取消,不可支付', 216);
            }else if($order['pay_status']){
                $this->msgbox->add('该订单已经支付', 217);
            }else if($order['order_status']==8){
                $this->msgbox->add('该订单已经完成', 218);
            }else{
                // 补价支付
                $up_data1 = array('pay_status'=>1,'pay_time'=> __TIME,'pay_ip'=>__IP,  'pay_code'=>'money','order_status'=>8);
                if($order['order_status'] == 2 && $order['pay_status'] == 0) {
                    $chajia = $order['amount'] - $order['deposit'] - $order['hongbao']; 
                    if($chajia > 0) {
                        $up = K::M('order/order')->update($order['order_id'],$up_data1); 
                        if($this->MEMBER['money'] < $chajia){
                            $this->msgbox->add('账户余额不足！',555);
                        }else if(K::M('member/member')->update_money($this->uid, -$chajia, '余额支付订单(ID:'.$order['order_id'].')')) {
                            $this->MEMBER['money'] = $this->MEMBER['money'] - $chajia;    
                            //师傅获得支付的金额
                            K::M('staff/staff')->update_money($order['staff_id'], $order['amount'],"订单补价结算(ID:{$order['order_id']})");     
                            $this->msgbox->set_data('data',$trade);   
                            $this->msgbox->add('支付成功');
                        }
                    }else {
                        $this->msgbox->add('差价金额不正确',220);
                    } 
                }else {
                    // 正常支付
                    if(!$order['staff_id']){
                        $up_data2 = array('pay_status'=>1,'pay_time'=> __TIME,'pay_ip'=>__IP,  'pay_code'=>'money','lasttime'=>__TIME);
                    }else{
                        $up_data2 = array('pay_status'=>1,'pay_time'=> __TIME,'pay_ip'=>__IP,  'pay_code'=>'money','order_status'=>1,'lasttime'=>__TIME);
                    }
                    $up = K::M('order/order')->update($order['order_id'],$up_data2);
                    if($this->MEMBER['money'] < $order['deposit']){
                        $this->msgbox->add('账户余额不足！',555);
                    }else if(K::M('member/member')->update_money($this->uid, -($order['deposit']), '余额支付定金(ID:'.$order['order_id'].')')){
                        $this->MEMBER['money'] = $this->MEMBER['money'] - $order['deposit'];    
                        $this->msgbox->set_data('data',$trade);   
                        $this->msgbox->add('定金支付成功');
                    }
                }   
            }
        } 
    }
}
