 <?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}
class Ctl_Staff_Member extends Ctl
{

    public function index()
    {
        exit('{"error":"0", "message":"staff api test"}');
    }

    public function login($params)
    {
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if(!$passwd = $params['passwd']){
            $this->msgbox->add('登录密码不正确',212);
        }else if($staff = K::M('staff/auth')->login($mobile, $passwd,null,true)){
            $staff = $this->filter_fields('staff_id,name,face,mobile,money,status',$staff);     
            $staff['token'] = $this->auth->token;
            $this->msgbox->set_data('data',$staff);
        }
    }

    public function signup($params)
    {
        $session = K::M('system/session')->start();
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($session->get('code_'.$mobile) != $params['sms_code']){
            $this->msgbox->add('短信验证码有误',213);
        }else if(!$passwd = $params['passwd']){
            $this->msgbox->add('登录密码不正确',214);
        }else if(!$name = $params['name']){
            $this->msgbox->add('用户名不正确',214);
        }else if($staff = K::M('staff/staff')->staff($mobile, 'mobile')){
            $this->msgbox->add('该手机号已经注册',215);
        }else{
            $a = array('mobile'=>$mobile, 'passwd'=>$passwd);
            if(!$a['name'] = $params['name']){
                $a['name'] = substr($mobile, 1,3).'***'.substr($mobile, -4);
            }            
            if($staff_id = K::M('staff/staff')->create($a)){
                $cates = explode(',',$params['cates']);
                foreach($cates as $val){
                    K::M('staff/attr')->create(array('staff_id'=>$staff_id,'cate_id'=>$val));
                }
                if(K::M('staff/auth')->manager($staff_id)){
                    $member = $this->filter_fields('staff_id,name,face,mobile', $this->auth->staff);
                    $this->msgbox->add('success');
                    $member['token'] = $this->auth->token;
                    $this->msgbox->set_data('data', $member);
                }
            }
        }
    }

    public function forgot($params)
    {
        $session = K::M('system/session')->start();
        if(!$params['mobile']){
            $this->msgbox->add('手机号码有误',211);
        }else if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($session->get('code_'.$mobile) != $params['sms_code']){
            $this->msgbox->add('短信验证码有误',213);
        }else if(!$new_passwd = $params['new_passwd']){
            $this->msgbox->add('登录密码不正确',214);
        }else if(!$staff = K::M('staff/staff')->staff($mobile, 'mobile')){
            $this->msgbox->add('该手机号未注册过',215);
        }else if(K::M('staff/staff')->update($staff['staff_id'], array('passwd'=>$new_passwd))){
            if($staff2 = K::M('staff/auth')->login($mobile, $new_passwd,null,true)){
                $staff2 = $this->filter_fields('staff_id,name,face,mobile,money,status',$staff2);     
                $staff2['token'] = $this->auth->token;
            }
            $this->msgbox->set_data('data', array('staff'=>$staff2));
        }
    }

    public function passwd($params)
    {
        $this->check_login();
        $session = K::M('system/session')->start();
        if(!$mobile = K::M('verify/check')->mobile($params['mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($session->get('code_'.$mobile) != $params['sms_code']){
            $this->msgbox->add('短信验证码有误',213);
        }else if(!$new_passwd = $params['new_passwd']){
            $this->msgbox->add('新密码不正确',214);
        }else if(K::M('staff/staff')->update($this->staff_id, array('passwd'=>$new_passwd))){
            if($staff2 = K::M('staff/auth')->login($mobile,$new_passwd,null,true)){
                $staff2 = $this->filter_fields('staff_id,name,face,mobile,money,status',$staff2);     
                $staff2['token'] = $this->auth->token;
            }
            $this->msgbox->set_data('data', array('staff_id'=>$this->staff_id));
        }
    }

    public function updatemobile($params)
    {
        $this->check_login();
        $session = K::M('system/session')->start();
        if(!$new_mobile = K::M('verify/check')->mobile($params['new_mobile'])){
            $this->msgbox->add('手机号码有误',212);
        }else if($session->get('code_'.$new_mobile) != $params['sms_code']){
            $this->msgbox->add('短信验证码有误',213);
        }else if($res = K::M('staff/staff')->staff($new_mobile, 'mobile')){
            $this->msgbox->add('手机号码已存在',214);
        }else if(K::M('staff/staff')->update($this->staff_id, array('mobile'=>$new_mobile))){
            $this->msgbox->set_data('data', array('staff_id'=>$this->staff_id));
        }
    }

    public function uploadface($params)
    {
        $this->check_login();
        if(!$face = $params['face']){
            $this->msgbox->add('未上传文件', 211);
        }else if(!$face = base64_decode($face)){
            $this->msgbox->add('文件格式不对', 211);
        }else if($face_url = K::M('staff/staff')->update_face($this->staff_id, null, $face)){
            $this->msgbox->add('success');
            $this->msgbox->set_data('data', array('face'=>$face_url));
        }
    }
    
    //提交认证资料
    public function verify($params)
    {
        $this->check_login(); 
        if($this->STAFF['verify_name'] == 1){
            $this->msgbox->add('已经认证成功不可修改',210);
        }else if(!$name = $params['name']){
            $this->msgbox->add('真实姓名不正确', 211);
        }else if(!$id_number = $params['id_number']){
            $this->msgbox->add('身份证号码不正确', 212);
        }else if(!$id_number = K::M('verify/check')->id_number($id_number)){
            $this->msgbox->add('身份证号码不正确', 213);
        }else{
           $data = array('name'=>$name, 'id_number'=>$id_number);
            if($attach = $_FILES['id_photo']){
                if($a = K::M('magic/upload')->upload($attach)){
                    $data['id_photo'] = $a['photo'];
                }
            }
            if(false !== K::M('staff/staff')->update($this->staff_id,$data)){
                $this->msgbox->add('success');
            }else{
                $this->msgbox->add('操作失败',222);
            }
        }
    }

    public function verifyinfo($params)
    {
        $this->check_login();
        if(!$verify_info = K::M('staff/verify')->detail($this->staff_id)){
            $verify_info = array('staff_id'=>$this->staff_id,'name'=>'','id_number'=>'','id_photo'=>'','verify'=>'','verify_time'=>'','refuse'=>'','updatetime'=>'');
        }
        $this->msgbox->set_data('data', $verify_info);
        $this->msgbox->add('success');
    }

    //结算帐号设置
    public function account($params)
    {
        $this->check_login();
        if(!$account_type = $params['account_type']){
            $this->msgbox->add('开户行不正确', 211);
        }else if(!$account_name = $params['account_name']){
            $this->msgbox->add('开户人不正确', 212);
        }else if(!$account_number = $params['account_number']){
            $this->msgbox->add('提现帐号不正确', 212);
        }else if(K::M('staff/staff')->update($this->staff_id, array('account_name'=>$account_name, 'account_type'=>$account_type, 'account_number'=>$account_number))){
            $this->msgbox->add('success');
        }
    }

    public function info($params)
    {
        $this->check_login();
        $staff = $this->filter_fields('staff_id,name,mobile,face,money,total_money,orders,loginip,lastlogin,account_type,account_name,account_number,id_number,id_photo,verify_name,verify_account,lat,lng,audit,tixian_percent', $this->STAFF);

        if(!$staff['verify_name'] && !$staff['id_number'] &&!$staff['id_photo']) {
            $staff['verify_status'] = '您还未提交身份认证资料';
        }else {
            if($staff['verify_name'] == 0 && $verify['id_number'] && $verify['id_photo']) {
                $staff['verify_status'] = '已提交认证资料等待管理员审核';
            }  
        }
        $staff['skill_count'] = K::M('staff/attr')->count(array('staff_id'=>$this->staff_id));
        $staff['tixian_amount'] = K::M('staff/tixian')->sum('money',"staff_id = ".$this->staff_id." and status = 1");
        // staff_id 0等待配送员接单
        $filter = array('order_status'=>0,'staff_id'=>0, 'closed'=>0, 'pay_status'=>1);
        //使用此函数计算得到结果后，带入sql查询。
        if(!defined('__DEV_MODEL') || !constant('__DEV_MODEL')){ //开发环境忽略坐标
            $squares = K::M('helper/round')->returnSquarePoint($staff['lng'], $staff['lat'], 5); //5KM以内的新订单
            $filter['lat'] = $squares['left-bottom']['lat'].'~'.$squares['right-top']['lat'];
            $filter['lng'] = $squares['left-bottom']['lng'].'~'.$squares['right-top']['lng'];
        }
        $staff['order_jie_count'] = (int)K::M('order/order')->count($filter);
        $staff['order_pei_count'] = (int)K::M('order/order')->count(array('staff_id'=>$this->staff_id, 'closed'=>0, 'order_status'=>array(1,2)));
        $staff['order_end_count'] = (int)K::M('order/order')->count(array('staff_id'=>$this->staff_id, 'closed'=>0, 'order_status'=>array(8)));
        $staff['msg_new_count'] = (int)K::M('staff/msg')->count(array('staff_id'=>$this->staff_id, 'is_read'=>0));
        $this->msgbox->set_data('data', $staff);  
    }

    //上报当前位置接口
    public function location($params)
    {
        
        $this->check_login();
        if(!($lat = $params['lat']) || !($lng = $params['lng'])){
            $this->msgbox->add('经纬度不正确', 211);
        }else if(K::M('staff/staff')->update($this->staff_id, array('lat'=>$lat, 'lng'=>$lng))){
            $this->msgbox->add('success');
        }
        
    }
    
    
    public function set_status($params)
    {
        $this->check_login();
        if(!in_array($params['status'], array(0, 1))){
            $this->msgbox->add('状态错误', 211);
        }else if(K::M('staff/staff')->update($this->staff_id, array('status'=>$params['status']))){
            $this->msgbox->add('success');
            $status = K::M('staff/staff')->detail($this->staff_id);
            $this->msgbox->set_data('status',$status['status']);
        }
    }
    
    
    public function staff_cate(){
        $this->check_login();
        $cate_items = array();
        if($attr = K::M('staff/attr')->items(array('staff_id'=>$this->staff_id))){
            $cate_ids = array();
            foreach($attr as $k=>$val){
                $cate_ids[] = $val['cate_id'];
            }
        }
        if($items = K::M('cate/cate')->fetch_all()){
            foreach ($items as $k=>$val){
                if($val['parent_id'] == 0){
                    unset($items[$k]);
                }
                foreach ($cate_ids as $kk=>$v){
                    if($v == $val['cate_id']){
                        unset($items[$k]);
                    }
                }
                
            }
        }
        if(!$items){
            $items = array();
        }else{
            foreach($items as $k=>$val){
                $items[$k] = $this->filter_fields('cate_id,title',$val);
            }
        }
        
        if($cate_ids){
            $attrs = K::M('cate/cate')->items_by_ids($cate_ids);
            foreach($attrs as $k=>$val){
                if($val['parent_id'] == 0){
                    unset($attrs[$k]);
                }
            }
            foreach($attrs as $k=>$val){
                $attrs[$k] = $this->filter_fields('cate_id,title',$val);
            }
        }else{
            $attrs = array();
        }
        $cate_items['other'] = array_values($items);
        $cate_items['have'] = array_values($attrs);
        $this->msgbox->add('success');
        $this->msgbox->set_data('data',array('items'=>$cate_items));
    }
    
    

    public function set_cate($params){
        $this->check_login();
        if(!$params['cates']){
            $this->msgbox->add('技能不能为空', 211);
        }else{
            $cates = explode(',',$params['cates']);
            K::M('staff/attr')->delete("staff_id = ".$this->staff_id);
            foreach($cates as $val){
                K::M('staff/attr')->create(array('staff_id'=>$this->staff_id,'cate_id'=>$val));
            }
            $this->msgbox->add('添加成功');  
        }
    }
    
  
    public function comments($params){
        $this->check_login();
        $comments = $this->filter_fields('staff_id,comments,praise_num,score',$this->STAFF);
        $comments['hplv'] = round($comments['praise_num']/$comments['comments'],2)*100;
        $comments['star'] = round($comments['score']/$comments['comments'],1);
        $filter['staff_id'] = $this->staff_id;
        $page = max((int)$params['page'], 1);
        if ($comment_lists = K::M('staff/comment')->items($filter, null, $page, 10, $count)) {
                $comment_ids = array();
                foreach ($comment_lists as $k=>$val){
                    $comment_ids[$val['comment_id']] = $val['comment_id'];
                    if($val['uid']){
                      $member = K::M('member/member')->detail($val['uid']);
                      $val['face'] = $member['face'];
                      $val['nickname'] = $member['nickname'];
                      $comment_lists[$k] = $val;
                    }
                    $comment_lists[$k] = $this->filter_fields('comment_id,staff_id,nickname,face,uid,order_id,score,content,have_photo,reply,reply_ip,reply_time,closed,clientip,dateline', $val);

                }
                $photos = K::M('staff/photo')->items(array('comment_id'=>$comment_ids));
                foreach($comment_lists as $k=>$val){
                    foreach ($photos as $kk=>$v){
                        if($val['comment_id'] == $v['comment_id']){
                            $comment_lists[$k]['pics'][] = $v;
                        }
                    }
                }
        }else{
            $comment_lists = array();
        }
        foreach($comment_lists as $k=>$val){
            if(empty($val['pics'])){
                $comment_lists[$k]['pics'] = array();
            }
        }
        $this->msgbox->add('success');
        $this->msgbox->set_data('data',array('items'=>$comments,'lists'=>  array_values($comment_lists)));
    }
    

    public function reply($params){
        $this->check_login();
        if(!$comment_id = (int)$params['comment_id']){
            $this->msgbox->add('评论不存在', 211);
        }elseif(!$detail = K::M('staff/comment')->detail($comment_id)){
            $this->msgbox->add('评论不存在', 212);
        }elseif($detail['staff_id'] != $this->staff_id){
            $this->msgbox->add('不能回复别人的订单', 213);
        }elseif(!$reply = $params['reply']){
            $this->msgbox->add('回复内容不能为空', 214);
        }else{
            if(false !== K::M('staff/comment')->update($comment_id,array('reply'=>$reply,'reply_ip'=>__IP,'reply_time'=>__TIME))){
                $this->msgbox->add('回复成功');
            }else{
                $this->msgbox->add('回复失败', 215);
            }
        }
    }
    
    
}
