<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Staff_Order extends Ctl
{

    protected $_allow_fields = 'order_id,cate_id,title,uid,comment_status,money,amount,hongbao,hongbao_id,contact,mobile,addr,house,lat,lng,note,order_status,pay_status,pay_code,pay_time,staff_id,pei_type,deposit,service_time,dateline';

    //订单列表
    public function index($params)
    {
        $this->check_login();
        $filter = array();
        if(!($lat = $params['lat']) || !($lng = $params['lng'])){
            $lat = $this->staff['lat'];
            $lng = $this->staff['lng'];
        }
        //0:全部, 1:待接单, 2:进行中的, 3:已完成的
        if(in_array($params['status'], array(0,1,2,3))){
            switch ($params['status']){
                case 3:
                    $filter['order_status'] = array(-1, 8);
                    $filter['staff_id'] = $this->staff_id;
                    break;
                case 2:
                    $filter['order_status'] = array(1,2);
                    $filter['staff_id'] = $this->staff_id;
                    break;
                case 1:
                    $filter['order_status'] = 0;
                    $filter['pay_status'] = 1;
                    $filter['staff_id'] = 0;
                    $attr = K::M('staff/attr')->items(array('staff_id'=>$this->staff_id));
                    foreach($attr as $val){
                        $res[] = $val['cate_id'];
                    }
                    $filter['cate_id'] = $res;
                    $filter['service_time'] =  '>=:'.date('Y-m-d H:i',time());
                    if(!defined('__DEV_MODEL') || !constant('__DEV_MODEL')){ //开发环境忽略坐标
                        //使用此函数计算得到结果后，带入sql查询。
                        $squares = K::M('helper/round')->returnSquarePoint($lng, $lat, 5); //5KM以内的新订单
                        $filter['lat'] = $squares['left-bottom']['lat'].'~'.$squares['right-top']['lat'];
                        $filter['lng'] = $squares['left-bottom']['lng'].'~'.$squares['right-top']['lng'];
                    }
                    break;
            }
        }
        $filter['closed'] = 0;
        $page = max((int)$params['page'], 1);
        if($order_list = K::M('order/order')->items($filter, null, $page, 10, $count)){
            $cate_ids = array();
            foreach($order_list as $k=>$val){
                $cate_ids[$val['cate_id']] = $val['cate_id'];
            }
            $cate_list = K::M('cate/cate')->items_by_ids($cate_ids);
            $items = array();
            foreach($order_list as $k=>$val){
                $items[$k] = $this->filter_fields($this->_allow_fields, $val);
                if($cate_list[$val['cate_id']]){
                    $items[$k]['title'] = $cate_list[$val['cate_id']]['title'];
                }
            }
        }else{
            $items = array();
        }
        $map = array();
        $map['order_status'] =0;
        $map['pay_status'] = 1;
        $map['staff_id'] = 0;
        $map['service_time'] =  '<:'.date('Y-m-d H:i',time());
        $last_items = K::M('order/order')->items($map);
        K::M('order/order')->plqx($last_items);
        $this->msgbox->add('success');
        $this->msgbox->set_data('data', array('items'=>array_values($items)));
    }

    //订单详情
    public function detail($params)
    {
        $this->check_login();
        if(!$order_id = (int)$params['order_id']){
            $this->msgbox->add('错误的订单ID',211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('不存在的订单',212);
        }else if($order['staff_id'] && $order['staff_id'] != $this->staff_id){
            $this->msgbox->add('非法订单',214);
        }else{
            $cate = K::M('cate/cate')->detail($order['cate_id']);
            $order['title'] = $cate['title'];
            $order = $this->filter_fields($this->_allow_fields, $order);
            if(!$logs = K::M('order/log')->items(array('order_id'=>$order_id),array('log_id'=>'asc'))){
                $logs = array();
            }
            if(!$photos = K::M('order/pics')->items(array('order_id'=>$order_id))){
                $order['pics'] = array();
            }else{
                $order['pics'] = array_values($photos);
            }
            if($order['comment_status'] ==1){
                $comment = K::M('staff/comment')->find(array('order_id'=>$order_id,'staff_id'=>$this->staff_id));
                $user = K::M('member/member')->detail($comment['uid']);
                $comment['nickname'] = $user['nickname']; 
                if(!$pics = K::M('staff/photo')->items(array('comment_id'=>$comment['comment_id']))){
                    $comment['picss'] = array();
                }else{
                    $comment['picss'] = array_values($pics);
                }
            }
            if(!$comment){
                $comment = array('comment_id'=>0);
            }
            $order['comment'] = $comment;
            //$order['logs'] = array_values($logs);
            $this->msgbox->add('success');
            $this->msgbox->set_data('data', array('order'=>$order));
        }
    }


    public function jiedan($params)
    {   //抢单
        $this->check_login();
        if(!$order_id = (int)$params['order_id']){
            $this->msgbox->add('错误的订单ID',211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('不存在的订单',212);
        }else if($order['order_status'] !=0 || empty($order['pay_status'])){
            $this->msgbox->add('该订单不可抢单',213);
        }else if($order['staff_id']){
            $this->msgbox->add('订单已经被抢走',214);
        }else if(K::M('order/order')->update($order_id, array('staff_id'=>$this->staff_id, 'order_status'=>1,'lasttime'=>__TIME))){
            //记录订单日志
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'staff', 'log'=>'配送员('.$this->STAFF['name'].')已接单(订单ID:'.$order_id.')', 'type'=>'1'));
            //增加订单统计
            K::M('staff/staff')->update_count($this->staff_id, 'orders', 1);
            $this->msgbox->set_data('data', array('order_id'=>$order_id));
        }
    }
    
    public function cancel($params){ //取消订单
        $this->check_login();
        if(!$order_id = (int)$params['order_id']){
            $this->msgbox->add('错误的订单ID',211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('不存在的订单',212);
        }else if($order['staff_id'] != $this->staff_id){
            $this->msgbox->add('该订单不是您的不可取消',213);
        }else if(in_array($order['order_status'], array(-1,8))){
            $this->msgbox->add('该订单不可取消',214);
        }else if(K::M('order/order')->update($order_id, array('staff_id'=>0, 'order_status'=>1,'lasttime'=>0))){
            //记录订单日志
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'staff', 'log'=>'配送员('.$this->STAFF['name'].')取消订单，原因：'.$params['reason'], 'type'=>'-1'));
            $this->msgbox->set_data('data', array('order_id'=>$order_id));
        }
    }

    public function complete($params) 
    {//完成工作，付尾款
        $this->check_login();
        if(!$order_id = (int)$params['order_id']){
            $this->msgbox->add('错误的订单ID',211);
        }else if(!$order = K::M('order/order')->detail($order_id)){
            $this->msgbox->add('不存在的订单',212);
        }else if($order['staff_id'] != $this->staff_id){
            $this->msgbox->add('您没有权限操作该订单',213);
        }else if($order['order_status'] != 1||$order['pay_status'] != 1){
            $this->msgbox->add('该订单不可补差价',213);
        }else if(K::M('order/order')->update($order_id, array('order_status'=>2,'pay_status'=>0))){
            //记录订单日志
            K::M('order/log')->create(array('order_id'=>$order_id, 'from'=>'staff', 'log'=>'配送员('.$this->STAFF['name'].')完成工作,下面进行补差价', 'type'=>'2'));
            $this->msgbox->set_data('data', array('order_id'=>$order_id));
        }
    }

    //订单提醒
    public function tixing($params)
    {
        $this->check_login();
        if(!$dateline = (int)$params['dateline']){
            //如果没有传时间戳设置为15分钟前
            $dateline = __TIME - 900;
        }
        $filter = array();
        $filter['order_status'] = 1;
        $filter['pay_status'] = 1;
        $filter['staff_id'] = $this->staff_id;
        $filter['lasttime'] = ">:".$dateline;
        $new_order = (int)K::M('order/order')->count($filter);
        $this->msgbox->set_data('data', array('new_order'=>$new_order,'dateline'=>__TIME));
    }

}
