<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */
if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Staff_Tongji extends Ctl
{

    public function money($params)
    {
        $this->check_login();
        $sday = date('Ymd', __TIME);
        $lday = date('Ymd', __TIME - 31*86400);
        $week_day = date('Ymd', __TIME - 7 * 86400);
        $filter = array('staff_id'=>$this->staff_id, 'day'=>$lday.'~'.$sday);
        $today_money = $week_money = $month_money = $total_money = 0;
        $items = array();
        for($i = 0; $i < 30; $i ++ ){
            $day = date('Ymd', __TIME - (30-$i)*86400);
            $date = date('Y-m-d', __TIME - (30-$i)*86400);
            $items[$day] = array('day'=>$day, 'date'=>$date, 'count'=>0, 'money'=>0);
        }
        if($count_list = K::M('staff/log')->count_by_day($filter)){
            foreach($count_list as $k=>$v){
                if($sday == $v['day']){
                    $today_money += $v['day_money'];
                }else{
                    if($week_day > $v['day']){
                        $week_money += $v['day_money'];
                    }
                    $month_money += $v['day_money'];
                    $items[$k]['money'] = $v['day_money'];
                }
            }
        }
        if($a = K::M('staff/log')->total_by_staff(array('staff_id'=>$this->staff_id, 'money'=>'>:0'))){
            $total_money = $a['total_money'];
        }
        $this->msgbox->set_data('data', array('items'=>array_values($items), 'today_money'=>$today_money, 'week_money'=>$week_money,'month_money'=>$month_money,'total_money'=>$total_money));
    }

    public function order($params)
    {
        $this->check_login();
        $sday = date('Ymd', __TIME);
        $lday = date('Ymd', __TIME - 31*86400);
        $week_day = date('Ymd', __TIME - 7 * 86400);
        $filter = array('staff_id'=>$this->staff_id, 'day'=>$lday.'~'.$sday);
        $today_count = $week_count = $month_count = $total_count = 0;
        $total_count = $this->STAFF['orders'];
        $items = array();
        for($i = 0; $i < 30; $i ++ ){
            $day = date('Ymd', __TIME - (30-$i)*86400);
            $date = date('Y-m-d', __TIME - (30-$i)*86400);
            $items[$day] = array('day'=>$day, 'date'=>$date, 'count'=>0);
        }

        if($count_list = K::M('order/order')->count_by_day($filter)){
            foreach($count_list as $k=>$v){
                if($sday == $v['day']){
                    $today_count += $v['day_count'];
                }else{
                    if($week_day > $v['day']){
                        $week_count += $v['day_count'];
                    }
                    $month_count += $v['day_count'];
                    $items[$k]['count'] = $v['day_count'];
                }
            }
        }
        $this->msgbox->set_data('data', array('items'=>array_values($items), 'today_count'=>$today_count, 'week_count'=>$week_count,'month_count'=>$month_count,'total_count'=>$total_count));
    }
}
